/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.metadata;

import csplugins.isb.pshannon.experiment.ExperimentRepository;
import csplugins.isb.pshannon.experiment.ExperimentRepositoryFactory;
import csplugins.isb.pshannon.experiment.metadata.MetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class MetaDataNavigator {
    String sourceUri;
    HashMap tree;
    HashMap titleToExperimentsHash;
    HashMap nameToExperimentsHash;
    HashMap perturbationsListToExperimentHash;

    public MetaDataNavigator(String string) throws Exception {
        this.sourceUri = string;
        this.tree = new HashMap();
        this.titleToExperimentsHash = new HashMap();
        this.nameToExperimentsHash = new HashMap();
        this.perturbationsListToExperimentHash = new HashMap();
        this.loadMetaData();
        this.buildSimpleTree();
    }

    public HashMap getPerturbationExperimentHash() {
        return this.perturbationsListToExperimentHash;
    }

    protected void loadMetaData() throws Exception {
        ExperimentRepository experimentRepository = ExperimentRepositoryFactory.create(this.sourceUri);
        Object[] objectArray = experimentRepository.getExperimentNames();
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            MetaData metaData = experimentRepository.getMetaData((String)objectArray[i]);
            String string = metaData.getTitle();
            if (this.titleToExperimentsHash.containsKey(string)) {
                String string2 = "warning!  skipping duplicate experiment title: " + string + " found in metadata.";
                System.err.println(string2);
            }
            this.titleToExperimentsHash.put(string, metaData);
            this.nameToExperimentsHash.put(object, metaData);
        }
    }

    public String[] getExperimentNames() {
        return this.nameToExperimentsHash.keySet().toArray(new String[0]);
    }

    public String[] getExperimentTitles() {
        return this.titleToExperimentsHash.keySet().toArray(new String[0]);
    }

    public String[] getPerturbationStrings() {
        Object[] objectArray = this.perturbationsListToExperimentHash.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public HashMap getExperimentsHashedByName() {
        return this.nameToExperimentsHash;
    }

    public HashMap getExperimentsHashedByTitle() {
        return this.titleToExperimentsHash;
    }

    public MetaData getExperimentByTitle(String string) {
        String[] stringArray = this.getExperimentTitles();
        if (this.titleToExperimentsHash.containsKey(string)) {
            return (MetaData)this.titleToExperimentsHash.get(string);
        }
        return null;
    }

    public MetaData getExperimentByName(String string) {
        if (this.nameToExperimentsHash.containsKey(string)) {
            return (MetaData)this.nameToExperimentsHash.get(string);
        }
        return null;
    }

    protected String createColonSeparatedString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append(":");
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public ArrayList findExperimentKeyForPerturbation(String[] stringArray) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        if (stringArray.length == 0) {
            return arrayList;
        }
        String string = this.createColonSeparatedString(stringArray);
        boolean bl = false;
        String[] stringArray2 = this.getPerturbationStrings();
        for (int i = 0; i < stringArray2.length; ++i) {
            boolean bl2;
            int n;
            int n2;
            String string2 = stringArray2[i];
            if (string.equals(string2)) {
                arrayList.add(new String[]{string2, null});
                continue;
            }
            if (string.indexOf(string2) == 0) {
                bl = true;
                n2 = string.charAt(string2.length());
                if (n2 != 58) continue;
                n = string2.length() + 1;
                String string3 = string.substring(n);
                arrayList.add(new String[]{string2, string3});
                continue;
            }
            if (string2.indexOf(string) != 0) continue;
            n2 = string.length();
            n = string2.charAt(n2);
            boolean bl3 = bl2 = n == 58;
            if (!bl2) break;
            arrayList.add(new String[]{string2, null});
        }
        return arrayList;
    }

    public MetaData[] getExperimentByPerturbationList(String string) {
        if (this.perturbationsListToExperimentHash.containsKey(string)) {
            ArrayList arrayList = (ArrayList)this.perturbationsListToExperimentHash.get(string);
            return arrayList.toArray(new MetaData[0]);
        }
        return new MetaData[0];
    }

    public HashMap getTree() {
        return this.tree;
    }

    protected void buildSimpleTree() {
        String[] stringArray = this.getExperimentTitles();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            MetaData metaData = this.getExperimentByTitle(string);
            String string2 = metaData.getPredicate("species");
            String string3 = metaData.getPredicate("strain");
            HashMap hashMap = metaData.getPredicates();
            if (!hashMap.containsKey("perturbation")) continue;
            String string4 = (String)hashMap.get("perturbation");
            String[] stringArray2 = string4.split(":");
            ArrayList arrayList = new ArrayList();
            if (this.perturbationsListToExperimentHash.containsKey(string4)) {
                arrayList = (ArrayList)this.perturbationsListToExperimentHash.get(string4);
            }
            arrayList.add(metaData);
            this.perturbationsListToExperimentHash.put(string4, arrayList);
            this.addToTree(metaData, stringArray2);
        }
    }

    protected void addToTree(MetaData metaData, String[] stringArray) {
        HashMap hashMap = this.tree;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new HashMap());
            }
            hashMap = (HashMap)hashMap.get(string);
            if (i != stringArray.length - 1) continue;
            String[] stringArray2 = metaData.getVariableNames();
            for (int j = 0; j < stringArray2.length; ++j) {
                String string2 = stringArray2[j];
                if (!hashMap.containsKey(string2)) {
                    hashMap.put(string2, new HashMap());
                }
                HashMap hashMap2 = metaData.getVariableValuesWithUnits(string2);
                String[] stringArray3 = hashMap2.keySet().toArray(new String[0]);
                for (int k = 0; k < stringArray3.length; ++k) {
                    HashMap hashMap3 = (HashMap)hashMap.get(string2);
                    hashMap3.put(stringArray3[k], new HashMap());
                }
            }
        }
    }

    public void dumpTree(HashMap hashMap, String string) {
        if (hashMap.size() == 0) {
            return;
        }
        Object[] objectArray = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        string = string + "  ";
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            System.out.println(string + (String)object);
            this.dumpTree((HashMap)hashMap.get(object), string);
        }
    }
}

