/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.gui.movie;

import csplugins.isb.pshannon.experiment.datamatrix.LensedDataMatrix;
import csplugins.isb.pshannon.experiment.gui.actions.IconFactory;
import csplugins.isb.pshannon.experiment.gui.movie.MovieControllerClient;
import csplugins.isb.pshannon.experiment.gui.movie.MovieControllerInfoDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.Timer;

public abstract class MovieController {
    String name = "movie";
    JPanel mainPanel;
    JPanel conditionsPanel;
    JPanel playPanel;
    JComboBox conditionChooser;
    JComboBox frameRateChooser;
    ImageIcon playIcon;
    ImageIcon stopIcon;
    ImageIcon questionIcon;
    JButton movieButton;
    JButton questionButton;
    JCheckBox loopCheckBox;
    JCheckBox reversePlayCheckBox;
    boolean loopMovie = false;
    boolean reversePlay = false;
    String[] matrixNames;
    protected LensedDataMatrix[] lenses;
    protected String[] columnNames = new String[0];
    protected int conditionChooserIndex = 0;
    MovieControllerClient parent;
    Date matricesTimeStamp = null;
    Timer frameTimer;
    FrameAnimator frameAnimator;
    int initialFrameDelay = 1;

    public MovieController(MovieControllerClient movieControllerClient) {
        this.parent = movieControllerClient;
        this.frameAnimator = new FrameAnimator();
        this.frameTimer = new Timer(this.initialFrameDelay * 1000, this.frameAnimator);
        movieControllerClient.getToolbarEtcPanel().add(this.createComboBoxUI());
    }

    public void setEnabled(boolean bl) {
        this.conditionChooser.setEnabled(bl);
        this.frameRateChooser.setEnabled(bl);
        this.movieButton.setEnabled(bl);
        this.questionButton.setEnabled(bl);
        this.loopCheckBox.setEnabled(bl);
        this.reversePlayCheckBox.setEnabled(bl);
    }

    protected JPanel createComboBoxUI() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.conditionChooser = new JComboBox();
        this.conditionChooser.setPrototypeDisplayValue("a very very long condition name");
        this.conditionChooser.setToolTipText("Experimental condition");
        this.conditionChooser.addActionListener(new ConditionChooserListener());
        this.mainPanel.add((Component)jPanel, "Center");
        jPanel.add(this.conditionChooser);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(1, 30, 1, 30));
        String[] stringArray = new String[]{"0", "0.5", "1", "2", "3", "5", "10"};
        this.frameRateChooser = new JComboBox<String>(stringArray);
        this.frameRateChooser.setSelectedIndex(2);
        this.frameRateChooser.setToolTipText("Frame Rate");
        this.frameRateChooser.addActionListener(new FrameRateChooserListener());
        this.mainPanel.add((Component)jPanel, "Center");
        jPanel.add(this.frameRateChooser);
        this.playIcon = IconFactory.getPlayIcon();
        this.stopIcon = IconFactory.getStopIcon();
        this.questionIcon = IconFactory.getQuestionIcon();
        this.movieButton = new JButton(this.playIcon);
        this.movieButton.setToolTipText("Run & Stop Movie");
        this.movieButton.setActionCommand("run");
        this.movieButton.addActionListener(new MovieButtonListener());
        jPanel.add(this.movieButton);
        this.questionButton = new JButton(this.questionIcon);
        this.questionButton.addActionListener(new QuestionButtonListener());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        this.loopCheckBox = new JCheckBox("loop");
        this.reversePlayCheckBox = new JCheckBox("reverse");
        this.loopCheckBox.addItemListener(new LoopCheckBoxListener());
        this.reversePlayCheckBox.addItemListener(new ReversePlayCheckBoxListener());
        jPanel2.add(this.loopCheckBox);
        jPanel2.add(this.reversePlayCheckBox);
        jPanel.add(jPanel2);
        jPanel.add(this.questionButton);
        return this.mainPanel;
    }

    protected void runMovie() {
        this.movieButton.setIcon(this.stopIcon);
        this.movieButton.setActionCommand("stop");
        this.frameTimer.start();
    }

    protected void stopMovie() {
        this.frameTimer.stop();
        this.movieButton.setIcon(this.playIcon);
        this.movieButton.setActionCommand("run");
    }

    public void loadMatrices() {
        if (this.parent.getLastModificationTime() == null) {
            return;
        }
        if (this.matricesTimeStamp == null || this.parent.getLastModificationTime().after(this.matricesTimeStamp)) {
            this.lenses = this.extractCongruentMatrices(this.parent.getLenses());
            System.out.println("congruent lens count: " + this.lenses.length);
            this.matrixNames = new String[this.lenses.length];
            for (int i = 0; i < this.lenses.length; ++i) {
                this.matrixNames[i] = this.lenses[i].getShortName();
            }
            if (this.lenses.length > 0) {
                this.columnNames = this.lenses[0].getColumnTitles();
            }
            this.matricesTimeStamp = this.parent.getLastModificationTime();
            this.loadConditionChooserComboBox(this.lenses);
            this.setEnabled(true);
        }
    }

    protected LensedDataMatrix[] extractCongruentMatrices(LensedDataMatrix[] lensedDataMatrixArray) {
        if (lensedDataMatrixArray.length == 1) {
            return lensedDataMatrixArray;
        }
        ArrayList<LensedDataMatrix> arrayList = new ArrayList<LensedDataMatrix>();
        LensedDataMatrix lensedDataMatrix = lensedDataMatrixArray[0];
        arrayList.add(lensedDataMatrix);
        int n = lensedDataMatrix.getRowCount();
        int n2 = lensedDataMatrix.getColumnCount();
        Object[] objectArray = lensedDataMatrix.getColumnTitles();
        Object[] objectArray2 = lensedDataMatrix.getRowTitles();
        for (int i = 1; i < lensedDataMatrixArray.length; ++i) {
            Object[] objectArray3;
            Object[] objectArray4;
            int n3 = lensedDataMatrixArray[i].getRowCount();
            int n4 = lensedDataMatrixArray[i].getColumnCount();
            if (n3 != n || n4 != n2 || !Arrays.equals(objectArray4 = lensedDataMatrixArray[i].getColumnTitles(), objectArray) || !Arrays.equals(objectArray3 = lensedDataMatrixArray[i].getRowTitles(), objectArray2)) continue;
            arrayList.add(lensedDataMatrixArray[i]);
        }
        return arrayList.toArray(new LensedDataMatrix[0]);
    }

    protected void loadConditionChooserComboBox(LensedDataMatrix[] lensedDataMatrixArray) {
        for (int i = 0; i < lensedDataMatrixArray.length; ++i) {
            System.out.println("full: " + lensedDataMatrixArray[i].getFullName());
            System.out.println("short: " + lensedDataMatrixArray[i].getShortName());
            System.out.println("ext: " + lensedDataMatrixArray[i].getFileExtension());
            System.out.println("type: " + lensedDataMatrixArray[i].getDataTypeBriefName());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = lensedDataMatrixArray[0].getColumnTitles();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.conditionChooser.getModel();
        defaultComboBoxModel.removeAllElements();
        defaultComboBoxModel.addElement("None");
        for (int i = 0; i < arrayList.size(); ++i) {
            defaultComboBoxModel.addElement(arrayList.get(i));
        }
    }

    protected abstract void broadcast();

    protected void changeCondition() {
        System.out.println("changeCondition, starting value: " + this.conditionChooserIndex);
        if (this.reversePlay) {
            this.handleFrameDecrementRequest();
        } else {
            this.handleFrameIncrementRequest();
        }
        System.out.println("changeCondition, ending value: " + this.conditionChooserIndex);
        this.conditionChooser.setSelectedIndex(this.conditionChooserIndex);
        this.broadcast();
    }

    protected void handleFrameIncrementRequest() {
        System.out.println("hfir, cci before: " + this.conditionChooserIndex);
        ++this.conditionChooserIndex;
        boolean bl = false;
        int n = this.conditionChooser.getModel().getSize() - 1;
        if (this.conditionChooserIndex > n) {
            if (this.loopMovie) {
                this.conditionChooserIndex = 1;
            } else {
                this.conditionChooserIndex = n;
                this.stopMovie();
            }
        }
        System.out.println("hfir, cci after: " + this.conditionChooserIndex);
    }

    protected void handleFrameDecrementRequest() {
        --this.conditionChooserIndex;
        int n = 0;
        int n2 = this.conditionChooser.getModel().getSize() - 1;
        if (this.conditionChooserIndex <= n) {
            if (this.loopMovie) {
                this.conditionChooserIndex = n2;
            } else {
                this.stopMovie();
                this.conditionChooserIndex = 1;
            }
        }
    }

    class FrameRateChooserListener
    implements ActionListener {
        FrameRateChooserListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            String string = (String)jComboBox.getSelectedItem();
            try {
                double d = new Double(string);
                int n = (int)(d * 1000.0);
                MovieController.this.frameTimer.setDelay(n);
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
    }

    class ConditionChooserListener
    implements ActionListener {
        ConditionChooserListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            MovieController.this.conditionChooserIndex = jComboBox.getSelectedIndex();
            MovieController.this.broadcast();
        }
    }

    class QuestionButtonListener
    implements ActionListener {
        QuestionButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("lauching info with lens count: " + MovieController.this.lenses.length);
            MovieControllerInfoDialog movieControllerInfoDialog = new MovieControllerInfoDialog(MovieController.this.lenses);
            movieControllerInfoDialog.pack();
            movieControllerInfoDialog.setLocationRelativeTo(MovieController.this.mainPanel);
            movieControllerInfoDialog.setVisible(true);
        }
    }

    class MovieButtonListener
    implements ActionListener {
        MovieButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ("run".equals(actionEvent.getActionCommand())) {
                MovieController.this.runMovie();
            } else if ("stop".equals(actionEvent.getActionCommand())) {
                MovieController.this.stopMovie();
            }
        }
    }

    class ReversePlayCheckBoxListener
    implements ItemListener {
        ReversePlayCheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            MovieController.this.reversePlay = itemEvent.getStateChange() == 1;
        }
    }

    class LoopCheckBoxListener
    implements ItemListener {
        LoopCheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            MovieController.this.loopMovie = itemEvent.getStateChange() == 1;
        }
    }

    class FrameAnimator
    implements ActionListener {
        FrameAnimator() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MovieController.this.changeCondition();
        }
    }
}

