/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.gui;

import csplugins.isb.pshannon.experiment.gui.SelectionAreaController;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class SelectionArea
extends ChartPanel {
    Rectangle currentRect = null;
    Rectangle rectToDraw = null;
    Rectangle previousRectDrawn = new Rectangle();
    SelectionAreaController controller;
    MyListener myListener;
    boolean draw = false;

    public SelectionArea(JFreeChart jFreeChart, SelectionAreaController selectionAreaController) {
        super(jFreeChart);
        this.controller = selectionAreaController;
        this.setOpaque(true);
        this.setMinimumSize(new Dimension(10, 10));
        this.myListener = new MyListener();
    }

    public void setEnableCustomDrag(boolean bl) {
        this.draw = bl;
        if (bl) {
            this.addMouseListener(this.myListener);
            this.addMouseMotionListener(this.myListener);
        } else {
            this.removeMouseListener(this.myListener);
            this.removeMouseMotionListener(this.myListener);
        }
    }

    public void clearSelection() {
        this.currentRect = null;
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.currentRect != null) {
            graphics.setXORMode(Color.white);
            graphics.drawRect(this.rectToDraw.x, this.rectToDraw.y, this.rectToDraw.width - 1, this.rectToDraw.height - 1);
        }
    }

    private void updateDrawableRect(int n, int n2) {
        int n3 = this.currentRect.x;
        int n4 = this.currentRect.y;
        int n5 = this.currentRect.width;
        int n6 = this.currentRect.height;
        if (n5 < 0 && (n3 = n3 - (n5 = 0 - n5) + 1) < 0) {
            n5 += n3;
            n3 = 0;
        }
        if (n6 < 0 && (n4 = n4 - (n6 = 0 - n6) + 1) < 0) {
            n6 += n4;
            n4 = 0;
        }
        if (n3 + n5 > n) {
            n5 = n - n3;
        }
        if (n4 + n6 > n2) {
            n6 = n2 - n4;
        }
        if (this.rectToDraw != null) {
            this.previousRectDrawn.setBounds(this.rectToDraw.x, this.rectToDraw.y, this.rectToDraw.width, this.rectToDraw.height);
            this.rectToDraw.setBounds(n3, n4, n5, n6);
        } else {
            this.rectToDraw = new Rectangle(n3, n4, n5, n6);
        }
    }

    private class MyListener
    extends MouseInputAdapter {
        private MyListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            SelectionArea.this.currentRect = new Rectangle(n, n2, 0, 0);
            SelectionArea.this.updateDrawableRect(SelectionArea.this.getWidth(), SelectionArea.this.getHeight());
            SelectionArea.this.repaint();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.updateSize(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            SelectionArea.this.controller.setDraggedRectangle(SelectionArea.this.rectToDraw);
            this.updateSize(mouseEvent);
        }

        void updateSize(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            SelectionArea.this.currentRect.setSize(n - SelectionArea.this.currentRect.x, n2 - SelectionArea.this.currentRect.y);
            SelectionArea.this.updateDrawableRect(SelectionArea.this.getWidth(), SelectionArea.this.getHeight());
            Rectangle rectangle = SelectionArea.this.rectToDraw.union(SelectionArea.this.previousRectDrawn);
            SelectionArea.this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

