/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.gui;

import csplugins.isb.dtenenbaum.nameHelper.NameHelper;
import csplugins.isb.dtenenbaum.nameHelper.NameHelperFactory;
import csplugins.isb.dtenenbaum.plot2d.UnsortedXYSeries;
import csplugins.isb.dtenenbaum.plot2d.XYMetaData;
import csplugins.isb.pshannon.experiment.datamatrix.LensedDataMatrix;
import csplugins.isb.pshannon.experiment.gui.DataMatrixView;
import csplugins.isb.pshannon.experiment.gui.actions.IconFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.SymbolicAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.labels.SymbolicXYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;

public class MatrixPlotter
extends JPanel
implements DataMatrixView {
    private String[] symbolicNames;
    private JComboBox cb;
    private String title;
    private String xAxisLabel;
    private String yAxisLabel;
    private ChartPanel chartPanel;
    private XYPlot plot;
    private int maxCols = 0;
    private XYSeriesCollection dataset;
    private JPanel statusPanel;
    private JPanel controlPanel;
    private JButton nameTogglingButton;
    protected JButton selectToggleButton;
    protected boolean selectToggleState = false;
    protected JTextField selectionCountTextField;
    private NameHelper nameHelper = null;
    private JLabel lblY = new JLabel("   Y:");
    private JLabel lblRow = new JLabel("   Row:");
    private JLabel lblXAxis = new JLabel();
    private Hashtable savedPaints;
    private ItemListSelectionListener ilsl;
    private JScrollPane statusScroll;
    private JFreeChart chart;
    private JButton dismissButton;
    private JButton toggleButton;
    private static final int UNIT = 20;
    private static final int MIN_WIDTH = 333;
    private int width;
    private int cbWidth;
    private JList itemList;
    protected boolean allowLiveUpdate = false;
    private LensedDataMatrix lens = null;
    private String[] nameCategories = null;
    protected String[] allItems;
    protected ArrayList currentSelection;
    protected boolean plotsFirstDisplay = true;

    public MatrixPlotter(String string, String string2, String string3, LensedDataMatrix lensedDataMatrix, NameHelper nameHelper) {
        this.title = string;
        this.xAxisLabel = string2;
        this.yAxisLabel = string3;
        this.lens = lensedDataMatrix;
        this.allItems = lensedDataMatrix.getRowTitles();
        Arrays.sort(this.allItems);
        if (null == nameHelper) {
            nameHelper = NameHelperFactory.getNameHelper();
        }
        this.nameCategories = nameHelper.getCategoryList();
        this.nameHelper = nameHelper;
        this.allowLiveUpdate = true;
        this.initUI();
        this.show();
        this.allowLiveUpdate = false;
        this.initializeCurrentSelection();
    }

    public MatrixPlotter() {
        this("", "", "", null, null);
    }

    public MatrixPlotter(String string) {
        this(string, "", "", null, null);
    }

    public MatrixPlotter(NameHelper nameHelper) {
        this("", "", "", null, nameHelper);
    }

    public MatrixPlotter(String string, NameHelper nameHelper) {
        this(string, "", "", null, nameHelper);
    }

    public String getClassName() {
        return "MatrixPlotter";
    }

    public String getName() {
        return this.title;
    }

    public String getSpecies() {
        return this.lens.getSpecies();
    }

    public void select(String[] stringArray) {
        this.select(this.getSpecies(), stringArray);
    }

    public void select(String string, String[] stringArray) {
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (Arrays.binarySearch(this.allItems, stringArray[i]) < 0) continue;
            arrayList.add(stringArray[i]);
        }
        stringArray = arrayList.toArray(new String[0]);
        this.selectInPlotter(stringArray, bl);
    }

    public void clearSelection() {
        this.currentSelection = new ArrayList();
        this.selectInPlotter(new String[0], false);
    }

    public String[] getSelection() {
        return this.currentSelection.toArray(new String[0]);
    }

    protected void initializeCurrentSelection() {
        this.currentSelection = new ArrayList();
        String[] stringArray = this.lens.getRowTitles();
        for (int i = 0; i < stringArray.length; ++i) {
            this.currentSelection.add(stringArray[i]);
        }
        this.updateCurrentSelectionReadout(this.currentSelection.size());
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.controlPanel = this.createControlPanel();
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "West");
        this.nameTogglingButton = new JButton(IconFactory.getToggleIcon());
        this.nameTogglingButton.setBackground(Color.WHITE);
        this.nameTogglingButton.setToolTipText("Toggle the type of name displayed in the list.");
        this.nameTogglingButton.setActionCommand(this.nameHelper.getCategoryList()[0]);
        this.nameTogglingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MatrixPlotter.this.nameTogglingButton.getActionCommand().equals(MatrixPlotter.this.nameHelper.getCategoryList()[0])) {
                    MatrixPlotter.this.nameTogglingButton.setActionCommand(MatrixPlotter.this.nameHelper.getCategoryList()[1]);
                } else {
                    MatrixPlotter.this.nameTogglingButton.setActionCommand(MatrixPlotter.this.nameHelper.getCategoryList()[0]);
                }
                MatrixPlotter.this.itemList.repaint();
            }
        });
        this.itemList = new JList();
        this.ilsl = new ItemListSelectionListener();
        this.itemList.addListSelectionListener(this.ilsl);
        JScrollPane jScrollPane = new JScrollPane(this.itemList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton(IconFactory.getExportIcon());
        if (null != this.nameCategories) {
            jPanel3.add(this.nameTogglingButton);
        }
        jPanel2.add((Component)jPanel3, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel4 = new JPanel();
        JButton jButton2 = new JButton("Test");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MatrixPlotter.this.select(new String[]{"VNG6413H", "VNG2396G", "VNG6430C"});
            }
        });
        this.selectToggleButton = new JButton("-");
        this.selectToggleButton.addActionListener(new SelectToggleButtonListener());
        jPanel4.add(this.selectToggleButton);
        this.selectionCountTextField = new JTextField(3);
        jPanel4.add(this.selectionCountTextField);
        jPanel2.add((Component)jPanel4, "South");
        JPanel jPanel5 = new JPanel();
        jPanel.add((Component)jPanel5, "Center");
        jPanel5.setLayout(new BorderLayout());
        this.dataset = new XYSeriesCollection();
        this.chart = this.createChart((XYDataset)this.dataset);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setHorizontalZoom(true);
        this.chartPanel.setVerticalZoom(true);
        this.chartPanel.setMouseZoomable(true);
        LineBorder lineBorder = new LineBorder(Color.BLACK, 5);
        this.chartPanel.setBorder((Border)lineBorder);
        this.chartPanel.addChartMouseListener((ChartMouseListener)new ML());
        this.chartPanel.setHorizontalZoom(false);
        this.chartPanel.setVerticalZoom(false);
        this.chartPanel.setMouseZoomable(true);
        this.chartPanel.setSize(300, 300);
        this.chartPanel.setPreferredSize(new Dimension(300, 300));
        this.statusPanel = new JPanel();
        LineBorder lineBorder2 = new LineBorder(Color.BLACK, 2);
        this.statusPanel.setLayout(new GridLayout(1, 3));
        Font font = this.lblY.getFont();
        Font font2 = new Font(font.getFontName(), font.getStyle(), 12);
        this.lblY.setFont(font2);
        this.lblRow.setFont(font2);
        this.lblXAxis.setFont(font2);
        this.statusPanel.add(this.lblY);
        this.statusPanel.add(this.lblRow);
        if ("".equals(this.xAxisLabel)) {
            this.xAxisLabel = "Condition";
        }
        this.lblXAxis.setText("   " + this.xAxisLabel + ": ");
        this.statusPanel.add(this.lblXAxis);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add((Component)this.chartPanel, "Center");
        jPanel6.add((Component)this.statusPanel, "South");
        jPanel5.add((Component)jPanel6, "Center");
        this.toggleButton = new JButton("Hide Condition Names");
        this.toggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MatrixPlotter.this.toggleButton.getText().indexOf("Hide") > -1) {
                    MatrixPlotter.this.toggleButton.setText("Show Condition Names");
                    MatrixPlotter.this.toggleConditionNames(false);
                } else {
                    MatrixPlotter.this.toggleButton.setText("Hide Condition Names");
                    MatrixPlotter.this.toggleConditionNames(true);
                }
            }
        });
        JPanel jPanel7 = new JPanel();
        jPanel7.add(this.toggleButton);
        jPanel5.add((Component)jPanel7, "South");
        this.dismissButton = new JButton(IconFactory.getDismissIcon());
        this.dismissButton.setBackground(Color.WHITE);
        this.dismissButton.setToolTipText("Closes this window.");
        this.dismissButton.setActionCommand("dismiss");
        this.dismissButton.addActionListener(new DismissAction());
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        this.cb = new JComboBox();
        if (null != this.lens) {
            JCheckBox jCheckBox = new JCheckBox();
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (MatrixPlotter.this.width == 0) {
                    return;
                }
                JPanel jPanel = (JPanel)componentEvent.getSource();
                if (jPanel.getWidth() == MatrixPlotter.this.width) {
                    return;
                }
                if (MatrixPlotter.this.width / 20 == jPanel.getWidth() / 20) {
                    jPanel.setSize(MatrixPlotter.this.getSize());
                    return;
                }
                if (jPanel.getWidth() < 333) {
                    jPanel.setSize(333, jPanel.getHeight());
                }
                MatrixPlotter.this.width = jPanel.getWidth();
                MatrixPlotter.this.repaint();
            }
        });
    }

    protected void updateCurrentSelectionReadout(int n) {
        this.selectionCountTextField.setText(new Integer(n).toString());
    }

    protected JPanel createControlPanel() {
        this.controlPanel = new JPanel();
        JButton jButton = new JButton(IconFactory.getBroadcastIcon());
        this.controlPanel.add(jButton);
        JButton jButton2 = new JButton(IconFactory.getExportIcon());
        this.controlPanel.add(jButton2);
        return this.controlPanel;
    }

    public void addDismissListener(ActionListener actionListener) {
        this.dismissButton.addActionListener(actionListener);
    }

    public void addChartMouseListener(ChartMouseListener chartMouseListener) {
        this.chartPanel.addChartMouseListener(chartMouseListener);
    }

    public boolean getAllowLiveUpdate() {
        return this.allowLiveUpdate;
    }

    public void setAllowLiveUpdate(boolean bl) {
        this.allowLiveUpdate = bl;
    }

    private UnsortedXYSeries getSeries(String string) {
        if (this.dataset.getSeriesCount() == 0) {
            UnsortedXYSeries unsortedXYSeries = new UnsortedXYSeries(string);
            this.dataset.addSeries((XYSeries)unsortedXYSeries);
            return unsortedXYSeries;
        }
        for (int i = 0; i < this.dataset.getSeriesCount(); ++i) {
            if (!this.dataset.getSeries(i).getName().equals(string)) continue;
            return (UnsortedXYSeries)this.dataset.getSeries(i);
        }
        UnsortedXYSeries unsortedXYSeries = new UnsortedXYSeries(string);
        this.dataset.addSeries((XYSeries)unsortedXYSeries);
        return unsortedXYSeries;
    }

    private void addPoints(UnsortedXYSeries unsortedXYSeries, double[] dArray, double[] dArray2) {
        boolean bl = false;
        if (null == dArray) {
            bl = true;
            dArray = new double[dArray2.length];
        }
        for (int i = 0; i < dArray2.length; ++i) {
            if (bl) {
                dArray[i] = i;
            }
            unsortedXYSeries.add(dArray[i], dArray2[i]);
        }
    }

    private void addData(String string, double[] dArray) {
        UnsortedXYSeries unsortedXYSeries = this.getSeries(string);
        this.addPoints(unsortedXYSeries, null, dArray);
    }

    private JFreeChart createChart(XYDataset xYDataset) {
        File file = new File(this.yAxisLabel);
        String string = file.getName();
        NumberAxis numberAxis = new NumberAxis(string);
        if (null == this.symbolicNames || "".equals(this.symbolicNames[0])) {
            if (null == this.lens) {
                this.symbolicNames = new String[1];
                this.symbolicNames[0] = "";
            } else {
                this.symbolicNames = this.lens.getColumnTitles();
            }
        }
        SymbolicAxis symbolicAxis = new SymbolicAxis(this.xAxisLabel, this.symbolicNames);
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(3, (XYToolTipGenerator)new SymbolicXYItemLabelGenerator());
        this.plot = new XYPlot(xYDataset, (ValueAxis)symbolicAxis, (ValueAxis)numberAxis, (XYItemRenderer)standardXYItemRenderer);
        this.plot.setDomainGridlinesVisible(true);
        this.plot.setRangeGridlinesVisible(true);
        JFreeChart jFreeChart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.plot, false);
        this.plot.getDomainAxis().setVerticalTickLabels(true);
        AbstractRenderer abstractRenderer = (AbstractRenderer)this.plot.getRenderer();
        Rectangle2D.Double double_ = new Rectangle2D.Double(-1.75, -1.75, 3.5, 3.5);
        XYItemRenderer xYItemRenderer = this.plot.getRenderer();
        xYItemRenderer.setShape((Shape)double_);
        this.plot.getRenderer().setToolTipGenerator((XYToolTipGenerator)new ToolTipGenerator());
        return jFreeChart;
    }

    private void resetStatusPanel() {
        this.lblY.setText("   Y:");
        this.lblRow.setText("   Row:");
        this.lblXAxis.setText("   " + this.xAxisLabel + ":");
    }

    public void setSize(Dimension dimension) {
        int n = dimension.getWidth() < 333.0 ? 333 : (int)dimension.getWidth();
        super.setSize(n, (int)dimension.getHeight());
    }

    public void setSize(int n, int n2) {
        this.setSize(new Dimension(n, n2));
    }

    private void resetColors() {
        XYItemRenderer xYItemRenderer = this.plot.getRenderer();
        for (int i = 0; i < this.dataset.getSeriesCount(); ++i) {
            xYItemRenderer.setSeriesPaint(i, (Paint)this.savedPaints.get(this.dataset.getSeriesName(i)));
        }
    }

    private void setupItemList() {
        this.itemList.setCellRenderer(new SelectorListRenderer());
        LegendItemCollection legendItemCollection = this.plot.getLegendItems();
        Vector<ListItem> vector = new Vector<ListItem>();
        this.savedPaints = new Hashtable();
        for (int i = 0; i < legendItemCollection.getItemCount(); ++i) {
            LegendItem legendItem = legendItemCollection.get(i);
            String string = legendItem.getLabel();
            String string2 = this.nameHelper.getName(this.nameHelper.getCategoryList()[1], legendItem.getLabel());
            ListItem listItem = new ListItem(legendItem, string2);
            if (!vector.contains(listItem)) {
                vector.add(listItem);
            }
            this.savedPaints.put(legendItem.getLabel(), legendItem.getPaint());
        }
        this.itemList.setListData(vector);
    }

    public void show() {
        if (null != this.lens) {
            boolean bl = this.allowLiveUpdate;
            this.populateFromLens(this.lens, true);
            this.allowLiveUpdate = bl;
        }
        if (this.plotsFirstDisplay) {
            this.setupItemList();
            this.plotsFirstDisplay = false;
        }
        this.width = this.getWidth();
        super.show();
        this.setSize(this.getSize());
    }

    public void toggleConditionNames(boolean bl) {
        SymbolicAxis symbolicAxis = (SymbolicAxis)this.plot.getDomainAxis();
        String[] stringArray = new String[this.symbolicNames.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "";
        }
        symbolicAxis = bl ? new SymbolicAxis(this.xAxisLabel, this.symbolicNames) : new SymbolicAxis(this.xAxisLabel, stringArray);
        symbolicAxis.setVerticalTickLabels(true);
        this.plot.setDomainAxis((ValueAxis)symbolicAxis);
    }

    public synchronized void populateFromLens(LensedDataMatrix lensedDataMatrix, boolean bl) {
        if (!this.allowLiveUpdate) {
            return;
        }
        bl = true;
        boolean bl2 = false;
        if (this.symbolicNames.length != lensedDataMatrix.getColumnTitles().length) {
            bl2 = true;
        } else {
            for (int i = 0; i < this.symbolicNames.length; ++i) {
                if (this.symbolicNames[i].equals(lensedDataMatrix.getColumnTitles()[i])) continue;
                bl2 = true;
                break;
            }
        }
        if (bl2) {
            SymbolicAxis symbolicAxis = (SymbolicAxis)this.plot.getDomainAxis();
            this.symbolicNames = lensedDataMatrix.getColumnTitles();
            symbolicAxis = new SymbolicAxis(this.xAxisLabel, this.symbolicNames);
            symbolicAxis.setVerticalTickLabels(true);
            this.plot.getRenderer().setToolTipGenerator((XYToolTipGenerator)new ToolTipGenerator());
            this.plot.setDomainAxis((ValueAxis)symbolicAxis);
        }
        File file = new File(lensedDataMatrix.getUnderlyingMatrix().getShortName());
        this.resetStatusPanel();
        this.dataset.removeAllSeries();
        this.yAxisLabel = file.getName();
        if (lensedDataMatrix.getRowCount() == 0) {
            return;
        }
        for (int i = 0; i < lensedDataMatrix.getRowCount(); ++i) {
            double[] dArray = lensedDataMatrix.get(i);
            this.addData(lensedDataMatrix.getRowTitles()[i], dArray);
        }
        if (bl) {
            this.chart = this.createChart((XYDataset)this.dataset);
            if (this.toggleButton.getText().indexOf("Show") > -1) {
                this.toggleConditionNames(false);
            }
        }
        if (this.chartPanel != null) {
            this.chartPanel.setChart(this.chart);
        }
        this.setupItemList();
        this.resetColors();
        this.repaint();
    }

    public void placeInCenter() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        int n = (int)graphicsConfiguration.getBounds().getHeight();
        int n2 = (int)graphicsConfiguration.getBounds().getWidth();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        this.setLocation((n2 - n3) / 2, (n - n4) / 2);
    }

    protected void deselectAll() {
        this.currentSelection = new ArrayList();
        this.selectInPlotter(new String[0], false);
    }

    protected void selectInPlotter(String[] stringArray, boolean bl) {
        int n;
        if (bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.currentSelection.contains(stringArray[i])) continue;
                this.currentSelection.add(stringArray[i]);
            }
            stringArray = this.currentSelection.toArray(new String[0]);
        }
        this.updateCurrentSelectionReadout(this.currentSelection.size());
        LegendItemCollection legendItemCollection = this.plot.getLegendItems();
        XYItemRenderer xYItemRenderer = this.plot.getRenderer();
        Color color = new Color(210, 210, 210);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Hashtable<Integer, String> hashtable2 = new Hashtable<Integer, String>();
        for (n = 0; n < this.dataset.getSeriesCount(); ++n) {
            Integer n2 = new Integer(n);
            hashtable.put(this.dataset.getSeriesName(n), n2);
            hashtable2.put(n2, this.dataset.getSeriesName(n));
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (!hashtable.containsKey(stringArray[n])) continue;
            int n3 = (Integer)hashtable.get(stringArray[n]);
            xYSeriesCollection.addSeries(this.dataset.getSeries(n3));
        }
        for (n = 0; n < this.dataset.getSeriesCount(); ++n) {
            xYItemRenderer.setSeriesPaint(n, (Paint)color);
        }
        for (n = 0; n < xYSeriesCollection.getSeriesCount(); ++n) {
            String string = xYSeriesCollection.getSeriesName(n);
            this.dataset.addSeries(xYSeriesCollection.getSeries(n));
            int n4 = (Integer)hashtable.get(string);
            xYItemRenderer.setSeriesPaint(this.dataset.getSeriesCount() - 1, (Paint)this.savedPaints.get(xYSeriesCollection.getSeriesName(n)));
        }
        this.chartPanel.repaint();
    }

    public String toString() {
        return "matrix plotter '" + this.title + " with selection count: " + this.selectionCountTextField.getText();
    }

    class SelectorListRenderer
    implements ListCellRenderer {
        SelectorListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            LegendItem legendItem = null;
            Object var7_7 = null;
            ListItem listItem = null;
            String string = null;
            if (!(object instanceof ListItem)) {
                return null;
            }
            listItem = (ListItem)object;
            legendItem = listItem.getLegendItem();
            string = listItem.getAlternameName();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout());
            Font font = new Font(jList.getFont().getName(), 0, jList.getFont().getSize() - 2);
            String string2 = MatrixPlotter.this.nameHelper.getName(MatrixPlotter.this.nameTogglingButton.getActionCommand(), legendItem.getLabel());
            String string3 = legendItem.getLabel();
            if (!string.equals(legendItem.getLabel())) {
                string3 = string3 + " (" + string + ")";
            }
            jPanel.setToolTipText(string3);
            JButton jButton = new JButton(string2);
            jButton.setSize(new Dimension(20, 20));
            jButton.setForeground((Color)legendItem.getPaint());
            JLabel jLabel = new JLabel();
            Color color = jLabel.getBackground();
            jPanel.add(jButton);
            return jPanel;
        }
    }

    class ItemListSelectionListener
    implements ListSelectionListener {
        ItemListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            Object object;
            LegendItem legendItem;
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            JList jList = (JList)listSelectionEvent.getSource();
            Object[] objectArray = jList.getSelectedValues();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            for (int i = 0; i < objectArray.length; ++i) {
                ListItem listItem = (ListItem)objectArray[i];
                legendItem = listItem.getLegendItem();
                hashtable.put(legendItem.getLabel(), "~");
            }
            String[] stringArray = hashtable.keySet().toArray(new String[0]);
            MatrixPlotter.this.currentSelection = new ArrayList();
            for (int i = 0; i < stringArray.length; ++i) {
                MatrixPlotter.this.currentSelection.add(stringArray[i]);
            }
            MatrixPlotter.this.updateCurrentSelectionReadout(MatrixPlotter.this.currentSelection.size());
            LegendItemCollection legendItemCollection = MatrixPlotter.this.plot.getLegendItems();
            legendItem = MatrixPlotter.this.plot.getRenderer();
            Color color = new Color(210, 210, 210);
            XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            Hashtable<Object, String> hashtable3 = new Hashtable<Object, String>();
            for (int i = 0; i < MatrixPlotter.this.dataset.getSeriesCount(); ++i) {
                object = new Integer(i);
                hashtable2.put(MatrixPlotter.this.dataset.getSeriesName(i), object);
                hashtable3.put(object, MatrixPlotter.this.dataset.getSeriesName(i));
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                int n2 = (Integer)hashtable2.get(object);
                xYSeriesCollection.addSeries(MatrixPlotter.this.dataset.getSeries(n2));
            }
            for (n = 0; n < MatrixPlotter.this.dataset.getSeriesCount(); ++n) {
                try {
                    String string = MatrixPlotter.this.dataset.getSeriesName(n);
                    if (null != hashtable.get(new Integer(n))) {
                        MatrixPlotter.this.dataset.removeSeries(n);
                        continue;
                    }
                    legendItem.setSeriesPaint(n, (Paint)color);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    System.out.println("caught ex");
                }
            }
            for (n = 0; n < xYSeriesCollection.getSeriesCount(); ++n) {
                String string = xYSeriesCollection.getSeriesName(n);
                MatrixPlotter.this.dataset.addSeries(xYSeriesCollection.getSeries(n));
                int n3 = (Integer)hashtable2.get(string);
                legendItem.setSeriesPaint(MatrixPlotter.this.dataset.getSeriesCount() - 1, (Paint)MatrixPlotter.this.savedPaints.get(xYSeriesCollection.getSeriesName(n)));
            }
            MatrixPlotter.this.chartPanel.repaint();
        }
    }

    class ListItem {
        private LegendItem li;
        private String alternateName;

        protected ListItem(LegendItem legendItem, String string) {
            this.li = legendItem;
            this.alternateName = string;
        }

        protected LegendItem getLegendItem() {
            return this.li;
        }

        protected String getAlternameName() {
            return this.alternateName;
        }
    }

    class ML
    implements ChartMouseListener {
        ML() {
        }

        public void chartMouseClicked(ChartMouseEvent chartMouseEvent) {
            ChartEntity chartEntity = chartMouseEvent.getEntity();
            String string = null;
            try {
                string = chartEntity.getShapeType();
            }
            catch (NullPointerException nullPointerException) {
                MatrixPlotter.this.resetStatusPanel();
                return;
            }
            XYMetaData xYMetaData = XYMetaData.parseToolTip((String)chartEntity.getToolTipText());
            MatrixPlotter.this.lblY.setText("   Y: " + xYMetaData.getY());
            MatrixPlotter.this.lblRow.setText("   Row: " + xYMetaData.getRow());
            try {
                MatrixPlotter.this.lblXAxis.setText("   " + MatrixPlotter.this.xAxisLabel + ": " + xYMetaData.getXTickName());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void chartMouseMoved(ChartMouseEvent chartMouseEvent) {
        }
    }

    class ToolTipGenerator
    implements XYToolTipGenerator {
        ToolTipGenerator() {
        }

        public String generateToolTip(XYDataset xYDataset, int n, int n2) {
            double d = (Double)xYDataset.getXValue(n, n2);
            double d2 = (Double)xYDataset.getYValue(n, n2);
            String string = xYDataset.getSeriesName(n);
            String string2 = null;
            string2 = MatrixPlotter.this.nameHelper.getName(MatrixPlotter.this.nameHelper.getDefaultCategory(), string);
            String string3 = MatrixPlotter.this.nameHelper.getName(MatrixPlotter.this.nameHelper.getCategoryList()[1], string);
            String string4 = "";
            if (d % 1.0 == 0.0) {
                try {
                    string4 = MatrixPlotter.this.xAxisLabel + "=" + MatrixPlotter.this.symbolicNames[(int)d];
                }
                catch (Exception exception) {
                    string4 = MatrixPlotter.this.xAxisLabel + "=Unknown";
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>" + string4 + "<br>y=" + d2 + "<br>row=" + string);
            if (null != string2 && string != string2) {
                stringBuffer.append(", " + string2);
            }
            if (!string3.equals(string2)) {
                stringBuffer.append(" (" + string3 + ")");
            }
            stringBuffer.append("</html>");
            return stringBuffer.toString();
        }
    }

    public class DismissAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("MatrixPlotter.dismiss ()");
        }
    }

    class SelectToggleButtonListener
    implements ActionListener {
        SelectToggleButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            if (MatrixPlotter.this.selectToggleState) {
                string = "-";
                MatrixPlotter.this.selectInPlotter(MatrixPlotter.this.allItems, true);
                MatrixPlotter.this.initializeCurrentSelection();
            } else {
                string = "+";
                MatrixPlotter.this.selectInPlotter(new String[0], true);
                MatrixPlotter.this.clearSelection();
            }
            MatrixPlotter.this.selectToggleButton.setLabel(string);
            MatrixPlotter.this.selectToggleState = !MatrixPlotter.this.selectToggleState;
        }
    }
}

