/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.datamatrix;

import csplugins.isb.pshannon.experiment.datamatrix.DataMatrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class MatrixCombiner {
    DataMatrix[] matrices;
    String[] newColumnTitles;
    String[] newRowTitles;
    HashMap columnTitleHash;
    HashMap rowTitleHash;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MatrixCombiner(DataMatrix[] dataMatrixArray) {
        this.matrices = dataMatrixArray;
        for (int i = 0; i < dataMatrixArray.length; ++i) {
            System.out.println(" MC.ctor " + i + ", species: " + dataMatrixArray[i].getSpecies());
        }
        this.newColumnTitles = this.createNonRedundantTitleList("column");
        this.newRowTitles = this.createNonRedundantTitleList("row");
        this.columnTitleHash = this.createTitleHash(this.newColumnTitles);
        this.rowTitleHash = this.createTitleHash(this.newRowTitles);
    }

    public DataMatrix combine() {
        DataMatrix dataMatrix = new DataMatrix();
        dataMatrix.setSize(this.newRowTitles.length, this.newColumnTitles.length);
        dataMatrix.setRowTitles(this.newRowTitles);
        dataMatrix.setRowTitlesTitle(this.matrices[0].getRowTitlesTitle());
        dataMatrix.setColumnTitles(this.newColumnTitles);
        dataMatrix.setDefault(Double.NaN);
        System.out.println("MatrixCombiner.combine, species of 0th: " + this.matrices[0].getSpecies());
        dataMatrix.setSpecies(this.matrices[0].getSpecies());
        for (int i = 0; i < this.matrices.length; ++i) {
            DataMatrix dataMatrix2 = this.matrices[i];
            double[][] dArray = dataMatrix2.get();
            for (int j = 0; j < dataMatrix2.getRowCount(); ++j) {
                for (int k = 0; k < dataMatrix2.getColumnCount(); ++k) {
                    int[] nArray = this.newIndices(dataMatrix2, j, k);
                    double d = dArray[j][k];
                    dataMatrix.set(nArray[0], nArray[1], d);
                }
            }
        }
        return dataMatrix;
    }

    protected int[] newIndices(DataMatrix dataMatrix, int n, int n2) {
        String string = dataMatrix.getRowTitles()[n];
        String string2 = dataMatrix.getColumnTitles()[n2];
        int n3 = (Integer)this.rowTitleHash.get(string);
        int n4 = (Integer)this.columnTitleHash.get(string2);
        return new int[]{n3, n4};
    }

    protected String[] createNonRedundantTitleList(String string) {
        if (!($assertionsDisabled || string.equals("row") || string.equals("column"))) {
            throw new AssertionError();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.matrices.length; ++i) {
            DataMatrix dataMatrix = this.matrices[i];
            String[] stringArray = string.equals("row") ? dataMatrix.getRowTitles() : dataMatrix.getColumnTitles();
            for (int j = 0; j < stringArray.length; ++j) {
                String string2 = stringArray[j];
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        Object[] objectArray = arrayList.toArray(new String[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public HashMap createTitleHash(String[] stringArray) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], new Integer(i));
        }
        return hashMap;
    }

    protected DataMatrix createEmptyMatrix(String[] stringArray) {
        DataMatrix dataMatrix = new DataMatrix();
        dataMatrix.setSize(0, stringArray.length);
        dataMatrix.setColumnTitles(stringArray);
        return dataMatrix;
    }

    static {
        $assertionsDisabled = !MatrixCombiner.class.desiredAssertionStatus();
    }
}

