/*
 * Decompiled with CFR 0.152.
 */
package DataLoader;

import DataLoader.NullWizardPanel;
import DataLoader.WizardContext;
import DataLoader.WizardListener;
import DataLoader.WizardPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class Wizard
extends JPanel
implements ActionListener {
    public static final String BACK_I18N = "BACK_I18N";
    public static final String NEXT_I18N = "NEXT_I18N";
    public static final String FINISH_I18N = "FINISH_I18N";
    public static final String CANCEL_I18N = "CANCEL_I18N";
    public static final String HELP_I18N = "HELP_I18N";
    public static final Dimension WIZARD_WINDOW_SIZE = new Dimension(800, 600);
    private final JButton backButton = new JButton("<< back");
    private final JButton nextButton = new JButton("next >>");
    private final JButton finishButton = new JButton("finish");
    private final JButton cancelButton = new JButton("cancel");
    private final JButton helpButton = new JButton("help");
    private final HashMap listeners = new HashMap();
    private Stack previous = null;
    private WizardPanel current = null;
    private WizardContext ctx = null;
    private Map i18n = null;

    public Wizard(Map map) {
        this.i18n = map;
        this.init();
        this.applyI18N(this.i18n);
    }

    public Wizard() {
        this.init();
    }

    public Wizard(WizardContext wizardContext) {
        this.init();
        this.ctx = wizardContext;
    }

    private void init() {
        this.nextButton.addActionListener(this);
        this.backButton.addActionListener(this);
        this.finishButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.nextButton.setEnabled(false);
        this.backButton.setEnabled(false);
        this.finishButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.helpButton.setEnabled(false);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        jPanel.add(this.backButton);
        jPanel.add(this.nextButton);
        jPanel.add(this.finishButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(this.cancelButton);
        jPanel2.add(this.helpButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel, "East");
        jPanel3.add((Component)jPanel2, "West");
        this.add((Component)jPanel3, "South");
        this.setMinimumSize(WIZARD_WINDOW_SIZE);
        this.setPreferredSize(WIZARD_WINDOW_SIZE);
    }

    public void setI18NMap(Map map) {
        this.i18n = map;
        this.applyI18N(this.i18n);
    }

    private void applyI18N(Map map) {
        if (map.size() > 0) {
            this.nextButton.setText((String)map.get(NEXT_I18N));
            this.backButton.setText((String)map.get(BACK_I18N));
            this.finishButton.setText((String)map.get(FINISH_I18N));
            this.cancelButton.setText((String)map.get(CANCEL_I18N));
            this.helpButton.setText((String)map.get(HELP_I18N));
            this.backButton.setActionCommand("<< back");
            this.nextButton.setActionCommand("next >>");
            this.finishButton.setActionCommand("finish");
            this.cancelButton.setActionCommand("cancel");
            this.helpButton.setActionCommand("help");
        }
    }

    public void addWizardListener(WizardListener wizardListener) {
        this.listeners.put(wizardListener, wizardListener);
    }

    public void removeWizardListener(WizardListener wizardListener) {
        this.listeners.remove(wizardListener);
    }

    public void start(WizardPanel wizardPanel) {
        this.previous = new Stack();
        if (this.ctx == null) {
            this.ctx = new WizardContext();
        }
        wizardPanel.setWizardContext(this.ctx);
        this.setPanel(wizardPanel);
        this.updateButtons();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("<< back".equals(string)) {
            this.back();
        } else if ("next >>".equals(string)) {
            this.next();
        } else if ("finish".equals(string)) {
            this.finish();
        } else if ("cancel".equals(string)) {
            this.cancel();
        } else if ("help".equals(string)) {
            this.help();
        }
    }

    private void setPanel(WizardPanel wizardPanel) {
        if (null != this.current) {
            this.remove(this.current);
        }
        this.current = wizardPanel;
        if (null == this.current) {
            this.current = new NullWizardPanel();
        }
        this.add((Component)this.current, "Center");
        Iterator iterator = this.listeners.values().iterator();
        while (iterator.hasNext()) {
            WizardListener wizardListener = (WizardListener)iterator.next();
            wizardListener.wizardPanelChanged(this);
        }
        this.setVisible(true);
        this.revalidate();
        this.updateUI();
        this.current.display();
    }

    private void updateButtons() {
        this.cancelButton.setEnabled(this.current.canCancel());
        this.helpButton.setEnabled(this.current.hasHelp());
        this.backButton.setEnabled(this.previous.size() > 0);
        this.nextButton.setEnabled(this.current.hasNext());
        this.finishButton.setEnabled(this.current.canFinish());
    }

    private void back() {
        WizardPanel wizardPanel = (WizardPanel)this.previous.pop();
        this.setPanel(wizardPanel);
        this.updateButtons();
    }

    private void next() {
        ArrayList arrayList = new ArrayList();
        if (this.current.validateNext(arrayList)) {
            this.previous.push(this.current);
            WizardPanel wizardPanel = this.current.next();
            if (null != wizardPanel) {
                wizardPanel.setWizardContext(this.ctx);
            }
            this.setPanel(wizardPanel);
            this.updateButtons();
        } else {
            this.showErrorMessages(arrayList);
        }
    }

    private void finish() {
        ArrayList arrayList = new ArrayList();
        if (this.current.validateFinish(arrayList)) {
            this.current.finish();
            Iterator iterator = this.listeners.values().iterator();
            while (iterator.hasNext()) {
                WizardListener wizardListener = (WizardListener)iterator.next();
                wizardListener.wizardFinished(this);
            }
        } else {
            this.showErrorMessages(arrayList);
        }
    }

    private void cancel() {
        Iterator iterator = this.listeners.values().iterator();
        while (iterator.hasNext()) {
            WizardListener wizardListener = (WizardListener)iterator.next();
            wizardListener.wizardCancelled(this);
        }
    }

    private void help() {
        this.current.help();
    }

    private void showErrorMessages(ArrayList arrayList) {
        Object[] objectArray = arrayList.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof String)) continue;
            JOptionPane.showMessageDialog(this, objectArray[i], "Data Loader Error", 0);
        }
    }
}

