/*
 * Decompiled with CFR 0.152.
 */
package DataLoader;

import DataLoader.VariableTableModel;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class VariableTable
extends JTable
implements MouseListener,
ActionListener {
    private static String SET_VALUE = "Set Value";
    private Vector selectedCells = new Vector();
    private DefaultTableModel model = new VariableTableModel();

    public VariableTable(int n, int n2) {
        this.setModel(this.model);
        for (int i = 0; i < n; ++i) {
            this.model.insertRow(0, new Object[this.getColumnCount()]);
        }
        this.setRowHeight(n2);
        this.setCellSelectionEnabled(true);
        this.addMouseListener(this);
        this.setAutoResizeMode(0);
    }

    public void addDataColumn(String string) {
        int n = this.getRowCount();
        Object[] objectArray = new String[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = "";
        }
        this.model.addColumn((Object)string, objectArray);
        this.packColumn(this.getColumnCount() - 1, 5);
        this.doLayout();
        this.repaint();
    }

    public void removeLastColumn() {
        int n = this.model.getColumnCount();
        if (n > 0) {
            this.model.setColumnCount(n - 1);
        }
    }

    public String getColumnHeader(int n) {
        if (n >= this.getColumnCount()) {
            return null;
        }
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        return (String)tableColumn.getHeaderValue();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n;
        Point point;
        int n2;
        if (SwingUtilities.isRightMouseButton(mouseEvent) && this.isCellSelected(n2 = this.rowAtPoint(point = mouseEvent.getPoint()), n = this.columnAtPoint(point))) {
            int n3;
            int n4 = this.getSelectedRow();
            int n5 = this.getSelectionModel().getMaxSelectionIndex();
            int n6 = this.getSelectedColumn();
            if (n6 != (n3 = this.getColumnModel().getSelectionModel().getMaxSelectionIndex())) {
                JOptionPane.showMessageDialog(this, "Multiple Variables Selected.\n\nPlease choose only one variable ");
                return;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Set Value...");
            jMenuItem.setActionCommand(SET_VALUE);
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.setLightWeightPopupEnabled(false);
            jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (SET_VALUE.equals(string)) {
            String string2 = JOptionPane.showInputDialog(this, (Object)"Set Value To: ");
            for (int i = 0; i < this.getColumnCount(); ++i) {
                for (int j = 0; j < this.getRowCount(); ++j) {
                    if (!this.isCellSelected(j, i)) continue;
                    this.setValueAt(string2, j, i);
                }
                this.packColumn(i, 5);
            }
        }
        this.repaint();
    }

    public void packColumn(int n, int n2) {
        TableModel tableModel = this.getModel();
        DefaultTableColumnModel defaultTableColumnModel = (DefaultTableColumnModel)this.getColumnModel();
        TableColumn tableColumn = defaultTableColumnModel.getColumn(n);
        int n3 = 0;
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getTableHeader().getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(this, tableColumn.getHeaderValue(), false, false, 0, 0);
        n3 = component.getPreferredSize().width;
        for (int i = 0; i < this.getRowCount(); ++i) {
            tableCellRenderer = this.getCellRenderer(i, n);
            component = tableCellRenderer.getTableCellRendererComponent(this, this.getValueAt(i, n), false, false, i, n);
            n3 = Math.max(n3, component.getPreferredSize().width);
        }
        tableColumn.setPreferredWidth(n3 += 2 * n2);
    }
}

