/*
 * Decompiled with CFR 0.152.
 */
package DataLoader;

import DataLoader.ConditionInfoWizardPanel;
import DataLoader.ConditionVariable;
import DataLoader.WizardContext;
import DataLoader.WizardPanel;
import SBEAMS.SBEAMSClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class GeneralInfoWizardPanel
extends WizardPanel {
    private JComboBox organismDropDown;
    private JComboBox constantsDropDown;
    private JTextField strain;
    private JTextField manipulationType;
    private JTextField manipulatedVariable;
    private JTextField constantsFile;
    private JTable constantsTable;
    private JScrollPane constantsScrollPane;
    private BufferedReader bufferedReader;
    private StringBuffer strbuf;
    private SBEAMSClient sc;
    private Hashtable constantsFiles;
    private String[] titles = new String[]{"Variable", "Value", "Units"};
    private static String CONSTANTS = "Constants";
    private static String SELECT_ORGANISM = "---Select Organism---";
    private static String SELECT_CONSTANTS = "---Select Constants---";
    private static String OTHER_ORGANISM = "Other...";
    private static String SBEAMS_SERVER_BASE = "http://db";
    private static String constantsFileURL = SBEAMS_SERVER_BASE + "/sbeams/cgi/Microarray/ViewFile.cgi?action=read&FILE_NAME=";
    private static String organismURL = SBEAMS_SERVER_BASE + "/sbeams/cgi/Microarray/ManageTable.cgi?TABLE_NAME=organism&output_mode=tsv";
    private static String constantsURL = SBEAMS_SERVER_BASE + "/sbeams/cgi/Microarray/ManageTable.cgi?TABLE_NAME=MA_experiment_constants&output_mode=tsv";

    public GeneralInfoWizardPanel(WizardContext wizardContext) {
        Object object;
        String[] stringArray;
        this.setWizardContext(wizardContext);
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("Step 3.  Describe the General Experiment Information"));
        SpringLayout springLayout = new SpringLayout();
        JPanel jPanel = new JPanel(springLayout);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 2));
        jPanel2.add(new JLabel("Organism"));
        if (this.wizardContext.getAttribute(SBEAMS_CLIENT) == null) {
            try {
                this.sc = new SBEAMSClient(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.sc = (SBEAMSClient)this.wizardContext.getAttribute(SBEAMS_CLIENT);
        }
        Vector<String> vector = new Vector<String>();
        vector.add(SELECT_ORGANISM);
        try {
            stringArray = this.sc.fetchSbeamsResultSetColumn(organismURL, "full_name");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("Other")) continue;
                vector.add(stringArray[i]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        vector.add(OTHER_ORGANISM);
        stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        this.organismDropDown = new JComboBox<String>(stringArray);
        this.organismDropDown.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    String string = new String("");
                    if (!((String)GeneralInfoWizardPanel.this.organismDropDown.getSelectedItem()).equals(OTHER_ORGANISM)) {
                        return;
                    }
                    string = JOptionPane.showInputDialog(null, (Object)"What is the name of this organism?");
                    if (string.equals("")) {
                        return;
                    }
                    int n = GeneralInfoWizardPanel.this.organismDropDown.getItemCount();
                    for (int i = 0; i < n; ++i) {
                        if (!string.equals((String)GeneralInfoWizardPanel.this.organismDropDown.getItemAt(i))) continue;
                        JOptionPane.showMessageDialog(null, "Organism is currently in the list!", "Alert", 0);
                        return;
                    }
                    if (!string.equals("")) {
                        GeneralInfoWizardPanel.this.organismDropDown.addItem(string);
                        GeneralInfoWizardPanel.this.organismDropDown.setSelectedItem(string);
                        GeneralInfoWizardPanel.this.organismDropDown.repaint();
                    }
                }
            }
        });
        jPanel2.add(this.organismDropDown);
        jPanel2.add(new JLabel("Strain"));
        this.strain = new JTextField("wild type", 30);
        jPanel2.add(this.strain);
        String string = (String)this.wizardContext.getAttribute(WIZARD_PERTURBATION);
        String[] stringArray2 = string.split(":");
        String string2 = new String();
        String string3 = new String();
        if (stringArray2.length >= 3) {
            string2 = stringArray2[0];
            string3 = stringArray2[stringArray2.length - 2];
        }
        jPanel2.add(new JLabel("Manipulation Type"));
        this.manipulationType = new JTextField(string2, 30);
        jPanel2.add(this.manipulationType);
        jPanel2.add(new JLabel("Manipulated Variable"));
        this.manipulatedVariable = new JTextField(string3, 30);
        jPanel2.add(this.manipulatedVariable);
        Vector<String> vector2 = new Vector<String>();
        this.constantsFiles = new Hashtable();
        vector2.add(SELECT_CONSTANTS);
        try {
            this.constantsFiles = this.sc.fetchSbeamsResultSetHash(constantsURL, "name", "experiment_constants_id");
            object = this.constantsFiles.keys();
            while (object.hasMoreElements()) {
                vector2.add((String)object.nextElement());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = new String[vector2.size()];
        vector2.toArray((T[])object);
        Arrays.sort((Object[])object);
        this.constantsDropDown = new JComboBox((E[])object);
        this.constantsDropDown.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Integer n = new Integer((String)GeneralInfoWizardPanel.this.constantsFiles.get(itemEvent.getItem()));
                    String string = constantsFileURL + GeneralInfoWizardPanel.this.constantsFiles.get(itemEvent.getItem()) + "_constants_file.dat";
                    try {
                        Object[][] objectArray = GeneralInfoWizardPanel.this.interpretConstants(n, GeneralInfoWizardPanel.this.sc.fetchSbeamsPage(string));
                        if (objectArray != null) {
                            ((DefaultTableModel)GeneralInfoWizardPanel.this.constantsTable.getModel()).setDataVector(objectArray, GeneralInfoWizardPanel.this.titles);
                        }
                        GeneralInfoWizardPanel.this.constantsScrollPane.getParent().setVisible(false);
                        GeneralInfoWizardPanel.this.constantsTable.repaint();
                        Dimension dimension = GeneralInfoWizardPanel.this.constantsTable.getPreferredSize();
                        GeneralInfoWizardPanel.this.constantsScrollPane.setPreferredSize(dimension);
                        GeneralInfoWizardPanel.this.constantsScrollPane.repaint();
                        GeneralInfoWizardPanel.this.constantsScrollPane.getParent().setVisible(true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        jPanel2.add(new JLabel("Constants"));
        jPanel2.add(this.constantsDropDown);
        jPanel.add(jPanel2);
        springLayout.putConstraint("West", (Component)jPanel2, 10, "West", (Component)jPanel);
        this.add((Component)jPanel, "Center");
        ConstantsTableModel constantsTableModel = new ConstantsTableModel();
        this.constantsTable = new JTable(constantsTableModel);
        constantsTableModel.setDataVector(new String[5][3], this.titles);
        Dimension dimension = this.constantsTable.getPreferredSize();
        this.constantsScrollPane = new JScrollPane(this.constantsTable);
        this.constantsScrollPane.setPreferredSize(dimension);
        this.add((Component)this.constantsScrollPane, "South");
    }

    public String[][] interpretConstants(Integer n, String string) {
        this.wizardContext.setAttribute(WIZARD_CONSTANTS_ID, n);
        return this.interpretConstants(string);
    }

    public String[][] interpretConstants(String string) {
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        Vector<ConditionVariable> vector2 = new Vector<ConditionVariable>();
        String[] stringArray2 = string.split("\\n");
        Pattern pattern = Pattern.compile(".*?<variable name='(.*?)'.*");
        Pattern pattern2 = Pattern.compile(".*?name='.*?'.*?value='(.*?)' .*>");
        Pattern pattern3 = Pattern.compile(".*?name.*?units='(.*?)'.*>");
        for (int i = 0; i < stringArray2.length; ++i) {
            Matcher matcher = pattern.matcher(stringArray2[i]);
            stringArray = pattern2.matcher(stringArray2[i]);
            Matcher matcher2 = pattern3.matcher(stringArray2[i]);
            if (!matcher.matches()) continue;
            String[] stringArray3 = new String[]{matcher.group(1), stringArray.matches() ? stringArray.group(1) : "", matcher2.matches() ? matcher2.group(1) : ""};
            vector.addElement(stringArray3);
            ConditionVariable conditionVariable = new ConditionVariable(stringArray3[0], stringArray3[1], stringArray3[2]);
            vector2.addElement(conditionVariable);
        }
        this.wizardContext.setAttribute(WIZARD_CONSTANTS, vector2);
        if (vector.size() > 0) {
            String[][] stringArray4 = new String[vector.size()][3];
            for (int i = 0; i < vector.size(); ++i) {
                stringArray = (String[])vector.elementAt(i);
                stringArray4[i] = stringArray;
            }
            return stringArray4;
        }
        return null;
    }

    public String[][] readConstants(String string) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        try {
            this.bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        this.strbuf = new StringBuffer();
        boolean bl = false;
        try {
            String string2;
            while ((string2 = this.bufferedReader.readLine()) != null) {
                this.strbuf.append(string2 + "\n");
            }
            String string3 = this.strbuf.toString();
            return this.interpretConstants(string3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public void display() {
    }

    public boolean hasNext() {
        return true;
    }

    public boolean validateNext(List list) {
        boolean bl = true;
        String string = (String)this.organismDropDown.getSelectedItem();
        String string2 = this.strain.getText();
        String string3 = this.manipulationType.getText();
        String string4 = this.manipulatedVariable.getText();
        if (string.equals(SELECT_ORGANISM)) {
            list.add("Please Select Organism Before Continuing");
            bl = false;
        } else {
            this.wizardContext.setAttribute(WIZARD_ORGANISM, string);
        }
        if (string2 == null) {
            list.add("Please Select Strain Before Continuing");
            bl = false;
        } else {
            this.wizardContext.setAttribute(WIZARD_STRAIN, string2);
        }
        if (string3 == null) {
            list.add("Please Select Manipulation Type Before Continuing");
            bl = false;
        } else {
            this.wizardContext.setAttribute(WIZARD_MANIPULATION_TYPE, string3);
        }
        if (string4 == null) {
            list.add("Please Select Manipulated Variable Before Continuing");
            bl = false;
        } else {
            this.wizardContext.setAttribute(WIZARD_MANIPULATED_VARIABLE, string4);
        }
        return bl;
    }

    public WizardPanel next() {
        return new ConditionInfoWizardPanel(this.getWizardContext());
    }

    public boolean canFinish() {
        return false;
    }

    public boolean canCancel() {
        return true;
    }

    public boolean validateFinish(List list) {
        return false;
    }

    public void finish() {
    }

    class ConstantsTableModel
    extends DefaultTableModel {
        ConstantsTableModel() {
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

