/*
 * Decompiled with CFR 0.152.
 */
package DataLoader;

import DataLoader.ExperimentCondition;
import SBEAMS.SBEAMSClient;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GeneExpressionFileReader {
    private String dataFileURI;
    private SBEAMSClient sc;
    private BufferedReader br;
    private StringBuffer sb;
    private static String MRNA = "MRNA";
    private static String MERGECONDS = "MERGECONDS";
    private static String UNKNOWN = "UNKNOWN";
    private Hashtable data;
    private String[] conditionNames;
    private Hashtable rosetta;

    public GeneExpressionFileReader(String string, String string2, SBEAMSClient sBEAMSClient) {
        this.sc = sBEAMSClient;
        this.rosetta = this.readTranslator(string2);
        this.dataFileURI = string;
        this.data = new Hashtable();
    }

    public GeneExpressionFileReader(String string, String string2) {
        this.rosetta = this.readTranslator(string2);
        this.dataFileURI = string;
        this.data = new Hashtable();
    }

    public GeneExpressionFileReader(String string) {
        this.rosetta = new Hashtable();
        this.dataFileURI = string;
        this.data = new Hashtable();
    }

    public boolean read() {
        String[] stringArray = this.getFile(this.dataFileURI);
        String string = this.determineFileType(stringArray[0]);
        boolean bl = false;
        if (string.equals(MRNA)) {
            bl = this.readMrnaFile(stringArray);
        } else if (string.equals(MERGECONDS)) {
            bl = this.readMergeCondsFile(stringArray);
        } else if (string.equals(UNKNOWN)) {
            // empty if block
        }
        return bl;
    }

    private String[] getFile(String string) {
        if (string.startsWith("sbeamsIndirect://")) {
            try {
                String[] stringArray = string.split("://");
                if (this.sc != null) {
                    this.sc = new SBEAMSClient(true);
                }
                String string2 = this.sc.fetchSbeamsPage("http://" + stringArray[1]);
                return string2.split("\\n");
            }
            catch (IOException iOException) {
                System.err.println("Page Not Found");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                String string3;
                this.br = new BufferedReader(new FileReader(string));
                this.sb = new StringBuffer();
                while ((string3 = this.br.readLine()) != null) {
                    this.sb.append(string3 + "\n");
                }
                String string4 = this.sb.toString();
                return string4.split("\\n");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    private String determineFileType(String string) {
        String string2 = UNKNOWN;
        String string3 = this.fileTypeUsingFileName();
        String string4 = UNKNOWN;
        String[] stringArray = string.split("\\s");
        Pattern pattern = Pattern.compile(".*RATIOS\\s*LAMBDAS.*");
        Pattern pattern2 = Pattern.compile("sequence_name\\s+gene_name.*");
        Matcher matcher = pattern.matcher(string);
        Matcher matcher2 = pattern2.matcher(string);
        if (matcher.matches()) {
            string4 = MERGECONDS;
        } else if (matcher2.matches()) {
            string4 = MRNA;
        }
        if (!string3.equals(string4)) {
            System.out.println("File Name (" + string3 + ")and Header (" + string4 + ") don't match.");
            string2 = string3.equals(UNKNOWN) ? string4 : string3;
        } else {
            string2 = string3;
        }
        System.out.println("Using Type: " + string2);
        return string2;
    }

    private String fileTypeUsingFileName() {
        if (this.dataFileURI.endsWith(".mrna")) {
            return MRNA;
        }
        if (this.dataFileURI.equals("matrix_output") || this.dataFileURI.endsWith(".merge")) {
            return MERGECONDS;
        }
        return UNKNOWN;
    }

    private boolean readMrnaFile(String[] stringArray) {
        int n = 1;
        int n2 = 0;
        int n3 = 2;
        int n4 = 0;
        String string = "\\s";
        return this.readDelimitedFile(stringArray, string, n, n2, n3, n4);
    }

    private boolean readMergeCondsFile(String[] stringArray) {
        int n = 2;
        int n2 = 1;
        int n3 = 2;
        int n4 = 1;
        String string = "\\t";
        return this.readDelimitedFile(stringArray, string, n, n2, n3, n4);
    }

    private boolean readDelimitedFile(String[] stringArray, String string, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n3 + n4;
        String[] stringArray2 = stringArray[n - 1].split(string);
        int n8 = (stringArray2.length - n7) / 2;
        this.conditionNames = new String[n8];
        for (n6 = 0; n6 < n8; ++n6) {
            this.conditionNames[n6] = stringArray2[n6 + n3];
        }
        n6 = stringArray.length - (n + n2);
        String[] stringArray3 = new String[n6];
        float[][] fArray = new float[n8][n6];
        float[][] fArray2 = new float[n8][n6];
        for (n5 = n; n5 < stringArray.length - n2; ++n5) {
            stringArray2 = stringArray[n5].split(string);
            if (stringArray2.length != 2 * n8 + n7) {
                return false;
            }
            stringArray3[n5 - n] = this.rosetta.containsKey(stringArray2[0].trim().toLowerCase()) ? (String)this.rosetta.get(stringArray2[0].trim().toLowerCase()) : stringArray2[0].trim();
            for (int i = 0; i < n8; ++i) {
                fArray[i][n5 - n] = new Float(stringArray2[i + n3]).floatValue();
                fArray2[i][n5 - n] = new Float(stringArray2[i + n3 + n8]).floatValue();
            }
        }
        for (n5 = 0; n5 < this.conditionNames.length; ++n5) {
            ExperimentCondition experimentCondition = new ExperimentCondition(this.conditionNames[n5], stringArray3, fArray[n5], fArray2[n5]);
            this.data.put(this.conditionNames[n5], experimentCondition);
        }
        return true;
    }

    private Hashtable readTranslator(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] stringArray = this.getFile(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].trim().split("\\t");
            if (stringArray2.length != 2) continue;
            hashtable.put(stringArray2[0].trim().toLowerCase(), stringArray2[1].trim());
        }
        return hashtable;
    }

    public Hashtable getData() {
        return this.data;
    }

    public String[] getConditionNames() {
        return this.conditionNames;
    }

    public SBEAMSClient getSbeamsClient() {
        return this.sc;
    }
}

