/*
 * Decompiled with CFR 0.152.
 */
package DataLoader;

import DataLoader.ArrayIcon;
import DataLoader.ConditionTreeWizardPanel;
import DataLoader.ExperimentCondition;
import DataLoader.GeneExpressionFileReader;
import DataLoader.WizardPanel;
import SBEAMS.SBEAMSClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FileChooserWizardPanel
extends WizardPanel
implements ActionListener,
ListSelectionListener {
    private static String NEW_EXPERIMENT = "New Experiment";
    private JButton chooseFileButton;
    private JPanel imagePanel;
    private JList conditionList;
    private String experimentName = NEW_EXPERIMENT;
    private String dataFile;
    private JTextField experimentNameField;
    private String[] conditionNames;
    private BufferedReader bufferedReader;
    private StringBuffer strbuf;
    private Hashtable tempData;
    private SBEAMSClient sc;
    private Integer project_id;
    private static String expNameURL = "http://db/sbeams/cgi/Microarray/ManageTable.cgi?TABLE_NAME=project&output_mode=tsv";

    public FileChooserWizardPanel() {
        this.initialize();
    }

    public FileChooserWizardPanel(String string) {
        this.dataFile = string;
        this.initialize();
        this.handleDataFile(string);
    }

    public FileChooserWizardPanel(String string, String string2, Integer n) {
        this.dataFile = string;
        this.project_id = n;
        this.initialize();
        this.handleDataFile(string, string2);
    }

    public void initialize() {
        Serializable serializable;
        if (this.project_id != null) {
            try {
                if (this.sc == null) {
                    this.sc = new SBEAMSClient(true);
                }
                if (((Hashtable)(serializable = this.sc.fetchSbeamsResultSetHash(expNameURL, "project_id", "name"))).containsKey(this.project_id.toString())) {
                    this.experimentName = (String)((Hashtable)serializable).get(this.project_id.toString());
                    this.experimentName = this.experimentName.trim();
                    this.experimentName = this.experimentName.replaceAll("\\s", "_");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.tempData = new Hashtable();
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("Step 1. Select File to Load"));
        serializable = new JPanel();
        ((Container)serializable).add(new JLabel("Experiment Name: "));
        this.experimentNameField = new JTextField(15);
        this.experimentNameField.requestFocus();
        ((Container)serializable).add(this.experimentNameField);
        this.add((Component)serializable, "North");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("Conditions"), "North");
        this.conditionList = new JList();
        this.conditionList.addListSelectionListener(this);
        jPanel.add((Component)new JScrollPane(this.conditionList), "Center");
        this.imagePanel = new JPanel(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(1, jPanel, this.imagePanel);
        jSplitPane.setDividerLocation(150);
        this.add((Component)jSplitPane, "Center");
        JPanel jPanel2 = new JPanel();
        this.chooseFileButton = new JButton("Select File");
        this.chooseFileButton.addActionListener(this);
        jPanel2.add(this.chooseFileButton);
        this.add((Component)jPanel2, "South");
    }

    private boolean readFile(String string) {
        try {
            this.bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        this.strbuf = new StringBuffer();
        boolean bl = false;
        try {
            int n;
            String string2;
            while ((string2 = this.bufferedReader.readLine()) != null) {
                this.strbuf.append(string2 + "\n");
            }
            String string3 = this.strbuf.toString();
            String[] stringArray = string3.split("\\n");
            String[] stringArray2 = stringArray[0].split("\\s");
            int n2 = (stringArray2.length - 2) / 2;
            this.conditionNames = new String[n2];
            for (int i = 0; i < n2; ++i) {
                this.conditionNames[i] = stringArray2[i + 2];
            }
            String[] stringArray3 = new String[stringArray.length - 1];
            float[][] fArray = new float[n2][stringArray.length - 1];
            float[][] fArray2 = new float[n2][stringArray.length - 1];
            for (n = 1; n < stringArray.length; ++n) {
                stringArray2 = stringArray[n].split("\\s");
                if (stringArray2.length != 2 * n2 + 2) {
                    return false;
                }
                stringArray3[n - 1] = stringArray2[0];
                for (int i = 0; i < n2; ++i) {
                    fArray[i][n - 1] = new Float(stringArray2[i + 2]).floatValue();
                    fArray2[i][n - 1] = new Float(stringArray2[i + 2 + n2]).floatValue();
                }
            }
            for (n = 0; n < this.conditionNames.length; ++n) {
                ExperimentCondition experimentCondition = new ExperimentCondition(this.conditionNames[n], stringArray3, fArray[n], fArray2[n]);
                this.tempData.put(this.conditionNames[n], experimentCondition);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.dataFile = jFileChooser.getSelectedFile().toString();
            this.handleDataFile(this.dataFile);
        }
    }

    private String getExperimentName() {
        String string = JOptionPane.showInputDialog(this, "What is the name of this experiment?", this.experimentName);
        this.experimentName = string == null || string.equals("") ? new String(NEW_EXPERIMENT) : string;
        return this.experimentName;
    }

    private void handleDataFile(String string) {
        this.handleDataFile(string, null);
    }

    private void handleDataFile(String string, String string2) {
        boolean bl = false;
        GeneExpressionFileReader geneExpressionFileReader = new GeneExpressionFileReader(string, string2, this.sc);
        bl = geneExpressionFileReader.read();
        if (!bl) {
            JOptionPane.showMessageDialog(null, "Unable to Load File", "Alert", 0);
            return;
        }
        if (this.sc == null && geneExpressionFileReader.getSbeamsClient() != null) {
            this.sc = geneExpressionFileReader.getSbeamsClient();
        }
        this.conditionNames = geneExpressionFileReader.getConditionNames();
        this.tempData = geneExpressionFileReader.getData();
        this.conditionList.setListData(this.conditionNames);
        this.conditionList.setSelectedIndex(0);
        this.conditionList.repaint();
        this.paintIcon();
        this.experimentName = this.getExperimentName();
        this.experimentNameField.setText(this.experimentName);
        this.experimentNameField.repaint();
    }

    private void paintIcon() {
        String string = (String)this.conditionList.getSelectedValue();
        ExperimentCondition experimentCondition = (ExperimentCondition)this.tempData.get(string);
        ArrayIcon arrayIcon = new ArrayIcon(experimentCondition.getIconData());
        JPanel jPanel = arrayIcon.getPanel();
        this.imagePanel.setVisible(false);
        this.imagePanel.add((Component)jPanel, "Center");
        this.imagePanel.setVisible(true);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            this.paintIcon();
        }
    }

    public void display() {
    }

    public boolean hasNext() {
        return true;
    }

    public boolean validateNext(List list) {
        boolean bl = true;
        if (this.dataFile == null) {
            list.add("Please Select a Data File Before Continuing");
            bl = false;
        } else if (this.experimentNameField.getText() == null || this.experimentNameField.getText().matches("^\\s*$")) {
            list.add("Please Input an ExperimentName");
            this.experimentNameField.requestFocus();
            bl = false;
        } else {
            this.experimentName = this.experimentNameField.getText();
            if (this.sc != null) {
                this.wizardContext.setAttribute(SBEAMS_CLIENT, this.sc);
            }
            if (this.project_id != null) {
                this.wizardContext.setAttribute(WIZARD_PROJECT_ID, this.project_id);
            }
            this.wizardContext.setAttribute(WIZARD_FILE, this.dataFile);
            this.wizardContext.setAttribute(WIZARD_EXPERIMENT, this.experimentName);
            this.wizardContext.setAttribute(WIZARD_HASH_CONDITIONS, this.tempData);
            this.wizardContext.setAttribute(WIZARD_CONDITIONS, this.conditionNames);
        }
        return bl;
    }

    public boolean hasHelp() {
        return false;
    }

    public void help() {
    }

    public WizardPanel next() {
        return new ConditionTreeWizardPanel(this.getWizardContext());
    }

    public boolean canFinish() {
        return false;
    }

    public boolean canCancel() {
        return true;
    }

    public boolean validateFinish(List list) {
        return false;
    }

    public void finish() {
    }
}

