/*
 * Decompiled with CFR 0.152.
 */
package DataLoader;

import DataLoader.ConditionVariable;
import DataLoader.ExperimentCondition;
import DataLoader.NullWizardPanel;
import DataLoader.TextWriter;
import DataLoader.WizardContext;
import DataLoader.WizardPanel;
import com.sun.msv.verifier.jarv.TheFactoryImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.iso_relax.verifier.Verifier;

public class DataSaverPanel
extends WizardPanel
implements ActionListener {
    protected JTextField baseFileName;
    protected JTextField directoryPath;
    protected JCheckBox fileCheck;
    protected JCheckBox sbeamsCheck;
    protected JButton fileButton;
    protected JButton okbutton;
    protected JButton cancelButton;
    protected JLabel nameLabel;
    private String CHOOSE_DIRECTORY = "CHOOSE_DIRECTORY";
    private String DIRECTORY_CHECK = "DIRECTORY_CHECK";
    private static DecimalFormat twoDigits = new DecimalFormat("00");
    private StringBuffer status;
    private Hashtable condData;

    public DataSaverPanel(WizardContext wizardContext) {
        this.setWizardContext(wizardContext);
        this.condData = (Hashtable)this.wizardContext.getAttribute(WIZARD_HASH_CONDITIONS);
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("Step 5.  Save Data and Exit"));
        this.status = new StringBuffer();
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("Method(s) for Saving These Data:"));
        JPanel jPanel2 = new JPanel();
        this.fileCheck = new JCheckBox("Save To Directory");
        this.fileCheck.setActionCommand(this.DIRECTORY_CHECK);
        this.fileCheck.addActionListener(this);
        jPanel2.add(this.fileCheck);
        this.directoryPath = new JTextField(30);
        this.directoryPath.setEditable(false);
        jPanel2.add(this.directoryPath);
        this.fileButton = new JButton("Choose Directory...");
        this.fileButton.setActionCommand(this.CHOOSE_DIRECTORY);
        this.fileButton.addActionListener(this);
        jPanel2.add(this.fileButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 1));
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(jPanel3);
        this.add((Component)jPanel4, "Center");
    }

    private void writeFiles(String string) {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n2;
        String string2;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = new Date();
        gregorianCalendar.setTime(date);
        String string3 = new String(gregorianCalendar.get(1) + "-" + twoDigits.format(gregorianCalendar.get(2) + 1) + "-" + twoDigits.format(gregorianCalendar.get(5)));
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string4 = string + ".lambda";
        String string5 = string + ".ratio";
        String string6 = string + ".xml";
        String[] stringArray = (String[])this.wizardContext.getAttribute(WIZARD_CONDITIONS);
        int n3 = stringArray.length;
        ExperimentCondition experimentCondition = (ExperimentCondition)this.condData.get(stringArray[0]);
        String[] stringArray2 = experimentCondition.getGenes();
        float[] fArray = experimentCondition.getRatioData();
        float[] fArray2 = experimentCondition.getLambdaData();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        String string7 = (String)this.wizardContext.getAttribute(WIZARD_EXPERIMENT);
        stringBuffer.append("<?xml version=\"1.0\" ?>\n");
        stringBuffer.append("<experiment name=\"");
        stringBuffer.append(string7);
        stringBuffer.append("\" date=\"" + string3 + "\">" + "\n");
        stringBuffer.append("\t");
        stringBuffer.append("<predicate category='species' value='");
        stringBuffer.append((String)this.wizardContext.getAttribute(WIZARD_ORGANISM));
        stringBuffer.append("'/>\n");
        stringBuffer.append("\t");
        stringBuffer.append("<predicate category='perturbation' value='");
        stringBuffer.append((String)this.wizardContext.getAttribute(WIZARD_PERTURBATION));
        stringBuffer.append("'/>\n");
        stringBuffer.append("\t");
        stringBuffer.append("<predicate category='strain' value='");
        stringBuffer.append((String)this.wizardContext.getAttribute(WIZARD_STRAIN));
        stringBuffer.append("'/>\n");
        String string8 = (String)this.wizardContext.getAttribute(WIZARD_MANIPULATION_TYPE);
        if (string8 != null) {
            stringBuffer.append("\t");
            stringBuffer.append("<predicate category='manipulationType' value='");
            stringBuffer.append(string8);
            stringBuffer.append("'/>\n");
        }
        if ((string2 = (String)this.wizardContext.getAttribute(WIZARD_MANIPULATED_VARIABLE)) != null) {
            stringBuffer.append("\t");
            stringBuffer.append("<predicate category='manipulatedVariable' value='");
            stringBuffer.append(string2);
            stringBuffer.append("'/>\n");
        }
        stringBuffer.append("\t");
        stringBuffer.append("<dataset status='primary' type='log10 ratios'>\n");
        stringBuffer.append("\t\t<uri>");
        stringBuffer.append(string7);
        stringBuffer.append(".ratio</uri>\n");
        stringBuffer.append("\t</dataset>\n");
        stringBuffer.append("\t");
        stringBuffer.append("<dataset status='derived' type='lambdas'>\n");
        stringBuffer.append("\t\t<uri>");
        stringBuffer.append(string7);
        stringBuffer.append(".lambda</uri>\n");
        stringBuffer.append("\t</dataset>\n");
        Vector vector = (Vector)this.wizardContext.getAttribute(WIZARD_CONSTANTS);
        stringBuffer.append("\t<constants>\n");
        for (n2 = 0; n2 < vector.size(); ++n2) {
            object4 = (ConditionVariable)vector.elementAt(n2);
            stringBuffer2.append("\t\t" + ((ConditionVariable)object4).getVariableTag() + "\n");
        }
        stringBuffer3.append("\t</constants>\n");
        for (n2 = 0; n2 < n3; ++n2) {
            object4 = stringArray[n2];
            experimentCondition = (ExperimentCondition)this.condData.get(object4);
            object3 = experimentCondition.getVariables();
            stringBuffer3.append("\t");
            stringBuffer3.append("<condition alias='");
            stringBuffer3.append(experimentCondition.getConditionAlias());
            stringBuffer3.append("'>\n");
            for (int i = 0; i < ((Vector)object3).size(); ++i) {
                object2 = (ConditionVariable)((Vector)object3).elementAt(i);
                object = ((ConditionVariable)object2).getVariableTag();
                stringBuffer3.append("\t\t");
                stringBuffer3.append((String)object + "\n");
            }
            stringBuffer3.append("\t</condition>\n");
        }
        stringBuffer3.append("</experiment>\n");
        TextWriter textWriter = new TextWriter(string6);
        textWriter.write(stringBuffer.toString());
        textWriter.write(stringBuffer2.toString());
        textWriter.write(stringBuffer3.toString());
        textWriter.close();
        try {
            object4 = new TheFactoryImpl();
            object3 = object4.compileSchema("http://db/sbeams/tmp/Microarray/dataLoader/experiment.xsd");
            Verifier verifier = object3.newVerifier();
            if (verifier.verify(string6)) {
                this.status.append("Document is valid\n");
            } else {
                this.status.append("Document is NOT valid.\nPlease report this to mjohnson@systemsbiology.org\n");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.status.append("Document is NOT valid.\nPlease report this to mjohnson@systemsbiology.org\n");
        }
        object4 = new TextWriter(string4);
        object3 = new TextWriter(string5);
        StringBuffer stringBuffer4 = new StringBuffer();
        object2 = new StringBuffer();
        object = new float[n3][fArray.length];
        float[][] fArray3 = new float[n3][fArray2.length];
        object[0] = fArray;
        fArray3[0] = fArray2;
        for (n = 0; n < n3; ++n) {
            experimentCondition = (ExperimentCondition)this.condData.get(stringArray[n]);
            hashtable.put(stringArray[n], experimentCondition.getConditionAlias());
            fArray = experimentCondition.getRatioData();
            fArray2 = experimentCondition.getLambdaData();
            object[n] = fArray;
            fArray3[n] = fArray2;
        }
        stringBuffer4.append("GENE");
        ((StringBuffer)object2).append("GENE");
        for (n = 0; n < n3; ++n) {
            stringBuffer4.append("\t" + (String)hashtable.get(stringArray[n]));
            ((StringBuffer)object2).append("\t" + (String)hashtable.get(stringArray[n]));
        }
        stringBuffer4.append("\n");
        ((StringBuffer)object2).append("\n");
        for (n = 0; n < ((Object)object[0]).length; ++n) {
            stringBuffer4.append(stringArray2[n]);
            ((StringBuffer)object2).append(stringArray2[n]);
            for (int i = 0; i < ((Object)object).length; ++i) {
                ((StringBuffer)object2).append("\t" + (float)object[i][n]);
                stringBuffer4.append("\t" + fArray3[i][n]);
            }
            stringBuffer4.append("\n");
            ((StringBuffer)object2).append("\n");
        }
        ((TextWriter)object4).write(stringBuffer4.toString());
        ((TextWriter)object3).write(((StringBuffer)object2).toString());
        ((TextWriter)object4).close();
        ((TextWriter)object3).close();
    }

    public boolean updateRepository(String string) {
        boolean bl = false;
        Pattern pattern = Pattern.compile("(.*)/.*?");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            string2 = string2 + "/.permissions";
            System.out.println(string2);
            String string3 = (String)this.wizardContext.getAttribute(WIZARD_EXPERIMENT);
            try {
                String string4;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
                TextWriter textWriter = new TextWriter(string2);
                StringBuffer stringBuffer = new StringBuffer();
                while ((string4 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string4 + "\n");
                }
                stringBuffer.append(string3 + ": lab\n");
                textWriter.write(stringBuffer.toString());
                textWriter.close();
                bl = true;
            }
            catch (IOException iOException) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (this.CHOOSE_DIRECTORY.equals(string) || this.DIRECTORY_CHECK.equals(string) && this.fileCheck.isSelected()) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setDialogType(1);
            jFileChooser.setApproveButtonText("Select Output Directory");
            int n = jFileChooser.showDialog(this, null);
            if (n == 0) {
                String string2 = jFileChooser.getSelectedFile().toString();
                if (!jFileChooser.getSelectedFile().isDirectory()) {
                    JOptionPane.showMessageDialog(this, "Selected Path is not a Directory!\n\n\t-Using Directory Portion of this Path.");
                    string2 = jFileChooser.getSelectedFile().getParent();
                }
                this.directoryPath.setText(string2);
                this.fileCheck.setSelected(true);
                this.repaint();
            }
        }
    }

    public void display() {
    }

    public boolean hasNext() {
        return false;
    }

    public boolean validateNext(List list) {
        return false;
    }

    public WizardPanel next() {
        return new NullWizardPanel();
    }

    public boolean canFinish() {
        return true;
    }

    public boolean canCancel() {
        return true;
    }

    public boolean validateFinish(List list) {
        if (!this.fileCheck.isSelected() && !this.sbeamsCheck.isSelected()) {
            list.add("Need to specify output file name");
            return false;
        }
        if (!this.fileCheck.isSelected() && this.sbeamsCheck.isSelected()) {
            list.add("SBEAMS saving is not currently functional. Please save to file");
            return false;
        }
        String string = this.directoryPath.getText();
        String string2 = new String(string + "/" + this.wizardContext.getAttribute(WIZARD_EXPERIMENT));
        this.writeFiles(string2);
        String string3 = new String("Data Has Been Saved!\n\nStatus:\n" + this.status.toString() + "\n" + "Thanks for using the Data Loader");
        JOptionPane.showMessageDialog(this, string3, "Data Loading Complete", 1);
        this.finish();
        return true;
    }

    public void finish() {
    }
}

