/*
 * Decompiled with CFR 0.152.
 */
package DataLoader;

import DataLoader.CommandLineReader;
import DataLoader.FileChooserWizardPanel;
import DataLoader.WelcomeWizardPanel;
import DataLoader.Wizard;
import DataLoader.WizardContext;
import DataLoader.WizardListener;
import java.awt.GraphicsConfiguration;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;

public class DataLoader
implements WizardListener {
    private static JFrame frame;

    public static void main(String[] stringArray) {
        CommandLineReader commandLineReader = new CommandLineReader(stringArray);
        frame = new JFrame("Cytoscape Data Loader");
        frame.addWindowListener(DataLoader.createAppCloser());
        WizardContext wizardContext = new WizardContext();
        Wizard wizard = new Wizard(wizardContext);
        wizard.addWizardListener(new DataLoader());
        frame.setContentPane(wizard);
        frame.pack();
        GraphicsConfiguration graphicsConfiguration = frame.getGraphicsConfiguration();
        int n = (int)graphicsConfiguration.getBounds().getHeight();
        int n2 = (int)graphicsConfiguration.getBounds().getWidth();
        int n3 = frame.getWidth();
        int n4 = frame.getHeight();
        int n5 = (n2 - n3) / 2;
        int n6 = (n - n4) / 2;
        frame.setLocation(n5, n6);
        frame.setVisible(true);
        String string = commandLineReader.getMatrixFile();
        String string2 = commandLineReader.getTranslator();
        Integer n7 = commandLineReader.getProjectID();
        if (string == null) {
            wizard.start(new WelcomeWizardPanel());
        } else {
            wizard.start(new FileChooserWizardPanel(string, string2, n7));
        }
    }

    private static WindowListener createAppCloser() {
        return new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        };
    }

    public void wizardFinished(Wizard wizard) {
        System.out.println("Good-Bye!");
        System.exit(0);
    }

    public void wizardCancelled(Wizard wizard) {
        System.out.println("Cancelled!");
        System.exit(0);
    }

    public void wizardPanelChanged(Wizard wizard) {
    }
}

