/*
 * Decompiled with CFR 0.152.
 */
package DataLoader;

import DataLoader.GeneralInfoWizardPanel;
import DataLoader.WizardContext;
import DataLoader.WizardPanel;
import csplugins.isb.pshannon.experiment.metadata.MetaDataNavigator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ConditionTreeWizardPanel
extends WizardPanel
implements ActionListener {
    private static String repository = "httpIndirect://db.systemsbiology.net:8080/halo/DataFetcher.py";
    protected MetaDataNavigator experimentNavigator;
    protected JTree tree;
    protected PerturbationNode rootNode;
    protected DefaultTreeModel treeModel;
    private static String INSERT_COMMAND = "Insert";
    private static String REPLACE_COMMAND = "Replace";
    private JTextField currentPerturbation;

    public ConditionTreeWizardPanel(WizardContext wizardContext) {
        this.setWizardContext(wizardContext);
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("Step 2. Place Experiment Set Within the Condition Tree"));
        this.add((Component)this.initTree(), "Center");
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Perturbation: "));
        this.currentPerturbation = new JTextField(30);
        this.currentPerturbation.setEditable(false);
        jPanel2.add(this.currentPerturbation);
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton(INSERT_COMMAND);
        jButton.setActionCommand(INSERT_COMMAND);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(REPLACE_COMMAND);
        jButton2.setActionCommand(REPLACE_COMMAND);
        jButton2.addActionListener(this);
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel2);
        this.add((Component)jPanel, "South");
    }

    public JScrollPane initTree() {
        try {
            this.experimentNavigator = new MetaDataNavigator(repository);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.rootNode = new PerturbationNode("Experiments");
        this.rootNode.setEditable(false);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.treeModel.addTreeModelListener(new ExperimentTreeModelListener());
        this.tree = new JTree(this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        HashMap hashMap = this.experimentNavigator.getTree();
        this.createTree(this.rootNode, hashMap);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        return jScrollPane;
    }

    private void createTree(PerturbationNode perturbationNode, HashMap hashMap) {
        Object[] objectArray = hashMap.keySet().toArray();
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            PerturbationNode perturbationNode2 = new PerturbationNode(objectArray[i]);
            perturbationNode2.setEditable(false);
            perturbationNode.add(perturbationNode2);
            if ((HashMap)hashMap.get(objectArray[i]) == null) continue;
            this.createTree(perturbationNode2, (HashMap)hashMap.get(objectArray[i]));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (INSERT_COMMAND.equals(string)) {
            String string2 = JOptionPane.showInputDialog("New Category/Perturbation Name?");
            if (string2 != null) {
                int n;
                Object[] objectArray;
                PerturbationNode perturbationNode = this.addObject(string2);
                Object[] objectArray2 = this.tree.getSelectionPath().getPath();
                if (INSERT_COMMAND.equals(string)) {
                    objectArray = new StringBuffer();
                    for (n = 1; n < objectArray2.length; ++n) {
                        objectArray.append(((PerturbationNode)objectArray2[n]).toString() + ":");
                    }
                    objectArray.append(string2);
                    this.wizardContext.setAttribute(WIZARD_PERTURBATION, objectArray.toString());
                    this.setVisible(false);
                    this.currentPerturbation.setText(objectArray.toString());
                    this.setVisible(true);
                }
                objectArray = new Object[objectArray2.length + 1];
                for (n = 0; n < objectArray2.length; ++n) {
                    objectArray[n] = objectArray2[n];
                }
                objectArray[objectArray2.length] = perturbationNode;
                this.tree.setSelectionPath(new TreePath(objectArray));
            }
        } else if (REPLACE_COMMAND.equals(string)) {
            Object[] objectArray = this.tree.getSelectionPath().getPath();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 1; i < objectArray.length; ++i) {
                stringBuffer.append(((PerturbationNode)objectArray[i]).toString());
                if (i == objectArray.length - 1) continue;
                stringBuffer.append(":");
            }
            this.wizardContext.setAttribute(WIZARD_PERTURBATION, stringBuffer.toString());
            this.setVisible(false);
            this.currentPerturbation.setText(stringBuffer.toString());
            this.setVisible(true);
        }
    }

    public PerturbationNode addObject(Object object) {
        PerturbationNode perturbationNode = null;
        TreePath treePath = this.tree.getSelectionPath();
        perturbationNode = treePath == null ? this.rootNode : (PerturbationNode)treePath.getLastPathComponent();
        return this.addObject(perturbationNode, object, true);
    }

    public PerturbationNode addObject(PerturbationNode perturbationNode, Object object, boolean bl) {
        PerturbationNode perturbationNode2 = new PerturbationNode(object);
        if (perturbationNode == null) {
            perturbationNode = this.rootNode;
        }
        this.treeModel.insertNodeInto(perturbationNode2, perturbationNode, perturbationNode.getChildCount());
        this.tree.scrollPathToVisible(new TreePath(perturbationNode2.getPath()));
        return perturbationNode2;
    }

    public void display() {
    }

    public boolean hasNext() {
        return true;
    }

    public boolean validateNext(List list) {
        boolean bl = true;
        if (this.wizardContext.getAttribute(WIZARD_PERTURBATION) == null) {
            list.add("Please Insert a Perturbation Before Continuing");
            bl = false;
        }
        return bl;
    }

    public WizardPanel next() {
        return new GeneralInfoWizardPanel(this.getWizardContext());
    }

    public boolean canFinish() {
        return false;
    }

    public boolean canCancel() {
        return true;
    }

    public boolean validateFinish(List list) {
        return false;
    }

    public void finish() {
    }

    class ExperimentTreeModelListener
    implements TreeModelListener {
        ExperimentTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            PerturbationNode perturbationNode = (PerturbationNode)treeModelEvent.getTreePath().getLastPathComponent();
            try {
                int n = treeModelEvent.getChildIndices()[0];
                perturbationNode = (PerturbationNode)perturbationNode.getChildAt(n);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }

    protected static class PerturbationNode
    extends DefaultMutableTreeNode {
        private boolean isEditable;

        public PerturbationNode(Object object) {
            super(object);
        }

        public void setEditable(boolean bl) {
            this.isEditable = bl;
        }

        public boolean isEditable() {
            return this.isEditable;
        }
    }
}

