/*
 * Decompiled with CFR 0.152.
 */
package DataLoader;

import DataLoader.ConditionVariable;
import DataLoader.DataSaverPanel;
import DataLoader.ExperimentCondition;
import DataLoader.VariableTable;
import DataLoader.WizardContext;
import DataLoader.WizardPanel;
import SBEAMS.SBEAMSClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class ConditionInfoWizardPanel
extends WizardPanel
implements ActionListener,
KeyListener,
MouseListener {
    private static DecimalFormat twoDigits = new DecimalFormat("00");
    private JComboBox variableNames;
    private JComboBox unitsNames;
    private SBEAMSClient sc;
    private JList conditionList;
    private JScrollPane variableList;
    private JScrollPane variableSummary;
    private VariableTable variableTable;
    private Hashtable condData;
    private Hashtable varsAndUnits;
    private static String VARIABLE_SELECTED = "variable_selected";
    private static String UNIT_SELECTED = "unit_selected";
    private static String OTHER = "Other...";
    private static String ADD = "Add";
    private static String POPUP = "Popup";
    private static String REMOVE = "Remove Last";
    private static String RENAME = "Rename Conditions";
    private int currentVariableIndex;
    private static String schemaFile = "sbeamsIndirect://db/sbeams/tmp/Microarray/dataLoader/experiment.xsd";

    public ConditionInfoWizardPanel(WizardContext wizardContext) {
        Object object;
        Object object2;
        this.setWizardContext(wizardContext);
        this.condData = (Hashtable)this.wizardContext.getAttribute(WIZARD_HASH_CONDITIONS);
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("Step 4.  Describe the Variables in this Experiment"));
        JPanel jPanel = new JPanel(new BorderLayout());
        JButton jButton = new JButton(RENAME);
        jButton.setActionCommand(RENAME);
        jButton.addActionListener(this);
        jPanel.add((Component)jButton, "West");
        JPanel jPanel2 = new JPanel(new FlowLayout());
        JLabel jLabel = new JLabel("Variable Name: ");
        JLabel jLabel2 = new JLabel("Units: ");
        JButton jButton2 = new JButton(ADD);
        jButton2.setActionCommand(ADD);
        jButton2.setMnemonic(10);
        jButton2.addActionListener(this);
        jButton2.addKeyListener(this);
        JButton jButton3 = new JButton(REMOVE);
        jButton3.setActionCommand(REMOVE);
        jButton3.addActionListener(this);
        Vector[] vectorArray = this.getVariableDataFromExperimentXSD(schemaFile);
        Vector vector = (Vector)this.wizardContext.getAttribute(WIZARD_CONSTANTS);
        this.varsAndUnits = new Hashtable();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                object2 = ((ConditionVariable)vector.elementAt(i)).getVariableName();
                object = ((ConditionVariable)vector.elementAt(i)).getVariableUnits();
                this.varsAndUnits.put(object2, object);
            }
        }
        Vector vector2 = vectorArray[0];
        vector2.add(0, "");
        object2 = vectorArray[1];
        ((Vector)object2).add(0, "");
        this.variableNames = new JComboBox(vector2);
        this.variableNames.setActionCommand(VARIABLE_SELECTED);
        this.variableNames.addActionListener(this);
        this.variableNames.addKeyListener(this);
        this.unitsNames = new JComboBox(object2);
        this.unitsNames.setActionCommand(UNIT_SELECTED);
        this.unitsNames.addActionListener(this);
        this.unitsNames.addKeyListener(this);
        jPanel2.add(jLabel);
        jPanel2.add(this.variableNames);
        jPanel2.add(jLabel2);
        jPanel2.add(this.unitsNames);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        jPanel2.addKeyListener(this);
        jPanel.add((Component)jPanel2, "Center");
        object = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        String[] stringArray = (String[])this.wizardContext.getAttribute(WIZARD_CONDITIONS);
        String[][] stringArray2 = new String[stringArray.length][5];
        this.currentVariableIndex = 0;
        ExperimentCondition[] experimentConditionArray = new ExperimentCondition[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            experimentConditionArray[i] = (ExperimentCondition)this.condData.get(stringArray[i]);
        }
        this.conditionList = new JList();
        this.conditionList.setModel(new ConditionListModel(experimentConditionArray));
        this.conditionList.addKeyListener(this);
        this.conditionList.addMouseListener(this);
        this.conditionList.setSelectionMode(2);
        this.conditionList.setFixedCellHeight(20);
        this.variableList = new JScrollPane(this.conditionList);
        this.variableTable = new VariableTable(stringArray.length, this.conditionList.getFixedCellHeight());
        String[] stringArray3 = new String[]{REMOVE};
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray3);
        double d = jComboBox.getPreferredSize().getHeight();
        JLabel jLabel3 = new JLabel("Conditions");
        this.variableTable.addKeyListener(this);
        this.variableSummary = new JScrollPane(this.variableTable);
        this.variableSummary.setHorizontalScrollBarPolicy(32);
        this.variableSummary.setVerticalScrollBarPolicy(22);
        ((Container)object).add((Component)jLabel3, "North");
        ((Container)object).add((Component)this.variableList, "Center");
        jPanel3.add((Component)this.variableSummary, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(1, (Component)object, jPanel3);
        jSplitPane.setDividerLocation(150);
        jPanel4.add((Component)jPanel, "North");
        jPanel4.add((Component)jSplitPane, "Center");
        this.add((Component)jPanel4, "Center");
    }

    protected Vector[] getVariableDataFromExperimentXSD(String string) {
        Serializable serializable;
        Object object;
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        String[] stringArray2 = new String[1];
        if (string.startsWith("sbeamsIndirect://")) {
            if (this.wizardContext.getAttribute(SBEAMS_CLIENT) == null) {
                try {
                    this.sc = new SBEAMSClient(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.sc = (SBEAMSClient)this.wizardContext.getAttribute(SBEAMS_CLIENT);
            }
            try {
                stringArray = string.split("://");
                object = this.sc.fetchSbeamsPage("http://" + stringArray[1]);
                stringArray2 = ((String)object).split("\\n");
            }
            catch (IOException iOException) {
                System.err.println("Page Not Found");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                stringArray = new BufferedReader(new FileReader(string));
                serializable = new Vector();
                while ((object = stringArray.readLine()) != null) {
                    ((Vector)serializable).add(object);
                }
                stringArray2 = new String[((Vector)serializable).size()];
                ((Vector)serializable).toArray(stringArray2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        stringArray = Pattern.compile("<xsd:simpleType name=\"VariableNameType\">");
        object = Pattern.compile("<xsd:enumeration value=\"(.*?)\"/>");
        serializable = Pattern.compile("</xsd:simpleType>");
        Pattern pattern = Pattern.compile("<xsd:simpleType name=\"VariableUnitsType\">");
        Pattern pattern2 = Pattern.compile("<xsd:enumeration value=\"(.*?)\"/>");
        Pattern pattern3 = Pattern.compile("</xsd:simpleType>");
        int n = 0;
        while (n < stringArray2.length) {
            Matcher matcher;
            Matcher matcher2;
            Matcher matcher3 = stringArray.matcher(stringArray2[n].trim());
            if (matcher3.matches()) {
                matcher2 = ((Pattern)serializable).matcher(stringArray2[++n].trim());
                while (n < stringArray2.length && !matcher2.matches()) {
                    matcher = ((Pattern)object).matcher(stringArray2[n].trim());
                    if (matcher.matches()) {
                        vector.add(matcher.group(1));
                    }
                    matcher2 = ((Pattern)serializable).matcher(stringArray2[++n].trim());
                }
                continue;
            }
            matcher2 = pattern.matcher(stringArray2[n].trim());
            if (matcher2.matches()) {
                matcher = ((Pattern)serializable).matcher(stringArray2[++n].trim());
                while (n < stringArray2.length && !matcher.matches()) {
                    Matcher matcher4 = pattern2.matcher(stringArray2[n].trim());
                    if (matcher4.matches()) {
                        vector2.add(matcher4.group(1));
                    }
                    matcher = ((Pattern)serializable).matcher(stringArray2[++n].trim());
                }
                continue;
            }
            ++n;
        }
        Vector[] vectorArray = new Vector[]{vector, vector2};
        return vectorArray;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.registerNewVariable();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (ADD.equals(string)) {
            this.registerNewVariable();
        } else if (POPUP.equals(string)) {
            this.registerAlias();
        } else if (VARIABLE_SELECTED.equals(string)) {
            String string2 = (String)this.variableNames.getSelectedItem();
            if (string2.equals(OTHER)) {
                String string3 = JOptionPane.showInputDialog(this, (Object)"New Variable Name?");
                if (string3 != null) {
                    this.variableNames.insertItemAt(string3, 1);
                    this.variableNames.setSelectedIndex(1);
                }
            } else if (this.varsAndUnits.containsKey(string2)) {
                String string4 = (String)this.varsAndUnits.get(string2);
                for (int i = 0; i < this.unitsNames.getItemCount(); ++i) {
                    if (!((String)this.unitsNames.getItemAt(i)).equals(string4)) continue;
                    this.unitsNames.setSelectedIndex(i);
                    break;
                }
            } else {
                this.unitsNames.setSelectedIndex(0);
            }
        } else if (UNIT_SELECTED.equals(string)) {
            String string5;
            String string6 = (String)this.unitsNames.getSelectedItem();
            if (string6.equals(OTHER) && (string5 = JOptionPane.showInputDialog(this, (Object)"New Unit Name?")) != null) {
                this.unitsNames.insertItemAt(string5, 1);
                this.unitsNames.setSelectedIndex(1);
            }
        } else if (REMOVE.equals(string)) {
            this.variableTable.removeLastColumn();
        } else if (RENAME.equals(string)) {
            this.intelligentlySetAliases();
        }
    }

    private void intelligentlySetAliases() {
        int n;
        String string = "unknownExperiment";
        string = (String)this.wizardContext.getAttribute(WIZARD_EXPERIMENT);
        int n2 = this.variableTable.getColumnCount();
        int n3 = this.variableTable.getRowCount();
        StringBuffer[] stringBufferArray = new StringBuffer[n3];
        for (n = 0; n < stringBufferArray.length; ++n) {
            stringBufferArray[n] = new StringBuffer();
            stringBufferArray[n].append(string + "__");
        }
        for (n = 0; n < n2; ++n) {
            String string2 = this.variableTable.getColumnHeader(n);
            Pattern pattern = Pattern.compile(".*\\(\\s?(.*?)\\s?\\).*");
            Matcher matcher = pattern.matcher(string2);
            String string3 = new String();
            if (matcher.matches()) {
                string3 = matcher.group(1);
            }
            String string4 = this.translate(string3);
            for (int i = 0; i < n3; ++i) {
                String string5 = (String)this.variableTable.getValueAt(i, n);
                stringBufferArray[i].append(string5);
                if (!string4.equals("")) {
                    stringBufferArray[i].append(string4);
                }
                if (n == n2 - 1) continue;
                stringBufferArray[i].append("-");
            }
        }
        for (n = 0; n < stringBufferArray.length; ++n) {
            this.registerAlias(n, stringBufferArray[n].toString());
        }
        this.repaint();
    }

    private String translate(String string) {
        string.toLowerCase();
        if (string.equals("micromolar")) {
            return "uM";
        }
        if (string.equals("millimolar")) {
            return "mM";
        }
        if (string.equals("Gy")) {
            return "gy";
        }
        if (string.equals("minutes")) {
            return "m";
        }
        if (string.equals("percent")) {
            return "pct";
        }
        return string;
    }

    private void registerNewVariable() {
        String string = new String(this.variableNames.getSelectedItem() + " ( " + this.unitsNames.getSelectedItem() + " ) ");
        this.variableTable.addDataColumn(string);
    }

    private void registerAlias(int n, String string) {
        ConditionListModel conditionListModel = (ConditionListModel)this.conditionList.getModel();
        ExperimentCondition experimentCondition = (ExperimentCondition)conditionListModel.getElementDataAt(n);
        experimentCondition.setAlias(string);
        this.repaint();
    }

    private void registerAlias() {
        int[] nArray = this.conditionList.getSelectedIndices();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            String string = this.getConditionName(n);
            String string2 = JOptionPane.showInputDialog(this, (Object)("Condition Name: " + string + "\n\nSet Alias To:"));
            if (string2 == null) continue;
            this.registerAlias(n, string2);
        }
    }

    private void setVariables() {
        int n = this.variableTable.getColumnCount();
        int n2 = this.variableTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string = this.variableTable.getColumnHeader(i);
            Pattern pattern = Pattern.compile("(.*)\\s\\((.*?)\\).*");
            Matcher matcher = pattern.matcher(string);
            String string2 = new String();
            String string3 = new String();
            if (matcher.matches()) {
                string2 = matcher.group(2);
                string3 = matcher.group(1);
            }
            for (int j = 0; j < n2; ++j) {
                String string4 = (String)this.variableTable.getValueAt(j, i);
                ConditionVariable conditionVariable = new ConditionVariable(string3.trim(), string4.trim(), string2.trim());
                this.conditionList.setSelectedIndex(j);
                ExperimentCondition experimentCondition = (ExperimentCondition)this.condData.get(this.getConditionName(j));
                experimentCondition.addVariable(conditionVariable);
            }
        }
    }

    private String getConditionName(int n) {
        return ((ExperimentCondition)((ConditionListModel)this.conditionList.getModel()).getElementDataAt(n)).getConditionName();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            Point point = mouseEvent.getPoint();
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Rename...");
            jPopupMenu.add(jMenuItem);
            jMenuItem.setActionCommand(POPUP);
            jMenuItem.addActionListener(this);
            jPopupMenu.setLightWeightPopupEnabled(false);
            jPopupMenu.show(this.variableList, (int)point.getX(), (int)point.getY());
        }
    }

    public void display() {
    }

    public boolean hasNext() {
        return true;
    }

    public boolean validateNext(List list) {
        boolean bl = true;
        this.setVariables();
        return bl;
    }

    public WizardPanel next() {
        return new DataSaverPanel(this.getWizardContext());
    }

    public boolean canFinish() {
        return false;
    }

    public boolean canCancel() {
        return true;
    }

    public boolean validateFinish(List list) {
        return true;
    }

    public void finish() {
    }

    class ConditionListModel
    extends AbstractListModel {
        ExperimentCondition[] ec;

        public ConditionListModel(ExperimentCondition[] experimentConditionArray) {
            this.ec = experimentConditionArray;
        }

        public Object getElementAt(int n) {
            return this.ec[n].getConditionAlias();
        }

        public Object getElementDataAt(int n) {
            return this.ec[n];
        }

        public int getSize() {
            return this.ec.length;
        }
    }
}

