/*
 * Decompiled with CFR 0.152.
 */
package DataLoader;

import gnu.getopt.Getopt;

public class CommandLineReader {
    private String validArguments = "m:r:p:hv";
    private String[] commandLineArguments;
    private String matrixFile;
    private Integer project_id;
    private String translator;
    private boolean verbose = false;
    private boolean inputError = false;
    private boolean helpRequested = false;

    public CommandLineReader(String[] stringArray) {
        this.commandLineArguments = stringArray;
        this.parseArgs();
    }

    private void parseArgs() {
        int n;
        this.helpRequested = false;
        boolean bl = false;
        if (this.commandLineArguments == null || this.commandLineArguments.length == 0) {
            this.helpRequested = true;
            return;
        }
        Getopt getopt = new Getopt("DataLoader", this.commandLineArguments, this.validArguments);
        block8: while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 109: {
                    this.matrixFile = getopt.getOptarg();
                    continue block8;
                }
                case 104: {
                    this.helpRequested = true;
                    continue block8;
                }
                case 112: {
                    this.project_id = new Integer(getopt.getOptarg());
                    continue block8;
                }
                case 114: {
                    this.translator = getopt.getOptarg();
                    continue block8;
                }
                case 118: {
                    this.verbose = true;
                    continue block8;
                }
                case 63: {
                    System.out.println("The option '" + (char)getopt.getOptopt() + "' is not understood");
                    this.helpRequested = true;
                    return;
                }
            }
            System.err.println("unexpected argument: " + n);
            this.inputError = true;
        }
        if (this.verbose) {
            this.printVerbose();
        }
    }

    protected void printVerbose() {
        StringBuffer stringBuffer = new StringBuffer("Command Line Arguments:\n");
        stringBuffer.append("Matrix File: ");
        if (this.matrixFile.equals("")) {
            stringBuffer.append("None\n");
        } else {
            stringBuffer.append(this.matrixFile + "\n");
        }
        stringBuffer.append("\n");
        System.out.println(stringBuffer.toString());
    }

    protected String getUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DataLoader Usage:\n");
        stringBuffer.append("\tjava DataLoader [PARAMETERS]\n");
        stringBuffer.append("\t-m <file> matrix file name\n");
        stringBuffer.append("\t-t <title> experiment name\n");
        stringBuffer.append("\t-h display help\n");
        stringBuffer.append("\t-r <file> ORF translator table\n");
        return stringBuffer.toString();
    }

    public boolean helpRequested() {
        return this.helpRequested;
    }

    public boolean inputError() {
        return this.inputError;
    }

    public String getMatrixFile() {
        return this.matrixFile;
    }

    public String getTranslator() {
        return this.translator;
    }

    public Integer getProjectID() {
        return this.project_id;
    }
}

