/*
 * Decompiled with CFR 0.152.
 */
package DataLoader;

import java.awt.Dimension;
import java.rmi.RemoteException;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import visad.ConstantMap;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.Display;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;

public class ArrayIcon
extends ImageIcon {
    private String conditionName = new String();
    private Float lambdaMin = new Float(0.0f);
    private Float lambdaMax = new Float(0.0f);
    private Float ratioMin = new Float(0.0f);
    private Float ratioMax = new Float(0.0f);
    private float[][] data;
    private JPanel graphPanel;

    public ArrayIcon(float[][] fArray) {
        this.data = fArray;
        this.conditionName = "Variable Plot";
        for (int i = 0; i < fArray[0].length; ++i) {
            if (fArray[1][i] > this.lambdaMax.floatValue()) {
                this.lambdaMax = new Float(fArray[1][i]);
            }
            if (fArray[1][i] < this.lambdaMin.floatValue()) {
                this.lambdaMin = new Float(fArray[1][i]);
            }
            if (fArray[0][i] > this.ratioMax.floatValue()) {
                this.ratioMax = new Float(fArray[0][i]);
            }
            if (!(fArray[0][i] < this.ratioMin.floatValue())) continue;
            this.ratioMin = new Float(fArray[0][i]);
        }
    }

    public JPanel getPanel() {
        this.graphPanel = new JPanel();
        DisplayImplJ2D displayImplJ2D = null;
        try {
            displayImplJ2D = new DisplayImplJ2D(this.conditionName);
            RealType realType = RealType.getRealType((String)"lambda");
            RealType realType2 = RealType.getRealType((String)"ratio");
            RealType realType3 = RealType.Generic;
            ScalarMap scalarMap = new ScalarMap((ScalarType)realType, Display.YAxis);
            ScalarMap scalarMap2 = new ScalarMap((ScalarType)realType2, Display.XAxis);
            RealTupleType realTupleType = new RealTupleType(realType2, realType);
            FunctionType functionType = new FunctionType((MathType)realType3, (MathType)realTupleType);
            ConstantMap[] constantMapArray = new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(0.0, Display.Blue), new ConstantMap(2.0, Display.PointSize)};
            GraphicsModeControl graphicsModeControl = displayImplJ2D.getGraphicsModeControl();
            graphicsModeControl.setScaleEnable(true);
            DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("data_ref");
            displayImplJ2D.removeAllReferences();
            displayImplJ2D.clearMaps();
            displayImplJ2D.addMap(scalarMap);
            displayImplJ2D.addMap(scalarMap2);
            displayImplJ2D.addReference((DataReference)dataReferenceImpl, constantMapArray);
            Integer1DSet integer1DSet = new Integer1DSet((MathType)realType3, this.data[0].length);
            FlatField flatField = new FlatField(functionType, (Set)integer1DSet);
            flatField.setSamples(this.data);
            scalarMap.setRange(1.1 * (double)this.lambdaMin.floatValue(), 1.1 * (double)this.lambdaMax.floatValue());
            scalarMap2.setRange(1.1 * (double)this.ratioMin.floatValue(), 1.1 * (double)this.ratioMax.floatValue());
            dataReferenceImpl.setData((Data)flatField);
            displayImplJ2D.reDisplayAll();
            this.graphPanel = (JPanel)displayImplJ2D.getComponent();
            this.graphPanel.setPreferredSize(new Dimension(300, 300));
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
        return this.graphPanel;
    }
}

