/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.vizmap.unitTests;

import cytoscape.unitTests.AllTests;
import cytoscape.vizmap.AttributeMapper;
import cytoscape.vizmap.AttributeMapperPropertiesAdapter;
import cytoscape.vizmap.Interpolator;
import cytoscape.vizmap.VizMapperCategories;
import java.awt.Color;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class VizMapperCategoriesTest
extends TestCase {
    public VizMapperCategoriesTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testInheritedMethods() throws Exception {
        VizMapperCategories vizMapperCategories = new VizMapperCategories();
        VizMapperCategories vizMapperCategories2 = vizMapperCategories;
        Map map = vizMapperCategories2.getInitialDefaults();
        VizMapperCategoriesTest.assertTrue((map.size() == 11 ? 1 : 0) != 0);
        VizMapperCategoriesTest.assertTrue((map.get(VizMapperCategories.NODE_FILL_COLOR) != null ? 1 : 0) != 0);
        Map map2 = vizMapperCategories2.getPropertyNamesMap();
        VizMapperCategoriesTest.assertTrue((map2.size() == 12 ? 1 : 0) != 0);
        VizMapperCategoriesTest.assertTrue((map2.get(VizMapperCategories.NODE_FILL_COLOR) != null ? 1 : 0) != 0);
        String string = "255,0,0";
        Object object = vizMapperCategories2.parseRangeAttributeValue(VizMapperCategories.NODE_FILL_COLOR, string);
        VizMapperCategoriesTest.assertTrue((object != null ? 1 : 0) != 0);
        VizMapperCategoriesTest.assertTrue((boolean)(object instanceof Color));
        Color color = (Color)object;
        VizMapperCategoriesTest.assertTrue((color.getRed() == 255 ? 1 : 0) != 0);
        VizMapperCategoriesTest.assertTrue((color.getGreen() == 0 ? 1 : 0) != 0);
        VizMapperCategoriesTest.assertTrue((color.getBlue() == 0 ? 1 : 0) != 0);
        Interpolator interpolator = vizMapperCategories2.getInterpolator(VizMapperCategories.NODE_FILL_COLOR);
        VizMapperCategoriesTest.assertTrue((interpolator != null ? 1 : 0) != 0);
    }

    public void testSpecificMethods() throws Exception {
        VizMapperCategories vizMapperCategories = new VizMapperCategories();
        AttributeMapper attributeMapper = new AttributeMapper(vizMapperCategories.getInitialDefaults());
        AttributeMapperPropertiesAdapter attributeMapperPropertiesAdapter = new AttributeMapperPropertiesAdapter(attributeMapper, vizMapperCategories);
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        fileInputStream = !AllTests.runAllTests() ? new FileInputStream("test.props") : new FileInputStream("src/cytoscape/vizmap/unitTests/test.props");
        properties.load(fileInputStream);
        attributeMapperPropertiesAdapter.applyAllRangeProperties(properties);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("expression", new Double(-3.0));
        hashMap.put("interaction", "pd");
        Color color = vizMapperCategories.getNodeFillColor(hashMap, attributeMapper);
        Color color2 = new Color(255, 64, 64);
        VizMapperCategoriesTest.assertTrue((boolean)color.equals(color2));
        Color color3 = vizMapperCategories.getEdgeColor(hashMap, attributeMapper);
        Color color4 = new Color(255, 255, 0);
        VizMapperCategoriesTest.assertTrue((boolean)color3.equals(color4));
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(VizMapperCategoriesTest.class));
    }
}

