/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.vizmap.unitTests;

import cytoscape.vizmap.BoundaryRangeValues;
import cytoscape.vizmap.ContinuousMapper;
import cytoscape.vizmap.LinearNumberToColorInterpolator;
import java.awt.Color;
import java.util.TreeMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ContinuousMapperTest
extends TestCase {
    public ContinuousMapperTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testBasics() throws Exception {
        ContinuousMapper continuousMapper = new ContinuousMapper();
        ContinuousMapperTest.assertTrue((continuousMapper.getValueMap() != null ? 1 : 0) != 0);
        ContinuousMapperTest.assertTrue((continuousMapper.getBoundaryRangeValuesMap() != null ? 1 : 0) != 0);
        ContinuousMapperTest.assertTrue((continuousMapper.getInterpolator() == null ? 1 : 0) != 0);
        Object object = continuousMapper.getRangeValue(new Object());
        ContinuousMapperTest.assertTrue((object == null ? 1 : 0) != 0);
        TreeMap treeMap = new TreeMap();
        continuousMapper.setBoundaryRangeValuesMap(treeMap);
        ContinuousMapperTest.assertTrue((continuousMapper.getValueMap() == treeMap ? 1 : 0) != 0);
        ContinuousMapperTest.assertTrue((continuousMapper.getBoundaryRangeValuesMap() == treeMap ? 1 : 0) != 0);
        LinearNumberToColorInterpolator linearNumberToColorInterpolator = new LinearNumberToColorInterpolator();
        continuousMapper.setInterpolator(linearNumberToColorInterpolator);
        ContinuousMapperTest.assertTrue((continuousMapper.getInterpolator() == linearNumberToColorInterpolator ? 1 : 0) != 0);
        ContinuousMapper continuousMapper2 = new ContinuousMapper(treeMap, linearNumberToColorInterpolator);
        ContinuousMapperTest.assertTrue((continuousMapper2.getValueMap() == treeMap ? 1 : 0) != 0);
        ContinuousMapperTest.assertTrue((continuousMapper.getBoundaryRangeValuesMap() == treeMap ? 1 : 0) != 0);
        ContinuousMapperTest.assertTrue((continuousMapper2.getInterpolator() == linearNumberToColorInterpolator ? 1 : 0) != 0);
        TreeMap treeMap2 = new TreeMap();
        continuousMapper2.setBoundaryRangeValuesMap(treeMap2);
        ContinuousMapperTest.assertTrue((continuousMapper2.getValueMap() == treeMap2 ? 1 : 0) != 0);
        ContinuousMapperTest.assertTrue((continuousMapper2.getBoundaryRangeValuesMap() == treeMap2 ? 1 : 0) != 0);
        LinearNumberToColorInterpolator linearNumberToColorInterpolator2 = new LinearNumberToColorInterpolator();
        continuousMapper2.setInterpolator(linearNumberToColorInterpolator2);
        ContinuousMapperTest.assertTrue((continuousMapper2.getInterpolator() == linearNumberToColorInterpolator2 ? 1 : 0) != 0);
        ContinuousMapper continuousMapper3 = continuousMapper2;
        object = continuousMapper3.getRangeValue(new Object());
        ContinuousMapperTest.assertTrue((object == null ? 1 : 0) != 0);
    }

    public void testFunction() throws Exception {
        Double d = new Double(-4.0);
        BoundaryRangeValues boundaryRangeValues = new BoundaryRangeValues(new Color(255, 0, 255), new Color(0, 0, 0), new Color(200, 20, 10));
        Double d2 = new Double(0.0);
        BoundaryRangeValues boundaryRangeValues2 = new BoundaryRangeValues(new Color(255, 255, 255), new Color(255, 255, 0), new Color(255, 255, 255));
        Double d3 = new Double(4.0);
        BoundaryRangeValues boundaryRangeValues3 = new BoundaryRangeValues(new Color(15, 30, 210), new Color(100, 100, 100), new Color(0, 255, 255));
        TreeMap<Double, BoundaryRangeValues> treeMap = new TreeMap<Double, BoundaryRangeValues>();
        treeMap.put(d, boundaryRangeValues);
        treeMap.put(d2, boundaryRangeValues2);
        treeMap.put(d3, boundaryRangeValues3);
        LinearNumberToColorInterpolator linearNumberToColorInterpolator = new LinearNumberToColorInterpolator();
        ContinuousMapper continuousMapper = new ContinuousMapper(treeMap, linearNumberToColorInterpolator);
        Object object = continuousMapper.getRangeValue(new Double(-5.0));
        ContinuousMapperTest.assertTrue((boolean)(object instanceof Color));
        Color color = (Color)object;
        ContinuousMapperTest.assertTrue((color.getRed() == 255 ? 1 : 0) != 0);
        ContinuousMapperTest.assertTrue((color.getGreen() == 0 ? 1 : 0) != 0);
        ContinuousMapperTest.assertTrue((color.getBlue() == 255 ? 1 : 0) != 0);
        Color color2 = (Color)continuousMapper.getRangeValue(new Double(-4.0));
        ContinuousMapperTest.assertTrue((color2.getRed() == 0 ? 1 : 0) != 0);
        ContinuousMapperTest.assertTrue((color2.getGreen() == 0 ? 1 : 0) != 0);
        ContinuousMapperTest.assertTrue((color2.getBlue() == 0 ? 1 : 0) != 0);
        Color color3 = (Color)continuousMapper.getRangeValue(new Double(-3.0));
        ContinuousMapperTest.assertTrue((color3.getRed() == 214 ? 1 : 0) != 0);
        ContinuousMapperTest.assertTrue((color3.getGreen() == 79 ? 1 : 0) != 0);
        ContinuousMapperTest.assertTrue((color3.getBlue() == 71 ? 1 : 0) != 0);
        Color color4 = (Color)continuousMapper.getRangeValue(new Double(0.0));
        ContinuousMapperTest.assertTrue((color4.getRed() == 255 ? 1 : 0) != 0);
        ContinuousMapperTest.assertTrue((color4.getGreen() == 255 ? 1 : 0) != 0);
        ContinuousMapperTest.assertTrue((color4.getBlue() == 0 ? 1 : 0) != 0);
        Color color5 = (Color)continuousMapper.getRangeValue(new Double(1.5));
        ContinuousMapperTest.assertTrue((color5.getRed() == 165 ? 1 : 0) != 0);
        ContinuousMapperTest.assertTrue((color5.getGreen() == 171 ? 1 : 0) != 0);
        ContinuousMapperTest.assertTrue((color5.getBlue() == 238 ? 1 : 0) != 0);
        Color color6 = (Color)continuousMapper.getRangeValue(new Double(4.0));
        ContinuousMapperTest.assertTrue((color6.getRed() == 100 ? 1 : 0) != 0);
        ContinuousMapperTest.assertTrue((color6.getGreen() == 100 ? 1 : 0) != 0);
        ContinuousMapperTest.assertTrue((color6.getBlue() == 100 ? 1 : 0) != 0);
        Color color7 = (Color)continuousMapper.getRangeValue(new Double(5.0));
        ContinuousMapperTest.assertTrue((color7.getRed() == 0 ? 1 : 0) != 0);
        ContinuousMapperTest.assertTrue((color7.getGreen() == 255 ? 1 : 0) != 0);
        ContinuousMapperTest.assertTrue((color7.getBlue() == 255 ? 1 : 0) != 0);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(ContinuousMapperTest.class));
    }
}

