/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.vizmap.unitTests;

import cytoscape.vizmap.AttributeMapper;
import cytoscape.vizmap.DiscreteMapper;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AttributeMapperTest
extends TestCase {
    public AttributeMapperTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testBasics() throws Exception {
        AttributeMapper attributeMapper = new AttributeMapper(null);
        Integer n = new Integer(0);
        AttributeMapperTest.assertTrue((attributeMapper.getControllingDomainAttributeName(n) == null ? 1 : 0) != 0);
        AttributeMapperTest.assertTrue((attributeMapper.getValueMapper(n) == null ? 1 : 0) != 0);
        Map map = attributeMapper.getDefaultValues();
        AttributeMapperTest.assertTrue((map != null ? 1 : 0) != 0);
        AttributeMapperTest.assertTrue((map.size() == 0 ? 1 : 0) != 0);
        AttributeMapperTest.assertTrue((attributeMapper.getDefaultValue(n) == null ? 1 : 0) != 0);
        Object object = new Object();
        attributeMapper.setDefaultValue(n, object);
        AttributeMapperTest.assertTrue((attributeMapper.getDefaultValue(n) == object ? 1 : 0) != 0);
        AttributeMapperTest.assertTrue((attributeMapper.getDefaultValues().size() == 1 ? 1 : 0) != 0);
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        attributeMapper.setDefaultValues(hashMap);
        map = attributeMapper.getDefaultValues();
        AttributeMapperTest.assertTrue((map != null ? 1 : 0) != 0);
        AttributeMapperTest.assertTrue((map.size() == 0 ? 1 : 0) != 0);
        AttributeMapperTest.assertTrue((attributeMapper.getDefaultValue(n) == null ? 1 : 0) != 0);
        AttributeMapperTest.assertTrue((!attributeMapper.getUseDefaultsOnly() ? 1 : 0) != 0);
        attributeMapper.setUseDefaultsOnly(true);
        AttributeMapperTest.assertTrue((attributeMapper.getUseDefaultsOnly() ? 1 : 0) != 0);
        hashMap.put(n, object);
        AttributeMapper attributeMapper2 = new AttributeMapper(hashMap);
        map = attributeMapper2.getDefaultValues();
        AttributeMapperTest.assertTrue((map != null ? 1 : 0) != 0);
        AttributeMapperTest.assertTrue((map.size() == 1 ? 1 : 0) != 0);
        AttributeMapperTest.assertTrue((attributeMapper2.getDefaultValue(n) == object ? 1 : 0) != 0);
    }

    public void testFunctions() throws Exception {
        HashMap<Integer, Double> hashMap = new HashMap<Integer, Double>();
        hashMap.put(new Integer(0), new Double(0.0));
        AttributeMapper attributeMapper = new AttributeMapper(hashMap);
        AttributeMapperTest.assertTrue((attributeMapper.getControllingDomainAttributeName(new Integer(0)) == null ? 1 : 0) != 0);
        AttributeMapperTest.assertTrue((attributeMapper.getValueMapper(new Integer(0)) == null ? 1 : 0) != 0);
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        hashMap2.put(new String("five"), new Double(5.0));
        DiscreteMapper discreteMapper = new DiscreteMapper(hashMap2);
        attributeMapper.setAttributeMapEntry(new Integer(0), new String("number"), discreteMapper);
        AttributeMapperTest.assertTrue((boolean)attributeMapper.getControllingDomainAttributeName(new Integer(0)).equals("number"));
        AttributeMapperTest.assertTrue((attributeMapper.getValueMapper(new Integer(0)) == discreteMapper ? 1 : 0) != 0);
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        hashMap3.put("number", "five");
        hashMap3.put("data", "0.5");
        Object object = attributeMapper.getRangeValue(hashMap3, new Integer(0));
        AttributeMapperTest.assertTrue((boolean)(object instanceof Double));
        AttributeMapperTest.assertTrue(((Double)object == 5.0 ? 1 : 0) != 0);
        Object object2 = attributeMapper.getRangeValue(hashMap3, new Integer(1));
        AttributeMapperTest.assertTrue((object2 == null ? 1 : 0) != 0);
        Object object3 = attributeMapper.getRangeValue(null, new Integer(0));
        AttributeMapperTest.assertTrue((boolean)(object3 instanceof Double));
        AttributeMapperTest.assertTrue(((Double)object3 == 0.0 ? 1 : 0) != 0);
        Object object4 = attributeMapper.getRangeValue(new HashMap(), new Integer(0));
        AttributeMapperTest.assertTrue((boolean)(object4 instanceof Double));
        AttributeMapperTest.assertTrue(((Double)object4 == 0.0 ? 1 : 0) != 0);
        attributeMapper.setUseDefaultsOnly(true);
        Object object5 = attributeMapper.getRangeValue(hashMap3, new Integer(0));
        AttributeMapperTest.assertTrue((boolean)(object5 instanceof Double));
        AttributeMapperTest.assertTrue(((Double)object5 == 0.0 ? 1 : 0) != 0);
        attributeMapper.setUseDefaultsOnly(false);
        Object object6 = attributeMapper.getRangeValue(hashMap3, new Integer(0));
        AttributeMapperTest.assertTrue((boolean)(object6 instanceof Double));
        AttributeMapperTest.assertTrue(((Double)object6 == 5.0 ? 1 : 0) != 0);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(AttributeMapperTest.class));
    }
}

