/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.vizmap;

import cytoscape.util.Misc;
import cytoscape.vizmap.AttributeMapper;
import cytoscape.vizmap.AttributeMapperCategories;
import cytoscape.vizmap.FlatInterpolator;
import cytoscape.vizmap.Interpolator;
import cytoscape.vizmap.LinearNumberToColorInterpolator;
import cytoscape.vizmap.LinearNumberToNumberInterpolator;
import java.awt.Color;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import y.view.Arrow;
import y.view.LineType;

public class VizMapperCategories
implements AttributeMapperCategories {
    public static final Integer NODE_FILL_COLOR = new Integer(0);
    public static final Integer NODE_BORDER_COLOR = new Integer(1);
    public static final Integer NODE_BORDER_LINETYPE = new Integer(2);
    public static final Integer NODE_HEIGHT = new Integer(3);
    public static final Integer NODE_WIDTH = new Integer(4);
    public static final Integer NODE_SHAPE = new Integer(5);
    public static final Integer NODE_SELECTED_COLOR = new Integer(6);
    public static final Integer EDGE_COLOR = new Integer(10);
    public static final Integer EDGE_LINETYPE = new Integer(11);
    public static final Integer EDGE_SOURCE_DECORATION = new Integer(12);
    public static final Integer EDGE_TARGET_DECORATION = new Integer(13);
    public static final Integer BG_COLOR = new Integer(14);

    public Color getNodeFillColor(Map map, AttributeMapper attributeMapper) {
        return (Color)this.getRangeValue(map, attributeMapper, NODE_FILL_COLOR);
    }

    public Color getNodeBorderColor(Map map, AttributeMapper attributeMapper) {
        return (Color)this.getRangeValue(map, attributeMapper, NODE_BORDER_COLOR);
    }

    public Color getNodeSelectedColor(AttributeMapper attributeMapper) {
        return (Color)attributeMapper.getDefaultValue(NODE_SELECTED_COLOR);
    }

    public LineType getNodeBorderLineType(Map map, AttributeMapper attributeMapper) {
        return (LineType)this.getRangeValue(map, attributeMapper, NODE_BORDER_LINETYPE);
    }

    public double getNodeHeight(Map map, AttributeMapper attributeMapper) {
        Double d = (Double)this.getRangeValue(map, attributeMapper, NODE_HEIGHT);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public double getNodeWidth(Map map, AttributeMapper attributeMapper) {
        Double d = (Double)this.getRangeValue(map, attributeMapper, NODE_WIDTH);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public byte getNodeShape(Map map, AttributeMapper attributeMapper) {
        Byte by = (Byte)this.getRangeValue(map, attributeMapper, NODE_SHAPE);
        if (by == null) {
            return 0;
        }
        return by;
    }

    public Color getEdgeColor(Map map, AttributeMapper attributeMapper) {
        return (Color)this.getRangeValue(map, attributeMapper, EDGE_COLOR);
    }

    public Color getBGColor(AttributeMapper attributeMapper) {
        return (Color)attributeMapper.getDefaultValue(BG_COLOR);
    }

    public LineType getEdgeLineType(Map map, AttributeMapper attributeMapper) {
        return (LineType)this.getRangeValue(map, attributeMapper, EDGE_LINETYPE);
    }

    public Arrow getEdgeSourceDecoration(Map map, AttributeMapper attributeMapper) {
        return (Arrow)this.getRangeValue(map, attributeMapper, EDGE_SOURCE_DECORATION);
    }

    public Arrow getEdgeTargetDecoration(Map map, AttributeMapper attributeMapper) {
        return (Arrow)this.getRangeValue(map, attributeMapper, EDGE_TARGET_DECORATION);
    }

    public Object getRangeValue(Map map, AttributeMapper attributeMapper, Integer n) {
        String string = (String)this.getPropertyNamesMap().get(n);
        if (string == null || map == null) {
            return attributeMapper.getRangeValue(map, n);
        }
        Object v = map.get(string);
        if (v == null) {
            return attributeMapper.getRangeValue(map, n);
        }
        if (!(v instanceof String)) {
            System.err.println("Unexpected data attribute value:");
            System.err.println("    " + string + " = " + v);
            System.err.println("    Expected a String, class = " + v.getClass());
            return attributeMapper.getRangeValue(map, n);
        }
        Object object = this.parseRangeAttributeValue(n, (String)v);
        if (object == null) {
            return attributeMapper.getRangeValue(map, n);
        }
        return object;
    }

    public Map getInitialDefaults() {
        HashMap<Integer, Serializable> hashMap = new HashMap<Integer, Serializable>();
        hashMap.put(NODE_FILL_COLOR, new Color(255, 255, 255));
        hashMap.put(NODE_BORDER_COLOR, new Color(0, 0, 0));
        hashMap.put(NODE_BORDER_LINETYPE, (Serializable)LineType.LINE_1);
        hashMap.put(NODE_HEIGHT, new Double(30.0));
        hashMap.put(NODE_WIDTH, new Double(70.0));
        hashMap.put(NODE_SHAPE, new Byte(0));
        hashMap.put(EDGE_COLOR, new Color(0, 0, 0));
        hashMap.put(BG_COLOR, new Color(255, 255, 255));
        hashMap.put(EDGE_LINETYPE, (Serializable)LineType.LINE_1);
        hashMap.put(EDGE_SOURCE_DECORATION, (Serializable)Arrow.NONE);
        hashMap.put(EDGE_TARGET_DECORATION, (Serializable)Arrow.NONE);
        return hashMap;
    }

    public Map getPropertyNamesMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(NODE_FILL_COLOR, "node.fillColor");
        hashMap.put(NODE_BORDER_COLOR, "node.borderColor");
        hashMap.put(NODE_SELECTED_COLOR, "node.selectedColor");
        hashMap.put(NODE_BORDER_LINETYPE, "node.borderLinetype");
        hashMap.put(NODE_HEIGHT, "node.height");
        hashMap.put(NODE_WIDTH, "node.width");
        hashMap.put(NODE_SHAPE, "node.shape");
        hashMap.put(EDGE_COLOR, "edge.color");
        hashMap.put(BG_COLOR, "background.color");
        hashMap.put(EDGE_LINETYPE, "edge.linetype");
        hashMap.put(EDGE_SOURCE_DECORATION, "edge.sourceDecoration");
        hashMap.put(EDGE_TARGET_DECORATION, "edge.targetDecoration");
        return hashMap;
    }

    public Object parseRangeAttributeValue(Integer n, String string) {
        Serializable serializable = null;
        if (n.equals(NODE_FILL_COLOR) || n.equals(NODE_BORDER_COLOR) || n.equals(EDGE_COLOR) || n.equals(BG_COLOR) || n.equals(NODE_SELECTED_COLOR)) {
            serializable = Misc.parseRGBText(string);
        } else if (n.equals(NODE_HEIGHT) || n.equals(NODE_WIDTH)) {
            serializable = new Double(string);
        } else if (n.equals(NODE_SHAPE)) {
            serializable = Misc.parseNodeShapeTextIntoByte(string);
        } else if (n.equals(NODE_BORDER_LINETYPE) || n.equals(EDGE_LINETYPE)) {
            serializable = Misc.parseLineTypeText(string);
        } else if (n.equals(EDGE_SOURCE_DECORATION) || n.equals(EDGE_TARGET_DECORATION)) {
            serializable = Misc.parseArrowText(string);
        } else {
            System.err.println("Error parsing range attribute value:");
            System.err.println("    unknown vizAttribute: " + n.toString());
        }
        return serializable;
    }

    public String rangeAttributeValueToString(Integer n, Object object) {
        boolean bl = false;
        boolean bl2 = false;
        if (n.equals(NODE_FILL_COLOR) || n.equals(NODE_BORDER_COLOR) || n.equals(EDGE_COLOR) || n.equals(BG_COLOR) || n.equals(NODE_SELECTED_COLOR)) {
            if (object instanceof Color) {
                return Misc.getRGBText((Color)object);
            }
            bl = true;
        } else if (n.equals(NODE_HEIGHT) || n.equals(NODE_WIDTH)) {
            if (object instanceof Double) {
                return object.toString();
            }
            bl = true;
        } else if (n.equals(NODE_SHAPE)) {
            if (object instanceof Byte) {
                return Misc.getNodeShapeText((Byte)object);
            }
            bl = true;
        } else if (n.equals(NODE_BORDER_LINETYPE) || n.equals(EDGE_LINETYPE)) {
            if (object instanceof LineType) {
                return Misc.getLineTypeText((LineType)object);
            }
            bl = true;
        } else if (n.equals(EDGE_SOURCE_DECORATION) || n.equals(EDGE_TARGET_DECORATION)) {
            if (object instanceof Arrow) {
                return Misc.getArrowText((Arrow)object);
            }
            bl = true;
        } else {
            bl2 = true;
        }
        if (bl) {
            System.err.println("Error converting attribute value to string:");
            System.err.println("Incorrect attribute value object type: " + object.getClass());
        }
        if (bl2) {
            System.err.println("Error converting attribute value to string:");
            System.err.println("    unknown vizAttribute: " + n.toString());
        }
        return "";
    }

    public Interpolator getInterpolator(Integer n) {
        Interpolator interpolator = null;
        if (n.equals(NODE_FILL_COLOR) || n.equals(NODE_BORDER_COLOR) || n.equals(EDGE_COLOR) || n.equals(BG_COLOR) || n.equals(NODE_SELECTED_COLOR)) {
            interpolator = new LinearNumberToColorInterpolator();
        } else if (n.equals(NODE_HEIGHT) || n.equals(NODE_WIDTH)) {
            interpolator = new LinearNumberToNumberInterpolator();
        } else if (n.equals(NODE_SHAPE)) {
            interpolator = new FlatInterpolator();
        } else if (n.equals(NODE_BORDER_LINETYPE) || n.equals(EDGE_LINETYPE)) {
            interpolator = new FlatInterpolator();
        } else if (n.equals(EDGE_SOURCE_DECORATION) || n.equals(EDGE_TARGET_DECORATION)) {
            interpolator = new FlatInterpolator();
        } else {
            System.err.println("Error parsing range attribute value:");
            System.err.println("    unknown vizAttribute: " + n.toString());
        }
        return interpolator;
    }
}

