/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.vizmap;

import cytoscape.vizmap.BoundaryRangeValues;
import cytoscape.vizmap.Interpolator;
import cytoscape.vizmap.ValueMapper;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class ContinuousMapper
implements ValueMapper {
    private SortedMap boundaryValueMap;
    private Interpolator fInt;

    public ContinuousMapper() {
        this.setBoundaryRangeValuesMap(new TreeMap());
        this.setInterpolator(null);
    }

    public ContinuousMapper(SortedMap sortedMap, Interpolator interpolator) {
        this.setBoundaryRangeValuesMap(sortedMap);
        this.setInterpolator(interpolator);
    }

    public Map getValueMap() {
        return this.getBoundaryRangeValuesMap();
    }

    public SortedMap getBoundaryRangeValuesMap() {
        return this.boundaryValueMap;
    }

    public void setBoundaryRangeValuesMap(SortedMap sortedMap) {
        this.boundaryValueMap = sortedMap;
    }

    public Interpolator getInterpolator() {
        return this.fInt;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.fInt = interpolator;
    }

    public Object getRangeValue(Object object) {
        if (object == null || this.boundaryValueMap == null) {
            return null;
        }
        int n = this.boundaryValueMap.size();
        if (n == 0) {
            return null;
        }
        if (!(object instanceof Comparable)) {
            return null;
        }
        Comparable comparable = (Comparable)object;
        Comparable comparable2 = (Comparable)this.boundaryValueMap.firstKey();
        int n2 = 0;
        try {
            n2 = this.compareValues(comparable, comparable2);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        if (n2 <= 0) {
            BoundaryRangeValues boundaryRangeValues = (BoundaryRangeValues)this.boundaryValueMap.get(comparable2);
            if (n2 < 0) {
                return boundaryRangeValues.lesserValue;
            }
            return boundaryRangeValues.equalValue;
        }
        Comparable comparable3 = (Comparable)this.boundaryValueMap.lastKey();
        if (this.compareValues(comparable, comparable3) > 0) {
            BoundaryRangeValues boundaryRangeValues = (BoundaryRangeValues)this.boundaryValueMap.get(comparable3);
            return boundaryRangeValues.greaterValue;
        }
        if (this.fInt == null) {
            return null;
        }
        Set set = this.boundaryValueMap.keySet();
        Iterator iterator = set.iterator();
        Comparable comparable4 = (Comparable)iterator.next();
        Comparable comparable5 = null;
        while (iterator.hasNext()) {
            comparable5 = (Comparable)iterator.next();
            int n3 = this.compareValues(comparable, comparable5);
            if (n3 == 0) {
                BoundaryRangeValues boundaryRangeValues = (BoundaryRangeValues)this.boundaryValueMap.get(comparable5);
                return boundaryRangeValues.equalValue;
            }
            if (n3 < 0) break;
            comparable4 = comparable5;
        }
        BoundaryRangeValues boundaryRangeValues = (BoundaryRangeValues)this.boundaryValueMap.get(comparable4);
        Object object2 = boundaryRangeValues.greaterValue;
        BoundaryRangeValues boundaryRangeValues2 = (BoundaryRangeValues)this.boundaryValueMap.get(comparable5);
        Object object3 = boundaryRangeValues2.lesserValue;
        return this.fInt.getRangeValue(comparable4, object2, comparable5, object3, object);
    }

    private int compareValues(Comparable comparable, Comparable comparable2) {
        if (comparable instanceof Number && comparable2 instanceof Number) {
            double d;
            double d2 = ((Number)((Object)comparable)).doubleValue();
            if (d2 < (d = ((Number)((Object)comparable2)).doubleValue())) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            return 0;
        }
        return comparable.compareTo(comparable2);
    }
}

