/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.vizmap;

import cytoscape.vizmap.AttributeMapper;
import cytoscape.vizmap.AttributeMapperCategories;
import cytoscape.vizmap.BoundaryRangeValues;
import cytoscape.vizmap.ContinuousMapper;
import cytoscape.vizmap.DiscreteMapper;
import cytoscape.vizmap.Interpolator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;

public class AttributeMapperPropertiesAdapter {
    private AttributeMapper mapper;
    private AttributeMapperCategories categories;

    public AttributeMapperPropertiesAdapter() {
        this.setAttributeMapper(null);
        this.setAttributeMapperCategories(null);
    }

    public AttributeMapperPropertiesAdapter(AttributeMapper attributeMapper, AttributeMapperCategories attributeMapperCategories) {
        this.setAttributeMapper(attributeMapper);
        this.setAttributeMapperCategories(attributeMapperCategories);
    }

    public AttributeMapper getAttributeMapper() {
        return this.mapper;
    }

    public void setAttributeMapper(AttributeMapper attributeMapper) {
        this.mapper = attributeMapper;
    }

    public AttributeMapperCategories getAttributeMapperCategories() {
        return this.categories;
    }

    public void setAttributeMapperCategories(AttributeMapperCategories attributeMapperCategories) {
        this.categories = attributeMapperCategories;
    }

    public void applyAllRangeProperties(Properties properties) {
        if (properties == null || this.mapper == null || this.categories == null) {
            return;
        }
        Iterator iterator = this.categories.getPropertyNamesMap().keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            this.applyRangeProperties(n, properties);
        }
    }

    public void applyRangeProperties(Integer n, Properties properties) {
        Object object;
        String string;
        if (n == null || properties == null || this.mapper == null || this.categories == null) {
            return;
        }
        String string2 = (String)this.categories.getPropertyNamesMap().get(n);
        if (string2 == null) {
            System.err.println("Error parsing attributeMap properties:");
            System.err.println("    don't know how to parse range attribute " + n.toString());
            return;
        }
        String string3 = string2 + ".default";
        if (properties.containsKey(string3)) {
            string = properties.getProperty(string3);
            object = this.categories.parseRangeAttributeValue(n, string);
            this.mapper.setDefaultValue(n, object);
        }
        if (properties.containsKey(string = string2 + ".controller")) {
            object = properties.getProperty(string);
            String string4 = string2 + "." + (String)object;
            String string5 = string4 + ".type";
            String string6 = properties.getProperty(string5);
            if (string6 == null) {
                System.err.println("Error parsing attributeMap properties:");
                System.err.println("    no property matching: " + string5);
                return;
            }
            if (string6.equals("discrete")) {
                Map map = this.parseDiscreteMap(properties, string4);
                this.parseDiscreteRangeMap(n, map);
                DiscreteMapper discreteMapper = new DiscreteMapper(map);
                this.mapper.setAttributeMapEntry(n, (String)object, discreteMapper);
                return;
            }
            if (string6.equals("continuous")) {
                SortedMap sortedMap = this.parseContinuousMap(properties, string4);
                SortedMap sortedMap2 = this.parseContinuousRangeMap(n, sortedMap);
                Interpolator interpolator = this.categories.getInterpolator(n);
                ContinuousMapper continuousMapper = new ContinuousMapper(sortedMap2, interpolator);
                this.mapper.setAttributeMapEntry(n, (String)object, continuousMapper);
                return;
            }
            System.err.println("Error parsing attributeMap properties:");
            System.err.println("    Unrecognized property value: " + string6);
            System.err.println("    for key: " + string5);
            System.err.println("    (Expected 'discrete' or 'continuous')");
            return;
        }
    }

    protected Map parseDiscreteMap(Properties properties, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = string + ".map";
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith(string2)) continue;
            String string4 = properties.getProperty(string3);
            String string5 = string3.substring(string2.length() + 1);
            hashMap.put(string5, string4);
        }
        return hashMap;
    }

    protected SortedMap parseContinuousMap(Properties properties, String string) {
        int n;
        TreeMap<String, BoundaryRangeValues> treeMap = new TreeMap<String, BoundaryRangeValues>();
        String string2 = string + ".boundaryvalues";
        String string3 = properties.getProperty(string2);
        if (string3 == null) {
            System.err.println("Warning: while parsing attributeMap properties:");
            System.err.println("    no boundary values specified for");
            System.err.println("continuous key: " + string);
            return treeMap;
        }
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Error parsing attributeMap properties:");
            System.err.println("    Expected number value for key: " + string3);
            return treeMap;
        }
        for (int i = 0; i < n; ++i) {
            String string4 = string + ".bv" + Integer.toString(i);
            String string5 = string4 + ".domainvalue";
            String string6 = properties.getProperty(string5);
            if (string6 == null) {
                System.err.println("Error parsing attributeMap properties:");
                System.err.println("    expected numerical value for key: " + string5);
                continue;
            }
            BoundaryRangeValues boundaryRangeValues = new BoundaryRangeValues();
            String string7 = string4 + ".lesser";
            String string8 = properties.getProperty(string7);
            boundaryRangeValues.lesserValue = string8;
            String string9 = string4 + ".equal";
            String string10 = properties.getProperty(string9);
            boundaryRangeValues.equalValue = string10;
            String string11 = string4 + ".greater";
            String string12 = properties.getProperty(string11);
            boundaryRangeValues.greaterValue = string12;
            treeMap.put(string6, boundaryRangeValues);
        }
        return treeMap;
    }

    protected void parseDiscreteRangeMap(Integer n, Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getValue();
            Object object = this.categories.parseRangeAttributeValue(n, string);
            if (object == null) {
                iterator.remove();
                continue;
            }
            entry.setValue(object);
        }
    }

    protected SortedMap parseContinuousRangeMap(Integer n, SortedMap sortedMap) {
        TreeMap<Double, BoundaryRangeValues> treeMap = new TreeMap<Double, BoundaryRangeValues>();
        Iterator iterator = sortedMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            BoundaryRangeValues boundaryRangeValues = (BoundaryRangeValues)sortedMap.get(string);
            Double d = null;
            try {
                d = Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Error parsing attributeMap properties:");
                System.err.println("    expected number value for key: " + string);
                continue;
            }
            String string2 = (String)boundaryRangeValues.lesserValue;
            Object object = this.categories.parseRangeAttributeValue(n, string2);
            if (object == null) continue;
            boundaryRangeValues.lesserValue = object;
            String string3 = (String)boundaryRangeValues.equalValue;
            Object object2 = this.categories.parseRangeAttributeValue(n, string3);
            if (object2 == null) continue;
            boundaryRangeValues.equalValue = object2;
            String string4 = (String)boundaryRangeValues.greaterValue;
            Object object3 = this.categories.parseRangeAttributeValue(n, string4);
            if (object3 == null) continue;
            boundaryRangeValues.greaterValue = object3;
            treeMap.put(d, boundaryRangeValues);
        }
        return treeMap;
    }
}

