/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.vizmap;

import cytoscape.vizmap.ValueMapper;
import java.util.HashMap;
import java.util.Map;

public class AttributeMapper {
    protected Map rangeToDomainName = new HashMap();
    protected Map rangeToValueMapper = new HashMap();
    private Map defaultRangeValues;
    private boolean useDefaultsOnly;

    public AttributeMapper(Map map) {
        this.setDefaultValues(map);
        this.setUseDefaultsOnly(false);
    }

    public void setAttributeMapEntry(Integer n, String string, ValueMapper valueMapper) {
        if (n != null && string != null && valueMapper != null) {
            this.rangeToDomainName.put(n, string);
            this.rangeToValueMapper.put(n, valueMapper);
        }
    }

    public void removeAttributeMapEntry(Integer n) {
        if (n != null) {
            this.rangeToDomainName.remove(n);
            this.rangeToValueMapper.remove(n);
        }
    }

    public String getControllingDomainAttributeName(Integer n) {
        return (String)this.rangeToDomainName.get(n);
    }

    public ValueMapper getValueMapper(Integer n) {
        return (ValueMapper)this.rangeToValueMapper.get(n);
    }

    public Object getRangeValue(Map map, Integer n) {
        Object object = this.getDefaultValue(n);
        if (this.useDefaultsOnly || map == null || n == null) {
            return object;
        }
        Object v = this.rangeToDomainName.get(n);
        if (v == null) {
            return object;
        }
        Object v2 = map.get(v);
        if (v2 == null) {
            return object;
        }
        ValueMapper valueMapper = (ValueMapper)this.rangeToValueMapper.get(n);
        if (valueMapper == null) {
            return object;
        }
        Object object2 = valueMapper.getRangeValue(v2);
        if (object2 == null) {
            return object;
        }
        return object2;
    }

    public Object getDefaultValue(Integer n) {
        return this.defaultRangeValues.get(n);
    }

    public Object setDefaultValue(Integer n, Object object) {
        if (n == null) {
            return null;
        }
        return this.defaultRangeValues.put(n, object);
    }

    public Map getDefaultValues() {
        return this.defaultRangeValues;
    }

    public void setDefaultValues(Map map) {
        this.defaultRangeValues = map == null ? new HashMap() : map;
    }

    public boolean getUseDefaultsOnly() {
        return this.useDefaultsOnly;
    }

    public void setUseDefaultsOnly(boolean bl) {
        this.useDefaultsOnly = bl;
    }
}

