/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.unitTests;

import cytoscape.GraphObjAttributes;
import cytoscape.visual.Network;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.NodeAppearanceCalculator;
import java.awt.Color;
import java.awt.Font;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import y.base.Node;
import y.view.Graph2D;
import y.view.LineType;

public class NodeAppearanceCalculatorTest
extends TestCase {
    public NodeAppearanceCalculatorTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testBypass() throws Exception {
        Color color = new Color(63, 128, 255);
        Color color2 = new Color(100, 100, 50);
        LineType lineType = LineType.DASHED_3;
        byte by = 8;
        double d = 49.0;
        double d2 = 79.0;
        String string = "testLabel";
        String string2 = "testToolTip";
        Font font = new Font("SansSerif", 2, 10);
        Graph2D graph2D = new Graph2D();
        Node node = graph2D.createNode();
        Node node2 = graph2D.createNode();
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        String string3 = "first node";
        graphObjAttributes.addNameMapping(string3, node);
        graphObjAttributes.set("node.fillColor", string3, color);
        graphObjAttributes.set("node.borderColor", string3, color2);
        graphObjAttributes.set("node.shape", string3, new Byte(by));
        graphObjAttributes.set("node.width", string3, d);
        graphObjAttributes.set("node.height", string3, d2);
        graphObjAttributes.set("node.label", string3, string);
        graphObjAttributes.set("node.toolTip", string3, string2);
        graphObjAttributes.set("node.font", string3, font);
        GraphObjAttributes graphObjAttributes2 = new GraphObjAttributes();
        String string4 = "second node";
        graphObjAttributes2.addNameMapping(string4, node2);
        graphObjAttributes2.set("node.fillColor", string4, "63,128,255");
        graphObjAttributes2.set("node.borderColor", string4, "100,100,50");
        graphObjAttributes2.set("node.lineType", string4, "dashed3");
        graphObjAttributes2.set("node.shape", string4, "diamond");
        graphObjAttributes2.set("node.width", string4, "49.0");
        graphObjAttributes2.set("node.height", string4, "79.0");
        graphObjAttributes2.set("node.label", string4, "testLabel");
        graphObjAttributes2.set("node.toolTip", string4, "testToolTip");
        graphObjAttributes2.set("node.font", string4, "SansSerif,italic,10");
        Network network = new Network(graph2D, graphObjAttributes, new GraphObjAttributes());
        Network network2 = new Network(graph2D, graphObjAttributes2, new GraphObjAttributes());
        NodeAppearanceCalculator nodeAppearanceCalculator = new NodeAppearanceCalculator();
        nodeAppearanceCalculator.setNodeSizeLocked(false);
        NodeAppearance nodeAppearance = nodeAppearanceCalculator.calculateNodeAppearance(node, network);
        NodeAppearanceCalculatorTest.assertTrue((boolean)nodeAppearance.getFillColor().equals(color));
        NodeAppearanceCalculatorTest.assertTrue((boolean)nodeAppearance.getBorderColor().equals(color2));
        NodeAppearanceCalculatorTest.assertTrue((nodeAppearance.getShape() == by ? 1 : 0) != 0);
        NodeAppearanceCalculatorTest.assertTrue((nodeAppearance.getWidth() == d ? 1 : 0) != 0);
        NodeAppearanceCalculatorTest.assertTrue((nodeAppearance.getHeight() == d2 ? 1 : 0) != 0);
        NodeAppearanceCalculatorTest.assertTrue((boolean)nodeAppearance.getLabel().equals(string));
        NodeAppearanceCalculatorTest.assertTrue((boolean)nodeAppearance.getToolTip().equals(string2));
        NodeAppearanceCalculatorTest.assertTrue((boolean)nodeAppearance.getFont().equals(font));
        NodeAppearance nodeAppearance2 = nodeAppearanceCalculator.calculateNodeAppearance(node2, network2);
        NodeAppearanceCalculatorTest.assertTrue((boolean)nodeAppearance2.getFillColor().equals(color));
        NodeAppearanceCalculatorTest.assertTrue((boolean)nodeAppearance2.getBorderColor().equals(color2));
        NodeAppearanceCalculatorTest.assertTrue((boolean)nodeAppearance2.getBorderLineType().equals((Object)lineType));
        NodeAppearanceCalculatorTest.assertTrue((nodeAppearance2.getShape() == by ? 1 : 0) != 0);
        NodeAppearanceCalculatorTest.assertTrue((nodeAppearance2.getWidth() == d ? 1 : 0) != 0);
        NodeAppearanceCalculatorTest.assertTrue((nodeAppearance2.getHeight() == d2 ? 1 : 0) != 0);
        NodeAppearanceCalculatorTest.assertTrue((boolean)nodeAppearance2.getLabel().equals(string));
        NodeAppearanceCalculatorTest.assertTrue((boolean)nodeAppearance2.getToolTip().equals(string2));
        NodeAppearanceCalculatorTest.assertTrue((boolean)nodeAppearance2.getFont().equals(font));
        nodeAppearanceCalculator.setNodeSizeLocked(true);
        nodeAppearanceCalculator.calculateNodeAppearance(nodeAppearance, node, network);
        NodeAppearanceCalculatorTest.assertTrue((nodeAppearance.getWidth() == d2 ? 1 : 0) != 0);
        nodeAppearanceCalculator.calculateNodeAppearance(nodeAppearance2, node2, network2);
        NodeAppearanceCalculatorTest.assertTrue((nodeAppearance2.getWidth() == d2 ? 1 : 0) != 0);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(NodeAppearanceCalculatorTest.class));
    }
}

