/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.dialogs.GridBagGroup;
import cytoscape.dialogs.MiscGB;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.ui.DefaultPanel;
import cytoscape.visual.ui.VizMapAttrTab;
import cytoscape.visual.ui.VizMapFontTab;
import cytoscape.visual.ui.VizMapSizeTab;
import cytoscape.visual.ui.VizMapTab;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;

public class VizMapUI
extends JDialog {
    public static final byte NODE_COLOR = 0;
    public static final byte NODE_BORDER_COLOR = 1;
    public static final byte NODE_LINETYPE = 2;
    public static final byte NODE_SHAPE = 3;
    public static final byte NODE_SIZE = 4;
    public static final byte NODE_LABEL = 5;
    public static final byte NODE_LABEL_FONT = 6;
    public static final byte EDGE_COLOR = 7;
    public static final byte EDGE_LINETYPE = 8;
    public static final byte EDGE_SRCARROW = 9;
    public static final byte EDGE_TGTARROW = 10;
    public static final byte EDGE_LABEL = 11;
    public static final byte EDGE_LABEL_FONT = 12;
    public static final byte NODE_TOOLTIP = 13;
    public static final byte EDGE_TOOLTIP = 14;
    public static final byte NODE_FONT_FACE = 122;
    public static final byte NODE_FONT_SIZE = 123;
    public static final byte EDGE_FONT_FACE = 124;
    public static final byte EDGE_FONT_SIZE = 125;
    public static final byte NODE_HEIGHT = 126;
    public static final byte NODE_WIDTH = 127;
    protected VisualMappingManager VMM;
    private JPanel mainPane;
    private GridBagGroup mainGBG;
    private JPanel actionButtonsPanel;
    private JPanel attrSelectorPanel;
    private JPanel tabPaneContainer;
    private VizMapTab[] tabs;
    protected Collection styles;
    protected StyleSelector styleSelector;
    private boolean initialized = false;

    public VizMapUI(VisualMappingManager visualMappingManager) {
        super((Frame)visualMappingManager.getCytoscapeWindow().getMainFrame(), "Set Visual Properties");
        Serializable serializable;
        byte by;
        this.VMM = visualMappingManager;
        this.mainGBG = new GridBagGroup();
        this.mainPane = this.mainGBG.panel;
        this.tabs = new VizMapTab[13];
        this.tabPaneContainer = new JPanel(false);
        JTabbedPane jTabbedPane = new JTabbedPane();
        JTabbedPane jTabbedPane2 = new JTabbedPane();
        for (by = 0; by <= 6; by = (byte)(by + 1)) {
            serializable = by == 4 ? new VizMapSizeTab(this, jTabbedPane, by, visualMappingManager, by) : (by == 6 ? new VizMapFontTab(this, jTabbedPane, by, visualMappingManager, by) : new VizMapAttrTab(this, jTabbedPane, by, visualMappingManager, by));
            jTabbedPane.add((Component)serializable, by);
            this.tabs[by] = serializable;
        }
        for (by = 7; by <= 12; by = (byte)(by + 1)) {
            serializable = by == 12 ? new VizMapFontTab(this, jTabbedPane2, by - 7, visualMappingManager, by) : new VizMapAttrTab(this, jTabbedPane2, by - 7, visualMappingManager, by);
            jTabbedPane2.add((Component)serializable, by - 7);
            this.tabs[by] = serializable;
        }
        DefaultPanel defaultPanel = new DefaultPanel(this, visualMappingManager);
        serializable = new ButtonGroup();
        JToggleButton jToggleButton = new JToggleButton("Node Attributes", true);
        JToggleButton jToggleButton2 = new JToggleButton("Edge Attributes", false);
        JToggleButton jToggleButton3 = new JToggleButton("Global Defaults", false);
        ((ButtonGroup)serializable).add(jToggleButton3);
        ((ButtonGroup)serializable).add(jToggleButton);
        ((ButtonGroup)serializable).add(jToggleButton2);
        Color color = new Color(130, 150, 129);
        Color color2 = new Color(124, 134, 173);
        Color color3 = new Color(201, 201, 15);
        jToggleButton.addActionListener(new AttrSelector(jTabbedPane, color));
        jToggleButton2.addActionListener(new AttrSelector(jTabbedPane2, color2));
        jToggleButton3.addActionListener(new AttrSelector(defaultPanel, color3));
        this.attrSelectorPanel = new JPanel(new FlowLayout(), false);
        this.attrSelectorPanel.add(jToggleButton);
        this.attrSelectorPanel.add(jToggleButton2);
        this.attrSelectorPanel.add(jToggleButton3);
        this.styleSelector = new StyleSelector(this);
        MiscGB.insert(this.mainGBG, this.attrSelectorPanel, 0, 0, 1, 1, 1, 0, 2);
        MiscGB.insert(this.mainGBG, this.tabPaneContainer, 0, 1, 1, 1, 1, 1, 1);
        this.actionButtonsPanel = new JPanel();
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new CloseAction());
        this.actionButtonsPanel.add(jButton);
        MiscGB.insert(this.mainGBG, this.actionButtonsPanel, 0, 3, 1, 1, 1, 0, 2);
        this.setContentPane(this.mainPane);
        this.pack();
        jToggleButton.doClick();
        this.initialized = true;
    }

    public StyleSelector getStyleSelector() {
        return this.styleSelector;
    }

    public void refreshUI() {
        for (int i = 0; i < this.tabs.length; ++i) {
            this.tabs[i].refreshUI();
        }
        this.validate();
        this.repaint();
    }

    public void visualStyleChanged() {
        for (int i = 0; i < this.tabs.length; ++i) {
            this.tabs[i].visualStyleChanged();
        }
        this.validate();
        this.pack();
        this.repaint();
    }

    VizMapTab checkCalcSelected(Calculator calculator) {
        if (!this.initialized) {
            return null;
        }
        VizMapTab vizMapTab = null;
        for (int i = 0; i < this.tabs.length && vizMapTab == null; ++i) {
            VizMapTab vizMapTab2 = this.tabs[i];
            vizMapTab = vizMapTab2.checkCalcSelected(calculator);
        }
        return vizMapTab;
    }

    public Vector checkCalculatorUsage(Calculator calculator) {
        Vector<Vector> vector = new Vector<Vector>();
        Iterator iterator = this.styles.iterator();
        while (iterator.hasNext()) {
            VisualStyle visualStyle = (VisualStyle)iterator.next();
            Vector vector2 = visualStyle.checkConflictingCalculator(calculator);
            if (vector2.size() == 1) continue;
            vector.add(vector2);
        }
        return vector;
    }

    private class CloseAction
    extends AbstractAction {
        private CloseAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VizMapUI.this.dispose();
        }
    }

    private class ApplyAction
    extends AbstractAction {
        private ApplyAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VizMapUI.this.VMM.getCytoscapeWindow().redrawGraph();
        }
    }

    private class AttrSelector
    implements ActionListener {
        private JComponent myTab;
        private Color bgColor;

        private AttrSelector(JComponent jComponent, Color color) {
            this.myTab = jComponent;
            this.bgColor = color;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VizMapUI.this.tabPaneContainer.removeAll();
            VizMapUI.this.tabPaneContainer.add(this.myTab);
            VizMapUI.this.tabPaneContainer.setBackground(this.bgColor);
            VizMapUI.this.actionButtonsPanel.setBackground(this.bgColor);
            VizMapUI.this.attrSelectorPanel.setBackground(this.bgColor);
            VizMapUI.this.pack();
            VizMapUI.this.repaint();
        }
    }

    public class StyleSelector
    extends JDialog {
        protected CalculatorCatalog catalog;
        protected DefaultComboBoxModel styleComboModel;
        protected JComboBox styleComboBox;
        protected JComboBox styleComboBoxDupe;
        protected GridBagGroup styleGBG;
        protected VisualStyle currentStyle;
        protected VizMapUI styleDefUI;
        protected StyleSelector myself;
        protected boolean styleDefNeedsUpdate;

        protected StyleSelector(VizMapUI vizMapUI2) {
            super((Frame)VizMapUI.this.VMM.getCytoscapeWindow().getMainFrame(), "Visual Styles");
            this.styleComboModel = new DefaultComboBoxModel();
            this.styleComboBox = new JComboBox(this.styleComboModel);
            this.styleComboBoxDupe = new JComboBox(this.styleComboModel);
            this.styleDefNeedsUpdate = true;
            this.currentStyle = VizMapUI.this.VMM.getVisualStyle();
            this.styleDefUI = vizMapUI2;
            this.catalog = VizMapUI.this.VMM.getCalculatorCatalog();
            VizMapUI.this.styles = this.catalog.getVisualStyles();
            this.styleGBG = new GridBagGroup("Visual Styles");
            this.myself = this;
            StyleSelectionListener styleSelectionListener = new StyleSelectionListener();
            this.styleComboBox.addItemListener(styleSelectionListener);
            String string = "Change the current visual style";
            this.styleComboBox.setToolTipText(string);
            this.styleComboBoxDupe.setToolTipText(string);
            MiscGB.pad(this.styleGBG.constraints, 2, 2);
            MiscGB.inset(this.styleGBG.constraints, 3);
            this.resetStyles();
            JButton jButton = new JButton("New");
            jButton.addActionListener(new NewStyleListener());
            MiscGB.insert(this.styleGBG, jButton, 0, 1, 1, 1, 1, 0, 2);
            jButton.setToolTipText("Create a new style");
            JButton jButton2 = new JButton("Duplicate");
            jButton2.addActionListener(new DupeStyleListener());
            MiscGB.insert(this.styleGBG, jButton2, 1, 1, 1, 1, 1, 0, 2);
            jButton2.setToolTipText("Duplicate the current style");
            JButton jButton3 = new JButton("Rename");
            jButton3.addActionListener(new RenStyleListener());
            MiscGB.insert(this.styleGBG, jButton3, 2, 1, 1, 1, 1, 0, 2);
            jButton3.setToolTipText("Rename the current style");
            JButton jButton4 = new JButton("Delete");
            jButton4.addActionListener(new RmStyleListener());
            MiscGB.insert(this.styleGBG, jButton4, 3, 1, 1, 1, 1, 0, 2);
            jButton4.setToolTipText("Delete the current style");
            JButton jButton5 = new JButton("Define");
            jButton5.addActionListener(new DefStyleListener());
            MiscGB.insert(this.styleGBG, jButton5, 4, 0, 1, 1, 1, 0, 2);
            jButton5.setToolTipText("Change the current style's settings");
            JButton jButton6 = new JButton("Close");
            jButton6.addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    this.dispose();
                }
            });
            MiscGB.insert(this.styleGBG, jButton6, 4, 1, 1, 1, 1, 0, 2);
            jButton6.setToolTipText("Close this dialog");
            MiscGB.insert(this.styleGBG, this.styleComboBox, 0, 0, 4, 1, 1, 0, 2);
            this.setContentPane(this.styleGBG.panel);
            this.styleGBG.panel.setToolTipText("Visual styles are a collection of attribute mappings.");
            this.pack();
        }

        public String getStyleName(VisualStyle visualStyle) {
            String string;
            String string2;
            int n;
            String string3 = null;
            if (visualStyle != null) {
                string3 = this.catalog.checkVisualStyleName(visualStyle.getName());
            }
            do {
                if ((string2 = (String)JOptionPane.showInputDialog(this.myself, "Name for new visual style", "Visual Style Name Input", 3, null, null, string3)) == null) {
                    return null;
                }
                string = this.catalog.checkVisualStyleName(string2);
                if (!string.equals(string2)) continue;
                return string2;
            } while ((n = JOptionPane.showConfirmDialog(this.myself, "Visual style with name " + string2 + " already exists,\nrename to " + string + " okay?", "Duplicate visual style name", 0, 2, null)) != 0);
            return string;
        }

        public JComboBox getToolbarComboBox() {
            return this.styleComboBoxDupe;
        }

        protected void refreshStyleComboBox() {
            Iterator iterator = VizMapUI.this.styles.iterator();
            VisualStyle visualStyle = this.currentStyle;
            this.styleComboModel.removeAllElements();
            int n = 0;
            while (iterator.hasNext()) {
                this.styleComboModel.addElement(iterator.next());
                ++n;
            }
            this.styleComboModel.setSelectedItem(null);
            if (visualStyle == null) {
                visualStyle = (VisualStyle)this.styleComboModel.getElementAt(0);
            }
            this.styleComboModel.setSelectedItem(visualStyle);
        }

        public void resetStyles() {
            VizMapUI.this.styles = this.catalog.getVisualStyles();
            this.refreshStyleComboBox();
        }

        public boolean setVisualStyle(VisualStyle visualStyle) {
            if (this.styleComboModel.getIndexOf(visualStyle) != -1) {
                this.currentStyle = visualStyle;
                this.styleComboModel.setSelectedItem(visualStyle);
                return true;
            }
            return false;
        }

        protected class StyleSelectionListener
        implements ItemListener {
            protected StyleSelectionListener() {
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                VisualStyle visualStyle;
                if (itemEvent.getStateChange() == 1 && (visualStyle = (VisualStyle)((JComboBox)itemEvent.getSource()).getSelectedItem()) != StyleSelector.this.currentStyle && visualStyle != null) {
                    StyleSelector.this.currentStyle = visualStyle;
                    ((StyleSelector)StyleSelector.this).VizMapUI.this.VMM.setVisualStyle(StyleSelector.this.currentStyle);
                    ((StyleSelector)StyleSelector.this).VizMapUI.this.VMM.getCytoscapeWindow().redrawGraph();
                    if (StyleSelector.this.styleDefUI.isShowing()) {
                        VizMapUI.this.visualStyleChanged();
                    } else {
                        StyleSelector.this.styleDefNeedsUpdate = true;
                    }
                }
            }
        }

        protected class DupeStyleListener
        extends AbstractAction {
            protected DupeStyleListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                VisualStyle visualStyle = null;
                try {
                    visualStyle = (VisualStyle)StyleSelector.this.currentStyle.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    System.err.println("Clone not supported exception!");
                }
                String string = StyleSelector.this.getStyleName(visualStyle);
                if (string == null) {
                    return;
                }
                visualStyle.setName(string);
                StyleSelector.this.catalog.addVisualStyle(visualStyle);
                StyleSelector.this.currentStyle = visualStyle;
                ((StyleSelector)StyleSelector.this).VizMapUI.this.VMM.setVisualStyle(StyleSelector.this.currentStyle);
                StyleSelector.this.resetStyles();
            }
        }

        protected class RmStyleListener
        extends AbstractAction {
            protected RmStyleListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (((StyleSelector)StyleSelector.this).VizMapUI.this.styles.size() == 1) {
                    JOptionPane.showMessageDialog(StyleSelector.this.myself, "There must be at least one visual style", "Cannot remove style", 0);
                    return;
                }
                String string = StyleSelector.this.currentStyle.getName();
                String string2 = "Are you sure you want to permanently delete the visual style named '" + string + "'?";
                int n = JOptionPane.showConfirmDialog(StyleSelector.this.myself, string2, "Confirm Delete Style", 0);
                if (n == 0) {
                    StyleSelector.this.catalog.removeVisualStyle(StyleSelector.this.currentStyle.getName());
                    StyleSelector.this.currentStyle = (VisualStyle)((StyleSelector)StyleSelector.this).VizMapUI.this.styles.iterator().next();
                    ((StyleSelector)StyleSelector.this).VizMapUI.this.VMM.setVisualStyle(StyleSelector.this.currentStyle);
                    StyleSelector.this.resetStyles();
                }
            }
        }

        protected class RenStyleListener
        extends AbstractAction {
            protected RenStyleListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = StyleSelector.this.getStyleName(StyleSelector.this.currentStyle);
                if (string == null) {
                    return;
                }
                StyleSelector.this.currentStyle.setName(string);
                StyleSelector.this.resetStyles();
            }
        }

        protected class NewStyleListener
        extends AbstractAction {
            protected NewStyleListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = StyleSelector.this.getStyleName(null);
                if (string == null) {
                    return;
                }
                StyleSelector.this.currentStyle = new VisualStyle(string);
                StyleSelector.this.catalog.addVisualStyle(StyleSelector.this.currentStyle);
                ((StyleSelector)StyleSelector.this).VizMapUI.this.VMM.setVisualStyle(StyleSelector.this.currentStyle);
                StyleSelector.this.resetStyles();
            }
        }

        protected class DefStyleListener
        extends AbstractAction {
            protected DefStyleListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (StyleSelector.this.styleDefNeedsUpdate) {
                    StyleSelector.this.styleDefUI.visualStyleChanged();
                    StyleSelector.this.styleDefNeedsUpdate = false;
                }
                StyleSelector.this.styleDefUI.show();
            }
        }
    }
}

