/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.NodeSizeCalculator;
import cytoscape.visual.ui.VizMapAttrTab;
import cytoscape.visual.ui.VizMapTab;
import cytoscape.visual.ui.VizMapUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class VizMapSizeTab
extends VizMapTab {
    private JPanel hwPanel;
    private JPanel lockPanel;
    private JPanel mainPanel;
    private VizMapAttrTab height;
    private VizMapAttrTab width;
    private VizMapAttrTab size;
    private VisualMappingManager VMM;
    private NodeAppearanceCalculator nodeCalc;
    private VizMapUI mainUIDialog;
    private boolean locked;
    JCheckBox lockBox;

    public VizMapSizeTab(VizMapUI vizMapUI, JTabbedPane jTabbedPane, int n, VisualMappingManager visualMappingManager, byte by) throws IllegalArgumentException {
        this(vizMapUI, jTabbedPane, n, visualMappingManager, by, visualMappingManager.getVisualStyle().getNodeAppearanceCalculator().getNodeSizeLocked());
    }

    public VizMapSizeTab(VizMapUI vizMapUI, JTabbedPane jTabbedPane, int n, VisualMappingManager visualMappingManager, byte by, boolean bl) throws IllegalArgumentException {
        super(new BorderLayout(), false);
        if (by != 4) {
            throw new IllegalArgumentException("You can only create a VizMapSizeTab for the Node Size attribute");
        }
        this.setName("Node Size");
        this.VMM = visualMappingManager;
        this.nodeCalc = visualMappingManager.getVisualStyle().getNodeAppearanceCalculator();
        this.mainUIDialog = vizMapUI;
        this.locked = bl;
        JPanel jPanel = new JPanel(false);
        this.lockBox = new JCheckBox("Lock height/width calculators");
        this.lockBox.setSelected(bl);
        this.lockBox.addItemListener(new LockCalcListener());
        jPanel.add(this.lockBox);
        this.hwPanel = new JPanel(false);
        this.hwPanel.setLayout(new BoxLayout(this.hwPanel, 1));
        this.lockPanel = new JPanel(false);
        this.height = new VizMapAttrTab(vizMapUI, jTabbedPane, n, visualMappingManager, 126);
        this.width = new VizMapAttrTab(vizMapUI, jTabbedPane, n, visualMappingManager, 127);
        this.size = new VizMapAttrTab(vizMapUI, jTabbedPane, n, visualMappingManager, 126);
        this.width.setBorder(BorderFactory.createTitledBorder(this.width.getName()));
        this.height.setBorder(BorderFactory.createTitledBorder(this.height.getName()));
        this.hwPanel.add(this.height);
        this.hwPanel.add(this.width);
        this.lockPanel.add(this.size);
        this.mainPanel = new JPanel(false);
        if (this.locked) {
            this.mainPanel.add(this.lockPanel);
        } else {
            this.mainPanel.add(this.hwPanel);
        }
        this.nodeCalc.setNodeSizeLocked(this.locked);
        this.add((Component)jPanel, "North");
        this.add((Component)this.mainPanel, "Center");
    }

    public void refreshUI() {
        this.height.refreshUI();
        this.width.refreshUI();
        this.size.refreshUI();
    }

    public void visualStyleChanged() {
        this.nodeCalc = this.VMM.getVisualStyle().getNodeAppearanceCalculator();
        this.height.visualStyleChanged();
        this.width.visualStyleChanged();
        this.size.visualStyleChanged();
        this.locked = this.nodeCalc.getNodeSizeLocked();
        if (this.lockBox.isSelected() != this.locked) {
            this.lockBox.setSelected(this.locked);
        }
    }

    VizMapTab checkCalcSelected(Calculator calculator) {
        if (this.locked) {
            return this.size.checkCalcSelected(calculator);
        }
        VizMapTab vizMapTab = this.height.checkCalcSelected(calculator);
        if (vizMapTab == null) {
            return this.width.checkCalcSelected(calculator);
        }
        return vizMapTab;
    }

    private class LockCalcListener
    implements ItemListener {
        private NodeSizeCalculator widthCalc;
        private NodeSizeCalculator heightCalc;
        private NodeSizeCalculator lockCalc;

        private LockCalcListener() {
            this.widthCalc = VizMapSizeTab.this.nodeCalc.getNodeWidthCalculator();
            this.heightCalc = VizMapSizeTab.this.nodeCalc.getNodeHeightCalculator();
            this.lockCalc = VizMapSizeTab.this.nodeCalc.getNodeHeightCalculator();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                VizMapSizeTab.this.mainPanel.removeAll();
                VizMapSizeTab.this.mainPanel.add(VizMapSizeTab.this.lockPanel);
                VizMapSizeTab.this.locked = true;
                VizMapSizeTab.this.nodeCalc.setNodeSizeLocked(true);
                this.widthCalc = VizMapSizeTab.this.nodeCalc.getNodeWidthCalculator();
                VizMapSizeTab.this.width.setComboBox(null);
                this.heightCalc = VizMapSizeTab.this.nodeCalc.getNodeHeightCalculator();
                VizMapSizeTab.this.height.setComboBox(null);
                VizMapSizeTab.this.size.setComboBox(this.lockCalc);
            } else {
                VizMapSizeTab.this.mainPanel.removeAll();
                VizMapSizeTab.this.mainPanel.add(VizMapSizeTab.this.hwPanel);
                VizMapSizeTab.this.locked = false;
                VizMapSizeTab.this.nodeCalc.setNodeSizeLocked(false);
                this.lockCalc = VizMapSizeTab.this.nodeCalc.getNodeHeightCalculator();
                VizMapSizeTab.this.size.setComboBox(null);
                VizMapSizeTab.this.height.setComboBox(this.heightCalc);
                VizMapSizeTab.this.width.setComboBox(this.widthCalc);
            }
            VizMapSizeTab.this.validate();
        }
    }
}

