/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.dialogs.GridBagGroup;
import cytoscape.dialogs.MiscGB;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.Network;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.calculators.AbstractCalculator;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.EdgeArrowCalculator;
import cytoscape.visual.calculators.EdgeColorCalculator;
import cytoscape.visual.calculators.EdgeFontFaceCalculator;
import cytoscape.visual.calculators.EdgeFontSizeCalculator;
import cytoscape.visual.calculators.EdgeLabelCalculator;
import cytoscape.visual.calculators.EdgeLineTypeCalculator;
import cytoscape.visual.calculators.EdgeToolTipCalculator;
import cytoscape.visual.calculators.GenericEdgeArrowCalculator;
import cytoscape.visual.calculators.GenericEdgeColorCalculator;
import cytoscape.visual.calculators.GenericEdgeFontFaceCalculator;
import cytoscape.visual.calculators.GenericEdgeFontSizeCalculator;
import cytoscape.visual.calculators.GenericEdgeLabelCalculator;
import cytoscape.visual.calculators.GenericEdgeLineTypeCalculator;
import cytoscape.visual.calculators.GenericEdgeToolTipCalculator;
import cytoscape.visual.calculators.GenericNodeColorCalculator;
import cytoscape.visual.calculators.GenericNodeFontFaceCalculator;
import cytoscape.visual.calculators.GenericNodeFontSizeCalculator;
import cytoscape.visual.calculators.GenericNodeLabelCalculator;
import cytoscape.visual.calculators.GenericNodeLineTypeCalculator;
import cytoscape.visual.calculators.GenericNodeShapeCalculator;
import cytoscape.visual.calculators.GenericNodeSizeCalculator;
import cytoscape.visual.calculators.GenericNodeToolTipCalculator;
import cytoscape.visual.calculators.NodeColorCalculator;
import cytoscape.visual.calculators.NodeFontFaceCalculator;
import cytoscape.visual.calculators.NodeFontSizeCalculator;
import cytoscape.visual.calculators.NodeLabelCalculator;
import cytoscape.visual.calculators.NodeLineTypeCalculator;
import cytoscape.visual.calculators.NodeShapeCalculator;
import cytoscape.visual.calculators.NodeSizeCalculator;
import cytoscape.visual.calculators.NodeToolTipCalculator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.ui.ValueDisplayer;
import cytoscape.visual.ui.VizMapTab;
import cytoscape.visual.ui.VizMapUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import y.view.Arrow;
import y.view.LineType;

public class VizMapAttrTab
extends VizMapTab {
    private Collection calculators;
    private CalculatorCatalog catalog;
    private Calculator currentCalculator;
    private Object defaultObj;
    private Network n;
    private JPanel calcPanel;
    private VizMapUI mainUIDialog;
    protected JTabbedPane tabbedContainer;
    private byte type;
    private VisualMappingManager VMM;
    private NodeAppearanceCalculator nodeCalc;
    private EdgeAppearanceCalculator edgeCalc;
    private ValueDisplayer defaultValueDisplayer;
    private JComboBox calcComboBox;
    private GridBagGroup mapPanelGBG;
    private JPanel calcContainer;
    private ImageIcon imageIcon;
    protected CalculatorUIListener calcListener = new CalculatorUIListener();
    static /* synthetic */ Class class$java$lang$Object;

    public VizMapAttrTab(VizMapUI vizMapUI, JTabbedPane jTabbedPane, int n, VisualMappingManager visualMappingManager, byte by) {
        super(new BorderLayout(), false);
        this.setName(VizMapAttrTab.getTypeName(by));
        this.VMM = visualMappingManager;
        this.mainUIDialog = vizMapUI;
        this.catalog = visualMappingManager.getCalculatorCatalog();
        this.n = visualMappingManager.getNetwork();
        this.type = by;
        this.catalog.addChangeListener(new CatalogListener(), this.type);
        jTabbedPane.addChangeListener(new TabContainerListener(n));
    }

    public void visualStyleChanged() {
        this.nodeCalc = this.VMM.getVisualStyle().getNodeAppearanceCalculator();
        this.edgeCalc = this.VMM.getVisualStyle().getEdgeAppearanceCalculator();
        this.getDefaults(this.type);
        if (this.defaultValueDisplayer == null) {
            this.drawDefault();
            this.drawCalc();
        } else {
            this.setDefault(this.defaultObj);
            this.refreshUI();
        }
    }

    private void setupCalcComboBox() {
        Object[] objectArray = new Object[this.calculators.size() + 1];
        objectArray[0] = new String("None");
        Iterator iterator = this.calculators.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            objectArray[n] = iterator.next();
            ++n;
        }
        this.calcComboBox = new JComboBox<Object>(objectArray);
        this.calcComboBox.setSelectedItem(null);
        this.calcComboBox.addItemListener(new calcComboSelectionListener());
        if (!this.calculators.contains(this.currentCalculator)) {
            this.currentCalculator = null;
        }
        if (this.currentCalculator == null) {
            this.calcComboBox.setSelectedIndex(0);
        } else {
            this.calcComboBox.setSelectedItem(this.currentCalculator);
        }
    }

    public void resetCalculatorDisplay() {
        this.refreshCalculators();
        if (this.calcComboBox != null) {
            this.mapPanelGBG.panel.remove(this.calcComboBox);
        }
        this.setupCalcComboBox();
        MiscGB.insert(this.mapPanelGBG, this.calcComboBox, 0, 0, 4, 1, 1, 0, 2);
    }

    protected void drawCalc() {
        this.mapPanelGBG = new GridBagGroup("Mapping");
        MiscGB.pad(this.mapPanelGBG.constraints, 2, 2);
        MiscGB.inset(this.mapPanelGBG.constraints, 3);
        this.calcContainer = new JPanel(false);
        this.resetCalculatorDisplay();
        JButton jButton = new JButton("New");
        jButton.addActionListener(new NewCalcListener());
        MiscGB.insert(this.mapPanelGBG, jButton, 0, 1, 1, 1, 1, 0, 2);
        JButton jButton2 = new JButton("Duplicate");
        jButton2.addActionListener(new DupeCalcListener());
        MiscGB.insert(this.mapPanelGBG, jButton2, 1, 1, 1, 1, 1, 0, 2);
        JButton jButton3 = new JButton("Rename");
        jButton3.addActionListener(new RenCalcListener());
        MiscGB.insert(this.mapPanelGBG, jButton3, 2, 1, 1, 1, 1, 0, 2);
        JButton jButton4 = new JButton("Delete");
        jButton4.addActionListener(new RmCalcListener());
        MiscGB.insert(this.mapPanelGBG, jButton4, 3, 1, 1, 1, 1, 0, 2);
        MiscGB.insert(this.mapPanelGBG, this.calcContainer, 0, 2, 4, 1, 5, 5, 1);
        this.add((Component)this.mapPanelGBG.panel, "Center");
    }

    private Calculator duplicateCalculator(Calculator calculator) {
        Calculator calculator2 = null;
        try {
            calculator2 = (Calculator)calculator.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Fatal error - Calculator didn't support Cloneable");
            cloneNotSupportedException.printStackTrace();
            return null;
        }
        String string = this.getCalculatorName(calculator2);
        if (string == null) {
            return null;
        }
        calculator2.setName(string);
        return calculator2;
    }

    private String getCalculatorName(Calculator calculator) {
        String string;
        String string2;
        int n;
        String string3 = null;
        if (calculator != null) {
            string3 = this.catalog.checkCalculatorName(((Object)calculator).toString(), this.type);
        }
        do {
            if ((string2 = (String)JOptionPane.showInputDialog(this.mainUIDialog, "New name for calculator", "Calculator Name Input", 3, null, null, string3)) == null) {
                return null;
            }
            string = this.catalog.checkCalculatorName(string2, this.type);
            if (!string.equals(string2)) continue;
            return string2;
        } while ((n = JOptionPane.showConfirmDialog(this.mainUIDialog, "Calculator with name " + string2 + " already exists,\nrename to " + string + " okay?", "Duplicate calculator name", 0, 2, null)) != 0);
        return string;
    }

    VizMapTab checkCalcSelected(Calculator calculator) {
        if (this.currentCalculator == calculator) {
            return this;
        }
        return null;
    }

    void setComboBox(Calculator calculator) {
        if (calculator == null) {
            this.calcComboBox.setSelectedIndex(0);
        } else {
            this.calcComboBox.setSelectedItem(calculator);
        }
    }

    public void refreshUI() {
        if (this.calcPanel != null) {
            this.calcContainer.remove(this.calcPanel);
        }
        if (this.currentCalculator != null) {
            this.calcPanel = this.currentCalculator.getUI(this.mainUIDialog, this.n);
            this.calcContainer.add(this.calcPanel);
        } else {
            this.calcPanel = null;
        }
        this.validate();
        this.repaint();
    }

    void switchCalculator(Calculator calculator) {
        String string;
        if (calculator != null && (string = this.catalog.checkCalculatorName(((Object)calculator).toString(), this.type)).equals(((Object)calculator).toString())) {
            calculator = null;
            this.setComboBox(null);
        }
        if (this.currentCalculator != null) {
            this.currentCalculator.removeChangeListener(this.calcListener);
        }
        this.currentCalculator = calculator;
        if (this.currentCalculator != null) {
            this.currentCalculator.addChangeListener(this.calcListener);
        }
        switch (this.type) {
            case 0: {
                this.nodeCalc.setNodeFillColorCalculator((NodeColorCalculator)calculator);
                break;
            }
            case 1: {
                this.nodeCalc.setNodeBorderColorCalculator((NodeColorCalculator)calculator);
                break;
            }
            case 2: {
                this.nodeCalc.setNodeLineTypeCalculator((NodeLineTypeCalculator)calculator);
                break;
            }
            case 3: {
                this.nodeCalc.setNodeShapeCalculator((NodeShapeCalculator)calculator);
                break;
            }
            case 5: {
                this.nodeCalc.setNodeLabelCalculator((NodeLabelCalculator)calculator);
                break;
            }
            case 126: {
                this.nodeCalc.setNodeHeightCalculator((NodeSizeCalculator)calculator);
                break;
            }
            case 127: {
                this.nodeCalc.setNodeWidthCalculator((NodeSizeCalculator)calculator);
                break;
            }
            case 4: {
                this.nodeCalc.setNodeWidthCalculator((NodeSizeCalculator)calculator);
                this.nodeCalc.setNodeHeightCalculator((NodeSizeCalculator)calculator);
                break;
            }
            case 13: {
                this.nodeCalc.setNodeToolTipCalculator((NodeToolTipCalculator)calculator);
                break;
            }
            case 7: {
                this.edgeCalc.setEdgeColorCalculator((EdgeColorCalculator)calculator);
                break;
            }
            case 8: {
                this.edgeCalc.setEdgeLineTypeCalculator((EdgeLineTypeCalculator)calculator);
                break;
            }
            case 9: {
                this.edgeCalc.setEdgeSourceArrowCalculator((EdgeArrowCalculator)calculator);
                break;
            }
            case 10: {
                this.edgeCalc.setEdgeTargetArrowCalculator((EdgeArrowCalculator)calculator);
                break;
            }
            case 11: {
                this.edgeCalc.setEdgeLabelCalculator((EdgeLabelCalculator)calculator);
                break;
            }
            case 14: {
                this.edgeCalc.setEdgeToolTipCalculator((EdgeToolTipCalculator)calculator);
                break;
            }
            case 124: {
                this.edgeCalc.setEdgeFontFaceCalculator((EdgeFontFaceCalculator)calculator);
                break;
            }
            case 125: {
                this.edgeCalc.setEdgeFontSizeCalculator((EdgeFontSizeCalculator)calculator);
                break;
            }
            case 122: {
                this.nodeCalc.setNodeFontFaceCalculator((NodeFontFaceCalculator)calculator);
                break;
            }
            case 123: {
                this.nodeCalc.setNodeFontSizeCalculator((NodeFontSizeCalculator)calculator);
            }
        }
        this.refreshUI();
        this.VMM.getCytoscapeWindow().redrawGraph();
    }

    public void setDefault(Object object) {
        this.defaultValueDisplayer.setObject(object);
    }

    protected void _setDefault(Object object) {
        switch (this.type) {
            case 0: {
                this.nodeCalc.setDefaultNodeFillColor((Color)object);
                break;
            }
            case 1: {
                this.nodeCalc.setDefaultNodeBorderColor((Color)object);
                break;
            }
            case 2: {
                this.nodeCalc.setDefaultNodeLineType((LineType)object);
                break;
            }
            case 3: {
                this.nodeCalc.setDefaultNodeShape((Byte)object);
                break;
            }
            case 126: {
                this.nodeCalc.setDefaultNodeHeight((Double)object);
                break;
            }
            case 127: {
                this.nodeCalc.setDefaultNodeWidth((Double)object);
                break;
            }
            case 4: {
                this.nodeCalc.setDefaultNodeHeight((Double)object);
                this.nodeCalc.setDefaultNodeWidth((Double)object);
                break;
            }
            case 5: {
                this.nodeCalc.setDefaultNodeLabel((String)object);
                break;
            }
            case 13: {
                this.nodeCalc.setDefaultNodeToolTip((String)object);
                break;
            }
            case 7: {
                this.edgeCalc.setDefaultEdgeColor((Color)object);
                break;
            }
            case 8: {
                this.edgeCalc.setDefaultEdgeLineType((LineType)object);
                break;
            }
            case 9: {
                this.edgeCalc.setDefaultEdgeSourceArrow((Arrow)object);
                break;
            }
            case 10: {
                this.edgeCalc.setDefaultEdgeTargetArrow((Arrow)object);
                break;
            }
            case 11: {
                this.edgeCalc.setDefaultEdgeLabel((String)object);
                break;
            }
            case 14: {
                this.edgeCalc.setDefaultEdgeToolTip((String)object);
                break;
            }
            case 124: {
                this.edgeCalc.setDefaultEdgeFontFace((Font)object);
                break;
            }
            case 125: {
                this.edgeCalc.setDefaultEdgeFontSize(((Double)object).floatValue());
                break;
            }
            case 122: {
                this.nodeCalc.setDefaultNodeFontFace((Font)object);
                break;
            }
            case 123: {
                this.nodeCalc.setDefaultNodeFontSize(((Double)object).floatValue());
            }
        }
        this.VMM.getCytoscapeWindow().redrawGraph();
    }

    protected void setImageIcon() {
        this.imageIcon = null;
        switch (this.type) {
            case 0: {
                this.imageIcon = new ImageIcon(this.getClass().getResource("images/nodeColorWheel.jpg"), "Node Color");
                break;
            }
            case 1: {
                this.imageIcon = new ImageIcon(this.getClass().getResource("images/nodeBorderColorWheel.jpg"), "Node Color");
            }
        }
    }

    protected void drawDefault() {
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JPanel jPanel2 = new JPanel(false);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        Box box = new Box(0);
        this.defaultValueDisplayer = ValueDisplayer.getDisplayFor(this.mainUIDialog, this.getName(), this.defaultObj);
        this.defaultValueDisplayer.addItemListener(new DefaultItemChangedListener());
        JButton jButton = new JButton("Change Default");
        jButton.addActionListener(this.defaultValueDisplayer.getInputListener());
        box.add(Box.createHorizontalGlue());
        box.add(jButton);
        box.add(Box.createHorizontalStrut(3));
        box.add(this.defaultValueDisplayer);
        box.add(Box.createHorizontalGlue());
        jPanel2.add(Box.createVerticalStrut(3));
        jPanel2.add(box);
        jPanel2.add(Box.createVerticalStrut(3));
        Border border = BorderFactory.createLineBorder(Color.BLACK);
        jPanel2.setBorder(BorderFactory.createTitledBorder(border, "Default", 2, 2));
        jPanel2.validate();
        this.setImageIcon();
        if (this.imageIcon == null) {
            this.add((Component)jPanel2, "North");
        } else {
            JButton jButton2 = new JButton();
            jButton2.setIcon(this.imageIcon);
            jPanel.add(jButton2);
            jPanel.add(jPanel2);
            this.add((Component)jPanel, "North");
        }
    }

    public void refreshCalculators() {
        this.calculators = this.getCalculators(this.type);
    }

    protected void getDefaults(byte by) {
        switch (by) {
            case 0: {
                this.defaultObj = this.nodeCalc.getDefaultNodeFillColor();
                this.currentCalculator = this.nodeCalc.getNodeFillColorCalculator();
                break;
            }
            case 1: {
                this.defaultObj = this.nodeCalc.getDefaultNodeBorderColor();
                this.currentCalculator = this.nodeCalc.getNodeBorderColorCalculator();
                break;
            }
            case 2: {
                this.defaultObj = this.nodeCalc.getDefaultNodeLineType();
                this.currentCalculator = this.nodeCalc.getNodeLineTypeCalculator();
                break;
            }
            case 3: {
                this.defaultObj = new Byte(this.nodeCalc.getDefaultNodeShape());
                this.currentCalculator = this.nodeCalc.getNodeShapeCalculator();
                break;
            }
            case 126: {
                this.defaultObj = new Double(this.nodeCalc.getDefaultNodeHeight());
                this.currentCalculator = this.nodeCalc.getNodeHeightCalculator();
                break;
            }
            case 127: {
                this.defaultObj = new Double(this.nodeCalc.getDefaultNodeWidth());
                this.currentCalculator = this.nodeCalc.getNodeWidthCalculator();
                break;
            }
            case 4: {
                this.defaultObj = new Double(this.nodeCalc.getDefaultNodeHeight());
                this.currentCalculator = this.nodeCalc.getNodeHeightCalculator();
                break;
            }
            case 5: {
                this.defaultObj = this.nodeCalc.getDefaultNodeLabel();
                this.currentCalculator = this.nodeCalc.getNodeLabelCalculator();
                break;
            }
            case 13: {
                this.defaultObj = this.nodeCalc.getDefaultNodeToolTip();
                this.currentCalculator = this.nodeCalc.getNodeToolTipCalculator();
                break;
            }
            case 7: {
                this.defaultObj = this.edgeCalc.getDefaultEdgeColor();
                this.currentCalculator = this.edgeCalc.getEdgeColorCalculator();
                break;
            }
            case 8: {
                this.defaultObj = this.edgeCalc.getDefaultEdgeLineType();
                this.currentCalculator = this.edgeCalc.getEdgeLineTypeCalculator();
                break;
            }
            case 9: {
                this.defaultObj = this.edgeCalc.getDefaultEdgeSourceArrow();
                this.currentCalculator = this.edgeCalc.getEdgeSourceArrowCalculator();
                break;
            }
            case 10: {
                this.defaultObj = this.edgeCalc.getDefaultEdgeTargetArrow();
                this.currentCalculator = this.edgeCalc.getEdgeTargetArrowCalculator();
                break;
            }
            case 11: {
                this.defaultObj = this.edgeCalc.getDefaultEdgeLabel();
                this.currentCalculator = this.edgeCalc.getEdgeLabelCalculator();
                break;
            }
            case 14: {
                this.defaultObj = this.edgeCalc.getDefaultEdgeToolTip();
                this.currentCalculator = this.edgeCalc.getEdgeToolTipCalculator();
                break;
            }
            case 122: {
                this.defaultObj = this.n.getGraph().getDefaultNodeRealizer().getLabel().getFont();
                this._setDefault(this.defaultObj);
                this.currentCalculator = this.nodeCalc.getNodeFontFaceCalculator();
                break;
            }
            case 124: {
                this.defaultObj = this.n.getGraph().getDefaultEdgeRealizer().getLabel().getFont();
                this._setDefault(this.defaultObj);
                this.currentCalculator = this.edgeCalc.getEdgeFontFaceCalculator();
                break;
            }
            case 123: {
                this.defaultObj = new Double(this.n.getGraph().getDefaultNodeRealizer().getLabel().getFont().getSize2D());
                this._setDefault(this.defaultObj);
                this.currentCalculator = this.nodeCalc.getNodeFontSizeCalculator();
                break;
            }
            case 125: {
                this.defaultObj = new Double(this.n.getGraph().getDefaultEdgeRealizer().getLabel().getFont().getSize2D());
                this._setDefault(this.defaultObj);
                this.currentCalculator = this.edgeCalc.getEdgeFontSizeCalculator();
            }
        }
    }

    private Collection getCalculators(byte by) {
        switch (by) {
            case 0: {
                return this.catalog.getNodeColorCalculators();
            }
            case 1: {
                return this.catalog.getNodeColorCalculators();
            }
            case 2: {
                return this.catalog.getNodeLineTypeCalculators();
            }
            case 3: {
                return this.catalog.getNodeShapeCalculators();
            }
            case 4: 
            case 126: 
            case 127: {
                return this.catalog.getNodeSizeCalculators();
            }
            case 5: {
                return this.catalog.getNodeLabelCalculators();
            }
            case 13: {
                return this.catalog.getNodeToolTipCalculators();
            }
            case 7: {
                return this.catalog.getEdgeColorCalculators();
            }
            case 8: {
                return this.catalog.getEdgeLineTypeCalculators();
            }
            case 9: {
                return this.catalog.getEdgeArrowCalculators();
            }
            case 10: {
                return this.catalog.getEdgeArrowCalculators();
            }
            case 11: {
                return this.catalog.getEdgeLabelCalculators();
            }
            case 14: {
                return this.catalog.getEdgeToolTipCalculators();
            }
            case 124: {
                return this.catalog.getEdgeFontFaceCalculators();
            }
            case 125: {
                return this.catalog.getEdgeFontSizeCalculators();
            }
            case 122: {
                return this.catalog.getNodeFontFaceCalculators();
            }
            case 123: {
                return this.catalog.getNodeFontSizeCalculators();
            }
        }
        System.err.println("WARNING: Couldn't find match for type " + by);
        return null;
    }

    protected static String getTypeName(byte by) {
        switch (by) {
            case 0: {
                return "Node Color";
            }
            case 1: {
                return "Node Border Color";
            }
            case 2: {
                return "Node Border Type";
            }
            case 3: {
                return "Node Shape";
            }
            case 127: {
                return "Node Width";
            }
            case 126: {
                return "Node Height";
            }
            case 4: {
                return "Node Size";
            }
            case 5: {
                return "Node Label";
            }
            case 13: {
                return "Node Tooltip";
            }
            case 7: {
                return "Edge Color";
            }
            case 8: {
                return "Edge Line Type";
            }
            case 9: {
                return "Edge Source Arrow";
            }
            case 10: {
                return "Edge Target Arrow";
            }
            case 11: {
                return "Edge Label";
            }
            case 14: {
                return "Edge Tooltip";
            }
            case 124: {
                return "Edge Font Face";
            }
            case 125: {
                return "Edge Font Size";
            }
            case 122: {
                return "Node Font Face";
            }
            case 6: {
                return "Node Font Size";
            }
        }
        return null;
    }

    private class DefaultItemChangedListener
    implements ItemListener {
        private DefaultItemChangedListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getItemSelectable() == VizMapAttrTab.this.defaultValueDisplayer && itemEvent.getStateChange() == 1) {
                VizMapAttrTab.this._setDefault(VizMapAttrTab.this.defaultValueDisplayer.getValue());
            }
        }
    }

    protected class TabContainerListener
    implements ChangeListener {
        protected int tabIndex;

        public TabContainerListener(int n) {
            this.tabIndex = n;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            if (jTabbedPane.getModel().getSelectedIndex() == this.tabIndex) {
                VizMapAttrTab.this.refreshUI();
            }
        }
    }

    protected class CalculatorUIListener
    implements ChangeListener {
        protected CalculatorUIListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            VizMapAttrTab.this.VMM.getCytoscapeWindow().redrawGraph();
        }
    }

    private class calcComboSelectionListener
    implements ItemListener {
        private calcComboSelectionListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                if (VizMapAttrTab.this.calcComboBox.getSelectedIndex() == 0) {
                    VizMapAttrTab.this.switchCalculator(null);
                } else {
                    Object object = VizMapAttrTab.this.calcComboBox.getSelectedItem();
                    VizMapAttrTab.this.switchCalculator((Calculator)object);
                }
            }
        }
    }

    private class CatalogListener
    implements ChangeListener {
        private CatalogListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            VizMapAttrTab.this.resetCalculatorDisplay();
            VizMapAttrTab.this.validate();
            VizMapAttrTab.this.repaint();
        }
    }

    private class RmCalcListener
    extends AbstractAction {
        private RmCalcListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            if (VizMapAttrTab.this.currentCalculator == null) {
                return;
            }
            Vector vector = VizMapAttrTab.this.mainUIDialog.checkCalculatorUsage(VizMapAttrTab.this.currentCalculator);
            if (vector.size() != 0 && (vector.size() != 1 || ((Vector)vector.get(0)).size() != 2)) {
                object = new StringBuffer("Calculator ");
                ((StringBuffer)object).append(((Object)VizMapAttrTab.this.currentCalculator).toString());
                ((StringBuffer)object).append(" currently in use by:<br><ul>");
                for (int i = 0; i < vector.size(); ++i) {
                    Vector vector2 = (Vector)vector.get(i);
                    ((StringBuffer)object).append("<li>");
                    ((StringBuffer)object).append(vector2.get(0));
                    ((StringBuffer)object).append("<ul>");
                    for (int j = 1; j < vector2.size(); ++j) {
                        ((StringBuffer)object).append("<li>");
                        ((StringBuffer)object).append(vector2.get(j));
                    }
                    ((StringBuffer)object).append("</ul>");
                }
                ((StringBuffer)object).append("</ul><br>Do you still want to delete this calculator?");
                JEditorPane jEditorPane = new JEditorPane("text/html", ((StringBuffer)object).toString());
                jEditorPane.setEditable(false);
                jEditorPane.setBackground(null);
                int n = JOptionPane.showConfirmDialog(VizMapAttrTab.this.mainUIDialog, jEditorPane, "Calculator In Use", 0, 2);
                if (n == 1) {
                    return;
                }
            } else {
                object = "Are you sure you want to permanently delete this calculator?";
                int n = JOptionPane.showConfirmDialog(VizMapAttrTab.this.mainUIDialog, object, "Confirm Remove Calculator", 0);
                if (n == 1) {
                    return;
                }
            }
            object = VizMapAttrTab.this.currentCalculator;
            VizMapAttrTab.this.currentCalculator = null;
            VizMapAttrTab.this.catalog.removeCalculator((Calculator)object);
        }
    }

    private class RenCalcListener
    extends AbstractAction {
        private RenCalcListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = VizMapAttrTab.this.getCalculatorName(VizMapAttrTab.this.currentCalculator);
            if (string == null) {
                return;
            }
            VizMapAttrTab.this.catalog.renameCalculator(VizMapAttrTab.this.currentCalculator, string);
        }
    }

    private class DupeCalcListener
    extends AbstractAction {
        private DupeCalcListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Calculator calculator = VizMapAttrTab.this.duplicateCalculator(VizMapAttrTab.this.currentCalculator);
            if (calculator == null) {
                return;
            }
            VizMapAttrTab.this.currentCalculator = calculator;
            VizMapAttrTab.this.catalog.addCalculator(calculator);
        }
    }

    private class NewCalcListener
    extends AbstractAction {
        private NewCalcListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            byte by;
            Constructor constructor;
            Set set = VizMapAttrTab.this.catalog.getMappingNames();
            Object[] objectArray = set.toArray();
            String string = (String)JOptionPane.showInputDialog(VizMapAttrTab.this.mainUIDialog, "Choose a mapper", "New Calculator", 3, null, objectArray, objectArray[0]);
            if (string == null) {
                return;
            }
            String string2 = VizMapAttrTab.this.getCalculatorName(null);
            if (string2 == null) {
                return;
            }
            Class clazz = VizMapAttrTab.this.catalog.getMapping(string);
            Class[] classArray = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = VizMapAttrTab.class$("java.lang.Object")) : class$java$lang$Object, Byte.TYPE};
            try {
                constructor = clazz.getConstructor(classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println("Invalid mapper " + clazz.getName());
                JOptionPane.showMessageDialog(VizMapAttrTab.this.mainUIDialog, "Mapper " + clazz.getName() + " does not have an acceptable constructor. See documentation for ObjectMapper.", "Invalid Mapper", 0);
                return;
            }
            switch (VizMapAttrTab.this.type) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 124: 
                case 125: {
                    by = 0;
                    break;
                }
                default: {
                    by = 1;
                }
            }
            Object[] objectArray2 = new Object[]{VizMapAttrTab.this.defaultObj, new Byte(by)};
            ObjectMapping objectMapping = null;
            try {
                objectMapping = (ObjectMapping)constructor.newInstance(objectArray2);
            }
            catch (Exception exception) {
                System.err.println("Error creating mapping");
                JOptionPane.showMessageDialog(VizMapAttrTab.this.mainUIDialog, "Error creating mapping " + clazz.getName(), "Error", 0);
            }
            AbstractCalculator abstractCalculator = null;
            if (VizMapAttrTab.this.type == 0 || VizMapAttrTab.this.type == 1) {
                abstractCalculator = new GenericNodeColorCalculator(string2, objectMapping);
            } else if (VizMapAttrTab.this.type == 2) {
                abstractCalculator = new GenericNodeLineTypeCalculator(string2, objectMapping);
            } else if (VizMapAttrTab.this.type == 3) {
                abstractCalculator = new GenericNodeShapeCalculator(string2, objectMapping);
            } else if (VizMapAttrTab.this.type == 126 || VizMapAttrTab.this.type == 127 || VizMapAttrTab.this.type == 4) {
                abstractCalculator = new GenericNodeSizeCalculator(string2, objectMapping);
            } else if (VizMapAttrTab.this.type == 5) {
                abstractCalculator = new GenericNodeLabelCalculator(string2, objectMapping);
            } else if (VizMapAttrTab.this.type == 13) {
                abstractCalculator = new GenericNodeToolTipCalculator(string2, objectMapping);
            } else if (VizMapAttrTab.this.type == 7) {
                abstractCalculator = new GenericEdgeColorCalculator(string2, objectMapping);
            } else if (VizMapAttrTab.this.type == 8) {
                abstractCalculator = new GenericEdgeLineTypeCalculator(string2, objectMapping);
            } else if (VizMapAttrTab.this.type == 9 || VizMapAttrTab.this.type == 10) {
                abstractCalculator = new GenericEdgeArrowCalculator(string2, objectMapping);
            } else if (VizMapAttrTab.this.type == 11) {
                abstractCalculator = new GenericEdgeLabelCalculator(string2, objectMapping);
            } else if (VizMapAttrTab.this.type == 14) {
                abstractCalculator = new GenericEdgeToolTipCalculator(string2, objectMapping);
            } else if (VizMapAttrTab.this.type == 124) {
                abstractCalculator = new GenericEdgeFontFaceCalculator(string2, objectMapping);
            } else if (VizMapAttrTab.this.type == 125) {
                abstractCalculator = new GenericEdgeFontSizeCalculator(string2, objectMapping);
            } else if (VizMapAttrTab.this.type == 122) {
                abstractCalculator = new GenericNodeFontFaceCalculator(string2, objectMapping);
            } else if (VizMapAttrTab.this.type == 123) {
                abstractCalculator = new GenericNodeFontSizeCalculator(string2, objectMapping);
            }
            VizMapAttrTab.this.currentCalculator = abstractCalculator;
            VizMapAttrTab.this.catalog.addCalculator(abstractCalculator);
        }
    }
}

