/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.visual.ui.FontChooser;
import cytoscape.visual.ui.MiscDialog;
import cytoscape.visual.ui.PopupIconChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import y.view.Arrow;
import y.view.LineType;

public class ValueDisplayer
extends JButton {
    public static DecimalFormat formatter = new DecimalFormat("0.0####");
    public static final byte COLOR = 0;
    public static final byte LINETYPE = 1;
    public static final byte ARROW = 2;
    public static final byte STRING = 3;
    public static final byte DOUBLE = 4;
    public static final byte NODESHAPE = 5;
    public static final byte INT = 6;
    public static final byte FONT = 7;
    protected byte dispType;
    private Object inputObj = null;
    private String title;
    private JDialog parent;
    private ActionListener inputListener;
    private boolean enabled;

    public Object getSelectedItem() {
        return this.getValue();
    }

    public Object getValue() {
        return this.inputObj;
    }

    public ActionListener getInputListener() {
        return this.inputListener;
    }

    public byte getType() {
        return this.dispType;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        super.setEnabled(bl);
    }

    private ValueDisplayer(JDialog jDialog, String string, String string2, byte by) {
        super(string);
        this.setBorderPainted(false);
        this.parent = jDialog;
        this.dispType = by;
        this.title = string2;
    }

    private ValueDisplayer(JDialog jDialog, String string, byte by) {
        this(jDialog, null, string, by);
    }

    public static ValueDisplayer getDisplayForColor(JDialog jDialog, String string, Color color) {
        String string2 = "   ";
        ValueDisplayer valueDisplayer = new ValueDisplayer(jDialog, string2, string, 0);
        if (color != null) {
            valueDisplayer.setOpaque(true);
            valueDisplayer.setBackground(color);
            valueDisplayer.inputObj = color;
        } else {
            valueDisplayer.setOpaque(false);
            valueDisplayer.setBackground(null);
            valueDisplayer.inputObj = null;
        }
        valueDisplayer.setInputColorListener();
        return valueDisplayer;
    }

    private void setInputColorListener() {
        this.inputListener = new ColorListener(this);
        this.addActionListener(this.inputListener);
    }

    protected void fireItemSelected() {
        this.fireItemStateChanged(new ItemEvent(this, 701, this.inputObj, 1));
    }

    public void setObject(Object object) throws ClassCastException {
        this.inputObj = object;
        if (object instanceof Icon) {
            this.setIcon((Icon)object);
        } else if (object instanceof Color) {
            this.setBackground((Color)object);
        } else if (object instanceof Font) {
            Font font = (Font)object;
            this.setFont(font);
            this.setText(font.getFontName());
        } else {
            this.setText(object.toString());
        }
    }

    private static ValueDisplayer getDisplayForFont(JDialog jDialog, String string, Font font) {
        ValueDisplayer valueDisplayer = new ValueDisplayer(jDialog, string, 7);
        valueDisplayer.setSelectedFont(font);
        valueDisplayer.setInputFontListener();
        return valueDisplayer;
    }

    private void setSelectedFont(Font font) {
        this.inputObj = font;
        String string = font.getFontName();
        this.setFont(font.deriveFont(12.0f));
        this.setText(string);
    }

    private void setInputFontListener() {
        this.inputListener = new FontListener(this);
        this.addActionListener(this.inputListener);
    }

    private static ValueDisplayer getDisplayForIcons(JDialog jDialog, String string, Object object, byte by) {
        ValueDisplayer valueDisplayer = new ValueDisplayer(jDialog, string, by);
        valueDisplayer.setInputIconListener(string, string, object, jDialog, by);
        return valueDisplayer;
    }

    private void setInputIconListener(String string, String string2, Object object, JDialog jDialog, byte by) {
        ImageIcon imageIcon;
        this.setContentAreaFilled(false);
        ImageIcon[] imageIconArray = null;
        HashMap hashMap = null;
        HashMap hashMap2 = null;
        switch (by) {
            case 2: {
                imageIconArray = MiscDialog.getArrowIcons();
                hashMap = MiscDialog.getArrowToStringHashMap(25);
                hashMap2 = MiscDialog.getStringToArrowHashMap(25);
                break;
            }
            case 5: {
                imageIconArray = MiscDialog.getShapeIcons();
                hashMap = MiscDialog.getShapeByteToStringHashMap();
                hashMap2 = MiscDialog.getStringToShapeByteHashMap();
                break;
            }
            case 1: {
                imageIconArray = MiscDialog.getLineTypeIcons();
                hashMap = MiscDialog.getLineTypeToStringHashMap();
                hashMap2 = MiscDialog.getStringToLineTypeHashMap();
            }
        }
        if (object == null) {
            imageIcon = imageIconArray[0];
        } else {
            int n;
            String string3 = (String)hashMap.get(object);
            for (n = 0; n < imageIconArray.length && !imageIconArray[n].getDescription().equals(string3); ++n) {
            }
            if (n == imageIconArray.length) {
                System.err.println("Icon for object " + object + " not found!");
                n = 0;
            }
            imageIcon = imageIconArray[n];
        }
        this.setIcon(imageIcon);
        this.inputObj = hashMap2.get(imageIcon.getDescription());
        this.inputListener = new IconListener(string, string2, imageIconArray, hashMap2, imageIcon, jDialog, this);
        this.addActionListener(this.inputListener);
    }

    private void addStringListener(String string, byte by) {
        this.inputListener = new StringListener(string, by);
        this.addActionListener(this.inputListener);
    }

    private static ValueDisplayer getDisplayForString(JDialog jDialog, String string, String string2) {
        ValueDisplayer valueDisplayer = new ValueDisplayer(jDialog, string2, string, 3);
        valueDisplayer.addStringListener("Input a string:", (byte)3);
        return valueDisplayer;
    }

    private static ValueDisplayer getDisplayForDouble(JDialog jDialog, String string, double d) {
        ValueDisplayer valueDisplayer = new ValueDisplayer(jDialog, formatter.format(d), string, 4);
        valueDisplayer.addStringListener("Input a double:", (byte)4);
        return valueDisplayer;
    }

    private static ValueDisplayer getDisplayForInt(JDialog jDialog, String string, int n) {
        ValueDisplayer valueDisplayer = new ValueDisplayer(jDialog, Integer.toString(n), string, 6);
        valueDisplayer.addStringListener("Input an integer:", (byte)6);
        return valueDisplayer;
    }

    private void showErrorDialog(String string) {
        JOptionPane.showMessageDialog(this.parent, string, "Bad Input", 0);
    }

    public static ValueDisplayer getBlankDisplayFor(JDialog jDialog, String string, byte by) {
        switch (by) {
            case 0: {
                return ValueDisplayer.getDisplayForColor(jDialog, string, null);
            }
            case 1: {
                return ValueDisplayer.getDisplayForIcons(jDialog, string, null, (byte)1);
            }
            case 5: {
                return ValueDisplayer.getDisplayForIcons(jDialog, string, new Byte(2), (byte)5);
            }
            case 2: {
                return ValueDisplayer.getDisplayForIcons(jDialog, string, Arrow.STANDARD, (byte)2);
            }
            case 3: {
                return ValueDisplayer.getDisplayForString(jDialog, string, null);
            }
            case 4: {
                return ValueDisplayer.getDisplayForDouble(jDialog, string, 0.0);
            }
            case 6: {
                return ValueDisplayer.getDisplayForInt(jDialog, string, 0);
            }
            case 7: {
                return ValueDisplayer.getDisplayForFont(jDialog, string, new Font(null, 0, 1));
            }
        }
        throw new ClassCastException("ValueDisplayer didn't understand type flag " + by);
    }

    public static ValueDisplayer getDisplayFor(JDialog jDialog, String string, Object object) throws ClassCastException {
        if (object instanceof Color) {
            return ValueDisplayer.getDisplayForColor(jDialog, string, (Color)object);
        }
        if (object instanceof LineType) {
            return ValueDisplayer.getDisplayForIcons(jDialog, string, object, (byte)1);
        }
        if (object instanceof Byte) {
            return ValueDisplayer.getDisplayForIcons(jDialog, string, object, (byte)5);
        }
        if (object instanceof Arrow) {
            return ValueDisplayer.getDisplayForIcons(jDialog, string, object, (byte)2);
        }
        if (object instanceof String) {
            return ValueDisplayer.getDisplayForString(jDialog, string, (String)object);
        }
        if (object instanceof Number) {
            if (object instanceof Float || object instanceof Double) {
                return ValueDisplayer.getDisplayForDouble(jDialog, string, ((Number)object).doubleValue());
            }
            return ValueDisplayer.getDisplayForInt(jDialog, string, ((Number)object).intValue());
        }
        if (object instanceof Font) {
            return ValueDisplayer.getDisplayForFont(jDialog, string, (Font)object);
        }
        throw new ClassCastException("ValueDisplayer doesn't know how to display type " + object.getClass().getName());
    }

    private class StringListener
    extends AbstractAction {
        private byte type;
        private String prompt;

        StringListener(String string, byte by) {
            super("ValueDisplayer StringListener");
            this.prompt = string;
            this.type = by;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.enabled) {
                block8: while (true) {
                    String string;
                    if ((string = (String)JOptionPane.showInputDialog(ValueDisplayer.this.parent, this.prompt, ValueDisplayer.this.title, 3, null, null, ValueDisplayer.this.inputObj)) == null) {
                        return;
                    }
                    switch (this.type) {
                        case 4: {
                            try {
                                ValueDisplayer.this.inputObj = new Double(Double.parseDouble(string));
                                break block8;
                            }
                            catch (NumberFormatException numberFormatException) {
                                ValueDisplayer.this.showErrorDialog("That is not a valid double");
                                continue block8;
                            }
                        }
                        case 6: {
                            try {
                                ValueDisplayer.this.inputObj = new Integer(Integer.parseInt(string));
                                break block8;
                            }
                            catch (NumberFormatException numberFormatException) {
                                ValueDisplayer.this.showErrorDialog("That is not a valid integer");
                                continue block8;
                            }
                        }
                        default: {
                            ValueDisplayer.this.inputObj = string;
                            break block8;
                        }
                    }
                    break;
                }
                ValueDisplayer.this.setText(ValueDisplayer.this.inputObj.toString());
                ValueDisplayer.this.fireItemSelected();
            }
        }
    }

    private class IconListener
    extends AbstractAction {
        private PopupIconChooser chooser;
        private ValueDisplayer parent;
        private HashMap sToI;

        IconListener(String string, String string2, ImageIcon[] imageIconArray, HashMap hashMap, ImageIcon imageIcon, JDialog jDialog, ValueDisplayer valueDisplayer2) {
            super("ValueDisplayer IconListener");
            this.chooser = new PopupIconChooser(string, string2, imageIconArray, imageIcon, jDialog);
            this.parent = valueDisplayer2;
            this.sToI = hashMap;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImageIcon imageIcon;
            if (this.enabled && (imageIcon = this.chooser.showDialog()) != null) {
                this.parent.setIcon(imageIcon);
                this.parent.inputObj = this.sToI.get(imageIcon.getDescription());
                this.parent.fireItemSelected();
            }
        }
    }

    private class FontListener
    extends AbstractAction {
        ValueDisplayer parent;
        JDialog popup;

        FontListener(ValueDisplayer valueDisplayer2) {
            super("ValueDisplayer FontListener");
            this.parent = valueDisplayer2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.enabled) {
                FontChooser fontChooser = new FontChooser(((Font)ValueDisplayer.this.inputObj).deriveFont(1.0f));
                this.popup = new JDialog(this.parent.parent, this.parent.title, true);
                JComboBox jComboBox = fontChooser.getFaceComboBox();
                jComboBox.setSelectedItem(this.parent.inputObj);
                JPanel jPanel = new JPanel(false);
                JButton jButton = new JButton("OK");
                jButton.addActionListener(new OKListener(fontChooser));
                JButton jButton2 = new JButton("Cancel");
                jButton2.addActionListener(new CancelListener());
                jPanel.add(jButton);
                jPanel.add(jButton2);
                Container container = this.popup.getContentPane();
                container.setLayout(new BorderLayout());
                container.add((Component)fontChooser, "Center");
                container.add((Component)jPanel, "South");
                this.popup.pack();
                this.popup.show();
            }
        }

        private class CancelListener
        extends AbstractAction {
            private CancelListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                FontListener.this.popup.dispose();
            }
        }

        private class OKListener
        extends AbstractAction {
            FontChooser chooser;

            private OKListener(FontChooser fontChooser) {
                this.chooser = fontChooser;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ValueDisplayer.this.setSelectedFont(this.chooser.getSelectedFont().deriveFont(12.0f));
                ValueDisplayer.this.fireItemSelected();
                FontListener.this.popup.dispose();
            }
        }
    }

    private class ColorListener
    extends AbstractAction {
        ValueDisplayer parent;

        ColorListener(ValueDisplayer valueDisplayer2) {
            super("ValueDisplayer ColorListener");
            this.parent = valueDisplayer2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Color color;
            if (this.enabled && (color = JColorChooser.showDialog(this.parent.parent, this.parent.title, (Color)this.parent.inputObj)) != null) {
                this.parent.inputObj = color;
                this.parent.setBackground(color);
                this.parent.fireItemSelected();
            }
        }
    }
}

