/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PopupIconChooser {
    private String title;
    private String objectName;
    private ImageIcon currentIcon;
    private JDialog mainDialog;
    private JDialog parentDialog;
    private JPanel mainPanel;
    private JList iconList;
    private boolean alreadyConstructed = false;

    public PopupIconChooser(String string, String string2, ImageIcon[] imageIconArray, ImageIcon imageIcon, JDialog jDialog) {
        this.parentDialog = jDialog;
        this.title = string;
        this.objectName = string2;
        this.iconList = new JList<ImageIcon>(imageIconArray);
        this.currentIcon = imageIcon != null ? imageIcon : (ImageIcon)this.iconList.getModel().getElementAt(0);
    }

    public ImageIcon showDialog() {
        if (!this.alreadyConstructed) {
            this.mainDialog = new JDialog(this.parentDialog, this.title, true);
            JPanel jPanel = new JPanel(new GridLayout(0, 1));
            final JButton jButton = new JButton("Apply");
            JButton jButton2 = new JButton("Dismiss");
            jButton.addActionListener(new ApplyIconAction());
            jButton2.addActionListener(new DismissIconAction());
            this.iconList.setLayoutOrientation(2);
            this.iconList.setVisibleRowCount(1);
            this.iconList.setBackground(Color.WHITE);
            this.iconList.setSelectionBackground(Color.RED);
            this.iconList.setSelectionForeground(Color.RED);
            this.iconList.setSelectionMode(0);
            this.iconList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        jButton.doClick();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.iconList);
            jScrollPane.setPreferredSize(new Dimension(150, 50));
            jScrollPane.setMinimumSize(new Dimension(150, 50));
            jScrollPane.setAlignmentX(0.0f);
            jScrollPane.setAlignmentY(1.0f);
            this.iconList.ensureIndexIsVisible(this.iconList.getSelectedIndex());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            JLabel jLabel = new JLabel("Set " + this.objectName);
            jLabel.setLabelFor(this.iconList);
            jPanel2.add(jLabel);
            jPanel2.add(Box.createRigidArea(new Dimension(0, 5)));
            jPanel2.add(jScrollPane);
            jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            jPanel3.add(Box.createHorizontalGlue());
            jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel3.add(jButton);
            jPanel3.add(jButton2);
            jPanel.add((Component)jPanel2, "Center");
            jPanel.add((Component)jPanel3, "South");
            this.mainDialog.setContentPane(jPanel);
            this.alreadyConstructed = true;
        }
        this.mainDialog.pack();
        this.mainDialog.setLocationRelativeTo(this.parentDialog);
        this.mainDialog.show();
        return this.currentIcon;
    }

    public class DismissIconAction
    extends AbstractAction {
        DismissIconAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PopupIconChooser.this.currentIcon = null;
            PopupIconChooser.this.mainDialog.dispose();
        }
    }

    public class ApplyIconAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            ImageIcon imageIcon = (ImageIcon)PopupIconChooser.this.iconList.getSelectedValue();
            PopupIconChooser.this.currentIcon = imageIcon;
            PopupIconChooser.this.mainDialog.dispose();
        }
    }
}

