/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.util.Misc;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;
import y.view.Arrow;
import y.view.LineType;

public class MiscDialog {
    public static HashMap getStringToArrowHashMap(int n) {
        HashMap<String, Arrow> hashMap = new HashMap<String, Arrow>();
        hashMap.put("NONE", Arrow.NONE);
        hashMap.put("DELTA", Arrow.DELTA);
        hashMap.put("DIAMOND", Arrow.DIAMOND);
        hashMap.put("STANDARD", Arrow.STANDARD);
        hashMap.put("SHORT", Arrow.SHORT);
        hashMap.put("WHITE_DELTA", Arrow.WHITE_DELTA);
        hashMap.put("WHITE_DIAMOND", Arrow.WHITE_DIAMOND);
        hashMap.put("SCALABLE", Misc.parseArrowText("scalableArrow" + Integer.toString(n / 2)));
        return hashMap;
    }

    public static HashMap getArrowToStringHashMap(int n) {
        HashMap<Arrow, String> hashMap = new HashMap<Arrow, String>();
        hashMap.put(Arrow.NONE, "NONE");
        hashMap.put(Arrow.DELTA, "DELTA");
        hashMap.put(Arrow.DIAMOND, "DIAMOND");
        hashMap.put(Arrow.STANDARD, "STANDARD");
        hashMap.put(Arrow.SHORT, "SHORT");
        hashMap.put(Arrow.WHITE_DELTA, "WHITE_DELTA");
        hashMap.put(Arrow.WHITE_DIAMOND, "WHITE_DIAMOND");
        hashMap.put(Misc.parseArrowText("scalableArrow" + Integer.toString(n / 2)), "SCALABLE");
        return hashMap;
    }

    public static ImageIcon[] getArrowIcons() {
        ImageIcon[] imageIconArray = new ImageIcon[]{new ImageIcon(MiscDialog.locateImage("arrow_none.jpg"), "NONE"), new ImageIcon(MiscDialog.locateImage("arrow_delta.jpg"), "DELTA"), new ImageIcon(MiscDialog.locateImage("arrow_diamond.jpg"), "DIAMOND"), new ImageIcon(MiscDialog.locateImage("arrow_standard.jpg"), "STANDARD"), new ImageIcon(MiscDialog.locateImage("arrow_short.jpg"), "SHORT"), new ImageIcon(MiscDialog.locateImage("arrow_whitediamond.jpg"), "WHITE_DIAMOND"), new ImageIcon(MiscDialog.locateImage("arrow_whitedelta.jpg"), "WHITE_DELTA"), new ImageIcon(MiscDialog.locateImage("arrow_scalable.jpg"), "SCALABLE")};
        return imageIconArray;
    }

    public static HashMap getStringToShapeByteHashMap() {
        HashMap<String, Byte> hashMap = new HashMap<String, Byte>();
        hashMap.put("ELLIPSE", new Byte(2));
        hashMap.put("ROUND_RECT", new Byte(1));
        hashMap.put("RECT_3D", new Byte(6));
        hashMap.put("RECTANGLE", new Byte(0));
        hashMap.put("DIAMOND", new Byte(8));
        hashMap.put("HEXAGON", new Byte(4));
        hashMap.put("OCTAGON", new Byte(7));
        hashMap.put("TRAPEZOID", new Byte(9));
        hashMap.put("TRAPEZOID_2", new Byte(10));
        hashMap.put("PARALLELOGRAM", new Byte(3));
        hashMap.put("TRIANGLE", new Byte(5));
        return hashMap;
    }

    public static HashMap getShapeByteToStringHashMap() {
        HashMap<Byte, String> hashMap = new HashMap<Byte, String>();
        hashMap.put(new Byte(2), "ELLIPSE");
        hashMap.put(new Byte(1), "ROUND_RECT");
        hashMap.put(new Byte(6), "RECT_3D");
        hashMap.put(new Byte(0), "RECTANGLE");
        hashMap.put(new Byte(8), "DIAMOND");
        hashMap.put(new Byte(4), "HEXAGON");
        hashMap.put(new Byte(7), "OCTAGON");
        hashMap.put(new Byte(9), "TRAPEZOID");
        hashMap.put(new Byte(10), "TRAPEZOID_2");
        hashMap.put(new Byte(3), "PARALLELOGRAM");
        hashMap.put(new Byte(5), "TRIANGLE");
        return hashMap;
    }

    public static ImageIcon[] getShapeIcons() {
        ImageIcon[] imageIconArray = new ImageIcon[]{new ImageIcon(MiscDialog.locateImage("ellipse.jpg"), "ELLIPSE"), new ImageIcon(MiscDialog.locateImage("round_rect.jpg"), "ROUND_RECT"), new ImageIcon(MiscDialog.locateImage("rect_3d.jpg"), "RECT_3D"), new ImageIcon(MiscDialog.locateImage("rect.jpg"), "RECTANGLE"), new ImageIcon(MiscDialog.locateImage("diamond.jpg"), "DIAMOND"), new ImageIcon(MiscDialog.locateImage("hexagon.jpg"), "HEXAGON"), new ImageIcon(MiscDialog.locateImage("octagon.jpg"), "OCTAGON"), new ImageIcon(MiscDialog.locateImage("trapezoid.jpg"), "TRAPEZOID"), new ImageIcon(MiscDialog.locateImage("trapezoid_2.jpg"), "TRAPEZOID_2"), new ImageIcon(MiscDialog.locateImage("parallelogram.jpg"), "PARALLELOGRAM"), new ImageIcon(MiscDialog.locateImage("triangle.jpg"), "TRIANGLE")};
        return imageIconArray;
    }

    public static HashMap getStringToLineTypeHashMap() {
        HashMap<String, LineType> hashMap = new HashMap<String, LineType>();
        hashMap.put("DASHED_1", LineType.DASHED_1);
        hashMap.put("DASHED_2", LineType.DASHED_2);
        hashMap.put("DASHED_3", LineType.DASHED_3);
        hashMap.put("DASHED_4", LineType.DASHED_4);
        hashMap.put("DASHED_5", LineType.DASHED_5);
        hashMap.put("LINE_1", LineType.LINE_1);
        hashMap.put("LINE_2", LineType.LINE_2);
        hashMap.put("LINE_3", LineType.LINE_3);
        hashMap.put("LINE_4", LineType.LINE_4);
        hashMap.put("LINE_5", LineType.LINE_5);
        hashMap.put("LINE_6", LineType.LINE_6);
        hashMap.put("LINE_7", LineType.LINE_7);
        return hashMap;
    }

    public static HashMap getLineTypeToStringHashMap() {
        HashMap<LineType, String> hashMap = new HashMap<LineType, String>();
        hashMap.put(LineType.DASHED_1, "DASHED_1");
        hashMap.put(LineType.DASHED_2, "DASHED_2");
        hashMap.put(LineType.DASHED_3, "DASHED_3");
        hashMap.put(LineType.DASHED_4, "DASHED_4");
        hashMap.put(LineType.DASHED_5, "DASHED_5");
        hashMap.put(LineType.LINE_1, "LINE_1");
        hashMap.put(LineType.LINE_2, "LINE_2");
        hashMap.put(LineType.LINE_3, "LINE_3");
        hashMap.put(LineType.LINE_4, "LINE_4");
        hashMap.put(LineType.LINE_5, "LINE_5");
        hashMap.put(LineType.LINE_6, "LINE_6");
        hashMap.put(LineType.LINE_7, "LINE_7");
        return hashMap;
    }

    public static ImageIcon[] getLineTypeIcons() {
        ImageIcon[] imageIconArray = new ImageIcon[]{new ImageIcon(MiscDialog.locateImage("line_1.jpg"), "LINE_1"), new ImageIcon(MiscDialog.locateImage("line_2.jpg"), "LINE_2"), new ImageIcon(MiscDialog.locateImage("line_3.jpg"), "LINE_3"), new ImageIcon(MiscDialog.locateImage("line_4.jpg"), "LINE_4"), new ImageIcon(MiscDialog.locateImage("line_5.jpg"), "LINE_5"), new ImageIcon(MiscDialog.locateImage("line_6.jpg"), "LINE_6"), new ImageIcon(MiscDialog.locateImage("line_7.jpg"), "LINE_7"), new ImageIcon(MiscDialog.locateImage("dashed_1.jpg"), "DASHED_1"), new ImageIcon(MiscDialog.locateImage("dashed_2.jpg"), "DASHED_2"), new ImageIcon(MiscDialog.locateImage("dashed_3.jpg"), "DASHED_3"), new ImageIcon(MiscDialog.locateImage("dashed_4.jpg"), "DASHED_4"), new ImageIcon(MiscDialog.locateImage("dashed_5.jpg"), "DASHED_5")};
        return imageIconArray;
    }

    private static URL locateImage(String string) {
        MiscDialog miscDialog = new MiscDialog();
        return miscDialog.getClass().getResource("images/" + string);
    }
}

