/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.visual.ui.FontRenderer;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class FontChooser
extends JPanel {
    private Font selectedFont;
    protected Font[] displayFonts;
    protected DefaultComboBoxModel fontFaceModel;
    protected JComboBox face;

    public FontChooser() {
        this((Font)null);
    }

    public FontChooser(Font font) {
        this(GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts(), font);
    }

    public FontChooser(Font[] fontArray, Font font) {
        this.displayFonts = fontArray;
        this.fontFaceModel = new DefaultComboBoxModel<Font>(this.displayFonts);
        this.face = new JComboBox(this.fontFaceModel);
        this.face.setRenderer(new FontRenderer());
        this.face.addItemListener(new FontFaceSelectionListener());
        this.selectedFont = font == null ? new Font("dialog", 0, 1) : font.deriveFont(1.0f);
        this.face.setSelectedItem(this.selectedFont);
        this.add(this.face);
    }

    public JComboBox getFaceComboBox() {
        return this.face;
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    private class FontFaceSelectionListener
    implements ItemListener {
        private FontFaceSelectionListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                FontChooser.this.selectedFont = (Font)jComboBox.getSelectedItem();
            }
        }
    }
}

