/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.dialogs.GridBagGroup;
import cytoscape.dialogs.MiscGB;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.ui.ValueDisplayer;
import cytoscape.visual.ui.VizMapUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class DefaultPanel
extends JPanel {
    private VisualMappingManager vmm;
    private ValueDisplayer backColor;

    public DefaultPanel(VizMapUI vizMapUI, VisualMappingManager visualMappingManager) {
        super(false);
        this.vmm = visualMappingManager;
        GridBagGroup gridBagGroup = new GridBagGroup();
        gridBagGroup.panel = this;
        this.setLayout(gridBagGroup.gridbag);
        MiscGB.pad(gridBagGroup.constraints, 2, 2);
        MiscGB.inset(gridBagGroup.constraints, 3);
        VisualStyle visualStyle = visualMappingManager.getVisualStyle();
        Color color = visualStyle.getGlobalAppearanceCalculator().getDefaultBackgroundColor();
        this.backColor = ValueDisplayer.getDisplayFor(vizMapUI, "Background Color", color);
        this.backColor.addItemListener(new BackColorListener());
        JButton jButton = new JButton("Background Color");
        jButton.addActionListener(this.backColor.getInputListener());
        MiscGB.insert(gridBagGroup, (Component)jButton, 0, 0);
        MiscGB.insert(gridBagGroup, (Component)this.backColor, 1, 0);
    }

    private class BackColorListener
    implements ItemListener {
        private BackColorListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                Color color = (Color)DefaultPanel.this.backColor.getValue();
                VisualStyle visualStyle = DefaultPanel.this.vmm.getVisualStyle();
                visualStyle.getGlobalAppearanceCalculator().setDefaultBackgroundColor(color);
            }
        }
    }
}

