/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.tests;

import cytoscape.CytoscapeWindow;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.CalculatorIO;
import cytoscape.visual.EdgeAppearance;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.Network;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.GenericEdgeArrowCalculator;
import cytoscape.visual.calculators.GenericEdgeColorCalculator;
import cytoscape.visual.calculators.GenericEdgeLabelCalculator;
import cytoscape.visual.calculators.GenericEdgeLineTypeCalculator;
import cytoscape.visual.calculators.GenericNodeColorCalculator;
import cytoscape.visual.calculators.GenericNodeLabelCalculator;
import cytoscape.visual.calculators.GenericNodeLineTypeCalculator;
import cytoscape.visual.calculators.GenericNodeShapeCalculator;
import cytoscape.visual.calculators.GenericNodeSizeCalculator;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.DiscreteMapping;
import cytoscape.visual.mappings.LinearNumberToColorInterpolator;
import cytoscape.visual.mappings.LinearNumberToNumberInterpolator;
import cytoscape.visual.mappings.PassThroughMapping;
import cytoscape.visual.ui.VizMapUI;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.AbstractAction;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Node;
import y.view.Arrow;
import y.view.EdgeRealizer;
import y.view.Graph2DView;
import y.view.LineType;
import y.view.NodeRealizer;
import y.view.ShapeNodeRealizer;

public class TestNewMappingsUI {
    protected CytoscapeWindow cytoscapeWindow;
    protected Network network;
    static /* synthetic */ Class class$cytoscape$visual$mappings$DiscreteMapping;
    static /* synthetic */ Class class$cytoscape$visual$mappings$ContinuousMapping;
    static /* synthetic */ Class class$cytoscape$visual$mappings$PassThroughMapping;

    public TestNewMappingsUI(CytoscapeWindow cytoscapeWindow) {
        this.cytoscapeWindow = cytoscapeWindow;
        this.network = new Network(cytoscapeWindow);
        cytoscapeWindow.getOperationsMenu().addSeparator();
        cytoscapeWindow.getOperationsMenu().add(new VizPropsUIAction());
        cytoscapeWindow.getOperationsMenu().addSeparator();
    }

    private void addNodeShapeMapping(NodeAppearanceCalculator nodeAppearanceCalculator) {
        DiscreteMapping discreteMapping = new DiscreteMapping(new Byte(0), 1);
        discreteMapping.setControllingAttributeName("GO Molecular Function (level 4)", this.network, false);
        discreteMapping.put("autophagy", new Byte(8));
        discreteMapping.put("budding", new Byte(4));
        discreteMapping.put("growth", new Byte(7));
        discreteMapping.put("metabolism", new Byte(3));
        discreteMapping.put("transport", new Byte(1));
        discreteMapping.put("biological_process unknown", new Byte(0));
        GenericNodeShapeCalculator genericNodeShapeCalculator = new GenericNodeShapeCalculator("Example Node Shape Map", discreteMapping);
        nodeAppearanceCalculator.setNodeShapeCalculator(genericNodeShapeCalculator);
    }

    private void addCanonicalNodeShapeMapping(NodeAppearanceCalculator nodeAppearanceCalculator) {
        DiscreteMapping discreteMapping = new DiscreteMapping(new Byte(0), 1);
        discreteMapping.setControllingAttributeName("canonicalName", this.network, false);
        discreteMapping.put("A", new Byte(8));
        discreteMapping.put("B", new Byte(4));
        discreteMapping.put("C", new Byte(7));
        discreteMapping.put("D", new Byte(3));
        discreteMapping.put("E", new Byte(1));
        discreteMapping.put("F", new Byte(0));
        discreteMapping.put("G", new Byte(6));
        discreteMapping.put("H", new Byte(2));
        discreteMapping.put("I", new Byte(9));
        discreteMapping.put("J", new Byte(10));
        discreteMapping.put("K", new Byte(5));
        GenericNodeShapeCalculator genericNodeShapeCalculator = new GenericNodeShapeCalculator("Canonical Node Shape Example", discreteMapping);
        nodeAppearanceCalculator.setNodeShapeCalculator(genericNodeShapeCalculator);
    }

    private void addNodeLineTypeMapping(NodeAppearanceCalculator nodeAppearanceCalculator) {
        DiscreteMapping discreteMapping = new DiscreteMapping(LineType.DASHED_3, 1);
        discreteMapping.setControllingAttributeName("GO Molecular Function (level 4)", this.network, false);
        discreteMapping.put("autophagy", LineType.DASHED_4);
        discreteMapping.put("budding", LineType.DASHED_5);
        discreteMapping.put("growth", LineType.LINE_3);
        discreteMapping.put("metabolism", LineType.LINE_5);
        discreteMapping.put("transport", LineType.LINE_6);
        discreteMapping.put("biological_process unknown", LineType.LINE_7);
        GenericNodeLineTypeCalculator genericNodeLineTypeCalculator = new GenericNodeLineTypeCalculator("Example Node LineType Map", discreteMapping);
        nodeAppearanceCalculator.setNodeLineTypeCalculator(genericNodeLineTypeCalculator);
    }

    private void addNodeBorderColorMapping(NodeAppearanceCalculator nodeAppearanceCalculator) {
        DiscreteMapping discreteMapping = new DiscreteMapping(new Color(0, 0, 0), 1);
        discreteMapping.setControllingAttributeName("GO Molecular Function (level 4)", this.network, false);
        this.addRandomColor(discreteMapping, "autophagy");
        this.addRandomColor(discreteMapping, "budding");
        this.addRandomColor(discreteMapping, "growth");
        this.addRandomColor(discreteMapping, "metabolism");
        this.addRandomColor(discreteMapping, "transport");
        this.addRandomColor(discreteMapping, "biological_process unknown");
        GenericNodeColorCalculator genericNodeColorCalculator = new GenericNodeColorCalculator("Example Node Border Color Map", discreteMapping);
        nodeAppearanceCalculator.setNodeBorderColorCalculator(genericNodeColorCalculator);
    }

    private void addNodeFillColorMapping(NodeAppearanceCalculator nodeAppearanceCalculator) {
        DiscreteMapping discreteMapping = new DiscreteMapping(new Color(0, 0, 0), 1);
        discreteMapping.setControllingAttributeName("GO Molecular Function (level 4)", this.network, false);
        this.addRandomColor(discreteMapping, "autophagy");
        this.addRandomColor(discreteMapping, "budding");
        this.addRandomColor(discreteMapping, "growth");
        this.addRandomColor(discreteMapping, "metabolism");
        this.addRandomColor(discreteMapping, "transport");
        this.addRandomColor(discreteMapping, "biological_process unknown");
        GenericNodeColorCalculator genericNodeColorCalculator = new GenericNodeColorCalculator("Example Node Fill Color Map", discreteMapping);
        nodeAppearanceCalculator.setNodeFillColorCalculator(genericNodeColorCalculator);
    }

    private void addNodeHeightMapping(NodeAppearanceCalculator nodeAppearanceCalculator) {
        DiscreteMapping discreteMapping = new DiscreteMapping(new Double(0.0), 1);
        discreteMapping.setControllingAttributeName("GO Molecular Function (level 4)", this.network, false);
        this.addRandomDouble(discreteMapping, "autophagy");
        this.addRandomDouble(discreteMapping, "budding");
        this.addRandomDouble(discreteMapping, "growth");
        this.addRandomDouble(discreteMapping, "metabolism");
        this.addRandomDouble(discreteMapping, "transport");
        this.addRandomDouble(discreteMapping, "biological_process unknown");
        GenericNodeSizeCalculator genericNodeSizeCalculator = new GenericNodeSizeCalculator("Example Node Height Map", discreteMapping);
        nodeAppearanceCalculator.setNodeHeightCalculator(genericNodeSizeCalculator);
    }

    private void addNodeWidthMapping(NodeAppearanceCalculator nodeAppearanceCalculator) {
        DiscreteMapping discreteMapping = new DiscreteMapping(new Double(0.0), 1);
        discreteMapping.setControllingAttributeName("GO Molecular Function (level 4)", this.network, false);
        this.addRandomDouble(discreteMapping, "autophagy");
        this.addRandomDouble(discreteMapping, "budding");
        this.addRandomDouble(discreteMapping, "growth");
        this.addRandomDouble(discreteMapping, "metabolism");
        this.addRandomDouble(discreteMapping, "transport");
        this.addRandomDouble(discreteMapping, "biological_process unknown");
        GenericNodeSizeCalculator genericNodeSizeCalculator = new GenericNodeSizeCalculator("Example Node Width Map", discreteMapping);
        nodeAppearanceCalculator.setNodeWidthCalculator(genericNodeSizeCalculator);
    }

    private void addDiscreteNodeLabelMapping(NodeAppearanceCalculator nodeAppearanceCalculator) {
        DiscreteMapping discreteMapping = new DiscreteMapping(new String(""), 1);
        discreteMapping.setControllingAttributeName("GO Molecular Function (level 4)", this.network, false);
        discreteMapping.put("autophagy", "Autophage");
        discreteMapping.put("budding", "Bud");
        discreteMapping.put("growth", "Grow");
        discreteMapping.put("metabolism", "Metabolize");
        discreteMapping.put("transport", "Transporter");
        discreteMapping.put("biological_process unknown", "?????");
        GenericNodeLabelCalculator genericNodeLabelCalculator = new GenericNodeLabelCalculator("Example Node Label Map", discreteMapping);
        nodeAppearanceCalculator.setNodeLabelCalculator(genericNodeLabelCalculator);
    }

    private GenericNodeColorCalculator getContinuousNFCC() {
        LinearNumberToColorInterpolator linearNumberToColorInterpolator = new LinearNumberToColorInterpolator();
        ContinuousMapping continuousMapping = new ContinuousMapping(new Color(200, 200, 255), "gal4RG.sigsig", linearNumberToColorInterpolator, 1);
        return new GenericNodeColorCalculator("Test Continuous Color", continuousMapping);
    }

    private GenericNodeColorCalculator getMultipointContinuousNFCC() {
        LinearNumberToColorInterpolator linearNumberToColorInterpolator = new LinearNumberToColorInterpolator();
        ContinuousMapping continuousMapping = new ContinuousMapping(new Color(255, 255, 255), "gal4RG.sigsig", linearNumberToColorInterpolator, 1);
        BoundaryRangeValues boundaryRangeValues = new BoundaryRangeValues();
        boundaryRangeValues.lesserValue = new Color(255, 255, 0);
        boundaryRangeValues.equalValue = new Color(255, 160, 64);
        boundaryRangeValues.greaterValue = new Color(255, 160, 32);
        continuousMapping.put(new Double(0.001), boundaryRangeValues);
        boundaryRangeValues = new BoundaryRangeValues();
        boundaryRangeValues.lesserValue = new Color(255, 0, 0);
        boundaryRangeValues.equalValue = new Color(255, 0, 0);
        boundaryRangeValues.greaterValue = new Color(255, 0, 0);
        continuousMapping.put(new Double(0.02), boundaryRangeValues);
        boundaryRangeValues = new BoundaryRangeValues();
        boundaryRangeValues.lesserValue = new Color(191, 0, 191);
        boundaryRangeValues.equalValue = new Color(191, 0, 191);
        boundaryRangeValues.greaterValue = new Color(0, 0, 191);
        continuousMapping.put(new Double(0.4), boundaryRangeValues);
        return new GenericNodeColorCalculator("Example Continuous Color", continuousMapping);
    }

    private GenericNodeSizeCalculator getMultipointContinuousNSC() {
        LinearNumberToNumberInterpolator linearNumberToNumberInterpolator = new LinearNumberToNumberInterpolator();
        ContinuousMapping continuousMapping = new ContinuousMapping(new Double(1.0), "gal4RG.sigsig", linearNumberToNumberInterpolator, 1);
        BoundaryRangeValues boundaryRangeValues = new BoundaryRangeValues();
        boundaryRangeValues.lesserValue = new Double(50.0);
        boundaryRangeValues.equalValue = new Double(50.0);
        boundaryRangeValues.greaterValue = new Double(50.0);
        continuousMapping.put(new Double(0.001), boundaryRangeValues);
        boundaryRangeValues = new BoundaryRangeValues();
        boundaryRangeValues.lesserValue = new Double(30.0);
        boundaryRangeValues.equalValue = new Double(30.0);
        boundaryRangeValues.greaterValue = new Double(30.0);
        continuousMapping.put(new Double(0.02), boundaryRangeValues);
        boundaryRangeValues = new BoundaryRangeValues();
        boundaryRangeValues.lesserValue = new Double(20.0);
        boundaryRangeValues.equalValue = new Double(20.0);
        boundaryRangeValues.greaterValue = new Double(20.0);
        continuousMapping.put(new Double(0.4), boundaryRangeValues);
        return new GenericNodeSizeCalculator("Example Continuous Size", continuousMapping);
    }

    private void addPassThroughNodeLabelMapping(NodeAppearanceCalculator nodeAppearanceCalculator) {
        GenericNodeLabelCalculator genericNodeLabelCalculator = this.getPassThroughNLC();
        nodeAppearanceCalculator.setNodeLabelCalculator(genericNodeLabelCalculator);
    }

    private GenericNodeLabelCalculator getPassThroughNLC() {
        PassThroughMapping passThroughMapping = new PassThroughMapping((Object)new String(""), "GO Molecular Function (level 4)");
        return new GenericNodeLabelCalculator("Example Label PassThru", passThroughMapping);
    }

    private void addEdgeColorMapping(EdgeAppearanceCalculator edgeAppearanceCalculator) {
        DiscreteMapping discreteMapping = new DiscreteMapping(new Color(0, 0, 0), 0);
        discreteMapping.setControllingAttributeName("interaction", this.network, false);
        this.addRandomColor(discreteMapping, "pp");
        this.addRandomColor(discreteMapping, "pd");
        GenericEdgeColorCalculator genericEdgeColorCalculator = new GenericEdgeColorCalculator("Example Edge Color Map", discreteMapping);
        edgeAppearanceCalculator.setEdgeColorCalculator(genericEdgeColorCalculator);
    }

    private void addEdgeLineTypeMapping(EdgeAppearanceCalculator edgeAppearanceCalculator) {
        DiscreteMapping discreteMapping = new DiscreteMapping(LineType.DASHED_3, 0);
        discreteMapping.setControllingAttributeName("interaction", this.network, false);
        discreteMapping.put("pp", LineType.DASHED_4);
        discreteMapping.put("pd", LineType.LINE_6);
        GenericEdgeLineTypeCalculator genericEdgeLineTypeCalculator = new GenericEdgeLineTypeCalculator("Example Edge Line Type Map", discreteMapping);
        edgeAppearanceCalculator.setEdgeLineTypeCalculator(genericEdgeLineTypeCalculator);
    }

    private void addEdgeSourceArrowMapping(EdgeAppearanceCalculator edgeAppearanceCalculator) {
        DiscreteMapping discreteMapping = new DiscreteMapping(Arrow.DIAMOND, 0);
        discreteMapping.setControllingAttributeName("interaction", this.network, false);
        discreteMapping.put("pp", Arrow.WHITE_DIAMOND);
        discreteMapping.put("pd", Arrow.WHITE_DELTA);
        GenericEdgeArrowCalculator genericEdgeArrowCalculator = new GenericEdgeArrowCalculator("Example Edge Source Arrow Map", discreteMapping);
        edgeAppearanceCalculator.setEdgeSourceArrowCalculator(genericEdgeArrowCalculator);
    }

    private void addEdgeTargetArrowMapping(EdgeAppearanceCalculator edgeAppearanceCalculator) {
        DiscreteMapping discreteMapping = new DiscreteMapping(Arrow.DIAMOND, 0);
        discreteMapping.setControllingAttributeName("interaction", this.network, false);
        discreteMapping.put("pp", Arrow.NONE);
        discreteMapping.put("pd", Arrow.DELTA);
        GenericEdgeArrowCalculator genericEdgeArrowCalculator = new GenericEdgeArrowCalculator("Example Edge Target Arrow Map", discreteMapping);
        edgeAppearanceCalculator.setEdgeTargetArrowCalculator(genericEdgeArrowCalculator);
    }

    private void addDiscreteEdgeLabelMapping(EdgeAppearanceCalculator edgeAppearanceCalculator) {
        DiscreteMapping discreteMapping = new DiscreteMapping(new String(""), 0);
        discreteMapping.setControllingAttributeName("interaction", this.network, false);
        discreteMapping.put("pp", "Protein-Protein");
        discreteMapping.put("pd", "Transcriptional");
        GenericEdgeLabelCalculator genericEdgeLabelCalculator = new GenericEdgeLabelCalculator("Example Edge Label Map", discreteMapping);
        edgeAppearanceCalculator.setEdgeLabelCalculator(genericEdgeLabelCalculator);
    }

    private void addPassThroughEdgeLabelMapping(EdgeAppearanceCalculator edgeAppearanceCalculator) {
        GenericEdgeLabelCalculator genericEdgeLabelCalculator = this.getPassThroughELC();
        edgeAppearanceCalculator.setEdgeLabelCalculator(genericEdgeLabelCalculator);
    }

    private GenericEdgeLabelCalculator getPassThroughELC() {
        PassThroughMapping passThroughMapping = new PassThroughMapping((Object)new String(""), "interaction");
        return new GenericEdgeLabelCalculator("Exaple Edge Label PassThru", passThroughMapping);
    }

    private void updateGraph() {
        Graph2DView graph2DView = this.cytoscapeWindow.getGraphView();
        System.out.println("Updating graph...");
        graph2DView.updateView();
        graph2DView.paintImmediately(0, 0, graph2DView.getWidth(), graph2DView.getHeight());
        this.cytoscapeWindow.updateStatusText();
    }

    private void addRandomColor(DiscreteMapping discreteMapping, String string) {
        discreteMapping.put(string, new Color((int)Math.floor(Math.random() * 255.0), (int)Math.floor(Math.random() * 255.0), (int)Math.floor(Math.random() * 255.0)));
    }

    private void addRandomDouble(DiscreteMapping discreteMapping, String string) {
        discreteMapping.put(string, new Double(20.0 + Math.random() * 40.0));
    }

    class RandomlyColorEdgesAction
    extends AbstractAction {
        RandomlyColorEdgesAction() {
            super("Test: Randomly Color Edges");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("Creating calculator...");
            EdgeAppearanceCalculator edgeAppearanceCalculator = new EdgeAppearanceCalculator();
            TestNewMappingsUI.this.addEdgeColorMapping(edgeAppearanceCalculator);
            System.out.println("Gathering graph information...");
            Graph2DView graph2DView = TestNewMappingsUI.this.cytoscapeWindow.getGraphView();
            EdgeCursor edgeCursor = graph2DView.getGraph2D().edges();
            edgeCursor.toFirst();
            System.out.println("Applying calculator to graph...");
            for (int i = 0; i < edgeCursor.size(); ++i) {
                Edge edge = edgeCursor.edge();
                EdgeAppearance edgeAppearance = new EdgeAppearance();
                edgeAppearanceCalculator.calculateEdgeAppearance(edgeAppearance, edge, TestNewMappingsUI.this.network);
                EdgeRealizer edgeRealizer = graph2DView.getGraph2D().getRealizer(edge);
                edgeRealizer.setLineColor(edgeAppearance.getColor());
                edgeCursor.cyclicNext();
            }
            TestNewMappingsUI.this.updateGraph();
        }
    }

    class RandomlySizeNodesByGoLev4Action
    extends AbstractAction {
        RandomlySizeNodesByGoLev4Action() {
            super("Test: Randomly Size Nodes by GO Level 4");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("Creating calculator...");
            NodeAppearanceCalculator nodeAppearanceCalculator = new NodeAppearanceCalculator();
            TestNewMappingsUI.this.addNodeHeightMapping(nodeAppearanceCalculator);
            TestNewMappingsUI.this.addNodeWidthMapping(nodeAppearanceCalculator);
            System.out.println("Gathering graph information...");
            Graph2DView graph2DView = TestNewMappingsUI.this.cytoscapeWindow.getGraphView();
            Node[] nodeArray = graph2DView.getGraph2D().getNodeArray();
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node = nodeArray[i];
                NodeAppearance nodeAppearance = new NodeAppearance();
                nodeAppearanceCalculator.calculateNodeAppearance(nodeAppearance, node, TestNewMappingsUI.this.network);
                NodeRealizer nodeRealizer = graph2DView.getGraph2D().getRealizer(node);
                nodeRealizer.setHeight(nodeAppearance.getHeight());
                nodeRealizer.setWidth(nodeAppearance.getWidth());
            }
            TestNewMappingsUI.this.updateGraph();
        }
    }

    class RandomlyColorNodesByGoLev4Action
    extends AbstractAction {
        RandomlyColorNodesByGoLev4Action() {
            super("Test: Randomly Color Nodes by GO Level 4");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("Creating calculator...");
            NodeAppearanceCalculator nodeAppearanceCalculator = new NodeAppearanceCalculator();
            TestNewMappingsUI.this.addNodeFillColorMapping(nodeAppearanceCalculator);
            System.out.println("Gathering graph information...");
            Graph2DView graph2DView = TestNewMappingsUI.this.cytoscapeWindow.getGraphView();
            Node[] nodeArray = graph2DView.getGraph2D().getNodeArray();
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node = nodeArray[i];
                NodeAppearance nodeAppearance = new NodeAppearance();
                nodeAppearanceCalculator.calculateNodeAppearance(nodeAppearance, node, TestNewMappingsUI.this.network);
                NodeRealizer nodeRealizer = graph2DView.getGraph2D().getRealizer(node);
                nodeRealizer.setFillColor(nodeAppearance.getFillColor());
            }
            TestNewMappingsUI.this.updateGraph();
        }
    }

    class RandomlyColorNodeBordersByGoLev4Action
    extends AbstractAction {
        RandomlyColorNodeBordersByGoLev4Action() {
            super("Test: Randomly Color Node Borders by GO Level 4");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("Creating calculator...");
            NodeAppearanceCalculator nodeAppearanceCalculator = new NodeAppearanceCalculator();
            TestNewMappingsUI.this.addNodeBorderColorMapping(nodeAppearanceCalculator);
            System.out.println("Gathering graph information...");
            Graph2DView graph2DView = TestNewMappingsUI.this.cytoscapeWindow.getGraphView();
            Node[] nodeArray = graph2DView.getGraph2D().getNodeArray();
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node = nodeArray[i];
                NodeAppearance nodeAppearance = new NodeAppearance();
                nodeAppearanceCalculator.calculateNodeAppearance(nodeAppearance, node, TestNewMappingsUI.this.network);
                NodeRealizer nodeRealizer = graph2DView.getGraph2D().getRealizer(node);
                nodeRealizer.setLineColor(nodeAppearance.getBorderColor());
            }
            TestNewMappingsUI.this.updateGraph();
        }
    }

    class SetNodeLabelByGoLev4Action
    extends AbstractAction {
        SetNodeLabelByGoLev4Action() {
            super("Test: Set Node Label by GO Level 4");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("Creating calculator...");
            NodeAppearanceCalculator nodeAppearanceCalculator = new NodeAppearanceCalculator();
            TestNewMappingsUI.this.addDiscreteNodeLabelMapping(nodeAppearanceCalculator);
            System.out.println("Gathering graph information...");
            Graph2DView graph2DView = TestNewMappingsUI.this.cytoscapeWindow.getGraphView();
            Node[] nodeArray = graph2DView.getGraph2D().getNodeArray();
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node = nodeArray[i];
                NodeAppearance nodeAppearance = new NodeAppearance();
                nodeAppearanceCalculator.calculateNodeAppearance(nodeAppearance, node, TestNewMappingsUI.this.network);
                NodeRealizer nodeRealizer = graph2DView.getGraph2D().getRealizer(node);
                nodeRealizer.setLabelText(nodeAppearance.getLabel());
            }
            TestNewMappingsUI.this.updateGraph();
        }
    }

    class SetNodeBorderThicknessByGoLev4Action
    extends AbstractAction {
        SetNodeBorderThicknessByGoLev4Action() {
            super("Test: Set Node Border Thickness by GO Level 4");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("Creating calculator...");
            NodeAppearanceCalculator nodeAppearanceCalculator = new NodeAppearanceCalculator();
            TestNewMappingsUI.this.addNodeLineTypeMapping(nodeAppearanceCalculator);
            System.out.println("Gathering graph information...");
            Graph2DView graph2DView = TestNewMappingsUI.this.cytoscapeWindow.getGraphView();
            Node[] nodeArray = graph2DView.getGraph2D().getNodeArray();
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node = nodeArray[i];
                NodeAppearance nodeAppearance = new NodeAppearance();
                nodeAppearanceCalculator.calculateNodeAppearance(nodeAppearance, node, TestNewMappingsUI.this.network);
                NodeRealizer nodeRealizer = graph2DView.getGraph2D().getRealizer(node);
                nodeRealizer.setLineType(nodeAppearance.getBorderLineType());
            }
            TestNewMappingsUI.this.updateGraph();
        }
    }

    class SetNodeShapeByCanonicalNameAction
    extends AbstractAction {
        SetNodeShapeByCanonicalNameAction() {
            super("Test: Set Node Shape by Canonical Name");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("Creating calculator...");
            NodeAppearanceCalculator nodeAppearanceCalculator = new NodeAppearanceCalculator();
            TestNewMappingsUI.this.addCanonicalNodeShapeMapping(nodeAppearanceCalculator);
            System.out.println("Gathering graph information...");
            Graph2DView graph2DView = TestNewMappingsUI.this.cytoscapeWindow.getGraphView();
            Node[] nodeArray = graph2DView.getGraph2D().getNodeArray();
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node = nodeArray[i];
                NodeAppearance nodeAppearance = new NodeAppearance();
                nodeAppearanceCalculator.calculateNodeAppearance(nodeAppearance, node, TestNewMappingsUI.this.network);
                NodeRealizer nodeRealizer = graph2DView.getGraph2D().getRealizer(node);
                if (!(nodeRealizer instanceof ShapeNodeRealizer)) continue;
                ShapeNodeRealizer shapeNodeRealizer = (ShapeNodeRealizer)nodeRealizer;
                shapeNodeRealizer.setShapeType(nodeAppearance.getShape());
            }
            TestNewMappingsUI.this.updateGraph();
        }
    }

    class SetNodeShapeByGoLev4Action
    extends AbstractAction {
        SetNodeShapeByGoLev4Action() {
            super("Test: Set Node Shape by GO Level 4");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("Creating calculator...");
            NodeAppearanceCalculator nodeAppearanceCalculator = new NodeAppearanceCalculator();
            TestNewMappingsUI.this.addNodeShapeMapping(nodeAppearanceCalculator);
            System.out.println("Gathering graph information...");
            Graph2DView graph2DView = TestNewMappingsUI.this.cytoscapeWindow.getGraphView();
            Node[] nodeArray = graph2DView.getGraph2D().getNodeArray();
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node = nodeArray[i];
                NodeAppearance nodeAppearance = new NodeAppearance();
                nodeAppearanceCalculator.calculateNodeAppearance(nodeAppearance, node, TestNewMappingsUI.this.network);
                NodeRealizer nodeRealizer = graph2DView.getGraph2D().getRealizer(node);
                if (!(nodeRealizer instanceof ShapeNodeRealizer)) continue;
                ShapeNodeRealizer shapeNodeRealizer = (ShapeNodeRealizer)nodeRealizer;
                shapeNodeRealizer.setShapeType(nodeAppearance.getShape());
            }
            TestNewMappingsUI.this.updateGraph();
        }
    }

    class VizPropsUIAction
    extends AbstractAction {
        private VisualMappingManager vmm;
        private VizMapUI vmu;
        private boolean initialized;

        VizPropsUIAction() {
            super("Test: VizPropsUI");
            this.initialized = false;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.initialized) {
                NodeAppearanceCalculator nodeAppearanceCalculator = new NodeAppearanceCalculator();
                TestNewMappingsUI.this.addNodeShapeMapping(nodeAppearanceCalculator);
                TestNewMappingsUI.this.addNodeLineTypeMapping(nodeAppearanceCalculator);
                TestNewMappingsUI.this.addNodeBorderColorMapping(nodeAppearanceCalculator);
                TestNewMappingsUI.this.addNodeFillColorMapping(nodeAppearanceCalculator);
                TestNewMappingsUI.this.addNodeHeightMapping(nodeAppearanceCalculator);
                TestNewMappingsUI.this.addNodeWidthMapping(nodeAppearanceCalculator);
                TestNewMappingsUI.this.addDiscreteNodeLabelMapping(nodeAppearanceCalculator);
                EdgeAppearanceCalculator edgeAppearanceCalculator = new EdgeAppearanceCalculator();
                TestNewMappingsUI.this.addEdgeColorMapping(edgeAppearanceCalculator);
                TestNewMappingsUI.this.addEdgeLineTypeMapping(edgeAppearanceCalculator);
                TestNewMappingsUI.this.addEdgeSourceArrowMapping(edgeAppearanceCalculator);
                TestNewMappingsUI.this.addEdgeTargetArrowMapping(edgeAppearanceCalculator);
                TestNewMappingsUI.this.addDiscreteEdgeLabelMapping(edgeAppearanceCalculator);
                GlobalAppearanceCalculator globalAppearanceCalculator = new GlobalAppearanceCalculator();
                VisualStyle visualStyle = new VisualStyle("mappingsTest", nodeAppearanceCalculator, edgeAppearanceCalculator, globalAppearanceCalculator);
                CalculatorCatalog calculatorCatalog = new CalculatorCatalog();
                this.vmm = new VisualMappingManager(TestNewMappingsUI.this.cytoscapeWindow, calculatorCatalog, visualStyle);
                calculatorCatalog.addNodeLabelCalculator(TestNewMappingsUI.this.getPassThroughNLC());
                calculatorCatalog.addNodeColorCalculator(TestNewMappingsUI.this.getContinuousNFCC());
                calculatorCatalog.addNodeColorCalculator(TestNewMappingsUI.this.getMultipointContinuousNFCC());
                calculatorCatalog.addEdgeLabelCalculator(TestNewMappingsUI.this.getPassThroughELC());
                calculatorCatalog.addNodeSizeCalculator(TestNewMappingsUI.this.getMultipointContinuousNSC());
                Properties properties = new Properties();
                try {
                    FileInputStream fileInputStream = new FileInputStream("vizmap.props");
                    properties.load(fileInputStream);
                    ((InputStream)fileInputStream).close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                CalculatorIO.loadCalculators(properties, calculatorCatalog);
                calculatorCatalog.addMapping("Discrete Mapper", class$cytoscape$visual$mappings$DiscreteMapping == null ? (class$cytoscape$visual$mappings$DiscreteMapping = TestNewMappingsUI.class$("cytoscape.visual.mappings.DiscreteMapping")) : class$cytoscape$visual$mappings$DiscreteMapping);
                calculatorCatalog.addMapping("Continuous Mapper", class$cytoscape$visual$mappings$ContinuousMapping == null ? (class$cytoscape$visual$mappings$ContinuousMapping = TestNewMappingsUI.class$("cytoscape.visual.mappings.ContinuousMapping")) : class$cytoscape$visual$mappings$ContinuousMapping);
                calculatorCatalog.addMapping("Passthrough Mapper", class$cytoscape$visual$mappings$PassThroughMapping == null ? (class$cytoscape$visual$mappings$PassThroughMapping = TestNewMappingsUI.class$("cytoscape.visual.mappings.PassThroughMapping")) : class$cytoscape$visual$mappings$PassThroughMapping);
                this.vmu = new VizMapUI(this.vmm);
                this.initialized = true;
            } else {
                this.vmu.refreshUI();
                this.vmu.show();
            }
        }
    }
}

