/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings;

import cytoscape.GraphObjAttributes;
import cytoscape.dialogs.GridBagGroup;
import cytoscape.dialogs.MiscGB;
import cytoscape.visual.Network;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.parsers.ObjectToString;
import cytoscape.visual.parsers.ValueParser;
import cytoscape.visual.ui.ValueDisplayer;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DiscreteMapping
extends TreeMap
implements ObjectMapping {
    Object defaultObj;
    Class rangeClass;
    String attrName;
    protected byte mapType;
    protected HashSet mappedKeys;
    protected JScrollPane listScrollPane;
    protected JDialog parentDialog;
    protected Vector changeListeners = new Vector(1, 1);
    protected transient ChangeEvent changeEvent;

    public DiscreteMapping(Object object, byte by) throws IllegalArgumentException {
        this(object, null, by);
    }

    public DiscreteMapping(Object object, String string, byte by) {
        this.defaultObj = object;
        this.rangeClass = object.getClass();
        if (by != 0 && by != 1) {
            throw new IllegalArgumentException("Unknown mapping type " + by);
        }
        this.mapType = by;
        if (string != null) {
            this.setControllingAttributeName(string, null, false);
        }
    }

    public Class getRangeClass() {
        return this.rangeClass;
    }

    public Class[] getAcceptedDataClasses() {
        Class[] classArray = new Class[]{String.class, Number.class};
        return classArray;
    }

    public String getControllingAttributeName() {
        return this.attrName;
    }

    public void setControllingAttributeName(String string, Network network, boolean bl) {
        this.attrName = string;
        if (!bl) {
            this.clear();
            this.mappedKeys = new HashSet();
        }
    }

    public void loadKeys(Network network) {
        if (network == null) {
            return;
        }
        GraphObjAttributes graphObjAttributes = this.mapType == 0 ? network.getEdgeAttributes() : network.getNodeAttributes();
        HashMap hashMap = graphObjAttributes.getAttribute(this.attrName);
        if (hashMap == null) {
            return;
        }
        Collection collection = hashMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (v instanceof List) {
                List list = (List)v;
                for (int i = 0; i < list.size(); ++i) {
                    Object e = list.get(i);
                    if (this.mappedKeys.contains(e)) continue;
                    this.mappedKeys.add(e);
                }
                continue;
            }
            if (this.mappedKeys.contains(v)) continue;
            this.mappedKeys.add(v);
        }
    }

    public Object calculateRangeValue(Map map) {
        if (map == null || this.attrName == null) {
            return null;
        }
        Object v = map.get(this.attrName);
        if (v == null) {
            return null;
        }
        try {
            if (v instanceof List) {
                Iterator iterator = ((List)v).iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (this.get(e) == null) continue;
                    return this.get(e);
                }
                return null;
            }
            return this.get(v);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Object put(Object object, Object object2) {
        if (this.rangeClass.isInstance(object2)) {
            return super.put(object, object2);
        }
        String string = "Invalid map entry: Expected class " + this.rangeClass.toString() + ", got class " + object2.getClass().toString();
        throw new ClassCastException(string);
    }

    public void putAll(Map map) {
        if (map == null) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            this.put(k, map.get(k));
        }
    }

    public void applyProperties(Properties properties, String string, ValueParser valueParser) {
        String string2 = string + ".controller";
        String string3 = properties.getProperty(string2);
        if (string3 != null) {
            this.setControllingAttributeName(string3, null, false);
        }
        String string4 = string + ".map.";
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string5 = (String)enumeration.nextElement();
            if (!string5.startsWith(string4)) continue;
            String string6 = properties.getProperty(string5);
            String string7 = string5.substring(string4.length());
            Object object = valueParser.parseStringValue(string6);
            this.put(string7, object);
        }
    }

    public Properties getProperties(String string) {
        Properties properties = new Properties();
        String string2 = string + ".controller";
        String string3 = this.getControllingAttributeName();
        properties.setProperty(string2, string3);
        String string4 = string + ".map.";
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            String string5 = (String)iterator.next();
            Object v = this.get(string5);
            String string6 = ObjectToString.getStringValue(v);
            properties.setProperty(string4 + string5, string6);
        }
        return properties;
    }

    public Object clone() {
        DiscreteMapping discreteMapping = (DiscreteMapping)super.clone();
        if (this.attrName != null) {
            discreteMapping.attrName = new String(this.attrName);
            discreteMapping.mappedKeys = (HashSet)this.mappedKeys.clone();
        }
        return discreteMapping;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    protected void fireStateChanged() {
        for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
            ChangeListener changeListener = (ChangeListener)this.changeListeners.get(i);
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            changeListener.stateChanged(this.changeEvent);
        }
    }

    public JPanel getUI(JDialog jDialog, Network network) {
        this.parentDialog = jDialog;
        this.loadKeys(network);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        if (this.attrName == null || this.mappedKeys == null || this.mappedKeys.size() == 0) {
            jPanel.add(new JLabel("Unknown attribute set!"));
            return jPanel;
        }
        Object[] objectArray = this.mappedKeys.toArray();
        int n = this.mappedKeys.size();
        int n2 = (int)Math.ceil((double)n * 2.0 / 512.0);
        for (int i = 0; i < n2; ++i) {
            GridBagGroup gridBagGroup = new GridBagGroup();
            int n3 = i * 256;
            for (int j = 0; j < 256 && n3 < objectArray.length; ++j, ++n3) {
                Object object = objectArray[n3];
                String string = object.toString();
                JButton jButton = new JButton(string);
                Object v = this.get(object);
                ValueDisplayer valueDisplayer = v == null ? ValueDisplayer.getDisplayFor(jDialog, "Define Discrete Mapping", this.defaultObj) : ValueDisplayer.getDisplayFor(jDialog, "Define Discrete Mapping", this.get(object));
                valueDisplayer.addItemListener(new ValueChangeListener(object));
                jButton.addActionListener(valueDisplayer.getInputListener());
                if (j == n - 1) {
                    MiscGB.insert(gridBagGroup, jButton, 0, j, -1, 0, 1);
                    MiscGB.insert(gridBagGroup, valueDisplayer, 1, j, 0, 0, 1);
                    continue;
                }
                MiscGB.insert(gridBagGroup, jButton, 0, j, -1, 1, 1);
                MiscGB.insert(gridBagGroup, valueDisplayer, 1, j, 0, 1, 1);
            }
            jPanel2.add(gridBagGroup.panel);
        }
        this.resetScrollPane(jPanel, jPanel2);
        return jPanel;
    }

    private void resetScrollPane(JPanel jPanel, JPanel jPanel2) {
        this.listScrollPane = new JScrollPane(jPanel2, 20, 31);
        jPanel.add(this.listScrollPane);
        Dimension dimension = this.listScrollPane.getPreferredSize();
        int n = (int)dimension.getHeight();
        if (n > 200) {
            n = 200;
        }
        this.listScrollPane.setPreferredSize(new Dimension((int)dimension.getWidth() + 10, n));
        if (this.parentDialog != null) {
            this.parentDialog.pack();
            this.parentDialog.validate();
            this.parentDialog.repaint();
        }
    }

    protected class ValueChangeListener
    implements ItemListener {
        private Object key;

        public ValueChangeListener(Object object) {
            this.key = object;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ValueDisplayer valueDisplayer = (ValueDisplayer)itemEvent.getItemSelectable();
            DiscreteMapping.this.put(this.key, valueDisplayer.getValue());
            DiscreteMapping.this.fireStateChanged();
        }
    }
}

