/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings;

import cytoscape.dialogs.GridBagGroup;
import cytoscape.dialogs.MiscGB;
import cytoscape.visual.Network;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.FlatInterpolator;
import cytoscape.visual.mappings.Interpolator;
import cytoscape.visual.mappings.InterpolatorFactory;
import cytoscape.visual.mappings.LinearNumberToColorInterpolator;
import cytoscape.visual.mappings.LinearNumberToNumberInterpolator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.parsers.ObjectToString;
import cytoscape.visual.parsers.ValueParser;
import cytoscape.visual.ui.ValueDisplayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ContinuousMapping
extends TreeMap
implements ObjectMapping {
    Object defaultObj;
    Class rangeClass;
    String attrName;
    Interpolator fInt;
    private ContinuousUI myUI;
    private byte mapType;
    protected Vector changeListeners = new Vector(1, 1);
    protected transient ChangeEvent changeEvent;
    private boolean needsUpdate = false;

    public ContinuousMapping(Object object, byte by) throws IllegalArgumentException {
        this(object, null, null, by);
    }

    public ContinuousMapping(Object object, String string, Interpolator interpolator, byte by) {
        this.rangeClass = object.getClass();
        this.defaultObj = object;
        if (by != 0 && by != 1) {
            throw new IllegalArgumentException("Unknown mapping type " + by);
        }
        if (interpolator == null) {
            interpolator = Color.class.isAssignableFrom(this.rangeClass) ? new LinearNumberToColorInterpolator() : (Number.class.isAssignableFrom(this.rangeClass) ? new LinearNumberToNumberInterpolator() : new FlatInterpolator());
        }
        this.mapType = by;
        this.setControllingAttributeName(string, null, false);
        this.setInterpolator(interpolator);
    }

    public Object clone() {
        ContinuousMapping continuousMapping = (ContinuousMapping)super.clone();
        continuousMapping.attrName = new String(this.attrName);
        return continuousMapping;
    }

    public Class getRangeClass() {
        return this.rangeClass;
    }

    public Class[] getAcceptedDataClasses() {
        Class[] classArray = new Class[]{Number.class};
        return classArray;
    }

    public String getControllingAttributeName() {
        return this.attrName;
    }

    public void setControllingAttributeName(String string, Network network, boolean bl) {
        this.attrName = string;
    }

    public Interpolator getInterpolator() {
        return this.fInt;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.fInt = interpolator;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    protected void fireStateChanged() {
        for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
            ChangeListener changeListener = (ChangeListener)this.changeListeners.get(i);
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            changeListener.stateChanged(this.changeEvent);
        }
    }

    public JPanel getUI(JDialog jDialog, Network network) {
        this.myUI = new ContinuousUI(jDialog, network);
        return this.myUI;
    }

    public Object calculateRangeValue(Map map) {
        if (this.needsUpdate) {
            this.myUI.updateMapper();
        }
        if (map == null || this.attrName == null) {
            return null;
        }
        if (this.size() == 0) {
            return null;
        }
        Object v = map.get(this.attrName);
        if (!(v instanceof Number)) {
            return null;
        }
        return this.getRangeValue((Number)v);
    }

    private Object getRangeValue(Number number) {
        Number number2 = (Number)this.firstKey();
        int n = this.compareValues(number, number2);
        if (n <= 0) {
            BoundaryRangeValues boundaryRangeValues = (BoundaryRangeValues)this.get(number2);
            if (n < 0) {
                return boundaryRangeValues.lesserValue;
            }
            return boundaryRangeValues.equalValue;
        }
        Number number3 = (Number)this.lastKey();
        if (this.compareValues(number, number3) > 0) {
            BoundaryRangeValues boundaryRangeValues = (BoundaryRangeValues)this.get(number3);
            return boundaryRangeValues.greaterValue;
        }
        if (this.fInt == null) {
            return null;
        }
        Set set = this.keySet();
        Iterator iterator = set.iterator();
        Number number4 = (Number)iterator.next();
        Number number5 = null;
        while (iterator.hasNext()) {
            number5 = (Number)iterator.next();
            int n2 = this.compareValues(number, number5);
            if (n2 == 0) {
                BoundaryRangeValues boundaryRangeValues = (BoundaryRangeValues)this.get(number5);
                return boundaryRangeValues.equalValue;
            }
            if (n2 < 0) break;
            number4 = number5;
        }
        BoundaryRangeValues boundaryRangeValues = (BoundaryRangeValues)this.get(number4);
        Object object = boundaryRangeValues.greaterValue;
        BoundaryRangeValues boundaryRangeValues2 = (BoundaryRangeValues)this.get(number5);
        Object object2 = boundaryRangeValues2.lesserValue;
        return this.fInt.getRangeValue(number4, object, number5, object2, number);
    }

    private int compareValues(Number number, Number number2) {
        double d;
        double d2 = number.doubleValue();
        if (d2 < (d = number2.doubleValue())) {
            return -1;
        }
        if (d2 > d) {
            return 1;
        }
        return 0;
    }

    public Object put(Object object, Object object2) {
        if (object == null || object2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = System.getProperty("line.separator");
            stringBuffer.append("Invalid map entry: cannot accept null values" + string);
            stringBuffer.append("key = " + object + ", value = " + object2);
            throw new ClassCastException(stringBuffer.toString());
        }
        if (!(object instanceof Number)) {
            String string = "Invalid map key: expected a Number, got class " + object.getClass().toString();
            throw new ClassCastException(string);
        }
        Double d = new Double(((Number)object).doubleValue());
        if (!(object2 instanceof BoundaryRangeValues)) {
            String string = "Invalid map entry: expected a BoundaryRangeValues object, got class " + object2.getClass().toString();
            throw new ClassCastException(string);
        }
        BoundaryRangeValues boundaryRangeValues = (BoundaryRangeValues)object2;
        this.testClass(boundaryRangeValues.lesserValue, "lesserValue");
        this.testClass(boundaryRangeValues.equalValue, "equalValue");
        this.testClass(boundaryRangeValues.greaterValue, "greaterValue");
        return super.put(d, object2);
    }

    private void testClass(Object object, String string) throws ClassCastException {
        if (!this.rangeClass.isInstance(object)) {
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = System.getProperty("line.separator");
            stringBuffer.append("Invalid map entry: BoundaryRangeValues field " + string);
            stringBuffer.append(":" + string2);
            stringBuffer.append("Expected class " + this.rangeClass.toString());
            stringBuffer.append(", got class " + object.getClass().toString() + string2);
            throw new ClassCastException(stringBuffer.toString());
        }
    }

    public void putAll(Map map) {
        if (map == null) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            this.put(k, map.get(k));
        }
    }

    public void applyProperties(Properties properties, String string, ValueParser valueParser) {
        int n;
        String string2;
        String string3;
        String string4 = string + ".controller";
        String string5 = properties.getProperty(string4);
        if (string5 != null) {
            this.setControllingAttributeName(string5, null, false);
        }
        if ((string3 = properties.getProperty(string2 = string + ".interpolator")) == null) {
            System.err.println("Warning: while parsing attributeMap properties:");
            System.err.println("    no interpolator specified for");
            System.err.println("    continuous key: " + string);
        } else {
            this.setInterpolator(InterpolatorFactory.newInterpolator(string3));
        }
        String string6 = string + ".boundaryvalues";
        String string7 = properties.getProperty(string6);
        if (string7 == null) {
            System.err.println("Warning: while parsing attributeMap properties:");
            System.err.println("    no boundary values specified for");
            System.err.println("    continuous key: " + string);
            return;
        }
        try {
            n = Integer.parseInt(string7);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Error parsing attributeMap properties:");
            System.err.println("    Expected number value for key: " + string7);
            return;
        }
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object object3;
            String string8 = string + ".bv" + Integer.toString(i);
            String string9 = string8 + ".domainvalue";
            String string10 = properties.getProperty(string9);
            if (string10 == null) {
                System.err.println("Error parsing attributeMap properties:");
                System.err.println("    expected value for key: " + string9);
                continue;
            }
            Double d = null;
            try {
                d = Double.valueOf(string10);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Error parsing attributeMap properties:");
                System.err.println("    expected number value for key: " + string9);
                continue;
            }
            BoundaryRangeValues boundaryRangeValues = new BoundaryRangeValues();
            String string11 = string8 + ".lesser";
            String string12 = properties.getProperty(string11);
            boundaryRangeValues.lesserValue = object3 = valueParser.parseStringValue(string12);
            String string13 = string8 + ".equal";
            String string14 = properties.getProperty(string13);
            boundaryRangeValues.equalValue = object2 = valueParser.parseStringValue(string14);
            String string15 = string8 + ".greater";
            String string16 = properties.getProperty(string15);
            boundaryRangeValues.greaterValue = object = valueParser.parseStringValue(string16);
            this.put(d, boundaryRangeValues);
        }
    }

    public Properties getProperties(String string) {
        Properties properties = new Properties();
        String string2 = string + ".controller";
        String string3 = this.getControllingAttributeName();
        properties.setProperty(string2, string3);
        String string4 = string + ".interpolator";
        String string5 = InterpolatorFactory.getName(this.getInterpolator());
        properties.setProperty(string4, string5);
        String string6 = string + ".boundaryvalues";
        int n = this.keySet().size();
        String string7 = Integer.toString(n);
        properties.setProperty(string6, string7);
        int n2 = 0;
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            String string8 = string + ".bv" + n2;
            String string9 = string8 + ".domainvalue";
            Double d = (Double)iterator.next();
            String string10 = d.toString();
            properties.setProperty(string9, string10);
            BoundaryRangeValues boundaryRangeValues = (BoundaryRangeValues)this.get(d);
            String string11 = string8 + ".lesser";
            String string12 = ObjectToString.getStringValue(boundaryRangeValues.lesserValue);
            properties.setProperty(string11, string12);
            String string13 = string8 + ".equal";
            String string14 = ObjectToString.getStringValue(boundaryRangeValues.equalValue);
            properties.setProperty(string13, string14);
            String string15 = string8 + ".greater";
            String string16 = ObjectToString.getStringValue(boundaryRangeValues.greaterValue);
            properties.setProperty(string15, string16);
            ++n2;
        }
        return properties;
    }

    private class ContinuousUI
    extends JPanel {
        private static final int LESSER = 0;
        private static final int EQUAL = 1;
        private static final int GREATER = 2;
        private JDialog parentDialog;
        private ContinuousMapping cm;
        private JLabel spaces = new JLabel(" ");
        private JLabel upperThresholdLabel = new JLabel("Threshold");
        private JLabel upperColorLabel = new JLabel("Appearance");
        private int numberOfPoints = 0;
        private Vector points;
        private Vector lesserButtons;
        private Vector equalButtons;
        private Vector greaterButtons;
        private Vector lesserColors;
        private Vector equalColors;
        private Vector greaterColors;
        private Vector lesserVDs;
        private Vector equalVDs;
        private Vector greaterVDs;
        private Vector pointText;
        private Vector delButtons;
        GridBagGroup g;
        PointTextListener ptl;

        ContinuousUI(JDialog jDialog, Network network) {
            this.parentDialog = jDialog;
            this.cm = ContinuousMapping.this;
            this.initializeVectors();
            this.establishPointsAndAppearances();
            this.createColorPanel();
        }

        private void initializeVectors() {
            this.initializePointVectors();
            this.initializeUIVectors();
        }

        private void initializePointVectors() {
            this.lesserColors = new Vector();
            this.equalColors = new Vector();
            this.greaterColors = new Vector();
            this.points = new Vector();
        }

        private void initializeUIVectors() {
            this.lesserButtons = new Vector();
            this.equalButtons = new Vector();
            this.greaterButtons = new Vector();
            this.lesserVDs = new Vector();
            this.equalVDs = new Vector();
            this.greaterVDs = new Vector();
            this.pointText = new Vector();
            this.delButtons = new Vector();
        }

        private void establishPointsAndAppearances() {
            Iterator iterator = this.cm.keySet().iterator();
            while (iterator.hasNext()) {
                Double d = (Double)iterator.next();
                if (d == null) {
                    return;
                }
                BoundaryRangeValues boundaryRangeValues = (BoundaryRangeValues)this.cm.get(d);
                this.addToPoints(boundaryRangeValues, d);
            }
        }

        private void addToPoints(BoundaryRangeValues boundaryRangeValues, Double d) {
            this.points.add(d);
            this.lesserColors.add(boundaryRangeValues.lesserValue);
            this.equalColors.add(boundaryRangeValues.equalValue);
            this.greaterColors.add(boundaryRangeValues.greaterValue);
            ++this.numberOfPoints;
        }

        private void removeFromPoints(int n) {
            this.lesserColors.removeElementAt(n);
            this.equalColors.removeElementAt(n);
            this.greaterColors.removeElementAt(n);
            this.points.removeElementAt(n);
            --this.numberOfPoints;
        }

        private int getPointCount() {
            return this.numberOfPoints;
        }

        public void setEnabled(boolean bl) {
            for (int i = 0; i < this.getPointCount(); ++i) {
                ((ValueDisplayer)this.lesserVDs.get(i)).setEnabled(bl);
                ((ValueDisplayer)this.equalVDs.get(i)).setEnabled(bl);
                ((ValueDisplayer)this.greaterVDs.get(i)).setEnabled(bl);
                ((JButton)this.lesserButtons.get(i)).setEnabled(bl);
                ((JButton)this.equalButtons.get(i)).setEnabled(bl);
                ((JButton)this.greaterButtons.get(i)).setEnabled(bl);
                ((JTextField)this.pointText.get(i)).setEnabled(bl);
                ((JButton)this.delButtons.get(i)).setEnabled(bl);
            }
        }

        public void updateMapper() {
            int n;
            Iterator iterator = this.cm.keySet().iterator();
            Vector<Double> vector = new Vector<Double>();
            while (iterator.hasNext()) {
                vector.add((Double)iterator.next());
            }
            Iterator iterator2 = vector.iterator();
            while (iterator2.hasNext()) {
                this.cm.remove((Double)iterator2.next());
            }
            for (n = 0; n < this.getPointCount(); ++n) {
                if (n != 0) {
                    this.lesserColors.set(n, this.equalColors.get(n));
                }
                if (n == this.getPointCount() - 1) continue;
                this.greaterColors.set(n, this.equalColors.get(n));
            }
            for (n = 0; n < this.getPointCount(); ++n) {
                BoundaryRangeValues boundaryRangeValues = new BoundaryRangeValues();
                boundaryRangeValues.lesserValue = this.lesserColors.get(n);
                boundaryRangeValues.equalValue = this.equalColors.get(n);
                boundaryRangeValues.greaterValue = this.greaterColors.get(n);
                this.cm.put((Double)this.points.get(n), boundaryRangeValues);
            }
            ContinuousMapping.this.needsUpdate = false;
        }

        public void createColorPanel() {
            this.g = new GridBagGroup();
            this.ptl = new PointTextListener();
            JButton jButton = new JButton("Add Point");
            jButton.addActionListener(new NewPointListener());
            MiscGB.insert(this.g, (Component)jButton, 4, 0);
            for (int i = 0; i < this.getPointCount(); ++i) {
                JTextField jTextField = new JTextField(this.points.get(i).toString(), 6);
                this.pointText.add(jTextField);
                jTextField.addFocusListener(this.ptl);
                MiscGB.insert(this.g, (Component)jTextField, 1, i + 1);
                JButton jButton2 = new JButton("Del");
                this.delButtons.add(jButton2);
                jButton2.addActionListener(new DelListener(i));
                MiscGB.insert(this.g, (Component)jButton2, 0, i + 1);
                this.createButtonAndVD(0, i);
                this.createButtonAndVD(1, i);
                this.createButtonAndVD(2, i);
            }
            this.add(this.g.panel);
        }

        private void createButtonAndVD(int n, int n2) {
            String string;
            Vector vector = null;
            Vector vector2 = null;
            Vector vector3 = null;
            int n3 = 0;
            switch (n) {
                case 0: {
                    vector = this.lesserColors;
                    vector2 = this.lesserVDs;
                    vector3 = this.lesserButtons;
                    string = "Below";
                    n3 = 0;
                    break;
                }
                case 1: {
                    vector = this.equalColors;
                    vector2 = this.equalVDs;
                    vector3 = this.equalButtons;
                    string = "Equal";
                    n3 = 1;
                    break;
                }
                default: {
                    vector = this.greaterColors;
                    vector2 = this.greaterVDs;
                    vector3 = this.greaterButtons;
                    string = "Above";
                    n3 = 2;
                }
            }
            Object e = vector.get(n2);
            ValueDisplayer valueDisplayer = ValueDisplayer.getDisplayFor(this.parentDialog, "Select Appearance", e);
            ValueDisplayerItemListener valueDisplayerItemListener = new ValueDisplayerItemListener(vector, n2);
            valueDisplayer.addItemListener(valueDisplayerItemListener);
            JButton jButton = new JButton(string);
            jButton.addActionListener(valueDisplayer.getInputListener());
            vector2.add(valueDisplayer);
            vector3.add(jButton);
            if (n2 == 0 && n == 0 || n == 1 || n2 == this.getPointCount() - 1 && n == 2) {
                MiscGB.insert(this.g, jButton, 2, n2 + n3, 1, 1, 2);
                MiscGB.insert(this.g, (Component)valueDisplayer, 3, n2 + n3);
            }
        }

        private void redoInterface() {
            this.remove(this.g.panel);
            this.initializeUIVectors();
            this.createColorPanel();
            this.g.panel.validate();
            this.parentDialog.validate();
            this.parentDialog.pack();
            ContinuousMapping.this.needsUpdate = true;
            this.updateMapper();
        }

        private class PointTextListener
        implements FocusListener {
            private PointTextListener() {
            }

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                this.validate();
            }

            private String fixZeroLength(String string, double d, JTextField jTextField) {
                if (string.length() == 0) {
                    String string2 = Double.toString(d);
                    jTextField.setText(string2);
                    return string2;
                }
                return string;
            }

            private String dropNonNumeric(String string) {
                return string.replaceAll("[^0-9+.-]", "");
            }

            private Double makeDouble(String string, double d, double d2, double d3, boolean bl, boolean bl2) {
                double d4;
                try {
                    d4 = Double.parseDouble(string);
                    if (!bl2 && d4 > d3) {
                        d4 = d2;
                    }
                    if (!bl && d4 < d) {
                        d4 = d2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Not actually a double: " + string);
                    d4 = d2;
                }
                return new Double(d4);
            }

            private void validate() {
                for (int i = 0; i < ContinuousUI.this.getPointCount(); ++i) {
                    String string = this.dropNonNumeric(((JTextField)ContinuousUI.this.pointText.get(i)).getText());
                    string = this.fixZeroLength(string, (Double)ContinuousUI.this.points.get(i), (JTextField)ContinuousUI.this.pointText.get(i));
                    double d = (Double)ContinuousUI.this.points.get(i);
                    double d2 = (Double)ContinuousUI.this.points.get(i);
                    double d3 = (Double)ContinuousUI.this.points.get(i);
                    boolean bl = true;
                    boolean bl2 = true;
                    if (i > 0) {
                        d = (Double)ContinuousUI.this.points.get(i - 1);
                        bl = false;
                    }
                    if (i < ContinuousUI.this.getPointCount() - 1) {
                        d3 = (Double)ContinuousUI.this.points.get(i + 1);
                        bl2 = false;
                    }
                    ContinuousUI.this.points.set(i, this.makeDouble(string, d, d2, d3, bl, bl2));
                    ((JTextField)ContinuousUI.this.pointText.get(i)).setText(((Double)ContinuousUI.this.points.get(i)).toString());
                }
                ContinuousMapping.this.needsUpdate = true;
                ContinuousMapping.this.fireStateChanged();
            }
        }

        private class NewPointListener
        implements ActionListener {
            private NewPointListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Double d;
                int n = ContinuousUI.this.getPointCount();
                BoundaryRangeValues boundaryRangeValues = new BoundaryRangeValues();
                if (n > 0) {
                    boundaryRangeValues.lesserValue = ContinuousUI.this.lesserColors.get(n - 1);
                    boundaryRangeValues.equalValue = ContinuousUI.this.equalColors.get(n - 1);
                    boundaryRangeValues.greaterValue = ContinuousUI.this.greaterColors.get(n - 1);
                    d = new Double((Double)ContinuousUI.this.points.get(n - 1));
                } else {
                    boundaryRangeValues.lesserValue = ((ContinuousUI)ContinuousUI.this).ContinuousMapping.this.defaultObj;
                    boundaryRangeValues.equalValue = ((ContinuousUI)ContinuousUI.this).ContinuousMapping.this.defaultObj;
                    boundaryRangeValues.greaterValue = ((ContinuousUI)ContinuousUI.this).ContinuousMapping.this.defaultObj;
                    d = new Double(0.0);
                }
                ContinuousUI.this.addToPoints(boundaryRangeValues, d);
                ContinuousUI.this.redoInterface();
                ContinuousMapping.this.fireStateChanged();
            }
        }

        private class DelListener
        implements ActionListener {
            int index = -1;

            DelListener(int n) {
                this.index = n;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (this.index < 0 || this.index >= ContinuousUI.this.getPointCount()) {
                    return;
                }
                ContinuousUI.this.removeFromPoints(this.index);
                ContinuousUI.this.redoInterface();
                ContinuousMapping.this.fireStateChanged();
            }
        }

        private class ValueDisplayerItemListener
        implements ItemListener {
            Vector v;
            int index;

            ValueDisplayerItemListener(Vector vector, int n) {
                this.v = vector;
                this.index = n;
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                Object object = ((ValueDisplayer)itemEvent.getItemSelectable()).getValue();
                ContinuousMapping.this.needsUpdate = true;
                this.v.set(this.index, object);
                ContinuousMapping.this.fireStateChanged();
            }
        }
    }
}

