/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.calculators;

import cytoscape.visual.Network;
import cytoscape.visual.calculators.EdgeCalculator;
import cytoscape.visual.calculators.EdgeFontSizeCalculator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.parsers.DoubleParser;
import java.util.HashMap;
import java.util.Properties;
import y.base.Edge;

public class GenericEdgeFontSizeCalculator
extends EdgeCalculator
implements EdgeFontSizeCalculator {
    public GenericEdgeFontSizeCalculator(String string, ObjectMapping objectMapping) {
        super(string, objectMapping);
        if (!Number.class.isAssignableFrom(objectMapping.getRangeClass())) {
            throw new ClassCastException("Invalid Calculator: Expected class Font, got " + objectMapping.getRangeClass().toString());
        }
    }

    public GenericEdgeFontSizeCalculator(String string, Properties properties, String string2) {
        super(string, properties, string2, new DoubleParser(), new Double(12.0));
    }

    public float calculateEdgeFontSize(Edge edge, Network network) {
        String string = network.getEdgeAttributes().getCanonicalName(edge);
        HashMap hashMap = network.getEdgeAttributes().getAttributes(string);
        Object object = super.getMapping().calculateRangeValue(hashMap);
        if (object != null) {
            return ((Number)object).floatValue();
        }
        return -1.0f;
    }
}

