/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.calculators;

import cytoscape.GraphObjAttributes;
import cytoscape.dialogs.GridBagGroup;
import cytoscape.dialogs.MiscGB;
import cytoscape.visual.Network;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.mappings.MappingFactory;
import cytoscape.visual.mappings.ObjectMapping;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractCalculator
implements Calculator {
    protected Vector mappings = new Vector(4, 2);
    protected Vector acceptedDataClasses = new Vector(4, 2);
    protected String name;
    private int dupeCount = 0;
    protected List changeListeners = new Vector(1, 1);
    protected transient ChangeEvent changeEvent;

    public AbstractCalculator(String string, ObjectMapping objectMapping) {
        this.name = string;
        this.addMapping(objectMapping);
    }

    public void addMapping(ObjectMapping objectMapping) {
        this.mappings.add(objectMapping);
        this.acceptedDataClasses.add(objectMapping.getAcceptedDataClasses());
        objectMapping.addChangeListener(new MappingListener());
    }

    public ObjectMapping getMapping() {
        return (ObjectMapping)this.mappings.get(0);
    }

    public Vector getMappings() {
        return this.mappings;
    }

    public ObjectMapping getMapping(int n) {
        return (ObjectMapping)this.mappings.get(n);
    }

    public int getDupeCount() {
        return this.dupeCount;
    }

    public Object clone() throws CloneNotSupportedException {
        int n;
        AbstractCalculator abstractCalculator = (AbstractCalculator)super.clone();
        String string = this.dupeCount != 0 ? ((n = this.name.lastIndexOf(new Integer(this.dupeCount).toString())) == -1 ? new String(this.name) : this.name.substring(0, n)) : new String(this.name);
        abstractCalculator.name = string;
        abstractCalculator.mappings = new Vector(this.mappings.size(), 2);
        for (n = 0; n < this.mappings.size(); ++n) {
            ObjectMapping objectMapping = this.getMapping(n);
            abstractCalculator.mappings.add(objectMapping.clone());
        }
        ++abstractCalculator.dupeCount;
        return abstractCalculator;
    }

    public final String toString() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Properties getProperties(String string) {
        String string2 = string + ".mapping";
        ObjectMapping objectMapping = this.getMapping(0);
        return MappingFactory.getProperties(objectMapping, string2);
    }

    void updateAttribute(String string, Network network) {
        this.updateAttribute(string, network, 0);
    }

    void updateAttribute(String string, Network network, ObjectMapping objectMapping) throws IllegalArgumentException {
        int n = this.mappings.indexOf(objectMapping);
        if (n == -1) {
            throw new IllegalArgumentException(objectMapping.getClass().getName() + " " + objectMapping.toString() + " is not contained in calculator " + this.toString());
        }
        this.updateAttribute(string, network, n);
    }

    void updateAttribute(String string, Network network, int n) throws ArrayIndexOutOfBoundsException {
        ObjectMapping objectMapping = (ObjectMapping)this.mappings.get(n);
        objectMapping.setControllingAttributeName(string, network, false);
        this.fireStateChanged();
    }

    public abstract JPanel getUI(JDialog var1, Network var2);

    protected JPanel getUI(GraphObjAttributes graphObjAttributes, JDialog jDialog, Network network) {
        return new CalculatorUI(graphObjAttributes, jDialog, network);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    protected void fireStateChanged() {
        for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
            ChangeListener changeListener = (ChangeListener)this.changeListeners.get(i);
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            changeListener.stateChanged(this.changeEvent);
        }
    }

    protected class CalculatorUI
    extends JPanel {
        protected GridBagGroup myGBG = new GridBagGroup(this);

        public CalculatorUI(GraphObjAttributes graphObjAttributes, JDialog jDialog, Network network) {
            String[] stringArray = graphObjAttributes.getAttributeNames();
            int n = 0;
            int n2 = 0;
            while (n2 < AbstractCalculator.this.mappings.size()) {
                String[] stringArray2;
                Serializable serializable;
                Serializable serializable2;
                MiscGB.insert(this.myGBG, (Component)new JLabel("Map Attribute:", 4), 0, n);
                MiscGB.insert(this.myGBG, Box.createHorizontalStrut(5), 1, n);
                ObjectMapping objectMapping = (ObjectMapping)AbstractCalculator.this.mappings.get(n2);
                Class[] classArray = (Class[])AbstractCalculator.this.acceptedDataClasses.get(n2);
                if (classArray != null) {
                    serializable2 = new Vector(stringArray.length);
                    block1: for (int i = 0; i < stringArray.length; ++i) {
                        serializable = graphObjAttributes.getClass(stringArray[i]);
                        for (int j = 0; j < classArray.length; ++j) {
                            if (!classArray[j].isAssignableFrom((Class<?>)serializable)) continue;
                            ((Vector)serializable2).add(stringArray[i]);
                            continue block1;
                        }
                    }
                    stringArray2 = ((Vector)serializable2).toArray(new String[0]);
                } else {
                    stringArray2 = stringArray;
                }
                serializable2 = new JComboBox<String>(stringArray2);
                String string = objectMapping.getControllingAttributeName();
                ((JComboBox)serializable2).setSelectedIndex(-1);
                ((JComboBox)serializable2).setSelectedItem(string);
                MiscGB.insert(this.myGBG, (Component)serializable2, 2, n, 1, 1, 1, 0, 2);
                serializable = objectMapping.getUI(jDialog, network);
                ((JComboBox)serializable2).addItemListener(new AttributeSelectorListener(jDialog, network, n2, ++n, (JPanel)serializable));
                MiscGB.insert(this.myGBG, (Component)serializable, 0, n, 3, 1, 2, 2, 1);
                ++n2;
                ++n;
            }
        }

        protected class AttributeSelectorListener
        implements ItemListener {
            private Network network;
            private int mapIndex;
            private int yPos;
            private JPanel mapperUI;
            private JDialog parent;

            protected AttributeSelectorListener(JDialog jDialog, Network network, int n, int n2, JPanel jPanel) {
                this.parent = jDialog;
                this.network = network;
                this.mapIndex = n;
                this.yPos = n2;
                this.mapperUI = jPanel;
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                    String string = (String)jComboBox.getSelectedItem();
                    AbstractCalculator.this.updateAttribute(string, this.network, this.mapIndex);
                    CalculatorUI.this.remove(this.mapperUI);
                    this.mapperUI = ((ObjectMapping)((CalculatorUI)CalculatorUI.this).AbstractCalculator.this.mappings.get(this.mapIndex)).getUI(this.parent, this.network);
                    MiscGB.insert(CalculatorUI.this.myGBG, this.mapperUI, 0, this.yPos, 3, 1, 2, 2, 1);
                }
            }
        }
    }

    protected class MappingListener
    implements ChangeListener {
        protected MappingListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            AbstractCalculator.this.fireStateChanged();
        }
    }
}

