/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.EdgeArrowCalculator;
import cytoscape.visual.calculators.EdgeColorCalculator;
import cytoscape.visual.calculators.EdgeFontFaceCalculator;
import cytoscape.visual.calculators.EdgeFontSizeCalculator;
import cytoscape.visual.calculators.EdgeLabelCalculator;
import cytoscape.visual.calculators.EdgeLineTypeCalculator;
import cytoscape.visual.calculators.EdgeToolTipCalculator;
import cytoscape.visual.calculators.NodeColorCalculator;
import cytoscape.visual.calculators.NodeFontFaceCalculator;
import cytoscape.visual.calculators.NodeFontSizeCalculator;
import cytoscape.visual.calculators.NodeLabelCalculator;
import cytoscape.visual.calculators.NodeLineTypeCalculator;
import cytoscape.visual.calculators.NodeShapeCalculator;
import cytoscape.visual.calculators.NodeSizeCalculator;
import cytoscape.visual.calculators.NodeToolTipCalculator;
import java.util.Vector;

public class VisualStyle
implements Cloneable {
    String name = "default";
    NodeAppearanceCalculator nodeAC;
    EdgeAppearanceCalculator edgeAC;
    GlobalAppearanceCalculator globalAC;
    protected int dupeCount = 0;

    public int getDupeCount() {
        return this.dupeCount;
    }

    public Vector checkConflictingCalculator(Calculator calculator) {
        Vector<String> vector = new Vector<String>();
        vector.add(this.name);
        if (calculator instanceof NodeColorCalculator) {
            if (this.nodeAC.getNodeFillColorCalculator() == calculator) {
                vector.add("Node Fill Color");
            }
            if (this.nodeAC.getNodeBorderColorCalculator() == calculator) {
                vector.add("Node Border Color");
            }
        } else if (calculator instanceof NodeLineTypeCalculator) {
            if (this.nodeAC.getNodeLineTypeCalculator() == calculator) {
                vector.add("Node Line Type");
            }
        } else if (calculator instanceof NodeShapeCalculator) {
            if (this.nodeAC.getNodeShapeCalculator() == calculator) {
                vector.add("Node Shape");
            }
        } else if (calculator instanceof NodeSizeCalculator) {
            if (this.nodeAC.getNodeWidthCalculator() == calculator) {
                vector.add("Node Width");
            }
            if (this.nodeAC.getNodeHeightCalculator() == calculator) {
                if (this.nodeAC.getNodeSizeLocked()) {
                    vector.add("Node Size");
                } else {
                    vector.add("Node Height");
                }
            }
        } else if (calculator instanceof NodeLabelCalculator) {
            if (this.nodeAC.getNodeLabelCalculator() == calculator) {
                vector.add("Node Label");
            }
        } else if (calculator instanceof NodeToolTipCalculator) {
            if (this.nodeAC.getNodeToolTipCalculator() == calculator) {
                vector.add("Node Tooltip");
            }
        } else if (calculator instanceof NodeFontFaceCalculator) {
            if (this.nodeAC.getNodeFontFaceCalculator() == calculator) {
                vector.add("Node Font Face");
            }
        } else if (calculator instanceof NodeFontSizeCalculator) {
            if (this.nodeAC.getNodeFontSizeCalculator() == calculator) {
                vector.add("Node Font Size");
            }
        } else if (calculator instanceof EdgeColorCalculator) {
            if (this.edgeAC.getEdgeColorCalculator() == calculator) {
                vector.add("Edge Color");
            }
        } else if (calculator instanceof EdgeLineTypeCalculator) {
            if (this.edgeAC.getEdgeLineTypeCalculator() == calculator) {
                vector.add("Edge Line Type");
            }
        } else if (calculator instanceof EdgeArrowCalculator) {
            if (this.edgeAC.getEdgeSourceArrowCalculator() == calculator) {
                vector.add("Edge Source Arrow");
            }
            if (this.edgeAC.getEdgeTargetArrowCalculator() == calculator) {
                vector.add("Edge Target Arrow");
            }
        } else if (calculator instanceof EdgeLabelCalculator) {
            if (this.edgeAC.getEdgeLabelCalculator() == calculator) {
                vector.add("Edge Label");
            }
        } else if (calculator instanceof EdgeToolTipCalculator) {
            if (this.edgeAC.getEdgeToolTipCalculator() == calculator) {
                vector.add("Edge Tooltip");
            }
        } else if (calculator instanceof EdgeFontFaceCalculator) {
            if (this.edgeAC.getEdgeFontFaceCalculator() == calculator) {
                vector.add("Edge Font Face");
            }
        } else if (calculator instanceof EdgeFontSizeCalculator && this.edgeAC.getEdgeFontSizeCalculator() == calculator) {
            vector.add("Edge Font Size");
        }
        return vector;
    }

    public Object clone() throws CloneNotSupportedException {
        int n;
        VisualStyle visualStyle = (VisualStyle)super.clone();
        String string = this.dupeCount != 0 ? ((n = this.name.lastIndexOf(new Integer(this.dupeCount).toString())) == -1 ? new String(this.name) : this.name.substring(0, n)) : new String(this.name);
        visualStyle.name = string;
        ++visualStyle.dupeCount;
        visualStyle.nodeAC = (NodeAppearanceCalculator)this.nodeAC.clone();
        visualStyle.edgeAC = (EdgeAppearanceCalculator)this.edgeAC.clone();
        visualStyle.globalAC = (GlobalAppearanceCalculator)this.globalAC.clone();
        return visualStyle;
    }

    public VisualStyle(String string) {
        this.setName(string);
        this.setNodeAppearanceCalculator(new NodeAppearanceCalculator());
        this.setEdgeAppearanceCalculator(new EdgeAppearanceCalculator());
        this.setGlobalAppearanceCalculator(new GlobalAppearanceCalculator());
    }

    public VisualStyle(String string, NodeAppearanceCalculator nodeAppearanceCalculator, EdgeAppearanceCalculator edgeAppearanceCalculator, GlobalAppearanceCalculator globalAppearanceCalculator) {
        this.setName(string);
        this.setNodeAppearanceCalculator(nodeAppearanceCalculator);
        this.setEdgeAppearanceCalculator(edgeAppearanceCalculator);
        this.setGlobalAppearanceCalculator(globalAppearanceCalculator);
    }

    public VisualStyle(VisualStyle visualStyle) {
        if (visualStyle == null) {
            return;
        }
        this.setName(visualStyle.getName());
        this.setNodeAppearanceCalculator(new NodeAppearanceCalculator(visualStyle.getNodeAppearanceCalculator()));
        this.setEdgeAppearanceCalculator(new EdgeAppearanceCalculator(visualStyle.getEdgeAppearanceCalculator()));
        this.setGlobalAppearanceCalculator(new GlobalAppearanceCalculator(visualStyle.getGlobalAppearanceCalculator()));
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String setName(String string) {
        String string2 = this.name;
        this.name = string;
        return string2;
    }

    public NodeAppearanceCalculator getNodeAppearanceCalculator() {
        return this.nodeAC;
    }

    public NodeAppearanceCalculator setNodeAppearanceCalculator(NodeAppearanceCalculator nodeAppearanceCalculator) {
        NodeAppearanceCalculator nodeAppearanceCalculator2 = this.nodeAC;
        this.nodeAC = nodeAppearanceCalculator == null ? new NodeAppearanceCalculator() : nodeAppearanceCalculator;
        return nodeAppearanceCalculator2;
    }

    public EdgeAppearanceCalculator getEdgeAppearanceCalculator() {
        return this.edgeAC;
    }

    public EdgeAppearanceCalculator setEdgeAppearanceCalculator(EdgeAppearanceCalculator edgeAppearanceCalculator) {
        EdgeAppearanceCalculator edgeAppearanceCalculator2 = this.edgeAC;
        this.edgeAC = edgeAppearanceCalculator == null ? new EdgeAppearanceCalculator() : edgeAppearanceCalculator;
        return edgeAppearanceCalculator2;
    }

    public GlobalAppearanceCalculator getGlobalAppearanceCalculator() {
        return this.globalAC;
    }

    public GlobalAppearanceCalculator setGlobalAppearanceCalculator(GlobalAppearanceCalculator globalAppearanceCalculator) {
        GlobalAppearanceCalculator globalAppearanceCalculator2 = this.globalAC;
        this.globalAC = globalAppearanceCalculator == null ? new GlobalAppearanceCalculator() : globalAppearanceCalculator;
        return globalAppearanceCalculator2;
    }
}

