/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CytoscapeWindow;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearance;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearance;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.Network;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.ui.VizMapUI;
import java.awt.Color;
import y.base.Edge;
import y.base.Node;
import y.view.DefaultBackgroundRenderer;
import y.view.EdgeLabel;
import y.view.EdgeRealizer;
import y.view.Graph2DView;
import y.view.NodeRealizer;
import y.view.ShapeNodeRealizer;

public class VisualMappingManager {
    Network network;
    CytoscapeWindow cytoscapeWindow;
    CalculatorCatalog catalog;
    VisualStyle visualStyle;

    public VisualMappingManager(CytoscapeWindow cytoscapeWindow, CalculatorCatalog calculatorCatalog, VisualStyle visualStyle) {
        this.cytoscapeWindow = cytoscapeWindow;
        this.network = new Network(cytoscapeWindow);
        this.catalog = calculatorCatalog;
        this.setVisualStyle(visualStyle);
    }

    public Network getNetwork() {
        return this.network;
    }

    public CytoscapeWindow getCytoscapeWindow() {
        return this.cytoscapeWindow;
    }

    public CalculatorCatalog getCalculatorCatalog() {
        return this.catalog;
    }

    public void setCalculatorCatalog(CalculatorCatalog calculatorCatalog) {
        this.catalog = calculatorCatalog;
    }

    public VisualStyle getVisualStyle() {
        return this.visualStyle;
    }

    public VisualStyle setVisualStyle(VisualStyle visualStyle) {
        if (visualStyle != null) {
            VisualStyle visualStyle2 = this.visualStyle;
            this.visualStyle = visualStyle;
            VizMapUI vizMapUI = this.cytoscapeWindow.getVizMapUI();
            if (vizMapUI != null && vizMapUI.getStyleSelector() != null) {
                vizMapUI.getStyleSelector().setVisualStyle(visualStyle);
            }
            return visualStyle2;
        }
        String string = "VisualMappingManager: Attempt to set null VisualStyle";
        this.cytoscapeWindow.getLogger().severe(string);
        return null;
    }

    public VisualStyle setVisualStyle(String string) {
        VisualStyle visualStyle = this.catalog.getVisualStyle(string);
        if (visualStyle != null) {
            return this.setVisualStyle(visualStyle);
        }
        String string2 = "VisualMappingManager: unknown VisualStyle: " + string;
        this.cytoscapeWindow.getLogger().severe(string2);
        return null;
    }

    public void applyNodeFillColor() {
        Graph2DView graph2DView = this.cytoscapeWindow.getGraphView();
        NodeAppearanceCalculator nodeAppearanceCalculator = this.visualStyle.getNodeAppearanceCalculator();
        Node[] nodeArray = graph2DView.getGraph2D().getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            NodeAppearance nodeAppearance = new NodeAppearance();
            nodeAppearanceCalculator.calculateNodeAppearance(nodeAppearance, node, this.network);
            NodeRealizer nodeRealizer = graph2DView.getGraph2D().getRealizer(node);
            nodeRealizer.setFillColor(nodeAppearance.getFillColor());
        }
    }

    public void applyNodeAppearances() {
        Graph2DView graph2DView = this.cytoscapeWindow.getGraphView();
        NodeAppearanceCalculator nodeAppearanceCalculator = this.visualStyle.getNodeAppearanceCalculator();
        Node[] nodeArray = graph2DView.getGraph2D().getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            ShapeNodeRealizer shapeNodeRealizer;
            Node node = nodeArray[i];
            NodeAppearance nodeAppearance = new NodeAppearance();
            nodeAppearanceCalculator.calculateNodeAppearance(nodeAppearance, node, this.network);
            NodeRealizer nodeRealizer = graph2DView.getGraph2D().getRealizer(node);
            nodeRealizer.setFillColor(nodeAppearance.getFillColor());
            nodeRealizer.setLineColor(nodeAppearance.getBorderColor());
            nodeRealizer.setLineType(nodeAppearance.getBorderLineType());
            nodeRealizer.setHeight(nodeAppearance.getHeight());
            nodeRealizer.setWidth(nodeAppearance.getWidth());
            if (nodeRealizer instanceof ShapeNodeRealizer) {
                shapeNodeRealizer = (ShapeNodeRealizer)nodeRealizer;
                shapeNodeRealizer.setShapeType(nodeAppearance.getShape());
            }
            shapeNodeRealizer = nodeRealizer.getLabel();
            shapeNodeRealizer.setText(nodeAppearance.getLabel());
            shapeNodeRealizer.setFont(nodeAppearance.getFont());
        }
    }

    public void applyEdgeAppearances() {
        Graph2DView graph2DView = this.cytoscapeWindow.getGraphView();
        EdgeAppearanceCalculator edgeAppearanceCalculator = this.visualStyle.getEdgeAppearanceCalculator();
        Edge[] edgeArray = graph2DView.getGraph2D().getEdgeArray();
        for (int i = 0; i < edgeArray.length; ++i) {
            Edge edge = edgeArray[i];
            EdgeAppearance edgeAppearance = new EdgeAppearance();
            edgeAppearanceCalculator.calculateEdgeAppearance(edgeAppearance, edge, this.network);
            EdgeRealizer edgeRealizer = graph2DView.getGraph2D().getRealizer(edge);
            edgeRealizer.setLineColor(edgeAppearance.getColor());
            edgeRealizer.setLineType(edgeAppearance.getLineType());
            edgeRealizer.setSourceArrow(edgeAppearance.getSourceArrow());
            edgeRealizer.setTargetArrow(edgeAppearance.getTargetArrow());
            EdgeLabel edgeLabel = edgeRealizer.getLabel();
            edgeRealizer.removeLabel(edgeLabel);
            edgeLabel.setText(edgeAppearance.getLabel());
            edgeLabel.setFont(edgeAppearance.getFont());
            edgeRealizer.addLabel(edgeLabel);
        }
    }

    public void applyGlobalAppearances() {
        Graph2DView graph2DView = this.cytoscapeWindow.getGraphView();
        GlobalAppearanceCalculator globalAppearanceCalculator = this.visualStyle.getGlobalAppearanceCalculator();
        GlobalAppearance globalAppearance = globalAppearanceCalculator.calculateGlobalAppearance(this.network);
        DefaultBackgroundRenderer defaultBackgroundRenderer = (DefaultBackgroundRenderer)graph2DView.getBackgroundRenderer();
        defaultBackgroundRenderer.setColor(globalAppearance.getBackgroundColor());
        NodeRealizer.setSloppySelectionColor((Color)globalAppearance.getSloppySelectionColor());
    }

    public void applyAppearances() {
        this.applyNodeAppearances();
        this.applyEdgeAppearances();
        this.applyGlobalAppearances();
    }
}

