/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.util.Misc;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.CalculatorIO;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.CalculatorFactory;
import cytoscape.visual.calculators.EdgeArrowCalculator;
import cytoscape.visual.calculators.EdgeColorCalculator;
import cytoscape.visual.calculators.EdgeLineTypeCalculator;
import cytoscape.visual.calculators.NodeColorCalculator;
import cytoscape.visual.calculators.NodeLineTypeCalculator;
import cytoscape.visual.calculators.NodeShapeCalculator;
import cytoscape.visual.calculators.NodeSizeCalculator;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class OldStyleCalculatorIO {
    public static String packageHeader = "cytoscape.visual.calculators.";
    public static String calcName = "oldFormat";
    public static boolean loaded = false;
    private static boolean isDone = false;

    public static void checkForCalculators(Properties properties, CalculatorCatalog calculatorCatalog) {
        String string;
        boolean bl = false;
        Object object = properties.propertyNames();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            if (!string.startsWith("node.fillColor.") && !string.startsWith("node.borderColor.") && !string.startsWith("node.selectedColor.") && !string.startsWith("node.borderLinetype.") && !string.startsWith("node.width.") && !string.startsWith("node.height.") && !string.startsWith("node.shape.") && !string.startsWith("edge.color.") && !string.startsWith("background.color.") && !string.startsWith("edge.linetype.") && !string.startsWith("edge.sourceDecoration.") && !string.startsWith("edge.targetDecoration.")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        object = new JFrame();
        string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Your cytoscape.props file contains visual mappings specified");
        stringBuffer.append(" in an old format.").append(string);
        stringBuffer.append("Cytoscape can automatically convert these mappings into the");
        stringBuffer.append(" new format.").append(string);
        stringBuffer.append("Simply specify a name for this group of visual mappings,");
        stringBuffer.append(" and Cytoscape").append(string);
        stringBuffer.append("will save them to your visual mappings");
        stringBuffer.append(" properties file").append(string);
        stringBuffer.append("(default: vizmap.props in your home directory).");
        stringBuffer.append(string).append(string);
        stringBuffer.append("To avoid seeing this message again, please remove all visual");
        stringBuffer.append(" mapping").append(string);
        stringBuffer.append("specifications from your cytoscape.props file.");
        stringBuffer.append(string);
        JTextArea jTextArea = new JTextArea(stringBuffer.toString());
        jTextArea.setEditable(false);
        jTextArea.setBorder(BorderFactory.createLineBorder(Color.WHITE, 10));
        JLabel jLabel = new JLabel("enter a name for these mappings");
        String string2 = calculatorCatalog.checkVisualStyleName(calcName);
        if (!calcName.equals(string2)) {
            calcName = "";
        }
        final JTextField jTextField = new JTextField(calcName, 20);
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                calcName = jTextField.getText();
            }
        });
        Properties properties2 = properties;
        CalculatorCatalog calculatorCatalog2 = calculatorCatalog;
        JButton jButton = new JButton("Convert old visual mapppings");
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(new ActionListener((JFrame)object, calculatorCatalog2, properties2){
            private final /* synthetic */ JFrame val$frame;
            private final /* synthetic */ CalculatorCatalog val$theCatalog;
            private final /* synthetic */ Properties val$theProps;
            {
                this.val$frame = jFrame;
                this.val$theCatalog = calculatorCatalog;
                this.val$theProps = properties;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                calcName = jTextField.getText();
                if (calcName == null || calcName.equals("")) {
                    String string = "You must specify a name for these mappings.";
                    JOptionPane.showMessageDialog(this.val$frame, string, "Bad name", 0);
                } else if (OldStyleCalculatorIO.checkName(this.val$theCatalog)) {
                    OldStyleCalculatorIO.loadCalculators(this.val$theProps, this.val$theCatalog);
                    loaded = true;
                    this.val$frame.dispose();
                    OldStyleCalculatorIO.setDone();
                } else {
                    String string = "The name you entered is already in use. Please choose another.";
                    JOptionPane.showMessageDialog(this.val$frame, string, "Bad name", 0);
                }
            }
        });
        JButton jButton2 = new JButton("Ignore old visual mappings");
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        jButton2.addActionListener(new ActionListener((JFrame)object){
            private final /* synthetic */ JFrame val$frame;
            {
                this.val$frame = jFrame;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.val$frame.dispose();
                OldStyleCalculatorIO.setDone();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(jLabel);
        jPanel.add(jTextField);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        Container container = ((JFrame)object).getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(jTextArea);
        container.add(jPanel);
        container.add(jPanel2);
        ((JFrame)object).getRootPane().setDefaultButton(jButton);
        ((Window)object).addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                OldStyleCalculatorIO.setDone();
            }
        });
        ((Window)object).pack();
        ((Window)object).show();
        while (!isDone) {
        }
    }

    private static void setDone() {
        isDone = true;
    }

    private static boolean checkName(CalculatorCatalog calculatorCatalog) {
        VisualStyle visualStyle = calculatorCatalog.getVisualStyle(calcName);
        return visualStyle == null;
    }

    public static void loadCalculators(Properties properties, CalculatorCatalog calculatorCatalog) {
        String string = "LinearNumberToColorInterpolator";
        String string2 = "LinearNumberToNumberInterpolator";
        String string3 = "FlatInterpolator";
        String string4 = "nodeColorCalculator." + calcName;
        String string5 = packageHeader + "GenericNodeColorCalculator";
        String string6 = NodeColorCalculator.class.getName();
        OldStyleCalculatorIO.loadCalculator(properties, calculatorCatalog, "node.fillColor", string4, string5, string6, string);
        String string7 = string4 + "2";
        OldStyleCalculatorIO.loadCalculator(properties, calculatorCatalog, "node.borderColor", string7, string5, string6, string);
        String string8 = "nodeLineTypeCalculator." + calcName;
        String string9 = packageHeader + "GenericNodeLineTypeCalculator";
        String string10 = NodeLineTypeCalculator.class.getName();
        OldStyleCalculatorIO.loadCalculator(properties, calculatorCatalog, "node.borderLinetype", string8, string9, string10, string3);
        String string11 = "nodeSizeCalculator." + calcName;
        String string12 = packageHeader + "GenericNodeSizeCalculator";
        String string13 = NodeSizeCalculator.class.getName();
        OldStyleCalculatorIO.loadCalculator(properties, calculatorCatalog, "node.width", string11, string12, string13, string2);
        String string14 = string11 + "2";
        OldStyleCalculatorIO.loadCalculator(properties, calculatorCatalog, "node.height", string14, string12, string13, string2);
        String string15 = "nodeShapeCalculator." + calcName;
        String string16 = packageHeader + "GenericNodeShapeCalculator";
        String string17 = NodeShapeCalculator.class.getName();
        OldStyleCalculatorIO.loadCalculator(properties, calculatorCatalog, "node.shape", string15, string16, string17, string3);
        String string18 = "edgeColorCalculator." + calcName;
        String string19 = packageHeader + "GenericEdgeColorCalculator";
        String string20 = EdgeColorCalculator.class.getName();
        OldStyleCalculatorIO.loadCalculator(properties, calculatorCatalog, "edge.color", string18, string19, string20, string);
        String string21 = "edgeLineTypeCalculator." + calcName;
        String string22 = packageHeader + "GenericEdgeLineTypeCalculator";
        String string23 = EdgeLineTypeCalculator.class.getName();
        OldStyleCalculatorIO.loadCalculator(properties, calculatorCatalog, "edge.linetype", string21, string22, string23, string3);
        String string24 = "edgeArrowCalculator." + calcName;
        String string25 = packageHeader + "GenericEdgeArrowCalculator";
        String string26 = EdgeArrowCalculator.class.getName();
        OldStyleCalculatorIO.loadCalculator(properties, calculatorCatalog, "edge.sourceDecoration", string24, string25, string26, string3);
        String string27 = string24 + "2";
        OldStyleCalculatorIO.loadCalculator(properties, calculatorCatalog, "edge.targetDecoration", string27, string25, string26, string3);
        VisualStyle visualStyle = new VisualStyle(calcName);
        VisualStyle visualStyle2 = calculatorCatalog.getVisualStyle("default");
        if (visualStyle2 == null) {
            visualStyle2 = new VisualStyle("default");
            calculatorCatalog.addVisualStyle(visualStyle2);
        }
        OldStyleCalculatorIO.loadNodeAppearanceCalculator(properties, calculatorCatalog, visualStyle, visualStyle2);
        OldStyleCalculatorIO.loadEdgeAppearanceCalculator(properties, calculatorCatalog, visualStyle, visualStyle2);
        OldStyleCalculatorIO.loadGlobalAppearanceCalculator(properties, calculatorCatalog, visualStyle, visualStyle2);
        calculatorCatalog.addVisualStyle(visualStyle);
    }

    private static void loadCalculator(Properties properties, CalculatorCatalog calculatorCatalog, String string, String string2, String string3, String string4, String string5) {
        Properties properties2 = OldStyleCalculatorIO.getNewProperties(properties, string, string2, string3, string5);
        if (properties2 == null) {
            return;
        }
        String string6 = string2.endsWith("2") ? calcName + "2" : calcName;
        Calculator calculator = CalculatorFactory.newCalculator(string6, properties2, string2, string4);
        if (calculator != null) {
            CalculatorIO.removeDuplicate(calculator, calculatorCatalog);
            calculatorCatalog.addCalculator(calculator);
        }
    }

    private static Properties getNewProperties(Properties properties, String string, String string2, String string3, String string4) {
        Properties properties2 = null;
        String string5 = properties.getProperty(string + ".controller");
        if (string5 != null) {
            String string6 = string + "." + string5;
            String string7 = properties.getProperty(string6 + ".type");
            if (string7 == null) {
                return null;
            }
            if (string7.equals("discrete")) {
                properties2 = OldStyleCalculatorIO.translateDiscrete(properties, string6, string2);
            } else if (string7.equals("continuous")) {
                properties2 = OldStyleCalculatorIO.translateContinuous(properties, string6, string2);
                properties2.setProperty(string2 + ".mapping.interpolator", string4);
            } else {
                return null;
            }
            properties2.setProperty(string2 + ".class", string3);
            properties2.setProperty(string2 + ".mapping.controller", string5);
        }
        return properties2;
    }

    private static Properties translateDiscrete(Properties properties, String string, String string2) {
        Properties properties2 = new Properties();
        properties2.setProperty(string2 + ".mapping.type", "DiscreteMapping");
        String string3 = string + ".map.";
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (!string4.startsWith(string3)) continue;
            String string5 = string4.substring(string3.length());
            String string6 = string2 + ".mapping.map." + string5;
            String string7 = properties.getProperty(string4);
            properties2.setProperty(string6, string7);
        }
        return properties2;
    }

    private static Properties translateContinuous(Properties properties, String string, String string2) {
        int n;
        Properties properties2 = new Properties();
        properties2.setProperty(string2 + ".mapping.type", "ContinuousMapping");
        String string3 = string + ".boundaryvalues";
        String string4 = properties.getProperty(string3);
        properties2.setProperty(string2 + ".mapping.boundaryvalues", string4);
        try {
            n = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            String string5 = string + ".bv" + Integer.toString(i);
            String string6 = string2 + ".mapping.bv" + Integer.toString(i);
            String string7 = string5 + ".domainvalue";
            String string8 = properties.getProperty(string7);
            properties2.setProperty(string6 + ".domainvalue", string8);
            String string9 = properties.getProperty(string5 + ".lesser");
            properties2.setProperty(string6 + ".lesser", string9);
            String string10 = properties.getProperty(string5 + ".equal");
            properties2.setProperty(string6 + ".equal", string10);
            String string11 = properties.getProperty(string5 + ".greater");
            properties2.setProperty(string6 + ".greater", string11);
        }
        return properties2;
    }

    private static void loadNodeAppearanceCalculator(Properties properties, CalculatorCatalog calculatorCatalog, VisualStyle visualStyle, VisualStyle visualStyle2) {
        NodeShapeCalculator nodeShapeCalculator;
        NodeSizeCalculator nodeSizeCalculator;
        NodeSizeCalculator nodeSizeCalculator2;
        NodeLineTypeCalculator nodeLineTypeCalculator;
        NodeColorCalculator nodeColorCalculator;
        NodeColorCalculator nodeColorCalculator2;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        NodeAppearanceCalculator nodeAppearanceCalculator = visualStyle.getNodeAppearanceCalculator();
        NodeAppearanceCalculator nodeAppearanceCalculator2 = visualStyle2.getNodeAppearanceCalculator();
        nodeAppearanceCalculator.setNodeLabelCalculator(nodeAppearanceCalculator2.getNodeLabelCalculator());
        String string6 = properties.getProperty("node.fillColor.default");
        if (string6 != null) {
            nodeAppearanceCalculator.setDefaultNodeFillColor(Misc.parseRGBText(string6));
            nodeAppearanceCalculator2.setDefaultNodeFillColor(Misc.parseRGBText(string6));
        }
        if ((string5 = properties.getProperty("node.borderColor.default")) != null) {
            nodeAppearanceCalculator.setDefaultNodeBorderColor(Misc.parseRGBText(string5));
            nodeAppearanceCalculator2.setDefaultNodeBorderColor(Misc.parseRGBText(string5));
        }
        if ((string4 = properties.getProperty("node.borderLinetype.default")) != null) {
            nodeAppearanceCalculator.setDefaultNodeLineType(Misc.parseLineTypeText(string4));
            nodeAppearanceCalculator2.setDefaultNodeLineType(Misc.parseLineTypeText(string4));
        }
        if ((string3 = properties.getProperty("node.width.default")) != null) {
            try {
                double d = Double.parseDouble(string3);
                nodeAppearanceCalculator.setDefaultNodeWidth(d);
                nodeAppearanceCalculator2.setDefaultNodeWidth(d);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string2 = properties.getProperty("node.height.default")) != null) {
            try {
                double d = Double.parseDouble(string2);
                nodeAppearanceCalculator.setDefaultNodeHeight(d);
                nodeAppearanceCalculator2.setDefaultNodeHeight(d);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = properties.getProperty("node.shape.default")) != null) {
            nodeAppearanceCalculator.setDefaultNodeShape(Misc.parseNodeShapeText(string));
            nodeAppearanceCalculator2.setDefaultNodeShape(Misc.parseNodeShapeText(string));
        }
        if ((nodeColorCalculator2 = calculatorCatalog.getNodeColorCalculator(calcName)) != null) {
            nodeAppearanceCalculator.setNodeFillColorCalculator(nodeColorCalculator2);
            nodeAppearanceCalculator2.setNodeFillColorCalculator(nodeColorCalculator2);
        }
        if ((nodeColorCalculator = calculatorCatalog.getNodeColorCalculator(calcName + "2")) != null) {
            nodeAppearanceCalculator.setNodeBorderColorCalculator(nodeColorCalculator);
            nodeAppearanceCalculator2.setNodeBorderColorCalculator(nodeColorCalculator);
        }
        if ((nodeLineTypeCalculator = calculatorCatalog.getNodeLineTypeCalculator(calcName)) != null) {
            nodeAppearanceCalculator.setNodeLineTypeCalculator(nodeLineTypeCalculator);
            nodeAppearanceCalculator2.setNodeLineTypeCalculator(nodeLineTypeCalculator);
        }
        if ((nodeSizeCalculator2 = calculatorCatalog.getNodeSizeCalculator(calcName)) != null) {
            nodeAppearanceCalculator.setNodeWidthCalculator(nodeSizeCalculator2);
            nodeAppearanceCalculator2.setNodeWidthCalculator(nodeSizeCalculator2);
        }
        if ((nodeSizeCalculator = calculatorCatalog.getNodeSizeCalculator(calcName + "2")) != null) {
            nodeAppearanceCalculator.setNodeHeightCalculator(nodeSizeCalculator);
            nodeAppearanceCalculator2.setNodeHeightCalculator(nodeSizeCalculator);
        }
        if ((nodeShapeCalculator = calculatorCatalog.getNodeShapeCalculator(calcName)) != null) {
            nodeAppearanceCalculator.setNodeShapeCalculator(nodeShapeCalculator);
            nodeAppearanceCalculator2.setNodeShapeCalculator(nodeShapeCalculator);
        }
    }

    private static void loadEdgeAppearanceCalculator(Properties properties, CalculatorCatalog calculatorCatalog, VisualStyle visualStyle, VisualStyle visualStyle2) {
        EdgeArrowCalculator edgeArrowCalculator;
        EdgeArrowCalculator edgeArrowCalculator2;
        EdgeLineTypeCalculator edgeLineTypeCalculator;
        EdgeColorCalculator edgeColorCalculator;
        String string;
        String string2;
        String string3;
        EdgeAppearanceCalculator edgeAppearanceCalculator = visualStyle.getEdgeAppearanceCalculator();
        EdgeAppearanceCalculator edgeAppearanceCalculator2 = visualStyle2.getEdgeAppearanceCalculator();
        String string4 = properties.getProperty("edge.color.default");
        if (string4 != null) {
            edgeAppearanceCalculator.setDefaultEdgeColor(Misc.parseRGBText(string4));
            edgeAppearanceCalculator2.setDefaultEdgeColor(Misc.parseRGBText(string4));
        }
        if ((string3 = properties.getProperty("edge.linetype.default")) != null) {
            edgeAppearanceCalculator.setDefaultEdgeLineType(Misc.parseLineTypeText(string3));
            edgeAppearanceCalculator2.setDefaultEdgeLineType(Misc.parseLineTypeText(string3));
        }
        if ((string2 = properties.getProperty("edge.sourceDecoration.default")) != null) {
            edgeAppearanceCalculator.setDefaultEdgeSourceArrow(Misc.parseArrowText(string2));
            edgeAppearanceCalculator2.setDefaultEdgeSourceArrow(Misc.parseArrowText(string2));
        }
        if ((string = properties.getProperty("edge.targetDecoration.default")) != null) {
            edgeAppearanceCalculator.setDefaultEdgeTargetArrow(Misc.parseArrowText(string));
            edgeAppearanceCalculator2.setDefaultEdgeTargetArrow(Misc.parseArrowText(string));
        }
        if ((edgeColorCalculator = calculatorCatalog.getEdgeColorCalculator(calcName)) != null) {
            edgeAppearanceCalculator.setEdgeColorCalculator(edgeColorCalculator);
            edgeAppearanceCalculator2.setEdgeColorCalculator(edgeColorCalculator);
        }
        if ((edgeLineTypeCalculator = calculatorCatalog.getEdgeLineTypeCalculator(calcName)) != null) {
            edgeAppearanceCalculator.setEdgeLineTypeCalculator(edgeLineTypeCalculator);
            edgeAppearanceCalculator2.setEdgeLineTypeCalculator(edgeLineTypeCalculator);
        }
        if ((edgeArrowCalculator2 = calculatorCatalog.getEdgeArrowCalculator(calcName)) != null) {
            edgeAppearanceCalculator.setEdgeSourceArrowCalculator(edgeArrowCalculator2);
            edgeAppearanceCalculator2.setEdgeSourceArrowCalculator(edgeArrowCalculator2);
        }
        if ((edgeArrowCalculator = calculatorCatalog.getEdgeArrowCalculator(calcName + "2")) != null) {
            edgeAppearanceCalculator.setEdgeTargetArrowCalculator(edgeArrowCalculator);
            edgeAppearanceCalculator2.setEdgeTargetArrowCalculator(edgeArrowCalculator);
        }
    }

    private static void loadGlobalAppearanceCalculator(Properties properties, CalculatorCatalog calculatorCatalog, VisualStyle visualStyle, VisualStyle visualStyle2) {
        String string;
        GlobalAppearanceCalculator globalAppearanceCalculator = visualStyle.getGlobalAppearanceCalculator();
        GlobalAppearanceCalculator globalAppearanceCalculator2 = visualStyle2.getGlobalAppearanceCalculator();
        String string2 = properties.getProperty("background.color");
        if (string2 != null) {
            globalAppearanceCalculator.setDefaultBackgroundColor(Misc.parseRGBText(string2));
            globalAppearanceCalculator2.setDefaultBackgroundColor(Misc.parseRGBText(string2));
        }
        if ((string = properties.getProperty("node.selectedColor")) != null) {
            globalAppearanceCalculator.setDefaultSloppySelectionColor(Misc.parseRGBText(string));
            globalAppearanceCalculator2.setDefaultSloppySelectionColor(Misc.parseRGBText(string));
        }
    }
}

