/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.GraphObjAttributes;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.Network;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.NodeColorCalculator;
import cytoscape.visual.calculators.NodeFontFaceCalculator;
import cytoscape.visual.calculators.NodeFontSizeCalculator;
import cytoscape.visual.calculators.NodeLabelCalculator;
import cytoscape.visual.calculators.NodeLineTypeCalculator;
import cytoscape.visual.calculators.NodeShapeCalculator;
import cytoscape.visual.calculators.NodeSizeCalculator;
import cytoscape.visual.calculators.NodeToolTipCalculator;
import cytoscape.visual.parsers.ColorParser;
import cytoscape.visual.parsers.DoubleParser;
import cytoscape.visual.parsers.FontParser;
import cytoscape.visual.parsers.LineTypeParser;
import cytoscape.visual.parsers.NodeShapeParser;
import cytoscape.visual.parsers.ObjectToString;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.util.Properties;
import y.base.Node;
import y.view.LineType;

public class NodeAppearanceCalculator
implements Cloneable {
    Color defaultNodeFillColor = Color.WHITE;
    Color defaultNodeBorderColor = Color.BLACK;
    LineType defaultNodeLineType = LineType.LINE_1;
    byte defaultNodeShape = 0;
    double defaultNodeWidth = 70.0;
    double defaultNodeHeight = 30.0;
    String defaultNodeLabel = "";
    String defaultNodeToolTip = "";
    Font defaultNodeFont = new Font(null, 0, 12);
    private boolean nodeSizeLocked = true;
    public static final String nodeFillColorBypass = "node.fillColor";
    public static final String nodeBorderColorBypass = "node.borderColor";
    public static final String nodeLineTypeBypass = "node.lineType";
    public static final String nodeShapeBypass = "node.shape";
    public static final String nodeWidthBypass = "node.width";
    public static final String nodeHeightBypass = "node.height";
    public static final String nodeLabelBypass = "node.label";
    public static final String nodeToolTipBypass = "node.toolTip";
    public static final String nodeFontBypass = "node.font";
    NodeColorCalculator nodeFillColorCalculator;
    NodeColorCalculator nodeBorderColorCalculator;
    NodeLineTypeCalculator nodeLineTypeCalculator;
    NodeShapeCalculator nodeShapeCalculator;
    NodeSizeCalculator nodeWidthCalculator;
    NodeSizeCalculator nodeHeightCalculator;
    NodeLabelCalculator nodeLabelCalculator;
    NodeToolTipCalculator nodeToolTipCalculator;
    NodeFontFaceCalculator nodeFontFaceCalculator;
    NodeFontSizeCalculator nodeFontSizeCalculator;

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error cloning!");
        }
        return object;
    }

    public NodeAppearanceCalculator() {
    }

    public NodeAppearanceCalculator(String string, Properties properties, String string2, CalculatorCatalog calculatorCatalog) {
        this.applyProperties(string, properties, string2, calculatorCatalog);
    }

    public NodeAppearanceCalculator(NodeAppearanceCalculator nodeAppearanceCalculator) {
        if (nodeAppearanceCalculator == null) {
            return;
        }
        this.setDefaultNodeFillColor(nodeAppearanceCalculator.getDefaultNodeFillColor());
        this.setDefaultNodeBorderColor(nodeAppearanceCalculator.getDefaultNodeBorderColor());
        this.setDefaultNodeLineType(nodeAppearanceCalculator.getDefaultNodeLineType());
        this.setDefaultNodeShape(nodeAppearanceCalculator.getDefaultNodeShape());
        this.setDefaultNodeWidth(nodeAppearanceCalculator.getDefaultNodeWidth());
        this.setDefaultNodeHeight(nodeAppearanceCalculator.getDefaultNodeHeight());
        this.setDefaultNodeLabel(nodeAppearanceCalculator.getDefaultNodeLabel());
        this.setDefaultNodeToolTip(nodeAppearanceCalculator.getDefaultNodeToolTip());
        this.setDefaultNodeFont(nodeAppearanceCalculator.getDefaultNodeFont());
        this.setNodeSizeLocked(nodeAppearanceCalculator.getNodeSizeLocked());
        this.setNodeFillColorCalculator(nodeAppearanceCalculator.getNodeFillColorCalculator());
        this.setNodeBorderColorCalculator(nodeAppearanceCalculator.getNodeBorderColorCalculator());
        this.setNodeLineTypeCalculator(nodeAppearanceCalculator.getNodeLineTypeCalculator());
        this.setNodeShapeCalculator(nodeAppearanceCalculator.getNodeShapeCalculator());
        this.setNodeWidthCalculator(nodeAppearanceCalculator.getNodeWidthCalculator());
        this.setNodeHeightCalculator(nodeAppearanceCalculator.getNodeHeightCalculator());
        this.setNodeLabelCalculator(nodeAppearanceCalculator.getNodeLabelCalculator());
        this.setNodeToolTipCalculator(nodeAppearanceCalculator.getNodeToolTipCalculator());
        this.setNodeFontFaceCalculator(nodeAppearanceCalculator.getNodeFontFaceCalculator());
        this.setNodeFontSizeCalculator(nodeAppearanceCalculator.getNodeFontSizeCalculator());
    }

    public NodeAppearance calculateNodeAppearance(Node node, Network network) {
        NodeAppearance nodeAppearance = new NodeAppearance();
        this.calculateNodeAppearance(nodeAppearance, node, network);
        return nodeAppearance;
    }

    public void calculateNodeAppearance(NodeAppearance nodeAppearance, Node node, Network network) {
        nodeAppearance.setFillColor(this.calculateNodeFillColor(node, network));
        nodeAppearance.setBorderColor(this.calculateNodeBorderColor(node, network));
        nodeAppearance.setBorderLineType(this.calculateNodeLineType(node, network));
        nodeAppearance.setShape(this.calculateNodeShape(node, network));
        if (this.nodeSizeLocked) {
            double d = this.calculateNodeHeight(node, network);
            nodeAppearance.setWidth(d);
            nodeAppearance.setHeight(d);
        } else {
            nodeAppearance.setWidth(this.calculateNodeWidth(node, network));
            nodeAppearance.setHeight(this.calculateNodeHeight(node, network));
        }
        nodeAppearance.setLabel(this.calculateNodeLabel(node, network));
        nodeAppearance.setToolTip(this.calculateNodeToolTip(node, network));
        nodeAppearance.setFont(this.calculateNodeFont(node, network));
    }

    public Color getDefaultNodeFillColor() {
        return this.defaultNodeFillColor;
    }

    public void setDefaultNodeFillColor(Color color) {
        if (color != null) {
            this.defaultNodeFillColor = color;
        }
    }

    public NodeColorCalculator getNodeFillColorCalculator() {
        return this.nodeFillColorCalculator;
    }

    public void setNodeFillColorCalculator(NodeColorCalculator nodeColorCalculator) {
        this.nodeFillColorCalculator = nodeColorCalculator;
    }

    public Color calculateNodeFillColor(Node node, Network network) {
        Color color;
        String string;
        if (node == null || network == null) {
            return this.defaultNodeFillColor;
        }
        GraphObjAttributes graphObjAttributes = network.getNodeAttributes();
        Object object = graphObjAttributes.getValue(nodeFillColorBypass, string = graphObjAttributes.getCanonicalName(node));
        if (object instanceof Color) {
            return (Color)object;
        }
        if (object instanceof String && (color = new ColorParser().parseColor((String)object)) != null) {
            return color;
        }
        if (this.nodeFillColorCalculator == null) {
            return this.defaultNodeFillColor;
        }
        color = this.nodeFillColorCalculator.calculateNodeColor(node, network);
        return color == null ? this.defaultNodeFillColor : color;
    }

    public Color getDefaultNodeBorderColor() {
        return this.defaultNodeBorderColor;
    }

    public void setDefaultNodeBorderColor(Color color) {
        if (color != null) {
            this.defaultNodeBorderColor = color;
        }
    }

    public NodeColorCalculator getNodeBorderColorCalculator() {
        return this.nodeBorderColorCalculator;
    }

    public void setNodeBorderColorCalculator(NodeColorCalculator nodeColorCalculator) {
        this.nodeBorderColorCalculator = nodeColorCalculator;
    }

    public Color calculateNodeBorderColor(Node node, Network network) {
        Color color;
        String string;
        if (node == null || network == null) {
            return this.defaultNodeBorderColor;
        }
        GraphObjAttributes graphObjAttributes = network.getNodeAttributes();
        Object object = graphObjAttributes.getValue(nodeBorderColorBypass, string = graphObjAttributes.getCanonicalName(node));
        if (object instanceof Color) {
            return (Color)object;
        }
        if (object instanceof String && (color = new ColorParser().parseColor((String)object)) != null) {
            return color;
        }
        if (this.nodeBorderColorCalculator == null) {
            return this.defaultNodeBorderColor;
        }
        color = this.nodeBorderColorCalculator.calculateNodeColor(node, network);
        return color == null ? this.defaultNodeBorderColor : color;
    }

    public LineType getDefaultNodeLineType() {
        return this.defaultNodeLineType;
    }

    public void setDefaultNodeLineType(LineType lineType) {
        if (lineType != null) {
            this.defaultNodeLineType = lineType;
        }
    }

    public NodeLineTypeCalculator getNodeLineTypeCalculator() {
        return this.nodeLineTypeCalculator;
    }

    public void setNodeLineTypeCalculator(NodeLineTypeCalculator nodeLineTypeCalculator) {
        this.nodeLineTypeCalculator = nodeLineTypeCalculator;
    }

    public LineType calculateNodeLineType(Node node, Network network) {
        LineType lineType;
        String string;
        if (node == null || network == null) {
            return this.defaultNodeLineType;
        }
        GraphObjAttributes graphObjAttributes = network.getNodeAttributes();
        Object object = graphObjAttributes.getValue(nodeLineTypeBypass, string = graphObjAttributes.getCanonicalName(node));
        if (object instanceof LineType) {
            return (LineType)object;
        }
        if (object instanceof String && (lineType = new LineTypeParser().parseLineType((String)object)) != null) {
            return lineType;
        }
        if (this.nodeLineTypeCalculator == null) {
            return this.defaultNodeLineType;
        }
        lineType = this.nodeLineTypeCalculator.calculateNodeLineType(node, network);
        return lineType == null ? this.defaultNodeLineType : lineType;
    }

    public byte getDefaultNodeShape() {
        return this.defaultNodeShape;
    }

    public void setDefaultNodeShape(byte by) {
        if (this.isValidShape(by)) {
            this.defaultNodeShape = by;
        }
    }

    public NodeShapeCalculator getNodeShapeCalculator() {
        return this.nodeShapeCalculator;
    }

    public void setNodeShapeCalculator(NodeShapeCalculator nodeShapeCalculator) {
        this.nodeShapeCalculator = nodeShapeCalculator;
    }

    public byte calculateNodeShape(Node node, Network network) {
        Byte by;
        byte by2;
        byte by3;
        String string;
        if (node == null || network == null) {
            return this.defaultNodeShape;
        }
        GraphObjAttributes graphObjAttributes = network.getNodeAttributes();
        Object object = graphObjAttributes.getValue(nodeShapeBypass, string = graphObjAttributes.getCanonicalName(node));
        if (object instanceof Byte && this.isValidShape(by3 = ((Byte)object).byteValue())) {
            return by3;
        }
        if (object instanceof String && this.isValidShape(by2 = (by = new NodeShapeParser().parseNodeShape((String)object)).byteValue())) {
            return by2;
        }
        if (this.nodeShapeCalculator == null) {
            return this.defaultNodeShape;
        }
        by3 = this.nodeShapeCalculator.calculateNodeShape(node, network);
        return this.isValidShape(by3) ? by3 : this.defaultNodeShape;
    }

    public boolean isValidShape(byte by) {
        if (by == 0) {
            return true;
        }
        if (by == 1) {
            return true;
        }
        if (by == 6) {
            return true;
        }
        if (by == 9) {
            return true;
        }
        if (by == 10) {
            return true;
        }
        if (by == 5) {
            return true;
        }
        if (by == 3) {
            return true;
        }
        if (by == 8) {
            return true;
        }
        if (by == 2) {
            return true;
        }
        if (by == 4) {
            return true;
        }
        return by == 7;
    }

    public double getDefaultNodeWidth() {
        return this.defaultNodeWidth;
    }

    public void setDefaultNodeWidth(double d) {
        if (d > 0.0) {
            this.defaultNodeWidth = d;
        }
    }

    public NodeSizeCalculator getNodeWidthCalculator() {
        return this.nodeWidthCalculator;
    }

    public void setNodeWidthCalculator(NodeSizeCalculator nodeSizeCalculator) {
        this.nodeWidthCalculator = nodeSizeCalculator;
    }

    public double calculateNodeWidth(Node node, Network network) {
        Double d;
        String string;
        if (node == null || network == null) {
            return this.defaultNodeWidth;
        }
        GraphObjAttributes graphObjAttributes = network.getNodeAttributes();
        Object object = graphObjAttributes.getValue(nodeWidthBypass, string = graphObjAttributes.getCanonicalName(node));
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof String && (d = new DoubleParser().parseDouble((String)object)) != null) {
            return d;
        }
        if (this.nodeWidthCalculator == null) {
            return this.defaultNodeWidth;
        }
        double d2 = this.nodeWidthCalculator.calculateNodeSize(node, network);
        return d2 <= 0.0 ? this.defaultNodeWidth : d2;
    }

    public double getDefaultNodeHeight() {
        return this.defaultNodeHeight;
    }

    public void setDefaultNodeHeight(double d) {
        if (d > 0.0) {
            this.defaultNodeHeight = d;
        }
    }

    public NodeSizeCalculator getNodeHeightCalculator() {
        return this.nodeHeightCalculator;
    }

    public void setNodeHeightCalculator(NodeSizeCalculator nodeSizeCalculator) {
        this.nodeHeightCalculator = nodeSizeCalculator;
    }

    public double calculateNodeHeight(Node node, Network network) {
        Double d;
        String string;
        if (node == null || network == null) {
            return this.defaultNodeHeight;
        }
        GraphObjAttributes graphObjAttributes = network.getNodeAttributes();
        Object object = graphObjAttributes.getValue(nodeHeightBypass, string = graphObjAttributes.getCanonicalName(node));
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof String && (d = new DoubleParser().parseDouble((String)object)) != null) {
            return d;
        }
        if (this.nodeHeightCalculator == null) {
            return this.defaultNodeHeight;
        }
        double d2 = this.nodeHeightCalculator.calculateNodeSize(node, network);
        return d2 <= 0.0 ? this.defaultNodeHeight : d2;
    }

    public boolean getNodeSizeLocked() {
        return this.nodeSizeLocked;
    }

    public void setNodeSizeLocked(boolean bl) {
        this.nodeSizeLocked = bl;
    }

    public String getDefaultNodeLabel() {
        return this.defaultNodeLabel;
    }

    public void setDefaultNodeLabel(String string) {
        if (string != null) {
            this.defaultNodeLabel = string;
        }
    }

    public NodeLabelCalculator getNodeLabelCalculator() {
        return this.nodeLabelCalculator;
    }

    public void setNodeLabelCalculator(NodeLabelCalculator nodeLabelCalculator) {
        this.nodeLabelCalculator = nodeLabelCalculator;
    }

    public String calculateNodeLabel(Node node, Network network) {
        String string;
        if (node == null || network == null) {
            return this.defaultNodeLabel;
        }
        GraphObjAttributes graphObjAttributes = network.getNodeAttributes();
        Object object = graphObjAttributes.getValue(nodeLabelBypass, string = graphObjAttributes.getCanonicalName(node));
        if (object instanceof String) {
            return (String)object;
        }
        if (this.nodeLabelCalculator == null) {
            return this.defaultNodeLabel;
        }
        String string2 = this.nodeLabelCalculator.calculateNodeLabel(node, network);
        return string2 == null ? this.defaultNodeLabel : string2;
    }

    public String getDefaultNodeToolTip() {
        return this.defaultNodeToolTip;
    }

    public void setDefaultNodeToolTip(String string) {
        if (string != null) {
            this.defaultNodeToolTip = string;
        }
    }

    public NodeToolTipCalculator getNodeToolTipCalculator() {
        return this.nodeToolTipCalculator;
    }

    public void setNodeToolTipCalculator(NodeToolTipCalculator nodeToolTipCalculator) {
        this.nodeToolTipCalculator = nodeToolTipCalculator;
    }

    public String calculateNodeToolTip(Node node, Network network) {
        String string;
        if (node == null || network == null) {
            return this.defaultNodeToolTip;
        }
        GraphObjAttributes graphObjAttributes = network.getNodeAttributes();
        Object object = graphObjAttributes.getValue(nodeToolTipBypass, string = graphObjAttributes.getCanonicalName(node));
        if (object instanceof String) {
            return (String)object;
        }
        if (this.nodeToolTipCalculator == null) {
            return this.defaultNodeToolTip;
        }
        String string2 = this.nodeToolTipCalculator.calculateNodeToolTip(node, network);
        return string2 == null ? this.defaultNodeToolTip : string2;
    }

    public Font getDefaultNodeFont() {
        return this.defaultNodeFont;
    }

    public void setDefaultNodeFont(Font font) {
        if (font != null) {
            this.defaultNodeFont = font;
        }
    }

    public Font getDefaultNodeFontFace() {
        return this.defaultNodeFont;
    }

    public void setDefaultNodeFontFace(Font font) {
        if (font != null) {
            float f = this.defaultNodeFont.getSize2D();
            this.defaultNodeFont = font.deriveFont(f);
        }
    }

    public NodeFontFaceCalculator getNodeFontFaceCalculator() {
        return this.nodeFontFaceCalculator;
    }

    public void setNodeFontFaceCalculator(NodeFontFaceCalculator nodeFontFaceCalculator) {
        this.nodeFontFaceCalculator = nodeFontFaceCalculator;
    }

    public float getDefaultNodeFontSize() {
        return this.defaultNodeFont.getSize2D();
    }

    public void setDefaultNodeFontSize(float f) {
        if ((double)f > 0.0) {
            this.defaultNodeFont = this.defaultNodeFont.deriveFont(f);
        }
    }

    public NodeFontSizeCalculator getNodeFontSizeCalculator() {
        return this.nodeFontSizeCalculator;
    }

    public void setNodeFontSizeCalculator(NodeFontSizeCalculator nodeFontSizeCalculator) {
        this.nodeFontSizeCalculator = nodeFontSizeCalculator;
    }

    public Font calculateNodeFont(Node node, Network network) {
        Font font;
        String string;
        if (node == null || network == null) {
            return this.defaultNodeFont;
        }
        GraphObjAttributes graphObjAttributes = network.getNodeAttributes();
        Object object = graphObjAttributes.getValue(nodeFontBypass, string = graphObjAttributes.getCanonicalName(node));
        if (object instanceof Font) {
            return (Font)object;
        }
        if (object instanceof String && (font = new FontParser().parseFont((String)object)) != null) {
            return font;
        }
        if (this.nodeFontFaceCalculator == null && this.nodeFontSizeCalculator == null) {
            return this.defaultNodeFont;
        }
        float f = this.defaultNodeFont.getSize2D();
        if (this.nodeFontFaceCalculator == null) {
            float f2 = this.nodeFontSizeCalculator.calculateNodeFontSize(node, network);
            if (f2 == -1.0f) {
                f2 = f;
            }
            return (font = this.defaultNodeFont.deriveFont(f2)) == null ? this.defaultNodeFont : font;
        }
        Font font2 = this.nodeFontFaceCalculator.calculateNodeFontFace(node, network);
        if (font2 == null) {
            font2 = this.defaultNodeFont;
        }
        if (this.nodeFontSizeCalculator == null) {
            font = font2.deriveFont(f);
        } else {
            float f3 = this.nodeFontSizeCalculator.calculateNodeFontSize(node, network);
            if (f3 == -1.0f) {
                f3 = f;
            }
            font = font2.deriveFont(f3);
        }
        return font == null ? this.defaultNodeFont : font;
    }

    public String getDescription() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NodeAppearanceCalculator:" + string);
        stringBuffer.append("defaultNodeFillColor = ").append(this.defaultNodeFillColor).append(string);
        stringBuffer.append("defaultNodeBorderColor = ").append(this.defaultNodeBorderColor).append(string);
        String string2 = ObjectToString.getStringValue(this.defaultNodeLineType);
        stringBuffer.append("defaultNodeLineType = ").append(string2).append(string);
        Byte by = new Byte(this.defaultNodeShape);
        String string3 = ObjectToString.getStringValue(by);
        stringBuffer.append("defaultNodeShape = ").append(string3).append(string);
        stringBuffer.append("defaultNodeWidth = ").append(this.defaultNodeWidth).append(string);
        stringBuffer.append("defaultNodeHeight = ").append(this.defaultNodeHeight).append(string);
        stringBuffer.append("defaultNodeLabel = ").append(this.defaultNodeLabel).append(string);
        stringBuffer.append("defaultNodeToolTip = ").append(this.defaultNodeToolTip).append(string);
        stringBuffer.append("defaultNodeFont = ").append(this.defaultNodeFont).append(string);
        stringBuffer.append("nodeSizeLocked = ").append(this.nodeSizeLocked).append(string);
        stringBuffer.append("nodeFillColorCalculator = ").append(this.nodeFillColorCalculator).append(string);
        stringBuffer.append("nodeBorderColorCalculator = ").append(this.nodeBorderColorCalculator).append(string);
        stringBuffer.append("nodeLineTypeCalculator = ").append(this.nodeLineTypeCalculator).append(string);
        stringBuffer.append("nodeShapeCalculator = ").append(this.nodeShapeCalculator).append(string);
        stringBuffer.append("nodeWidthCalculator = ").append(this.nodeWidthCalculator).append(string);
        stringBuffer.append("nodeHeightCalculator = ").append(this.nodeHeightCalculator).append(string);
        stringBuffer.append("nodeLabelCalculator = ").append(this.nodeLabelCalculator).append(string);
        stringBuffer.append("nodeToolTipCalculator = ").append(this.nodeToolTipCalculator).append(string);
        stringBuffer.append("nodeFontFaceCalculator = ").append(this.nodeFontFaceCalculator).append(string);
        stringBuffer.append("nodeFontSizeCalculator = ").append(this.nodeFontSizeCalculator).append(string);
        return stringBuffer.toString();
    }

    public void applyProperties(String string, Properties properties, String string2, CalculatorCatalog calculatorCatalog) {
        NodeFontSizeCalculator nodeFontSizeCalculator;
        NodeFontFaceCalculator nodeFontFaceCalculator;
        NodeToolTipCalculator nodeToolTipCalculator;
        NodeLabelCalculator nodeLabelCalculator;
        NodeSizeCalculator nodeSizeCalculator;
        NodeSizeCalculator nodeSizeCalculator2;
        NodeShapeCalculator nodeShapeCalculator;
        NodeLineTypeCalculator nodeLineTypeCalculator;
        NodeColorCalculator nodeColorCalculator;
        NodeColorCalculator nodeColorCalculator2;
        double d;
        double d2;
        byte by;
        Serializable serializable;
        String string3 = null;
        string3 = properties.getProperty(string2 + ".defaultNodeFillColor");
        if (string3 != null && (serializable = new ColorParser().parseColor(string3)) != null) {
            this.setDefaultNodeFillColor((Color)serializable);
        }
        if ((string3 = properties.getProperty(string2 + ".defaultNodeBorderColor")) != null && (serializable = new ColorParser().parseColor(string3)) != null) {
            this.setDefaultNodeBorderColor((Color)serializable);
        }
        if ((string3 = properties.getProperty(string2 + ".defaultNodeLineType")) != null && (serializable = new LineTypeParser().parseLineType(string3)) != null) {
            this.setDefaultNodeLineType((LineType)serializable);
        }
        if ((string3 = properties.getProperty(string2 + ".defaultNodeShape")) != null && (serializable = new NodeShapeParser().parseNodeShape(string3)) != null && this.isValidShape(by = ((Byte)serializable).byteValue())) {
            this.setDefaultNodeShape(by);
        }
        if ((string3 = properties.getProperty(string2 + ".defaultNodeWidth")) != null && (serializable = new DoubleParser().parseDouble(string3)) != null && (d2 = ((Double)serializable).doubleValue()) > 0.0) {
            this.setDefaultNodeWidth(d2);
        }
        if ((string3 = properties.getProperty(string2 + ".defaultNodeHeight")) != null && (serializable = new DoubleParser().parseDouble(string3)) != null && (d = ((Double)serializable).doubleValue()) > 0.0) {
            this.setDefaultNodeHeight(d);
        }
        if ((string3 = properties.getProperty(string2 + ".defaultNodeLabel")) != null) {
            this.setDefaultNodeLabel(string3);
        }
        if ((string3 = properties.getProperty(string2 + ".defaultNodeToolTip")) != null) {
            this.setDefaultNodeToolTip(string3);
        }
        if ((string3 = properties.getProperty(string2 + ".defaultNodeFont")) != null && (serializable = new FontParser().parseFont(string3)) != null) {
            this.setDefaultNodeFont((Font)serializable);
        }
        if ((string3 = properties.getProperty(string2 + ".nodeSizeLocked")) != null) {
            boolean bl = Boolean.valueOf(string3);
            this.setNodeSizeLocked(bl);
        }
        if ((string3 = properties.getProperty(string2 + ".nodeFillColorCalculator")) != null && !string3.equals("null") && (nodeColorCalculator2 = calculatorCatalog.getNodeColorCalculator(string3)) != null) {
            this.setNodeFillColorCalculator(nodeColorCalculator2);
        }
        if ((string3 = properties.getProperty(string2 + ".nodeBorderColorCalculator")) != null && !string3.equals("null") && (nodeColorCalculator = calculatorCatalog.getNodeColorCalculator(string3)) != null) {
            this.setNodeBorderColorCalculator(nodeColorCalculator);
        }
        if ((string3 = properties.getProperty(string2 + ".nodeLineTypeCalculator")) != null && !string3.equals("null") && (nodeLineTypeCalculator = calculatorCatalog.getNodeLineTypeCalculator(string3)) != null) {
            this.setNodeLineTypeCalculator(nodeLineTypeCalculator);
        }
        if ((string3 = properties.getProperty(string2 + ".nodeShapeCalculator")) != null && !string3.equals("null") && (nodeShapeCalculator = calculatorCatalog.getNodeShapeCalculator(string3)) != null) {
            this.setNodeShapeCalculator(nodeShapeCalculator);
        }
        if ((string3 = properties.getProperty(string2 + ".nodeWidthCalculator")) != null && !string3.equals("null") && (nodeSizeCalculator2 = calculatorCatalog.getNodeSizeCalculator(string3)) != null) {
            this.setNodeWidthCalculator(nodeSizeCalculator2);
        }
        if ((string3 = properties.getProperty(string2 + ".nodeHeightCalculator")) != null && !string3.equals("null") && (nodeSizeCalculator = calculatorCatalog.getNodeSizeCalculator(string3)) != null) {
            this.setNodeHeightCalculator(nodeSizeCalculator);
        }
        if ((string3 = properties.getProperty(string2 + ".nodeLabelCalculator")) != null && !string3.equals("null") && (nodeLabelCalculator = calculatorCatalog.getNodeLabelCalculator(string3)) != null) {
            this.setNodeLabelCalculator(nodeLabelCalculator);
        }
        if ((string3 = properties.getProperty(string2 + ".nodeToolTipCalculator")) != null && !string3.equals("null") && (nodeToolTipCalculator = calculatorCatalog.getNodeToolTipCalculator(string3)) != null) {
            this.setNodeToolTipCalculator(nodeToolTipCalculator);
        }
        if ((string3 = properties.getProperty(string2 + ".nodeFontFaceCalculator")) != null && !string3.equals("null") && (nodeFontFaceCalculator = calculatorCatalog.getNodeFontFaceCalculator(string3)) != null) {
            this.setNodeFontFaceCalculator(nodeFontFaceCalculator);
        }
        if ((string3 = properties.getProperty(string2 + ".nodeFontSizeCalculator")) != null && !string3.equals("null") && (nodeFontSizeCalculator = calculatorCatalog.getNodeFontSizeCalculator(string3)) != null) {
            this.setNodeFontSizeCalculator(nodeFontSizeCalculator);
        }
    }

    public Properties getProperties(String string) {
        String string2 = null;
        String string3 = null;
        Properties properties = new Properties();
        string2 = string + ".defaultNodeFillColor";
        string3 = ObjectToString.getStringValue(this.getDefaultNodeFillColor());
        properties.setProperty(string2, string3);
        string2 = string + ".defaultNodeBorderColor";
        string3 = ObjectToString.getStringValue(this.getDefaultNodeBorderColor());
        properties.setProperty(string2, string3);
        string2 = string + ".defaultNodeLineType";
        string3 = ObjectToString.getStringValue(this.getDefaultNodeLineType());
        properties.setProperty(string2, string3);
        string2 = string + ".defaultNodeShape";
        Byte by = new Byte(this.getDefaultNodeShape());
        string3 = ObjectToString.getStringValue(by);
        properties.setProperty(string2, string3);
        string2 = string + ".defaultNodeWidth";
        Double d = new Double(this.getDefaultNodeWidth());
        string3 = ObjectToString.getStringValue(d);
        properties.setProperty(string2, string3);
        string2 = string + ".defaultNodeHeight";
        Double d2 = new Double(this.getDefaultNodeHeight());
        string3 = ObjectToString.getStringValue(d2);
        properties.setProperty(string2, string3);
        string2 = string + ".defaultNodeLabel";
        string3 = ObjectToString.getStringValue(this.getDefaultNodeLabel());
        properties.setProperty(string2, string3);
        string2 = string + ".defaultNodeToolTip";
        string3 = ObjectToString.getStringValue(this.getDefaultNodeToolTip());
        properties.setProperty(string2, string3);
        string2 = string + ".defaultNodeFont";
        string3 = ObjectToString.getStringValue(this.getDefaultNodeFont());
        properties.setProperty(string2, string3);
        string2 = string + ".nodeSizeLocked";
        string3 = Boolean.toString(this.getNodeSizeLocked());
        properties.setProperty(string2, string3);
        Calculator calculator = null;
        string2 = string + ".nodeFillColorCalculator";
        calculator = this.getNodeFillColorCalculator();
        string3 = calculator == null ? "null" : ((Object)calculator).toString();
        properties.setProperty(string2, string3);
        string2 = string + ".nodeBorderColorCalculator";
        calculator = this.getNodeBorderColorCalculator();
        string3 = calculator == null ? "null" : ((Object)calculator).toString();
        properties.setProperty(string2, string3);
        string2 = string + ".nodeLineTypeCalculator";
        calculator = this.getNodeLineTypeCalculator();
        string3 = calculator == null ? "null" : ((Object)calculator).toString();
        properties.setProperty(string2, string3);
        string2 = string + ".nodeShapeCalculator";
        calculator = this.getNodeShapeCalculator();
        string3 = calculator == null ? "null" : ((Object)calculator).toString();
        properties.setProperty(string2, string3);
        string2 = string + ".nodeWidthCalculator";
        calculator = this.getNodeWidthCalculator();
        string3 = calculator == null ? "null" : ((Object)calculator).toString();
        properties.setProperty(string2, string3);
        string2 = string + ".nodeHeightCalculator";
        calculator = this.getNodeHeightCalculator();
        string3 = calculator == null ? "null" : ((Object)calculator).toString();
        properties.setProperty(string2, string3);
        string2 = string + ".nodeLabelCalculator";
        calculator = this.getNodeLabelCalculator();
        string3 = calculator == null ? "null" : ((Object)calculator).toString();
        properties.setProperty(string2, string3);
        string2 = string + ".nodeToolTipCalculator";
        calculator = this.getNodeToolTipCalculator();
        string3 = calculator == null ? "null" : ((Object)calculator).toString();
        properties.setProperty(string2, string3);
        string2 = string + ".nodeFontFaceCalculator";
        calculator = this.getNodeFontFaceCalculator();
        string3 = calculator == null ? "null" : ((Object)calculator).toString();
        properties.setProperty(string2, string3);
        string2 = string + ".nodeFontSizeCalculator";
        calculator = this.getNodeFontSizeCalculator();
        string3 = calculator == null ? "null" : ((Object)calculator).toString();
        properties.setProperty(string2, string3);
        return properties;
    }
}

