/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.GlobalAppearance;
import cytoscape.visual.Network;
import cytoscape.visual.parsers.ColorParser;
import cytoscape.visual.parsers.ObjectToString;
import java.awt.Color;
import java.util.Properties;

public class GlobalAppearanceCalculator
implements Cloneable {
    Color defaultBackgroundColor = Color.WHITE;
    Color defaultSloppySelectionColor = Color.GRAY;

    public Object clone() throws CloneNotSupportedException {
        Object object = null;
        object = super.clone();
        return object;
    }

    public GlobalAppearanceCalculator() {
    }

    public GlobalAppearanceCalculator(GlobalAppearanceCalculator globalAppearanceCalculator) {
        if (globalAppearanceCalculator == null) {
            return;
        }
        this.setDefaultBackgroundColor(globalAppearanceCalculator.getDefaultBackgroundColor());
        this.setDefaultSloppySelectionColor(globalAppearanceCalculator.getDefaultSloppySelectionColor());
    }

    public GlobalAppearanceCalculator(String string, Properties properties, String string2, CalculatorCatalog calculatorCatalog) {
        this.applyProperties(string, properties, string2, calculatorCatalog);
    }

    public GlobalAppearance calculateGlobalAppearance(Network network) {
        GlobalAppearance globalAppearance = new GlobalAppearance();
        this.calculateGlobalAppearance(globalAppearance, network);
        return globalAppearance;
    }

    public void calculateGlobalAppearance(GlobalAppearance globalAppearance, Network network) {
        globalAppearance.setBackgroundColor(this.calculateBackgroundColor(network));
        globalAppearance.setSloppySelectionColor(this.calculateSloppySelectionColor(network));
    }

    public Color getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    public void setDefaultBackgroundColor(Color color) {
        if (color != null) {
            this.defaultBackgroundColor = color;
        }
    }

    public Color calculateBackgroundColor(Network network) {
        return this.defaultBackgroundColor;
    }

    public Color getDefaultSloppySelectionColor() {
        return this.defaultSloppySelectionColor;
    }

    public void setDefaultSloppySelectionColor(Color color) {
        if (color != null) {
            this.defaultSloppySelectionColor = color;
        }
    }

    public Color calculateSloppySelectionColor(Network network) {
        return this.defaultSloppySelectionColor;
    }

    public String getDescription() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GlobalAppearanceCalculator:" + string);
        stringBuffer.append("defaultBackgroundColor = ");
        stringBuffer.append(this.defaultBackgroundColor).append(string);
        stringBuffer.append("defaultSloppySelectionColor = ");
        stringBuffer.append(this.defaultSloppySelectionColor).append(string);
        return stringBuffer.toString();
    }

    public void applyProperties(String string, Properties properties, String string2, CalculatorCatalog calculatorCatalog) {
        Color color;
        String string3 = null;
        string3 = properties.getProperty(string2 + ".defaultBackgroundColor");
        if (string3 != null && (color = new ColorParser().parseColor(string3)) != null) {
            this.setDefaultBackgroundColor(color);
        }
        if ((string3 = properties.getProperty(string2 + ".defaultSloppySelectionColor")) != null && (color = new ColorParser().parseColor(string3)) != null) {
            this.setDefaultSloppySelectionColor(color);
        }
    }

    public Properties getProperties(String string) {
        String string2 = null;
        String string3 = null;
        Properties properties = new Properties();
        string2 = string + ".defaultBackgroundColor";
        string3 = ObjectToString.getStringValue(this.getDefaultBackgroundColor());
        properties.setProperty(string2, string3);
        string2 = string + ".defaultSloppySelectionColor";
        string3 = ObjectToString.getStringValue(this.getDefaultSloppySelectionColor());
        properties.setProperty(string2, string3);
        return properties;
    }
}

