/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearance;
import cytoscape.visual.Network;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.EdgeArrowCalculator;
import cytoscape.visual.calculators.EdgeColorCalculator;
import cytoscape.visual.calculators.EdgeFontFaceCalculator;
import cytoscape.visual.calculators.EdgeFontSizeCalculator;
import cytoscape.visual.calculators.EdgeLabelCalculator;
import cytoscape.visual.calculators.EdgeLineTypeCalculator;
import cytoscape.visual.calculators.EdgeToolTipCalculator;
import cytoscape.visual.parsers.ArrowParser;
import cytoscape.visual.parsers.ColorParser;
import cytoscape.visual.parsers.FontParser;
import cytoscape.visual.parsers.LineTypeParser;
import cytoscape.visual.parsers.ObjectToString;
import java.awt.Color;
import java.awt.Font;
import java.util.Properties;
import y.base.Edge;
import y.view.Arrow;
import y.view.LineType;

public class EdgeAppearanceCalculator
implements Cloneable {
    Color defaultEdgeColor = Color.BLACK;
    LineType defaultEdgeLineType = LineType.LINE_1;
    Arrow defaultEdgeSourceArrow = Arrow.NONE;
    Arrow defaultEdgeTargetArrow = Arrow.NONE;
    String defaultEdgeLabel = "";
    String defaultEdgeToolTip = "";
    Font defaultEdgeFont = new Font(null, 0, 10);
    EdgeColorCalculator edgeColorCalculator;
    EdgeLineTypeCalculator edgeLineTypeCalculator;
    EdgeArrowCalculator edgeSourceArrowCalculator;
    EdgeArrowCalculator edgeTargetArrowCalculator;
    EdgeLabelCalculator edgeLabelCalculator;
    EdgeToolTipCalculator edgeToolTipCalculator;
    EdgeFontFaceCalculator edgeFontFaceCalculator;
    EdgeFontSizeCalculator edgeFontSizeCalculator;

    public Object clone() throws CloneNotSupportedException {
        Object object = null;
        object = super.clone();
        return object;
    }

    public EdgeAppearanceCalculator() {
    }

    public EdgeAppearanceCalculator(EdgeAppearanceCalculator edgeAppearanceCalculator) {
        if (edgeAppearanceCalculator == null) {
            return;
        }
        this.setDefaultEdgeColor(edgeAppearanceCalculator.getDefaultEdgeColor());
        this.setDefaultEdgeLineType(edgeAppearanceCalculator.getDefaultEdgeLineType());
        this.setDefaultEdgeSourceArrow(edgeAppearanceCalculator.getDefaultEdgeSourceArrow());
        this.setDefaultEdgeTargetArrow(edgeAppearanceCalculator.getDefaultEdgeTargetArrow());
        this.setDefaultEdgeLabel(edgeAppearanceCalculator.getDefaultEdgeLabel());
        this.setDefaultEdgeToolTip(edgeAppearanceCalculator.getDefaultEdgeToolTip());
        this.setDefaultEdgeFont(edgeAppearanceCalculator.getDefaultEdgeFont());
        this.setEdgeColorCalculator(edgeAppearanceCalculator.getEdgeColorCalculator());
        this.setEdgeLineTypeCalculator(edgeAppearanceCalculator.getEdgeLineTypeCalculator());
        this.setEdgeSourceArrowCalculator(edgeAppearanceCalculator.getEdgeSourceArrowCalculator());
        this.setEdgeTargetArrowCalculator(edgeAppearanceCalculator.getEdgeTargetArrowCalculator());
        this.setEdgeLabelCalculator(edgeAppearanceCalculator.getEdgeLabelCalculator());
        this.setEdgeToolTipCalculator(edgeAppearanceCalculator.getEdgeToolTipCalculator());
        this.setEdgeFontFaceCalculator(edgeAppearanceCalculator.getEdgeFontFaceCalculator());
        this.setEdgeFontSizeCalculator(edgeAppearanceCalculator.getEdgeFontSizeCalculator());
    }

    public EdgeAppearanceCalculator(String string, Properties properties, String string2, CalculatorCatalog calculatorCatalog) {
        this.applyProperties(string, properties, string2, calculatorCatalog);
    }

    public EdgeAppearance calculateEdgeAppearance(Edge edge, Network network) {
        EdgeAppearance edgeAppearance = new EdgeAppearance();
        this.calculateEdgeAppearance(edgeAppearance, edge, network);
        return edgeAppearance;
    }

    public void calculateEdgeAppearance(EdgeAppearance edgeAppearance, Edge edge, Network network) {
        edgeAppearance.setColor(this.calculateEdgeColor(edge, network));
        edgeAppearance.setLineType(this.calculateEdgeLineType(edge, network));
        edgeAppearance.setSourceArrow(this.calculateEdgeSourceArrow(edge, network));
        edgeAppearance.setTargetArrow(this.calculateEdgeTargetArrow(edge, network));
        edgeAppearance.setLabel(this.calculateEdgeLabel(edge, network));
        edgeAppearance.setToolTip(this.calculateEdgeToolTip(edge, network));
        edgeAppearance.setFont(this.calculateEdgeFont(edge, network));
    }

    public Color getDefaultEdgeColor() {
        return this.defaultEdgeColor;
    }

    public void setDefaultEdgeColor(Color color) {
        if (color != null) {
            this.defaultEdgeColor = color;
        }
    }

    public EdgeColorCalculator getEdgeColorCalculator() {
        return this.edgeColorCalculator;
    }

    public void setEdgeColorCalculator(EdgeColorCalculator edgeColorCalculator) {
        this.edgeColorCalculator = edgeColorCalculator;
    }

    public Color calculateEdgeColor(Edge edge, Network network) {
        if (edge == null || network == null || this.edgeColorCalculator == null) {
            return this.defaultEdgeColor;
        }
        Color color = this.edgeColorCalculator.calculateEdgeColor(edge, network);
        return color == null ? this.defaultEdgeColor : color;
    }

    public LineType getDefaultEdgeLineType() {
        return this.defaultEdgeLineType;
    }

    public void setDefaultEdgeLineType(LineType lineType) {
        if (lineType != null) {
            this.defaultEdgeLineType = lineType;
        }
    }

    public EdgeLineTypeCalculator getEdgeLineTypeCalculator() {
        return this.edgeLineTypeCalculator;
    }

    public void setEdgeLineTypeCalculator(EdgeLineTypeCalculator edgeLineTypeCalculator) {
        this.edgeLineTypeCalculator = edgeLineTypeCalculator;
    }

    public LineType calculateEdgeLineType(Edge edge, Network network) {
        if (edge == null || network == null || this.edgeLineTypeCalculator == null) {
            return this.defaultEdgeLineType;
        }
        LineType lineType = this.edgeLineTypeCalculator.calculateEdgeLineType(edge, network);
        return lineType == null ? this.defaultEdgeLineType : lineType;
    }

    public Arrow getDefaultEdgeSourceArrow() {
        return this.defaultEdgeSourceArrow;
    }

    public void setDefaultEdgeSourceArrow(Arrow arrow) {
        if (arrow != null) {
            this.defaultEdgeSourceArrow = arrow;
        }
    }

    public EdgeArrowCalculator getEdgeSourceArrowCalculator() {
        return this.edgeSourceArrowCalculator;
    }

    public void setEdgeSourceArrowCalculator(EdgeArrowCalculator edgeArrowCalculator) {
        this.edgeSourceArrowCalculator = edgeArrowCalculator;
    }

    public Arrow calculateEdgeSourceArrow(Edge edge, Network network) {
        if (edge == null || network == null || this.edgeSourceArrowCalculator == null) {
            return this.defaultEdgeSourceArrow;
        }
        Arrow arrow = this.edgeSourceArrowCalculator.calculateEdgeArrow(edge, network);
        return arrow == null ? this.defaultEdgeSourceArrow : arrow;
    }

    public Arrow getDefaultEdgeTargetArrow() {
        return this.defaultEdgeTargetArrow;
    }

    public void setDefaultEdgeTargetArrow(Arrow arrow) {
        if (arrow != null) {
            this.defaultEdgeTargetArrow = arrow;
        }
    }

    public EdgeArrowCalculator getEdgeTargetArrowCalculator() {
        return this.edgeTargetArrowCalculator;
    }

    public void setEdgeTargetArrowCalculator(EdgeArrowCalculator edgeArrowCalculator) {
        this.edgeTargetArrowCalculator = edgeArrowCalculator;
    }

    public Arrow calculateEdgeTargetArrow(Edge edge, Network network) {
        if (edge == null || network == null || this.edgeTargetArrowCalculator == null) {
            return this.defaultEdgeTargetArrow;
        }
        Arrow arrow = this.edgeTargetArrowCalculator.calculateEdgeArrow(edge, network);
        return arrow == null ? this.defaultEdgeTargetArrow : arrow;
    }

    public String getDefaultEdgeLabel() {
        return this.defaultEdgeLabel;
    }

    public void setDefaultEdgeLabel(String string) {
        if (string != null) {
            this.defaultEdgeLabel = string;
        }
    }

    public EdgeLabelCalculator getEdgeLabelCalculator() {
        return this.edgeLabelCalculator;
    }

    public void setEdgeLabelCalculator(EdgeLabelCalculator edgeLabelCalculator) {
        this.edgeLabelCalculator = edgeLabelCalculator;
    }

    public String calculateEdgeLabel(Edge edge, Network network) {
        if (edge == null || network == null || this.edgeLabelCalculator == null) {
            return this.defaultEdgeLabel;
        }
        String string = this.edgeLabelCalculator.calculateEdgeLabel(edge, network);
        return string == null ? this.defaultEdgeLabel : string;
    }

    public Font getDefaultEdgeFont() {
        return this.defaultEdgeFont;
    }

    public void setDefaultEdgeFont(Font font) {
        if (font != null) {
            this.defaultEdgeFont = font;
        }
    }

    public Font getDefaultEdgeFontFace() {
        return this.defaultEdgeFont;
    }

    public void setDefaultEdgeFontFace(Font font) {
        if (font != null) {
            float f = this.defaultEdgeFont.getSize2D();
            this.defaultEdgeFont = font.deriveFont(f);
        }
    }

    public EdgeFontFaceCalculator getEdgeFontFaceCalculator() {
        return this.edgeFontFaceCalculator;
    }

    public void setEdgeFontFaceCalculator(EdgeFontFaceCalculator edgeFontFaceCalculator) {
        this.edgeFontFaceCalculator = edgeFontFaceCalculator;
    }

    public float getDefaultEdgeFontSize() {
        return this.defaultEdgeFont.getSize2D();
    }

    public void setDefaultEdgeFontSize(float f) {
        if ((double)f > 0.0) {
            this.defaultEdgeFont = this.defaultEdgeFont.deriveFont(f);
        }
    }

    public EdgeFontSizeCalculator getEdgeFontSizeCalculator() {
        return this.edgeFontSizeCalculator;
    }

    public void setEdgeFontSizeCalculator(EdgeFontSizeCalculator edgeFontSizeCalculator) {
        this.edgeFontSizeCalculator = edgeFontSizeCalculator;
    }

    public Font calculateEdgeFont(Edge edge, Network network) {
        Font font;
        if (edge == null || network == null || this.edgeFontFaceCalculator == null && this.edgeFontSizeCalculator == null) {
            return this.defaultEdgeFont;
        }
        float f = this.defaultEdgeFont.getSize2D();
        if (this.edgeFontFaceCalculator == null) {
            Font font2;
            float f2 = this.edgeFontSizeCalculator.calculateEdgeFontSize(edge, network);
            if (f2 == -1.0f) {
                f2 = f;
            }
            return (font2 = this.defaultEdgeFont.deriveFont(f2)) == null ? this.defaultEdgeFont : font2;
        }
        Font font3 = this.edgeFontFaceCalculator.calculateEdgeFontFace(edge, network);
        if (font3 == null) {
            font3 = this.defaultEdgeFont;
        }
        if (this.edgeFontSizeCalculator == null) {
            font = font3.deriveFont(f);
        } else {
            float f3 = this.edgeFontSizeCalculator.calculateEdgeFontSize(edge, network);
            if (f3 == -1.0f) {
                f3 = f;
            }
            font = font3.deriveFont(f3);
        }
        return font == null ? this.defaultEdgeFont : font;
    }

    public String getDefaultEdgeToolTip() {
        return this.defaultEdgeToolTip;
    }

    public void setDefaultEdgeToolTip(String string) {
        if (string != null) {
            this.defaultEdgeToolTip = string;
        }
    }

    public EdgeToolTipCalculator getEdgeToolTipCalculator() {
        return this.edgeToolTipCalculator;
    }

    public void setEdgeToolTipCalculator(EdgeToolTipCalculator edgeToolTipCalculator) {
        this.edgeToolTipCalculator = edgeToolTipCalculator;
    }

    public String calculateEdgeToolTip(Edge edge, Network network) {
        if (edge == null || network == null || this.edgeToolTipCalculator == null) {
            return this.defaultEdgeToolTip;
        }
        String string = this.edgeToolTipCalculator.calculateEdgeToolTip(edge, network);
        return string == null ? this.defaultEdgeToolTip : string;
    }

    public String getDescription() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EdgeAppearanceCalculator:" + string);
        stringBuffer.append("defaultEdgeColor = ").append(this.defaultEdgeColor).append(string);
        String string2 = ObjectToString.getStringValue(this.defaultEdgeLineType);
        stringBuffer.append("defaultEdgeLineType = ").append(string2).append(string);
        String string3 = ObjectToString.getStringValue(this.defaultEdgeSourceArrow);
        stringBuffer.append("defaultEdgeSourceArrow = ").append(string3).append(string);
        String string4 = ObjectToString.getStringValue(this.defaultEdgeTargetArrow);
        stringBuffer.append("defaultEdgeTargetArrow = ").append(string4).append(string);
        stringBuffer.append("defaultEdgeLabel = ").append(this.defaultEdgeLabel).append(string);
        stringBuffer.append("defaultEdgeToolTip = ").append(this.defaultEdgeToolTip).append(string);
        stringBuffer.append("defaultEdgeFont = ").append(this.defaultEdgeFont).append(string);
        stringBuffer.append("edgeColorCalculator = ").append(this.edgeColorCalculator).append(string);
        stringBuffer.append("edgeLineTypeCalculator = ").append(this.edgeLineTypeCalculator).append(string);
        stringBuffer.append("edgeSourceArrowCalculator = ").append(this.edgeSourceArrowCalculator).append(string);
        stringBuffer.append("edgeTargetArrowCalculator = ").append(this.edgeTargetArrowCalculator).append(string);
        stringBuffer.append("edgeLabelCalculator = ").append(this.edgeLabelCalculator).append(string);
        stringBuffer.append("edgeToolTipCalculator = ").append(this.edgeToolTipCalculator).append(string);
        stringBuffer.append("edgeFontFaceCalculator = ").append(this.edgeFontFaceCalculator).append(string);
        stringBuffer.append("edgeFontSizeCalculator = ").append(this.edgeFontSizeCalculator).append(string);
        return stringBuffer.toString();
    }

    public void applyProperties(String string, Properties properties, String string2, CalculatorCatalog calculatorCatalog) {
        Object object;
        String string3 = null;
        string3 = properties.getProperty(string2 + ".defaultEdgeColor");
        if (string3 != null && (object = new ColorParser().parseColor(string3)) != null) {
            this.setDefaultEdgeColor((Color)object);
        }
        if ((string3 = properties.getProperty(string2 + ".defaultEdgeLineType")) != null && (object = new LineTypeParser().parseLineType(string3)) != null) {
            this.setDefaultEdgeLineType((LineType)object);
        }
        if ((string3 = properties.getProperty(string2 + ".defaultEdgeSourceArrow")) != null && (object = new ArrowParser().parseArrow(string3)) != null) {
            this.setDefaultEdgeSourceArrow((Arrow)object);
        }
        if ((string3 = properties.getProperty(string2 + ".defaultEdgeTargetArrow")) != null && (object = new ArrowParser().parseArrow(string3)) != null) {
            this.setDefaultEdgeTargetArrow((Arrow)object);
        }
        if ((string3 = properties.getProperty(string2 + ".defaultEdgeLabel")) != null) {
            this.setDefaultEdgeLabel(string3);
        }
        if ((string3 = properties.getProperty(string2 + ".defaultEdgeToolTip")) != null) {
            this.setDefaultEdgeToolTip(string3);
        }
        if ((string3 = properties.getProperty(string2 + ".defaultEdgeFont")) != null && (object = new FontParser().parseFont(string3)) != null) {
            this.setDefaultEdgeFont((Font)object);
        }
        if ((string3 = properties.getProperty(string2 + ".edgeColorCalculator")) != null && !string3.equals("null") && (object = calculatorCatalog.getEdgeColorCalculator(string3)) != null) {
            this.setEdgeColorCalculator((EdgeColorCalculator)object);
        }
        if ((string3 = properties.getProperty(string2 + ".edgeLineTypeCalculator")) != null && !string3.equals("null") && (object = calculatorCatalog.getEdgeLineTypeCalculator(string3)) != null) {
            this.setEdgeLineTypeCalculator((EdgeLineTypeCalculator)object);
        }
        if ((string3 = properties.getProperty(string2 + ".edgeSourceArrowCalculator")) != null && !string3.equals("null") && (object = calculatorCatalog.getEdgeArrowCalculator(string3)) != null) {
            this.setEdgeSourceArrowCalculator((EdgeArrowCalculator)object);
        }
        if ((string3 = properties.getProperty(string2 + ".edgeTargetArrowCalculator")) != null && !string3.equals("null") && (object = calculatorCatalog.getEdgeArrowCalculator(string3)) != null) {
            this.setEdgeTargetArrowCalculator((EdgeArrowCalculator)object);
        }
        if ((string3 = properties.getProperty(string2 + ".edgeLabelCalculator")) != null && !string3.equals("null") && (object = calculatorCatalog.getEdgeLabelCalculator(string3)) != null) {
            this.setEdgeLabelCalculator((EdgeLabelCalculator)object);
        }
        if ((string3 = properties.getProperty(string2 + ".edgeToolTipCalculator")) != null && !string3.equals("null") && (object = calculatorCatalog.getEdgeToolTipCalculator(string3)) != null) {
            this.setEdgeToolTipCalculator((EdgeToolTipCalculator)object);
        }
        if ((string3 = properties.getProperty(string2 + ".edgeFontFaceCalculator")) != null && !string3.equals("null") && (object = calculatorCatalog.getEdgeFontFaceCalculator(string3)) != null) {
            this.setEdgeFontFaceCalculator((EdgeFontFaceCalculator)object);
        }
        if ((string3 = properties.getProperty(string2 + ".edgeFontSizeCalculator")) != null && !string3.equals("null") && (object = calculatorCatalog.getEdgeFontSizeCalculator(string3)) != null) {
            this.setEdgeFontSizeCalculator((EdgeFontSizeCalculator)object);
        }
    }

    public Properties getProperties(String string) {
        String string2 = null;
        String string3 = null;
        Properties properties = new Properties();
        string2 = string + ".defaultEdgeColor";
        string3 = ObjectToString.getStringValue(this.getDefaultEdgeColor());
        properties.setProperty(string2, string3);
        string2 = string + ".defaultEdgeLineType";
        string3 = ObjectToString.getStringValue(this.getDefaultEdgeLineType());
        properties.setProperty(string2, string3);
        string2 = string + ".defaultEdgeSourceArrow";
        string3 = ObjectToString.getStringValue(this.getDefaultEdgeSourceArrow());
        properties.setProperty(string2, string3);
        string2 = string + ".defaultEdgeTargetArrow";
        string3 = ObjectToString.getStringValue(this.getDefaultEdgeTargetArrow());
        properties.setProperty(string2, string3);
        string2 = string + ".defaultEdgeLabel";
        string3 = ObjectToString.getStringValue(this.getDefaultEdgeLabel());
        properties.setProperty(string2, string3);
        string2 = string + ".defaultEdgeToolTip";
        string3 = ObjectToString.getStringValue(this.getDefaultEdgeToolTip());
        properties.setProperty(string2, string3);
        string2 = string + ".defaultEdgeFont";
        string3 = ObjectToString.getStringValue(this.getDefaultEdgeFont());
        properties.setProperty(string2, string3);
        Calculator calculator = null;
        string2 = string + ".edgeColorCalculator";
        calculator = this.getEdgeColorCalculator();
        string3 = calculator == null ? "null" : ((Object)calculator).toString();
        properties.setProperty(string2, string3);
        string2 = string + ".edgeLineTypeCalculator";
        calculator = this.getEdgeLineTypeCalculator();
        string3 = calculator == null ? "null" : ((Object)calculator).toString();
        properties.setProperty(string2, string3);
        string2 = string + ".edgeSourceArrowCalculator";
        calculator = this.getEdgeSourceArrowCalculator();
        string3 = calculator == null ? "null" : ((Object)calculator).toString();
        properties.setProperty(string2, string3);
        string2 = string + ".edgeTargetArrowCalculator";
        calculator = this.getEdgeTargetArrowCalculator();
        string3 = calculator == null ? "null" : ((Object)calculator).toString();
        properties.setProperty(string2, string3);
        string2 = string + ".edgeLabelCalculator";
        calculator = this.getEdgeLabelCalculator();
        string3 = calculator == null ? "null" : ((Object)calculator).toString();
        properties.setProperty(string2, string3);
        string2 = string + ".edgeToolTipCalculator";
        calculator = this.getEdgeToolTipCalculator();
        string3 = calculator == null ? "null" : ((Object)calculator).toString();
        properties.setProperty(string2, string3);
        string2 = string + ".edgeFontFaceCalculator";
        calculator = this.getEdgeFontFaceCalculator();
        string3 = calculator == null ? "null" : ((Object)calculator).toString();
        properties.setProperty(string2, string3);
        string2 = string + ".edgeFontSizeCalculator";
        calculator = this.getEdgeFontSizeCalculator();
        string3 = calculator == null ? "null" : ((Object)calculator).toString();
        properties.setProperty(string2, string3);
        return properties;
    }
}

