/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.CalculatorFactory;
import cytoscape.visual.calculators.EdgeArrowCalculator;
import cytoscape.visual.calculators.EdgeColorCalculator;
import cytoscape.visual.calculators.EdgeFontFaceCalculator;
import cytoscape.visual.calculators.EdgeFontSizeCalculator;
import cytoscape.visual.calculators.EdgeLabelCalculator;
import cytoscape.visual.calculators.EdgeLineTypeCalculator;
import cytoscape.visual.calculators.EdgeToolTipCalculator;
import cytoscape.visual.calculators.NodeColorCalculator;
import cytoscape.visual.calculators.NodeFontFaceCalculator;
import cytoscape.visual.calculators.NodeFontSizeCalculator;
import cytoscape.visual.calculators.NodeLabelCalculator;
import cytoscape.visual.calculators.NodeLineTypeCalculator;
import cytoscape.visual.calculators.NodeShapeCalculator;
import cytoscape.visual.calculators.NodeSizeCalculator;
import cytoscape.visual.calculators.NodeToolTipCalculator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CalculatorIO {
    public static final String dirHeader = "cytoscape.visual.calculators.";
    public static final String nodeColorBaseKey = "nodeColorCalculator";
    public static final String nodeColorClassName = "NodeColorCalculator";
    public static final String nodeLineTypeBaseKey = "nodeLineTypeCalculator";
    public static final String nodeLineTypeClassName = "NodeLineTypeCalculator";
    public static final String nodeShapeBaseKey = "nodeShapeCalculator";
    public static final String nodeShapeClassName = "NodeShapeCalculator";
    public static final String nodeSizeBaseKey = "nodeSizeCalculator";
    public static final String nodeSizeClassName = "NodeSizeCalculator";
    public static final String nodeLabelBaseKey = "nodeLabelCalculator";
    public static final String nodeLabelClassName = "NodeLabelCalculator";
    public static final String nodeToolTipBaseKey = "nodeToolTipCalculator";
    public static final String nodeToolTipClassName = "NodeToolTipCalculator";
    public static final String nodeFontFaceBaseKey = "nodeFontFaceCalculator";
    public static final String nodeFontFaceClassName = "NodeFontFaceCalculator";
    public static final String nodeFontSizeBaseKey = "nodeFontSizeCalculator";
    public static final String nodeFontSizeClassName = "NodeFontSizeCalculator";
    public static final String edgeColorBaseKey = "edgeColorCalculator";
    public static final String edgeColorClassName = "EdgeColorCalculator";
    public static final String edgeLineTypeBaseKey = "edgeLineTypeCalculator";
    public static final String edgeLineTypeClassName = "EdgeLineTypeCalculator";
    public static final String edgeArrowBaseKey = "edgeArrowCalculator";
    public static final String edgeArrowClassName = "EdgeArrowCalculator";
    public static final String edgeLabelBaseKey = "edgeLabelCalculator";
    public static final String edgeLabelClassName = "EdgeLabelCalculator";
    public static final String edgeToolTipBaseKey = "edgeToolTipCalculator";
    public static final String edgeToolTipClassName = "EdgeToolTipCalculator";
    public static final String edgeFontFaceBaseKey = "edgeFontFaceCalculator";
    public static final String edgeFontFaceClassName = "EdgeFontFaceCalculator";
    public static final String edgeFontSizeBaseKey = "edgeFontSizeCalculator";
    public static final String edgeFontSizeClassName = "EdgeFontSizeCalculator";
    public static final String nodeAppearanceBaseKey = "nodeAppearanceCalculator";
    public static final String edgeAppearanceBaseKey = "edgeAppearanceCalculator";
    public static final String globalAppearanceBaseKey = "globalAppearanceCalculator";

    public static void storeCatalog(CalculatorCatalog calculatorCatalog, File file) {
        try {
            String string;
            String string2 = System.getProperty("line.separator");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("This file specifies visual mappings for Cytoscape");
            stringBuffer.append(" and has been automatically generated.").append(string2);
            stringBuffer.append("# WARNING: any changes you make to this file while");
            stringBuffer.append(" Cytoscape is running may be overwritten.").append(string2);
            stringBuffer.append("# Any changes may make these visual mappings unreadable.");
            stringBuffer.append(string2);
            stringBuffer.append("# Please make sure you know what you are doing before");
            stringBuffer.append(" modifying this file by hand.").append(string2);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            Properties properties = CalculatorIO.getProperties(calculatorCatalog);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            properties.store(byteArrayOutputStream, stringBuffer.toString());
            String string3 = byteArrayOutputStream.toString();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string3));
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string4 = bufferedReader.readLine();
            while (string4 != null) {
                if (string4.startsWith("#")) {
                    arrayList.add(string4);
                } else {
                    arrayList2.add(string4);
                }
                string4 = bufferedReader.readLine();
            }
            Collections.sort(arrayList2);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
            }
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Properties getProperties(CalculatorCatalog calculatorCatalog) {
        Properties properties = new Properties();
        CalculatorIO.addProperties(properties, calculatorCatalog.getNodeColorCalculators(), nodeColorBaseKey);
        CalculatorIO.addProperties(properties, calculatorCatalog.getNodeLineTypeCalculators(), nodeLineTypeBaseKey);
        CalculatorIO.addProperties(properties, calculatorCatalog.getNodeShapeCalculators(), nodeShapeBaseKey);
        CalculatorIO.addProperties(properties, calculatorCatalog.getNodeSizeCalculators(), nodeSizeBaseKey);
        CalculatorIO.addProperties(properties, calculatorCatalog.getNodeLabelCalculators(), nodeLabelBaseKey);
        CalculatorIO.addProperties(properties, calculatorCatalog.getNodeToolTipCalculators(), nodeToolTipBaseKey);
        CalculatorIO.addProperties(properties, calculatorCatalog.getNodeFontFaceCalculators(), nodeFontFaceBaseKey);
        CalculatorIO.addProperties(properties, calculatorCatalog.getNodeFontSizeCalculators(), nodeFontSizeBaseKey);
        CalculatorIO.addProperties(properties, calculatorCatalog.getEdgeColorCalculators(), edgeColorBaseKey);
        CalculatorIO.addProperties(properties, calculatorCatalog.getEdgeLineTypeCalculators(), edgeLineTypeBaseKey);
        CalculatorIO.addProperties(properties, calculatorCatalog.getEdgeArrowCalculators(), edgeArrowBaseKey);
        CalculatorIO.addProperties(properties, calculatorCatalog.getEdgeLabelCalculators(), edgeLabelBaseKey);
        CalculatorIO.addProperties(properties, calculatorCatalog.getEdgeToolTipCalculators(), edgeToolTipBaseKey);
        CalculatorIO.addProperties(properties, calculatorCatalog.getEdgeFontFaceCalculators(), edgeFontFaceBaseKey);
        CalculatorIO.addProperties(properties, calculatorCatalog.getEdgeFontSizeCalculators(), edgeFontSizeBaseKey);
        Set set = calculatorCatalog.getVisualStyleNames();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object;
            String string = (String)iterator.next();
            VisualStyle visualStyle = calculatorCatalog.getVisualStyle(string);
            try {
                Properties properties2 = new Properties();
                object = visualStyle.getNodeAppearanceCalculator();
                String string2 = "nodeAppearanceCalculator." + string;
                Properties properties3 = ((NodeAppearanceCalculator)object).getProperties(string2);
                properties2.putAll((Map<?, ?>)properties3);
                EdgeAppearanceCalculator edgeAppearanceCalculator = visualStyle.getEdgeAppearanceCalculator();
                String string3 = "edgeAppearanceCalculator." + string;
                Properties properties4 = edgeAppearanceCalculator.getProperties(string3);
                properties2.putAll((Map<?, ?>)properties4);
                GlobalAppearanceCalculator globalAppearanceCalculator = visualStyle.getGlobalAppearanceCalculator();
                String string4 = "globalAppearanceCalculator." + string;
                Properties properties5 = globalAppearanceCalculator.getProperties(string4);
                properties2.putAll((Map<?, ?>)properties5);
                properties.putAll((Map<?, ?>)properties2);
            }
            catch (Exception exception) {
                object = "Exception while saving visual style " + string;
                System.err.println((String)object);
                System.err.println(exception.getMessage());
            }
        }
        return properties;
    }

    private static void addProperties(Properties properties, Collection collection, String string) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Calculator calculator = (Calculator)iterator.next();
            if (calculator == null) continue;
            String string2 = string + "." + ((Object)calculator).toString();
            try {
                Properties properties2 = CalculatorFactory.getProperties(calculator, string2);
                properties.putAll((Map<?, ?>)properties2);
            }
            catch (Exception exception) {
                System.err.println("Exception while saving " + string2);
                System.err.println(exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public static void loadCalculators(Properties properties, CalculatorCatalog calculatorCatalog) {
        CalculatorIO.loadCalculators(properties, calculatorCatalog, true);
    }

    public static void loadCalculators(Properties properties, CalculatorCatalog calculatorCatalog, boolean bl) {
        VisualStyle visualStyle;
        Cloneable cloneable;
        String string;
        Properties properties2;
        Object object;
        Object object2;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashMap hashMap4 = new HashMap();
        HashMap hashMap5 = new HashMap();
        HashMap hashMap6 = new HashMap();
        HashMap hashMap7 = new HashMap();
        HashMap hashMap8 = new HashMap();
        HashMap hashMap9 = new HashMap();
        HashMap hashMap10 = new HashMap();
        HashMap hashMap11 = new HashMap();
        HashMap hashMap12 = new HashMap();
        HashMap hashMap13 = new HashMap();
        HashMap hashMap14 = new HashMap();
        HashMap hashMap15 = new HashMap();
        HashMap hashMap16 = new HashMap();
        HashMap hashMap17 = new HashMap();
        HashMap hashMap18 = new HashMap();
        Object object3 = properties.propertyNames();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            if (((String)object2).startsWith("nodeColorCalculator.")) {
                CalculatorIO.storeKey((String)object2, properties, hashMap);
                continue;
            }
            if (((String)object2).startsWith("nodeLineTypeCalculator.")) {
                CalculatorIO.storeKey((String)object2, properties, hashMap2);
                continue;
            }
            if (((String)object2).startsWith("nodeShapeCalculator.")) {
                CalculatorIO.storeKey((String)object2, properties, hashMap3);
                continue;
            }
            if (((String)object2).startsWith("nodeSizeCalculator.")) {
                CalculatorIO.storeKey((String)object2, properties, hashMap4);
                continue;
            }
            if (((String)object2).startsWith("nodeLabelCalculator.")) {
                CalculatorIO.storeKey((String)object2, properties, hashMap5);
                continue;
            }
            if (((String)object2).startsWith("nodeToolTipCalculator.")) {
                CalculatorIO.storeKey((String)object2, properties, hashMap6);
                continue;
            }
            if (((String)object2).startsWith("nodeFontFaceCalculator.")) {
                CalculatorIO.storeKey((String)object2, properties, hashMap7);
                continue;
            }
            if (((String)object2).startsWith("nodeFontSizeCalculator.")) {
                CalculatorIO.storeKey((String)object2, properties, hashMap8);
                continue;
            }
            if (((String)object2).startsWith("edgeColorCalculator.")) {
                CalculatorIO.storeKey((String)object2, properties, hashMap9);
                continue;
            }
            if (((String)object2).startsWith("edgeLineTypeCalculator.")) {
                CalculatorIO.storeKey((String)object2, properties, hashMap10);
                continue;
            }
            if (((String)object2).startsWith("edgeArrowCalculator.")) {
                CalculatorIO.storeKey((String)object2, properties, hashMap11);
                continue;
            }
            if (((String)object2).startsWith("edgeLabelCalculator.")) {
                CalculatorIO.storeKey((String)object2, properties, hashMap12);
                continue;
            }
            if (((String)object2).startsWith("edgeToolTipCalculator.")) {
                CalculatorIO.storeKey((String)object2, properties, hashMap13);
                continue;
            }
            if (((String)object2).startsWith("edgeFontFaceCalculator.")) {
                CalculatorIO.storeKey((String)object2, properties, hashMap14);
                continue;
            }
            if (((String)object2).startsWith("edgeFontSizeCalculator.")) {
                CalculatorIO.storeKey((String)object2, properties, hashMap15);
                continue;
            }
            if (((String)object2).startsWith("nodeAppearanceCalculator.")) {
                CalculatorIO.storeKey((String)object2, properties, hashMap16);
                continue;
            }
            if (((String)object2).startsWith("edgeAppearanceCalculator.")) {
                CalculatorIO.storeKey((String)object2, properties, hashMap17);
                continue;
            }
            if (!((String)object2).startsWith("globalAppearanceCalculator.")) continue;
            CalculatorIO.storeKey((String)object2, properties, hashMap18);
        }
        CalculatorIO.handleCalculators(hashMap, calculatorCatalog, bl, nodeColorBaseKey, nodeColorClassName);
        CalculatorIO.handleCalculators(hashMap2, calculatorCatalog, bl, nodeLineTypeBaseKey, nodeLineTypeClassName);
        CalculatorIO.handleCalculators(hashMap3, calculatorCatalog, bl, nodeShapeBaseKey, nodeShapeClassName);
        CalculatorIO.handleCalculators(hashMap4, calculatorCatalog, bl, nodeSizeBaseKey, nodeSizeClassName);
        CalculatorIO.handleCalculators(hashMap5, calculatorCatalog, bl, nodeLabelBaseKey, nodeLabelClassName);
        CalculatorIO.handleCalculators(hashMap6, calculatorCatalog, bl, nodeToolTipBaseKey, nodeToolTipClassName);
        CalculatorIO.handleCalculators(hashMap7, calculatorCatalog, bl, nodeFontFaceBaseKey, nodeFontFaceClassName);
        CalculatorIO.handleCalculators(hashMap8, calculatorCatalog, bl, nodeFontSizeBaseKey, nodeFontSizeClassName);
        CalculatorIO.handleCalculators(hashMap9, calculatorCatalog, bl, edgeColorBaseKey, edgeColorClassName);
        CalculatorIO.handleCalculators(hashMap10, calculatorCatalog, bl, edgeLineTypeBaseKey, edgeLineTypeClassName);
        CalculatorIO.handleCalculators(hashMap11, calculatorCatalog, bl, edgeArrowBaseKey, edgeArrowClassName);
        CalculatorIO.handleCalculators(hashMap12, calculatorCatalog, bl, edgeLabelBaseKey, edgeLabelClassName);
        CalculatorIO.handleCalculators(hashMap13, calculatorCatalog, bl, edgeToolTipBaseKey, edgeToolTipClassName);
        CalculatorIO.handleCalculators(hashMap14, calculatorCatalog, bl, edgeFontFaceBaseKey, edgeFontFaceClassName);
        CalculatorIO.handleCalculators(hashMap15, calculatorCatalog, bl, edgeFontSizeBaseKey, edgeFontSizeClassName);
        object3 = new HashMap();
        object2 = hashMap16.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            properties2 = (Properties)hashMap16.get(object);
            string = "nodeAppearanceCalculator." + (String)object;
            cloneable = new NodeAppearanceCalculator((String)object, properties2, string, calculatorCatalog);
            visualStyle = (VisualStyle)object3.get(object);
            if (visualStyle == null) {
                visualStyle = new VisualStyle((String)object);
                object3.put(object, visualStyle);
            }
            visualStyle.setNodeAppearanceCalculator((NodeAppearanceCalculator)cloneable);
        }
        object2 = hashMap17.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            properties2 = (Properties)hashMap17.get(object);
            string = "edgeAppearanceCalculator." + (String)object;
            cloneable = new EdgeAppearanceCalculator((String)object, properties2, string, calculatorCatalog);
            visualStyle = (VisualStyle)object3.get(object);
            if (visualStyle == null) {
                visualStyle = new VisualStyle((String)object);
                object3.put(object, visualStyle);
            }
            visualStyle.setEdgeAppearanceCalculator((EdgeAppearanceCalculator)cloneable);
        }
        object2 = hashMap18.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            properties2 = (Properties)hashMap18.get(object);
            string = "globalAppearanceCalculator." + (String)object;
            cloneable = new GlobalAppearanceCalculator((String)object, properties2, string, calculatorCatalog);
            visualStyle = (VisualStyle)object3.get(object);
            if (visualStyle == null) {
                visualStyle = new VisualStyle((String)object);
                object3.put(object, visualStyle);
            }
            visualStyle.setGlobalAppearanceCalculator((GlobalAppearanceCalculator)cloneable);
        }
        object2 = object3.values().iterator();
        while (object2.hasNext()) {
            object = (VisualStyle)object2.next();
            calculatorCatalog.addVisualStyle((VisualStyle)object);
        }
    }

    private static void storeKey(String string, Properties properties, Map map) {
        String string2 = CalculatorIO.extractName(string);
        if (string2 != null) {
            Properties properties2 = (Properties)map.get(string2);
            if (properties2 == null) {
                properties2 = new Properties();
                map.put(string2, properties2);
            }
            properties2.setProperty(string, properties.getProperty(string));
        }
    }

    private static String extractName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(".");
        if (n == -1 || n >= string.length() - 1) {
            return null;
        }
        int n2 = string.indexOf(".", n + 1);
        if (n2 == -1) {
            return null;
        }
        return string.substring(n + 1, n2);
    }

    private static void handleCalculators(Map map, CalculatorCatalog calculatorCatalog, boolean bl, String string, String string2) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string3;
            String string4;
            Properties properties;
            String string5 = (String)iterator.next();
            Calculator calculator = CalculatorFactory.newCalculator(string5, properties = (Properties)map.get(string5), string4 = string + "." + string5, string3 = dirHeader + string2);
            if (calculator == null) continue;
            if (bl) {
                CalculatorIO.removeDuplicate(calculator, calculatorCatalog);
            } else {
                CalculatorIO.renameAsNeeded(calculator, calculatorCatalog);
            }
            calculatorCatalog.addCalculator(calculator);
        }
    }

    public static void removeDuplicate(Calculator calculator, CalculatorCatalog calculatorCatalog) {
        String string = ((Object)calculator).toString();
        if (calculator instanceof NodeColorCalculator) {
            calculatorCatalog.removeNodeColorCalculator(string);
        } else if (calculator instanceof NodeLineTypeCalculator) {
            calculatorCatalog.removeNodeLineTypeCalculator(string);
        } else if (calculator instanceof NodeShapeCalculator) {
            calculatorCatalog.removeNodeShapeCalculator(string);
        } else if (calculator instanceof NodeSizeCalculator) {
            calculatorCatalog.removeNodeSizeCalculator(string);
        } else if (calculator instanceof NodeLabelCalculator) {
            calculatorCatalog.removeNodeLabelCalculator(string);
        } else if (calculator instanceof NodeToolTipCalculator) {
            calculatorCatalog.removeNodeToolTipCalculator(string);
        } else if (calculator instanceof NodeFontFaceCalculator) {
            calculatorCatalog.removeNodeFontFaceCalculator(string);
        } else if (calculator instanceof NodeFontSizeCalculator) {
            calculatorCatalog.removeNodeFontSizeCalculator(string);
        } else if (calculator instanceof EdgeColorCalculator) {
            calculatorCatalog.removeEdgeColorCalculator(string);
        } else if (calculator instanceof EdgeLineTypeCalculator) {
            calculatorCatalog.removeEdgeLineTypeCalculator(string);
        } else if (calculator instanceof EdgeArrowCalculator) {
            calculatorCatalog.removeEdgeArrowCalculator(string);
        } else if (calculator instanceof EdgeLabelCalculator) {
            calculatorCatalog.removeEdgeLabelCalculator(string);
        } else if (calculator instanceof EdgeToolTipCalculator) {
            calculatorCatalog.removeEdgeToolTipCalculator(string);
        } else if (calculator instanceof EdgeFontFaceCalculator) {
            calculatorCatalog.removeEdgeFontFaceCalculator(string);
        } else if (calculator instanceof EdgeFontSizeCalculator) {
            calculatorCatalog.removeEdgeFontSizeCalculator(string);
        }
    }

    public static void renameAsNeeded(Calculator calculator, CalculatorCatalog calculatorCatalog) {
        String string;
        String string2 = ((Object)calculator).toString();
        if (calculator instanceof NodeColorCalculator) {
            String string3 = calculatorCatalog.checkNodeColorCalculatorName(string2);
            if (!string3.equals(string2)) {
                calculator.setName(string3);
            }
        } else if (calculator instanceof NodeLineTypeCalculator) {
            String string4 = calculatorCatalog.checkNodeLineTypeCalculatorName(string2);
            if (!string4.equals(string2)) {
                calculator.setName(string4);
            }
        } else if (calculator instanceof NodeShapeCalculator) {
            String string5 = calculatorCatalog.checkNodeShapeCalculatorName(string2);
            if (!string5.equals(string2)) {
                calculator.setName(string5);
            }
        } else if (calculator instanceof NodeSizeCalculator) {
            String string6 = calculatorCatalog.checkNodeSizeCalculatorName(string2);
            if (!string6.equals(string2)) {
                calculator.setName(string6);
            }
        } else if (calculator instanceof NodeLabelCalculator) {
            String string7 = calculatorCatalog.checkNodeLabelCalculatorName(string2);
            if (!string7.equals(string2)) {
                calculator.setName(string7);
            }
        } else if (calculator instanceof NodeToolTipCalculator) {
            String string8 = calculatorCatalog.checkNodeToolTipCalculatorName(string2);
            if (!string8.equals(string2)) {
                calculator.setName(string8);
            }
        } else if (calculator instanceof NodeFontFaceCalculator) {
            String string9 = calculatorCatalog.checkNodeFontFaceCalculatorName(string2);
            if (!string9.equals(string2)) {
                calculator.setName(string9);
            }
        } else if (calculator instanceof NodeFontSizeCalculator) {
            String string10 = calculatorCatalog.checkNodeFontSizeCalculatorName(string2);
            if (!string10.equals(string2)) {
                calculator.setName(string10);
            }
        } else if (calculator instanceof EdgeColorCalculator) {
            String string11 = calculatorCatalog.checkEdgeColorCalculatorName(string2);
            if (!string11.equals(string2)) {
                calculator.setName(string11);
            }
        } else if (calculator instanceof EdgeLineTypeCalculator) {
            String string12 = calculatorCatalog.checkEdgeLineTypeCalculatorName(string2);
            if (!string12.equals(string2)) {
                calculator.setName(string12);
            }
        } else if (calculator instanceof EdgeArrowCalculator) {
            String string13 = calculatorCatalog.checkEdgeArrowCalculatorName(string2);
            if (!string13.equals(string2)) {
                calculator.setName(string13);
            }
        } else if (calculator instanceof EdgeLabelCalculator) {
            String string14 = calculatorCatalog.checkEdgeLabelCalculatorName(string2);
            if (!string14.equals(string2)) {
                calculator.setName(string14);
            }
        } else if (calculator instanceof EdgeToolTipCalculator) {
            String string15 = calculatorCatalog.checkEdgeToolTipCalculatorName(string2);
            if (!string15.equals(string2)) {
                calculator.setName(string15);
            }
        } else if (calculator instanceof EdgeFontFaceCalculator) {
            String string16 = calculatorCatalog.checkEdgeFontFaceCalculatorName(string2);
            if (!string16.equals(string2)) {
                calculator.setName(string16);
            }
        } else if (calculator instanceof EdgeFontSizeCalculator && !(string = calculatorCatalog.checkEdgeFontSizeCalculatorName(string2)).equals(string2)) {
            calculator.setName(string);
        }
    }
}

