/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.DuplicateCalculatorNameException;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.EdgeArrowCalculator;
import cytoscape.visual.calculators.EdgeColorCalculator;
import cytoscape.visual.calculators.EdgeFontFaceCalculator;
import cytoscape.visual.calculators.EdgeFontSizeCalculator;
import cytoscape.visual.calculators.EdgeLabelCalculator;
import cytoscape.visual.calculators.EdgeLineTypeCalculator;
import cytoscape.visual.calculators.EdgeToolTipCalculator;
import cytoscape.visual.calculators.NodeColorCalculator;
import cytoscape.visual.calculators.NodeFontFaceCalculator;
import cytoscape.visual.calculators.NodeFontSizeCalculator;
import cytoscape.visual.calculators.NodeLabelCalculator;
import cytoscape.visual.calculators.NodeLineTypeCalculator;
import cytoscape.visual.calculators.NodeShapeCalculator;
import cytoscape.visual.calculators.NodeSizeCalculator;
import cytoscape.visual.calculators.NodeToolTipCalculator;
import cytoscape.visual.mappings.ObjectMapping;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CalculatorCatalog {
    Map nodeColorCalculators = new HashMap();
    List nodeColorListeners = new Vector(2, 1);
    Map nodeLineTypeCalculators = new HashMap();
    List nodeLineTypeListeners = new Vector(1, 1);
    Map nodeShapeCalculators = new HashMap();
    List nodeShapeListeners = new Vector(1, 1);
    Map nodeSizeCalculators = new HashMap();
    List nodeSizeListeners = new Vector(2, 1);
    Map nodeLabelCalculators = new HashMap();
    List nodeLabelListeners = new Vector(1, 1);
    Map nodeToolTipCalculators = new HashMap();
    List nodeToolTipListeners = new Vector(1, 1);
    Map nodeFontFaceCalculators = new HashMap();
    List nodeFontFaceListeners = new Vector(1, 1);
    Map nodeFontSizeCalculators = new HashMap();
    List nodeFontSizeListeners = new Vector(1, 1);
    Map edgeColorCalculators = new HashMap();
    List edgeColorListeners = new Vector(1, 1);
    Map edgeLineTypeCalculators = new HashMap();
    List edgeLineTypeListeners = new Vector(1, 1);
    Map edgeArrowCalculators = new HashMap();
    List edgeArrowListeners = new Vector(2, 1);
    Map edgeLabelCalculators = new HashMap();
    List edgeLabelListeners = new Vector(1, 1);
    Map edgeToolTipCalculators = new HashMap();
    List edgeToolTipListeners = new Vector(1, 1);
    Map edgeFontFaceCalculators = new HashMap();
    List edgeFontFaceListeners = new Vector(1, 1);
    Map edgeFontSizeCalculators = new HashMap();
    List edgeFontSizeListeners = new Vector(1, 1);
    Map visualStyles = new HashMap();
    Map mappers = new HashMap();
    protected transient ChangeEvent changeEvent;

    public CalculatorCatalog() {
    }

    public CalculatorCatalog(Properties properties) {
    }

    protected List getListenerList(byte by) throws IllegalArgumentException {
        switch (by) {
            case 0: 
            case 1: {
                return this.nodeColorListeners;
            }
            case 2: {
                return this.nodeLineTypeListeners;
            }
            case 3: {
                return this.nodeShapeListeners;
            }
            case 4: 
            case 126: 
            case 127: {
                return this.nodeSizeListeners;
            }
            case 5: {
                return this.nodeLabelListeners;
            }
            case 13: {
                return this.nodeToolTipListeners;
            }
            case 122: {
                return this.nodeFontFaceListeners;
            }
            case 123: {
                return this.nodeFontSizeListeners;
            }
            case 7: {
                return this.edgeColorListeners;
            }
            case 8: {
                return this.edgeLineTypeListeners;
            }
            case 9: 
            case 10: {
                return this.edgeArrowListeners;
            }
            case 11: {
                return this.edgeLabelListeners;
            }
            case 14: {
                return this.edgeToolTipListeners;
            }
            case 124: {
                return this.edgeFontFaceListeners;
            }
            case 125: {
                return this.edgeFontSizeListeners;
            }
        }
        throw new IllegalArgumentException("Unknown type " + by);
    }

    public void addChangeListener(ChangeListener changeListener, byte by) throws IllegalArgumentException {
        List list = this.getListenerList(by);
        list.add(changeListener);
    }

    protected void fireStateChanged(byte by) throws IllegalArgumentException {
        List list = this.getListenerList(by);
        for (int i = list.size() - 1; i >= 0; --i) {
            ChangeListener changeListener = (ChangeListener)list.get(i);
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            changeListener.stateChanged(this.changeEvent);
        }
    }

    public byte getType(Calculator calculator) throws IllegalArgumentException {
        if (calculator instanceof NodeColorCalculator) {
            return 0;
        }
        if (calculator instanceof NodeLineTypeCalculator) {
            return 2;
        }
        if (calculator instanceof NodeShapeCalculator) {
            return 3;
        }
        if (calculator instanceof NodeSizeCalculator) {
            return 4;
        }
        if (calculator instanceof NodeLabelCalculator) {
            return 5;
        }
        if (calculator instanceof NodeToolTipCalculator) {
            return 13;
        }
        if (calculator instanceof NodeFontFaceCalculator) {
            return 122;
        }
        if (calculator instanceof NodeFontSizeCalculator) {
            return 123;
        }
        if (calculator instanceof EdgeColorCalculator) {
            return 7;
        }
        if (calculator instanceof EdgeLineTypeCalculator) {
            return 8;
        }
        if (calculator instanceof EdgeArrowCalculator) {
            return 9;
        }
        if (calculator instanceof EdgeLabelCalculator) {
            return 11;
        }
        if (calculator instanceof EdgeToolTipCalculator) {
            return 14;
        }
        if (calculator instanceof EdgeFontFaceCalculator) {
            return 124;
        }
        if (calculator instanceof EdgeFontSizeCalculator) {
            return 125;
        }
        throw new IllegalArgumentException("Unknown calculator type");
    }

    protected Map getCalculatorMap(byte by) {
        switch (by) {
            case 0: 
            case 1: {
                return this.nodeColorCalculators;
            }
            case 2: {
                return this.nodeLineTypeCalculators;
            }
            case 3: {
                return this.nodeShapeCalculators;
            }
            case 4: 
            case 126: 
            case 127: {
                return this.nodeSizeCalculators;
            }
            case 5: {
                return this.nodeLabelCalculators;
            }
            case 13: {
                return this.nodeToolTipCalculators;
            }
            case 122: {
                return this.nodeFontFaceCalculators;
            }
            case 123: {
                return this.nodeFontSizeCalculators;
            }
            case 7: {
                return this.edgeColorCalculators;
            }
            case 8: {
                return this.edgeLineTypeCalculators;
            }
            case 9: 
            case 10: {
                return this.edgeArrowCalculators;
            }
            case 11: {
                return this.edgeLabelCalculators;
            }
            case 14: {
                return this.edgeToolTipCalculators;
            }
            case 124: {
                return this.edgeFontFaceCalculators;
            }
            case 125: {
                return this.edgeFontSizeCalculators;
            }
        }
        throw new IllegalArgumentException("Unknown type " + by);
    }

    public void addCalculator(Calculator calculator) throws DuplicateCalculatorNameException, IllegalArgumentException {
        byte by = this.getType(calculator);
        Map map = this.getCalculatorMap(by);
        this.addCalculator(calculator, map);
        this.fireStateChanged(by);
    }

    public String checkCalculatorName(String string, byte by) {
        Map map = this.getCalculatorMap(by);
        return this.checkName(string, map);
    }

    public void renameCalculator(Calculator calculator, String string) throws DuplicateCalculatorNameException, IllegalArgumentException {
        byte by = this.getType(calculator);
        Map map = this.getCalculatorMap(by);
        String string2 = this.checkName(string, map);
        if (!string2.equals(string)) {
            throw new DuplicateCalculatorNameException(string2);
        }
        map.remove(((Object)calculator).toString());
        calculator.setName(string);
        map.put(string, calculator);
        this.fireStateChanged(by);
    }

    public void removeCalculator(Calculator calculator) throws IllegalArgumentException {
        byte by = this.getType(calculator);
        Map map = this.getCalculatorMap(by);
        map.remove(((Object)calculator).toString());
        this.fireStateChanged(by);
    }

    public Set getMappingNames() {
        return this.mappers.keySet();
    }

    public void addMapping(String string, Class clazz) throws DuplicateCalculatorNameException, IllegalArgumentException {
        if (!ObjectMapping.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is not an ObjectMapper!");
        }
        if (this.mappers.keySet().contains(string)) {
            throw new DuplicateCalculatorNameException("Duplicate mapper name " + string);
        }
        this.mappers.put(string, clazz);
    }

    public Class removeMapping(String string) {
        return (Class)this.mappers.remove(string);
    }

    public Class getMapping(String string) {
        return (Class)this.mappers.get(string);
    }

    public String checkMappingName(String string) {
        String string2 = string;
        int n = 2;
        while (this.mappers.keySet().contains(string2)) {
            string2 = string + n;
            ++n;
        }
        return string2;
    }

    public Set getVisualStyleNames() {
        return this.visualStyles.keySet();
    }

    public Collection getVisualStyles() {
        return this.visualStyles.values();
    }

    public void addVisualStyle(VisualStyle visualStyle) {
        if (visualStyle == null) {
            return;
        }
        String string = visualStyle.toString();
        if (this.visualStyles.keySet().contains(string)) {
            String string2 = "Duplicate visual style name " + string;
            throw new DuplicateCalculatorNameException(string2);
        }
        this.visualStyles.put(string, visualStyle);
        this.addNodeAppearanceCalculator(visualStyle.getNodeAppearanceCalculator());
        this.addEdgeAppearanceCalculator(visualStyle.getEdgeAppearanceCalculator());
    }

    public VisualStyle removeVisualStyle(String string) {
        return (VisualStyle)this.visualStyles.remove(string);
    }

    public VisualStyle getVisualStyle(String string) {
        return (VisualStyle)this.visualStyles.get(string);
    }

    public String checkVisualStyleName(String string) {
        return this.checkName(string, this.visualStyles);
    }

    private void addNodeAppearanceCalculator(NodeAppearanceCalculator nodeAppearanceCalculator) {
        NodeFontSizeCalculator nodeFontSizeCalculator;
        NodeFontFaceCalculator nodeFontFaceCalculator;
        NodeToolTipCalculator nodeToolTipCalculator;
        NodeLabelCalculator nodeLabelCalculator;
        NodeSizeCalculator nodeSizeCalculator;
        NodeSizeCalculator nodeSizeCalculator2;
        NodeShapeCalculator nodeShapeCalculator;
        NodeLineTypeCalculator nodeLineTypeCalculator;
        NodeColorCalculator nodeColorCalculator;
        NodeColorCalculator nodeColorCalculator2 = nodeAppearanceCalculator.getNodeFillColorCalculator();
        if (nodeColorCalculator2 != null && !this.nodeColorCalculators.values().contains(nodeColorCalculator2)) {
            this.addNodeColorCalculator(nodeColorCalculator2);
        }
        if ((nodeColorCalculator = nodeAppearanceCalculator.getNodeBorderColorCalculator()) != null && !this.nodeColorCalculators.values().contains(nodeColorCalculator)) {
            this.addNodeColorCalculator(nodeColorCalculator);
        }
        if ((nodeLineTypeCalculator = nodeAppearanceCalculator.getNodeLineTypeCalculator()) != null && !this.nodeLineTypeCalculators.values().contains(nodeLineTypeCalculator)) {
            this.addNodeLineTypeCalculator(nodeLineTypeCalculator);
        }
        if ((nodeShapeCalculator = nodeAppearanceCalculator.getNodeShapeCalculator()) != null && !this.nodeShapeCalculators.values().contains(nodeShapeCalculator)) {
            this.addNodeShapeCalculator(nodeShapeCalculator);
        }
        if ((nodeSizeCalculator2 = nodeAppearanceCalculator.getNodeHeightCalculator()) != null && !this.nodeSizeCalculators.values().contains(nodeSizeCalculator2)) {
            this.addNodeSizeCalculator(nodeSizeCalculator2);
        }
        if ((nodeSizeCalculator = nodeAppearanceCalculator.getNodeWidthCalculator()) != null && !this.nodeSizeCalculators.values().contains(nodeSizeCalculator)) {
            this.addNodeSizeCalculator(nodeSizeCalculator);
        }
        if ((nodeLabelCalculator = nodeAppearanceCalculator.getNodeLabelCalculator()) != null && !this.nodeLabelCalculators.values().contains(nodeLabelCalculator)) {
            this.addNodeLabelCalculator(nodeLabelCalculator);
        }
        if ((nodeToolTipCalculator = nodeAppearanceCalculator.getNodeToolTipCalculator()) != null && !this.nodeToolTipCalculators.values().contains(nodeToolTipCalculator)) {
            this.addNodeToolTipCalculator(nodeToolTipCalculator);
        }
        if ((nodeFontFaceCalculator = nodeAppearanceCalculator.getNodeFontFaceCalculator()) != null && !this.nodeFontFaceCalculators.values().contains(nodeFontFaceCalculator)) {
            this.addNodeFontFaceCalculator(nodeFontFaceCalculator);
        }
        if ((nodeFontSizeCalculator = nodeAppearanceCalculator.getNodeFontSizeCalculator()) != null && !this.nodeFontSizeCalculators.values().contains(nodeFontSizeCalculator)) {
            this.addNodeFontSizeCalculator(nodeFontSizeCalculator);
        }
    }

    private void addEdgeAppearanceCalculator(EdgeAppearanceCalculator edgeAppearanceCalculator) {
        EdgeFontSizeCalculator edgeFontSizeCalculator;
        EdgeFontFaceCalculator edgeFontFaceCalculator;
        EdgeToolTipCalculator edgeToolTipCalculator;
        EdgeLabelCalculator edgeLabelCalculator;
        EdgeArrowCalculator edgeArrowCalculator;
        EdgeArrowCalculator edgeArrowCalculator2;
        EdgeLineTypeCalculator edgeLineTypeCalculator;
        EdgeColorCalculator edgeColorCalculator = edgeAppearanceCalculator.getEdgeColorCalculator();
        if (edgeColorCalculator != null && !this.edgeColorCalculators.values().contains(edgeColorCalculator)) {
            this.addEdgeColorCalculator(edgeColorCalculator);
        }
        if ((edgeLineTypeCalculator = edgeAppearanceCalculator.getEdgeLineTypeCalculator()) != null && !this.edgeLineTypeCalculators.values().contains(edgeLineTypeCalculator)) {
            this.addEdgeLineTypeCalculator(edgeLineTypeCalculator);
        }
        if ((edgeArrowCalculator2 = edgeAppearanceCalculator.getEdgeSourceArrowCalculator()) != null && !this.edgeArrowCalculators.values().contains(edgeArrowCalculator2)) {
            this.addEdgeArrowCalculator(edgeArrowCalculator2);
        }
        if ((edgeArrowCalculator = edgeAppearanceCalculator.getEdgeTargetArrowCalculator()) != null && !this.edgeArrowCalculators.values().contains(edgeArrowCalculator)) {
            this.addEdgeArrowCalculator(edgeArrowCalculator);
        }
        if ((edgeLabelCalculator = edgeAppearanceCalculator.getEdgeLabelCalculator()) != null && !this.edgeLabelCalculators.values().contains(edgeLabelCalculator)) {
            this.addEdgeLabelCalculator(edgeLabelCalculator);
        }
        if ((edgeToolTipCalculator = edgeAppearanceCalculator.getEdgeToolTipCalculator()) != null && !this.edgeToolTipCalculators.values().contains(edgeToolTipCalculator)) {
            this.addEdgeToolTipCalculator(edgeToolTipCalculator);
        }
        if ((edgeFontFaceCalculator = edgeAppearanceCalculator.getEdgeFontFaceCalculator()) != null && !this.edgeFontFaceCalculators.values().contains(edgeFontFaceCalculator)) {
            this.addEdgeFontFaceCalculator(edgeFontFaceCalculator);
        }
        if ((edgeFontSizeCalculator = edgeAppearanceCalculator.getEdgeFontSizeCalculator()) != null && !this.edgeFontSizeCalculators.values().contains(edgeFontSizeCalculator)) {
            this.addEdgeFontSizeCalculator(edgeFontSizeCalculator);
        }
    }

    protected void addCalculator(Calculator calculator, Map map) throws DuplicateCalculatorNameException {
        if (calculator == null) {
            return;
        }
        String string = ((Object)calculator).toString();
        if (map.keySet().contains(string)) {
            String string2 = "Duplicate calculator name " + string;
            throw new DuplicateCalculatorNameException(string2);
        }
        map.put(string, calculator);
    }

    protected String checkName(String string, Map map) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        int n = 2;
        while (map.keySet().contains(string2)) {
            string2 = string + n;
            ++n;
        }
        return string2;
    }

    public Collection getNodeColorCalculators() {
        return this.nodeColorCalculators.values();
    }

    public void addNodeColorCalculator(NodeColorCalculator nodeColorCalculator) throws DuplicateCalculatorNameException {
        this.addCalculator(nodeColorCalculator, this.nodeColorCalculators);
    }

    public NodeColorCalculator removeNodeColorCalculator(String string) {
        return (NodeColorCalculator)this.nodeColorCalculators.remove(string);
    }

    public NodeColorCalculator getNodeColorCalculator(String string) {
        return (NodeColorCalculator)this.nodeColorCalculators.get(string);
    }

    public String checkNodeColorCalculatorName(String string) {
        return this.checkName(string, this.nodeColorCalculators);
    }

    public Collection getNodeLineTypeCalculators() {
        return this.nodeLineTypeCalculators.values();
    }

    public void addNodeLineTypeCalculator(NodeLineTypeCalculator nodeLineTypeCalculator) throws DuplicateCalculatorNameException {
        this.addCalculator(nodeLineTypeCalculator, this.nodeLineTypeCalculators);
    }

    public NodeLineTypeCalculator removeNodeLineTypeCalculator(String string) {
        return (NodeLineTypeCalculator)this.nodeLineTypeCalculators.remove(string);
    }

    public NodeLineTypeCalculator getNodeLineTypeCalculator(String string) {
        return (NodeLineTypeCalculator)this.nodeLineTypeCalculators.get(string);
    }

    public String checkNodeLineTypeCalculatorName(String string) {
        return this.checkName(string, this.nodeLineTypeCalculators);
    }

    public Collection getNodeShapeCalculators() {
        return this.nodeShapeCalculators.values();
    }

    public void addNodeShapeCalculator(NodeShapeCalculator nodeShapeCalculator) throws DuplicateCalculatorNameException {
        this.addCalculator(nodeShapeCalculator, this.nodeShapeCalculators);
    }

    public NodeShapeCalculator removeNodeShapeCalculator(String string) {
        return (NodeShapeCalculator)this.nodeShapeCalculators.remove(string);
    }

    public NodeShapeCalculator getNodeShapeCalculator(String string) {
        return (NodeShapeCalculator)this.nodeShapeCalculators.get(string);
    }

    public String checkNodeShapeCalculatorName(String string) {
        return this.checkName(string, this.nodeShapeCalculators);
    }

    public Collection getNodeSizeCalculators() {
        return this.nodeSizeCalculators.values();
    }

    public void addNodeSizeCalculator(NodeSizeCalculator nodeSizeCalculator) throws DuplicateCalculatorNameException {
        this.addCalculator(nodeSizeCalculator, this.nodeSizeCalculators);
    }

    public NodeSizeCalculator removeNodeSizeCalculator(String string) {
        return (NodeSizeCalculator)this.nodeSizeCalculators.remove(string);
    }

    public NodeSizeCalculator getNodeSizeCalculator(String string) {
        return (NodeSizeCalculator)this.nodeSizeCalculators.get(string);
    }

    public String checkNodeSizeCalculatorName(String string) {
        return this.checkName(string, this.nodeSizeCalculators);
    }

    public Collection getNodeLabelCalculators() {
        return this.nodeLabelCalculators.values();
    }

    public void addNodeLabelCalculator(NodeLabelCalculator nodeLabelCalculator) throws DuplicateCalculatorNameException {
        this.addCalculator(nodeLabelCalculator, this.nodeLabelCalculators);
    }

    public NodeLabelCalculator removeNodeLabelCalculator(String string) {
        return (NodeLabelCalculator)this.nodeLabelCalculators.remove(string);
    }

    public NodeLabelCalculator getNodeLabelCalculator(String string) {
        return (NodeLabelCalculator)this.nodeLabelCalculators.get(string);
    }

    public String checkNodeLabelCalculatorName(String string) {
        return this.checkName(string, this.nodeLabelCalculators);
    }

    public Collection getNodeToolTipCalculators() {
        return this.nodeToolTipCalculators.values();
    }

    public void addNodeToolTipCalculator(NodeToolTipCalculator nodeToolTipCalculator) throws DuplicateCalculatorNameException {
        this.addCalculator(nodeToolTipCalculator, this.nodeToolTipCalculators);
    }

    public NodeToolTipCalculator removeNodeToolTipCalculator(String string) {
        return (NodeToolTipCalculator)this.nodeToolTipCalculators.remove(string);
    }

    public NodeToolTipCalculator getNodeToolTipCalculator(String string) {
        return (NodeToolTipCalculator)this.nodeToolTipCalculators.get(string);
    }

    public String checkNodeToolTipCalculatorName(String string) {
        return this.checkName(string, this.nodeToolTipCalculators);
    }

    public Collection getNodeFontFaceCalculators() {
        return this.nodeFontFaceCalculators.values();
    }

    public void addNodeFontFaceCalculator(NodeFontFaceCalculator nodeFontFaceCalculator) throws DuplicateCalculatorNameException {
        this.addCalculator(nodeFontFaceCalculator, this.nodeFontFaceCalculators);
    }

    public NodeFontFaceCalculator removeNodeFontFaceCalculator(String string) {
        return (NodeFontFaceCalculator)this.nodeFontFaceCalculators.remove(string);
    }

    public NodeFontFaceCalculator getNodeFontFaceCalculator(String string) {
        return (NodeFontFaceCalculator)this.nodeFontFaceCalculators.get(string);
    }

    public String checkNodeFontFaceCalculatorName(String string) {
        return this.checkName(string, this.nodeFontFaceCalculators);
    }

    public Collection getNodeFontSizeCalculators() {
        return this.nodeFontSizeCalculators.values();
    }

    public void addNodeFontSizeCalculator(NodeFontSizeCalculator nodeFontSizeCalculator) throws DuplicateCalculatorNameException {
        this.addCalculator(nodeFontSizeCalculator, this.nodeFontSizeCalculators);
    }

    public NodeFontSizeCalculator removeNodeFontSizeCalculator(String string) {
        return (NodeFontSizeCalculator)this.nodeFontSizeCalculators.remove(string);
    }

    public NodeFontSizeCalculator getNodeFontSizeCalculator(String string) {
        return (NodeFontSizeCalculator)this.nodeFontSizeCalculators.get(string);
    }

    public String checkNodeFontSizeCalculatorName(String string) {
        return this.checkName(string, this.nodeFontSizeCalculators);
    }

    public Collection getEdgeColorCalculators() {
        return this.edgeColorCalculators.values();
    }

    public void addEdgeColorCalculator(EdgeColorCalculator edgeColorCalculator) throws DuplicateCalculatorNameException {
        this.addCalculator(edgeColorCalculator, this.edgeColorCalculators);
    }

    public EdgeColorCalculator removeEdgeColorCalculator(String string) {
        return (EdgeColorCalculator)this.edgeColorCalculators.remove(string);
    }

    public EdgeColorCalculator getEdgeColorCalculator(String string) {
        return (EdgeColorCalculator)this.edgeColorCalculators.get(string);
    }

    public String checkEdgeColorCalculatorName(String string) {
        return this.checkName(string, this.edgeColorCalculators);
    }

    public Collection getEdgeLineTypeCalculators() {
        return this.edgeLineTypeCalculators.values();
    }

    public void addEdgeLineTypeCalculator(EdgeLineTypeCalculator edgeLineTypeCalculator) throws DuplicateCalculatorNameException {
        this.addCalculator(edgeLineTypeCalculator, this.edgeLineTypeCalculators);
    }

    public EdgeLineTypeCalculator removeEdgeLineTypeCalculator(String string) {
        return (EdgeLineTypeCalculator)this.edgeLineTypeCalculators.remove(string);
    }

    public EdgeLineTypeCalculator getEdgeLineTypeCalculator(String string) {
        return (EdgeLineTypeCalculator)this.edgeLineTypeCalculators.get(string);
    }

    public String checkEdgeLineTypeCalculatorName(String string) {
        return this.checkName(string, this.edgeLineTypeCalculators);
    }

    public Collection getEdgeArrowCalculators() {
        return this.edgeArrowCalculators.values();
    }

    public void addEdgeArrowCalculator(EdgeArrowCalculator edgeArrowCalculator) throws DuplicateCalculatorNameException {
        this.addCalculator(edgeArrowCalculator, this.edgeArrowCalculators);
    }

    public EdgeArrowCalculator removeEdgeArrowCalculator(String string) {
        return (EdgeArrowCalculator)this.edgeArrowCalculators.remove(string);
    }

    public EdgeArrowCalculator getEdgeArrowCalculator(String string) {
        return (EdgeArrowCalculator)this.edgeArrowCalculators.get(string);
    }

    public String checkEdgeArrowCalculatorName(String string) {
        return this.checkName(string, this.edgeArrowCalculators);
    }

    public Collection getEdgeLabelCalculators() {
        return this.edgeLabelCalculators.values();
    }

    public void addEdgeLabelCalculator(EdgeLabelCalculator edgeLabelCalculator) throws DuplicateCalculatorNameException {
        this.addCalculator(edgeLabelCalculator, this.edgeLabelCalculators);
    }

    public EdgeLabelCalculator removeEdgeLabelCalculator(String string) {
        return (EdgeLabelCalculator)this.edgeLabelCalculators.remove(string);
    }

    public EdgeLabelCalculator getEdgeLabelCalculator(String string) {
        return (EdgeLabelCalculator)this.edgeLabelCalculators.get(string);
    }

    public String checkEdgeLabelCalculatorName(String string) {
        return this.checkName(string, this.edgeLabelCalculators);
    }

    public Collection getEdgeToolTipCalculators() {
        return this.edgeToolTipCalculators.values();
    }

    public void addEdgeToolTipCalculator(EdgeToolTipCalculator edgeToolTipCalculator) throws DuplicateCalculatorNameException {
        this.addCalculator(edgeToolTipCalculator, this.edgeToolTipCalculators);
    }

    public EdgeToolTipCalculator removeEdgeToolTipCalculator(String string) {
        return (EdgeToolTipCalculator)this.edgeToolTipCalculators.remove(string);
    }

    public EdgeToolTipCalculator getEdgeToolTipCalculator(String string) {
        return (EdgeToolTipCalculator)this.edgeToolTipCalculators.get(string);
    }

    public String checkEdgeToolTipCalculatorName(String string) {
        return this.checkName(string, this.edgeToolTipCalculators);
    }

    public Collection getEdgeFontFaceCalculators() {
        return this.edgeFontFaceCalculators.values();
    }

    public void addEdgeFontFaceCalculator(EdgeFontFaceCalculator edgeFontFaceCalculator) throws DuplicateCalculatorNameException {
        this.addCalculator(edgeFontFaceCalculator, this.edgeFontFaceCalculators);
    }

    public EdgeFontFaceCalculator removeEdgeFontFaceCalculator(String string) {
        return (EdgeFontFaceCalculator)this.edgeFontFaceCalculators.remove(string);
    }

    public EdgeFontFaceCalculator getEdgeFontFaceCalculator(String string) {
        return (EdgeFontFaceCalculator)this.edgeFontFaceCalculators.get(string);
    }

    public String checkEdgeFontFaceCalculatorName(String string) {
        return this.checkName(string, this.edgeFontFaceCalculators);
    }

    public Collection getEdgeFontSizeCalculators() {
        return this.edgeFontSizeCalculators.values();
    }

    public void addEdgeFontSizeCalculator(EdgeFontSizeCalculator edgeFontSizeCalculator) throws DuplicateCalculatorNameException {
        this.addCalculator(edgeFontSizeCalculator, this.edgeFontSizeCalculators);
    }

    public EdgeFontSizeCalculator removeEdgeFontSizeCalculator(String string) {
        return (EdgeFontSizeCalculator)this.edgeFontSizeCalculators.remove(string);
    }

    public EdgeFontSizeCalculator getEdgeFontSizeCalculator(String string) {
        return (EdgeFontSizeCalculator)this.edgeFontSizeCalculators.get(string);
    }

    public String checkEdgeFontSizeCalculatorName(String string) {
        return this.checkName(string, this.edgeFontSizeCalculators);
    }
}

