/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.unitTests;

import cytoscape.unitTests.AllTests;
import cytoscape.util.Misc;
import java.awt.Color;
import java.util.Properties;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class MiscTest
extends TestCase {
    private boolean runAll = false;

    public MiscTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testParseRGBTest() throws Exception {
        AllTests.standardOut("testRGBParseText");
        Color color = Misc.parseRGBText("0,0,0");
        MiscTest.assertTrue((boolean)color.equals(Color.black));
        color = Misc.parseRGBText("27,39,121");
        MiscTest.assertTrue((color.getRed() == 27 ? 1 : 0) != 0);
        MiscTest.assertTrue((color.getGreen() == 39 ? 1 : 0) != 0);
        MiscTest.assertTrue((color.getBlue() == 121 ? 1 : 0) != 0);
        color = Misc.parseRGBText(" 27 , 39 , 121 ");
        MiscTest.assertTrue((color.getRed() == 27 ? 1 : 0) != 0);
        MiscTest.assertTrue((color.getGreen() == 39 ? 1 : 0) != 0);
        MiscTest.assertTrue((color.getBlue() == 121 ? 1 : 0) != 0);
        color = Misc.parseRGBText("255,255,255");
        MiscTest.assertTrue((boolean)color.equals(Color.white));
    }

    public void testParseList() throws Exception {
        AllTests.standardOut("testParseList");
        String string = "::";
        String string2 = "(";
        String string3 = ")";
        String string4 = "abcd";
        String string5 = "efgh";
        String string6 = "dog";
        String string7 = "cat";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  ");
        stringBuffer.append(string2);
        stringBuffer.append(string4 + string);
        stringBuffer.append(string5 + string);
        stringBuffer.append(string6 + string);
        stringBuffer.append(string7);
        stringBuffer.append(string3);
        stringBuffer.append("   ");
        String[] stringArray = Misc.parseList(stringBuffer.toString(), string2, string3, string);
        MiscTest.assertTrue((stringArray.length == 4 ? 1 : 0) != 0);
        MiscTest.assertTrue((boolean)stringArray[0].equals(string4));
        MiscTest.assertTrue((boolean)stringArray[1].equals(string5));
        MiscTest.assertTrue((boolean)stringArray[2].equals(string6));
        MiscTest.assertTrue((boolean)stringArray[3].equals(string7));
        string4 = "((abcd))";
        string5 = "ef()gh";
        string6 = "do))((g";
        string7 = "c*())*at";
        stringBuffer = new StringBuffer();
        stringBuffer.append("  ");
        stringBuffer.append(string2);
        stringBuffer.append(string4 + string);
        stringBuffer.append(string5 + string);
        stringBuffer.append(string6 + string);
        stringBuffer.append(string7);
        stringBuffer.append(string3);
        stringBuffer.append("  ");
        stringArray = Misc.parseList(stringBuffer.toString(), string2, string3, string);
        MiscTest.assertTrue((stringArray.length == 4 ? 1 : 0) != 0);
        MiscTest.assertTrue((boolean)stringArray[0].equals(string4));
        MiscTest.assertTrue((boolean)stringArray[1].equals(string5));
        MiscTest.assertTrue((boolean)stringArray[2].equals(string6));
        MiscTest.assertTrue((boolean)stringArray[3].equals(string7));
        string4 = "abcd))";
        string5 = "ef()gh";
        string6 = "do))((g";
        string7 = "c*())*at";
        stringBuffer = new StringBuffer();
        stringBuffer.append(string4 + string);
        stringBuffer.append(string5 + string);
        stringBuffer.append(string6 + string);
        stringBuffer.append(string7);
        stringBuffer.append(string3);
        stringBuffer.append("   ");
        stringArray = Misc.parseList(stringBuffer.toString(), string2, string3, string);
        MiscTest.assertTrue((stringArray.length == 1 ? 1 : 0) != 0);
        string4 = "abcd))";
        string5 = "ef()gh";
        string6 = "do))((g";
        string7 = "c*())*at";
        stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append(string4 + string);
        stringBuffer.append(string5 + string);
        stringBuffer.append(string6 + string);
        stringBuffer.append(string7);
        stringBuffer.append("   ");
        stringArray = Misc.parseList(stringBuffer.toString(), string2, string3, string);
        MiscTest.assertTrue((stringArray.length == 1 ? 1 : 0) != 0);
        string4 = "http://www.genome.ad.jp/dbget-bin/get_pathway?org_name=hsa&mapno=00600";
        string5 = "http://www.genome.ad.jp/dbget-bin/get_pathway?org_name=hsa&mapno=00562";
        string6 = "http://www.genome.ad.jp/dbget-bin/get_pathway?org_name=hsa&mapno=00500";
        string7 = "http://www.genome.ad.jp/dbget-bin/get_pathway?org_name=hsa&mapno=00860";
        String string8 = "http://www.genome.ad.jp/dbget-bin/get_pathway?org_name=hsa&mapno=00760";
        stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append(string4 + string);
        stringBuffer.append(string5 + string);
        stringBuffer.append(string6 + string);
        stringBuffer.append(string7 + string);
        stringBuffer.append(string8);
        stringBuffer.append(string3);
        stringArray = Misc.parseList(stringBuffer.toString(), string2, string3, string);
        MiscTest.assertTrue((stringArray.length == 5 ? 1 : 0) != 0);
        MiscTest.assertTrue((boolean)stringArray[0].equals(string4));
        MiscTest.assertTrue((boolean)stringArray[1].equals(string5));
        MiscTest.assertTrue((boolean)stringArray[2].equals(string6));
        MiscTest.assertTrue((boolean)stringArray[3].equals(string7));
        MiscTest.assertTrue((boolean)stringArray[4].equals(string8));
    }

    public void testGetPropertyValues() throws Exception {
        AllTests.standardOut("testGetPropertyValues");
        Properties properties = new Properties();
        properties.put("dog", "dozer");
        properties.put("cat", "(ernie::louie)");
        Vector vector = Misc.getPropertyValues(properties, "dog");
        MiscTest.assertTrue((vector.size() == 1 ? 1 : 0) != 0);
        Vector vector2 = Misc.getPropertyValues(properties, "cat");
        MiscTest.assertTrue((vector2.size() == 2 ? 1 : 0) != 0);
        String[] stringArray = vector2.toArray(new String[0]);
        MiscTest.assertTrue((stringArray.length == 2 ? 1 : 0) != 0);
        MiscTest.assertTrue((boolean)stringArray[0].equals("ernie"));
        MiscTest.assertTrue((boolean)stringArray[1].equals("louie"));
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(MiscTest.class));
    }
}

