/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.unitTests;

import cytoscape.unitTests.AllTests;
import cytoscape.util.MinMaxDouble;
import cytoscape.util.MinMaxInt;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class MinMaxTest
extends TestCase {
    public MinMaxTest(String string) {
        super(string);
    }

    public void testMinMaxDoubleVector() throws Exception {
        AllTests.standardOut("testMinMaxDoubleVector");
        double d = -888.88;
        double d2 = 123456.789;
        double[] dArray = new double[]{1.0, 23.2, 18.5, -100.232, d2, d};
        MinMaxDouble minMaxDouble = new MinMaxDouble(dArray);
        MinMaxTest.assertTrue((minMaxDouble.getMin() == d ? 1 : 0) != 0);
        MinMaxTest.assertTrue((minMaxDouble.getMax() == d2 ? 1 : 0) != 0);
    }

    public void testMinMaxDoubleMatrix() throws Exception {
        AllTests.standardOut("testMinMaxDoubleMatrix");
        double d = -888.88;
        double d2 = 123456.789;
        double[][] dArrayArray = new double[][]{{1.0, 23.2, 18.5, -100.232, d2, d}, {8.7, 1.2, 1.2, 1.2, 1.2, -50.3}, {23.4, 2.1, 2.1, 2.1, 2.2, 0.0}};
        MinMaxDouble minMaxDouble = new MinMaxDouble(dArrayArray);
        MinMaxTest.assertTrue((minMaxDouble.getMin() == d ? 1 : 0) != 0);
        MinMaxTest.assertTrue((minMaxDouble.getMax() == d2 ? 1 : 0) != 0);
    }

    public void testMinMaxIntVector() throws Exception {
        AllTests.standardOut("testMinMaxIntVector");
        int n = -888;
        int n2 = 123456;
        int[] nArray = new int[]{1, 232, 18, -100, n2, n};
        MinMaxInt minMaxInt = new MinMaxInt(nArray);
        MinMaxTest.assertTrue((minMaxInt.getMin() == n ? 1 : 0) != 0);
        MinMaxTest.assertTrue((minMaxInt.getMax() == n2 ? 1 : 0) != 0);
    }

    public void testMinMaxIntMatrix() throws Exception {
        AllTests.standardOut("testMinMaxIntMatrix");
        int n = -888;
        int n2 = 123456;
        int[][] nArrayArray = new int[][]{{1, 23, 18, -100, n2, n}, {8, 1, 1, 1, 1, -50}, {23, 2, 2, 2, 2, 0}};
        MinMaxInt minMaxInt = new MinMaxInt(nArrayArray);
        MinMaxTest.assertTrue((minMaxInt.getMin() == n ? 1 : 0) != 0);
        MinMaxTest.assertTrue((minMaxInt.getMax() == n2 ? 1 : 0) != 0);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(MinMaxTest.class));
    }
}

