/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.unitTests;

import cytoscape.unitTests.AllTests;
import cytoscape.util.Exec;
import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ExecTest
extends TestCase {
    public ExecTest(String string) {
        super(string);
    }

    public void noTestBasic() {
        String string;
        AllTests.standardOut("testBasic");
        String[] stringArray = new String[]{"ls", "-l"};
        Exec exec = new Exec(stringArray);
        int n = exec.run();
        ExecTest.assertTrue((n == 0 ? 1 : 0) != 0);
        Enumeration enumeration = exec.getStdout().elements();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("=========== STDOUT =============\n");
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        enumeration = exec.getStderr().elements();
        stringBuffer.append("=========== STDERR =============\n");
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        string = stringBuffer.toString();
        ExecTest.assertTrue((string.indexOf("ExecTest.java") >= 0 ? 1 : 0) != 0);
        ExecTest.assertTrue((string.indexOf("ExecTest.class") >= 0 ? 1 : 0) != 0);
    }

    public void testBasicWithThreadedExec() throws Exception {
        AllTests.standardOut("testBasicWithThreadedExec");
        String[] stringArray = new String[]{"ls", "-l"};
        Exec exec = new Exec(stringArray);
        int n = exec.runThreaded();
        ExecTest.assertTrue((n == 0 ? 1 : 0) != 0);
        String string = exec.getStdoutAsString();
        String string2 = exec.getStderrAsString();
        AllTests.standardOut("stdout: " + string);
        AllTests.standardOut("stderr: " + string2);
    }

    public void testBasicWithThreadedExec2() throws Exception {
        AllTests.standardOut("testBasicWithThreadedExec2");
        String[] stringArray = new String[]{"ls", "-l"};
        Exec exec = new Exec(stringArray);
        int n = exec.runThreaded();
        ExecTest.assertTrue((n == 0 ? 1 : 0) != 0);
        String string = exec.getStdoutAsString();
        String string2 = exec.getStderrAsString();
        AllTests.standardOut("stdout: " + string);
        AllTests.standardOut("stderr: " + string2);
    }

    public void notestBasicInBackground() {
        String string;
        AllTests.standardOut("testBasicInBackground");
        String[] stringArray = new String[]{"date"};
        Exec exec = new Exec(stringArray);
        exec.setRunInBackground(true);
        AllTests.standardOut("cmd: " + exec.getCmd());
        int n = exec.run();
        Enumeration enumeration = exec.getStdout().elements();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("=========== STDOUT =============\n");
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            AllTests.standardOut(string);
            stringBuffer.append("\n");
        }
        enumeration = exec.getStderr().elements();
        stringBuffer.append("=========== STDERR =============\n");
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            AllTests.standardOut(string);
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        string = stringBuffer.toString();
        AllTests.standardOut("--> " + string + " <--");
    }

    public void notestUsingStandardInput() {
        String string;
        AllTests.standardOut("testUsingStandardInput");
        String[] stringArray = new String[]{"cat"};
        Exec exec = new Exec(stringArray);
        exec.setStandardInput("sample input\nsent to cat\nto be echoed\n");
        int n = exec.run();
        ExecTest.assertTrue((n == 0 ? 1 : 0) != 0);
        Enumeration enumeration = exec.getStdout().elements();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        ExecTest.assertTrue((stringBuffer.toString().indexOf("sample input") >= 0 ? 1 : 0) != 0);
        ExecTest.assertTrue((stringBuffer.toString().indexOf("sent to cat") >= 0 ? 1 : 0) != 0);
        ExecTest.assertTrue((stringBuffer.toString().indexOf("to be echoed") >= 0 ? 1 : 0) != 0);
        enumeration = exec.getStderr().elements();
        stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        string = stringBuffer.toString();
        ExecTest.assertTrue((string.length() == 0 ? 1 : 0) != 0);
    }

    public void disabled_testRunNetscape() {
        String string;
        String[] stringArray = new String[]{"/users/pshannon/data/human/jdrf/web", "http://sewardpark.net"};
        Exec exec = new Exec(stringArray);
        int n = exec.run();
        ExecTest.assertTrue((n == 0 ? 1 : 0) != 0);
        Enumeration enumeration = exec.getStdout().elements();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("=========== STDOUT =============\n");
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        enumeration = exec.getStderr().elements();
        stringBuffer.append("=========== STDERR =============\n");
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        string = stringBuffer.toString();
        AllTests.standardOut(string);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(ExecTest.class));
    }
}

