/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import java.awt.Color;
import java.awt.Polygon;
import java.awt.Shape;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import y.view.Arrow;
import y.view.LineType;

public class Misc {
    static Polygon p;

    public static void init() {
        p = new Polygon();
        p.addPoint(0, 0);
        p.addPoint(-40, 20);
        p.addPoint(-30, 0);
        p.addPoint(-40, -20);
        Arrow.addCustomArrow((String)"BigDelta", (Shape)p, (Color)new Color(255, 128, 0));
    }

    private static Arrow scalableArrow(String string) {
        p = new Polygon();
        int n = Integer.parseInt(string);
        p.addPoint(0, 0);
        p.addPoint(-n, n / 2);
        p.addPoint(-(n * 3) / 4, 0);
        p.addPoint(-n, -n / 2);
        return Arrow.addCustomArrow((String)("scalableArrow" + string), (Shape)p, (Color)new Color(255, 255, 255));
    }

    public static Color parseRGBText(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() != 3) {
            System.err.println("illegal RGB string in EdgeViz.parseRGBText: " + string);
            return Color.black;
        }
        String string2 = stringTokenizer.nextToken().trim();
        String string3 = stringTokenizer.nextToken().trim();
        String string4 = stringTokenizer.nextToken().trim();
        try {
            int n = Integer.parseInt(string2);
            int n2 = Integer.parseInt(string3);
            int n3 = Integer.parseInt(string4);
            return new Color(n, n2, n3);
        }
        catch (NumberFormatException numberFormatException) {
            return Color.black;
        }
    }

    public static String getRGBText(Color color) {
        Integer n = new Integer(color.getRed());
        Integer n2 = new Integer(color.getGreen());
        Integer n3 = new Integer(color.getBlue());
        return new String(n.toString() + "," + n2.toString() + "," + n3.toString());
    }

    public static Arrow parseArrowText(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() != 1) {
            System.err.println("illegal Arrow string in EdgeViz.parseArrowText: " + string);
            return Arrow.NONE;
        }
        String string2 = stringTokenizer.nextToken().trim();
        if (string2.equalsIgnoreCase("delta")) {
            return Arrow.DELTA;
        }
        if (string2.equalsIgnoreCase("standard")) {
            return Arrow.STANDARD;
        }
        if (string2.equalsIgnoreCase("arrow")) {
            return Arrow.STANDARD;
        }
        if (string2.equalsIgnoreCase("diamond")) {
            return Arrow.DIAMOND;
        }
        if (string2.equalsIgnoreCase("short")) {
            return Arrow.SHORT;
        }
        if (string2.equalsIgnoreCase("white_delta")) {
            return Arrow.WHITE_DELTA;
        }
        if (string2.equalsIgnoreCase("whitedelta")) {
            return Arrow.WHITE_DELTA;
        }
        if (string2.equalsIgnoreCase("white_diamond")) {
            return Arrow.WHITE_DIAMOND;
        }
        if (string2.equalsIgnoreCase("whitediamond")) {
            return Arrow.WHITE_DIAMOND;
        }
        if (string2.equalsIgnoreCase("bigdelta")) {
            return Arrow.getCustomArrow((String)"BigDelta");
        }
        if (string2.equalsIgnoreCase("none")) {
            return Arrow.NONE;
        }
        if (string2.startsWith("scalableArrow")) {
            return Misc.scalableArrow(string2.replaceFirst("scalableArrow", ""));
        }
        return Arrow.NONE;
    }

    public static String getArrowText(Arrow arrow) {
        byte by = arrow.getType();
        if (by == 3) {
            return "delta";
        }
        if (by == 2) {
            return "standard";
        }
        if (by == 5) {
            return "diamond";
        }
        if (by == 7) {
            return "short";
        }
        if (by == 4) {
            return "white_delta";
        }
        if (by == 6) {
            return "white_diamond";
        }
        if (by == 1) {
            return "none";
        }
        if (arrow.getCustomName() != null) {
            return arrow.getCustomName();
        }
        return "none";
    }

    public static LineType parseLineTypeText(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() != 1) {
            System.err.println("illegal LineType string in EdgeViz.parseLineTypeText: " + string);
            return LineType.LINE_1;
        }
        String string2 = stringTokenizer.nextToken().trim();
        if ((string2 = string2.replaceAll("_", "")).equalsIgnoreCase("dashed1")) {
            return LineType.DASHED_1;
        }
        if (string2.equalsIgnoreCase("dashed2")) {
            return LineType.DASHED_2;
        }
        if (string2.equalsIgnoreCase("dashed3")) {
            return LineType.DASHED_3;
        }
        if (string2.equalsIgnoreCase("dashed4")) {
            return LineType.DASHED_4;
        }
        if (string2.equalsIgnoreCase("dashed5")) {
            return LineType.DASHED_5;
        }
        if (string2.equalsIgnoreCase("line1")) {
            return LineType.LINE_1;
        }
        if (string2.equalsIgnoreCase("line2")) {
            return LineType.LINE_2;
        }
        if (string2.equalsIgnoreCase("line3")) {
            return LineType.LINE_3;
        }
        if (string2.equalsIgnoreCase("line4")) {
            return LineType.LINE_4;
        }
        if (string2.equalsIgnoreCase("line5")) {
            return LineType.LINE_5;
        }
        if (string2.equalsIgnoreCase("line6")) {
            return LineType.LINE_6;
        }
        if (string2.equalsIgnoreCase("line7")) {
            return LineType.LINE_7;
        }
        return LineType.LINE_1;
    }

    public static String getLineTypeText(LineType lineType) {
        if (lineType.equals((Object)LineType.DASHED_1)) {
            return "dashed1";
        }
        if (lineType.equals((Object)LineType.DASHED_2)) {
            return "dashed2";
        }
        if (lineType.equals((Object)LineType.DASHED_3)) {
            return "dashed3";
        }
        if (lineType.equals((Object)LineType.DASHED_4)) {
            return "dashed4";
        }
        if (lineType.equals((Object)LineType.DASHED_5)) {
            return "dashed5";
        }
        if (lineType.equals((Object)LineType.LINE_1)) {
            return "line1";
        }
        if (lineType.equals((Object)LineType.LINE_2)) {
            return "line2";
        }
        if (lineType.equals((Object)LineType.LINE_3)) {
            return "line3";
        }
        if (lineType.equals((Object)LineType.LINE_4)) {
            return "line4";
        }
        if (lineType.equals((Object)LineType.LINE_5)) {
            return "line5";
        }
        if (lineType.equals((Object)LineType.LINE_6)) {
            return "line6";
        }
        if (lineType.equals((Object)LineType.LINE_7)) {
            return "line7";
        }
        return "line1";
    }

    public static Byte parseNodeShapeTextIntoByte(String string) {
        return new Byte(Misc.parseNodeShapeText(string));
    }

    public static byte parseNodeShapeText(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() != 1) {
            System.err.println("illegal NodeShape string in EdgeViz.parseNodeShapeText: " + string);
            return 0;
        }
        String string2 = stringTokenizer.nextToken().trim();
        if ((string2 = string2.replaceAll("_", "")).equalsIgnoreCase("rect")) {
            return 0;
        }
        if (string2.equalsIgnoreCase("roundrect")) {
            return 1;
        }
        if (string2.equalsIgnoreCase("rect3d")) {
            return 6;
        }
        if (string2.equalsIgnoreCase("trapezoid")) {
            return 9;
        }
        if (string2.equalsIgnoreCase("trapezoid2")) {
            return 10;
        }
        if (string2.equalsIgnoreCase("triangle")) {
            return 5;
        }
        if (string2.equalsIgnoreCase("parallelogram")) {
            return 3;
        }
        if (string2.equalsIgnoreCase("diamond")) {
            return 8;
        }
        if (string2.equalsIgnoreCase("ellipse") || string2.equalsIgnoreCase("circle")) {
            return 2;
        }
        if (string2.equalsIgnoreCase("hexagon")) {
            return 4;
        }
        if (string2.equalsIgnoreCase("octagon")) {
            return 7;
        }
        return 0;
    }

    public static String getNodeShapeText(byte by) {
        if (by == 0) {
            return "rect";
        }
        if (by == 1) {
            return "roundrect";
        }
        if (by == 6) {
            return "rect3d";
        }
        if (by == 9) {
            return "trapezoid";
        }
        if (by == 10) {
            return "trapezoid2";
        }
        if (by == 5) {
            return "triangle";
        }
        if (by == 3) {
            return "parallelogram";
        }
        if (by == 8) {
            return "diamond";
        }
        if (by == 2) {
            return "ellipse";
        }
        if (by == 4) {
            return "hexagon";
        }
        if (by == 7) {
            return "octagon";
        }
        return "rect";
    }

    public static Vector getPropertyValues(Properties properties, String string) {
        String string2 = "property.token.delimiter";
        String string3 = properties.getProperty(string2, "::");
        String string4 = "list.startToken";
        String string5 = properties.getProperty(string4, "(");
        String string6 = "list.endToken";
        String string7 = properties.getProperty(string6, ")");
        Vector<String> vector = new Vector<String>();
        String string8 = properties.getProperty(string);
        if (string8 == null) {
            return vector;
        }
        String string9 = string8.trim();
        String[] stringArray = Misc.parseList(string9, string5, string7, string3);
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return vector;
    }

    public static boolean isList(String string, String string2, String string3, String string4) {
        String string5 = string.trim();
        Vector vector = new Vector();
        return string5.startsWith(string2) && string5.endsWith(string3);
    }

    public static String[] parseList(String string, String string2, String string3, String string4) {
        String string5 = string.trim();
        if (string5.startsWith(string2) && string5.endsWith(string3)) {
            string5 = string5.substring(1, string5.length() - 1);
            return string5.split(string4);
        }
        String[] stringArray = new String[]{string};
        return stringArray;
    }
}

