/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Vector;

public class Exec {
    String[] cmd;
    Vector stdoutResults;
    Vector stderrResults;
    String stringToSendToStandardInput;
    boolean runInBackground = false;
    String stdout;
    String stderr;

    public Exec() {
        this(null);
    }

    public Exec(String[] stringArray) {
        this.cmd = stringArray;
        this.stdoutResults = new Vector(100);
        this.stderrResults = new Vector(10);
    }

    public void setStandardInput(String string) {
        this.stringToSendToStandardInput = string;
    }

    public void setRunInBackground(boolean bl) {
        this.runInBackground = bl;
        int n = this.cmd.length;
        String[] stringArray = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.cmd[i];
        }
        stringArray[n] = " &";
        this.cmd = stringArray;
    }

    public String getCmd() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.cmd.length; ++i) {
            stringBuffer.append(this.cmd[i]);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public int run() {
        int n = -1;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.cmd.length; ++i) {
            stringBuffer.append(this.cmd[i]);
            stringBuffer.append(" ");
        }
        try {
            String string;
            Object object;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(stringBuffer.toString());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            if (this.stringToSendToStandardInput != null) {
                object = new PrintStream(process.getOutputStream(), true);
                ((PrintStream)object).print(this.stringToSendToStandardInput);
                ((PrintStream)object).close();
            }
            try {
                n = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            while ((object = bufferedReader.readLine()) != null) {
                this.stdoutResults.addElement(object);
            }
            while ((string = bufferedReader2.readLine()) != null) {
                this.stderrResults.addElement(string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n;
    }

    public int runThreaded() throws Exception {
        int n = -1;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.cmd.length; ++i) {
            stringBuffer.append(this.cmd[i]);
            stringBuffer.append(" ");
        }
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(stringBuffer.toString());
        final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        final BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        final StringBuffer stringBuffer2 = new StringBuffer();
        final StringBuffer stringBuffer3 = new StringBuffer();
        Thread thread = new Thread(){

            public void run() {
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        stringBuffer2.append(string + "\n");
                    }
                }
                catch (Exception exception) {
                    System.out.println("--- error: " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
        };
        Thread thread2 = new Thread(){

            public void run() {
                try {
                    String string;
                    while ((string = bufferedReader2.readLine()) != null) {
                        stringBuffer3.append(string + "\n");
                    }
                }
                catch (Exception exception) {
                    System.out.println("--- error: " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
        };
        thread.start();
        thread2.start();
        n = process.waitFor();
        this.stdout = stringBuffer2.toString();
        this.stderr = stringBuffer3.toString();
        return n;
    }

    public Vector getStdout() {
        return this.stdoutResults;
    }

    public Vector getStderr() {
        return this.stderrResults;
    }

    public String getStdoutAsString() {
        return this.stdout;
    }

    public String getStderrAsString() {
        return this.stderr;
    }
}

